// HexFileList.h : header file for CHexFileList overrride of MFC CRecentFileList class
//

// Copyright (c) 1999 by Andrew W. Phillips.
//
// No restrictions are placed on the noncommercial use of this code,
// as long as this text (from the above copyright notice to the
// disclaimer below) is preserved.
//
// This code may be redistributed as long as it remains unmodified
// and is not sold for profit without the author's written consent.
//
// This code, or any part of it, may not be used in any software that
// is sold for profit, without the author's written consent.
//
// DISCLAIMER: This file is provided "as is" with no expressed or
// implied warranty. The author accepts no liability for any damage
// or loss of business that this product may cause.
//

#include <afxadv.h>
#include <vector>
#include "Partition.h"

/////////////////////////////////////////////////////////////////////////////
// CHexFileList class
// Overrides the CRecentFileList class so that we can save some options for
// each of the files that appears in the recent file list.

class CHexFileList : public CRecentFileList
{
// Construction
public:
        CHexFileList(UINT nStart, LPCTSTR lpszSection,
                LPCTSTR lpszEntryFormat, int nSize,
                int nMaxDispLen = AFX_ABBREV_FILENAME_LEN);

// Attributes
public:
        int GetIndex(LPCTSTR lpszPathName) const;

// Operations
public:
        virtual void Remove(int nIndex);
        virtual void Add(LPCTSTR lpszPathName);
        virtual void ReadList();    // reads from registry or ini file
        virtual void WriteList();   // writes to registry or ini file

// Implementation
public:
        virtual ~CHexFileList();

public:
    BOOL *autofit_;                     // Use auto-fit on open?
    BOOL *dec_addr_;                    // Display decimal addresses on open
    BOOL *display_char_;                // Display chars (on right) on open
    BOOL *ebcdic_;                      // Display chars in EBCDIC on open
    BOOL *oem_;                         // Display OEM/IBM graphic characters
    BOOL *control_;                     // Display control chars on open
    BOOL *graphic_;                     // Display graphic chars on open

    std::vector<partn> **ppart_;             // Array of pointers to partitions vectors

    BOOL *allow_mods_;                  // Turn off read only on open?
    BOOL *insert_;                      // Turn off overtype on open?

    int *rowsize_;                      // Default number of display columns
    int *group_by_;                     // Default column grouping
    int *offset_;                       // Display offset on open

    long *start_addr_, *end_addr_;      // Selection
    long *mark_;                        // Location of mark
    long *scroll_;                      // Current position in file
    BOOL *edit_char_;                   // Is edit (caret) in char area?

    CString *face_;                     // Font face name
    long *height_;                      // Font height
    CString *oem_face_;                 // OEM/IBM font face name
    long *oem_height_;                  // OEM/IBM font height

    int *cmd_;                          // Show state: minimized/normal/maximized
    int *top_, *left_, *bottom_, *right_; // Location of window in pixels
};

/////////////////////////////////////////////////////////////////////////////
