/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */
import teamdev.jxcapture.Capture;
import teamdev.jxcapture.events.CaptureAdapter;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

/**
 * The example demonstrates how to capture the specified object.
 * <p>To complete the operation and retrieve the screen shot of selected object -
 * press the Shift key.
 * <p>To cancel the operation press the Esc key.
 *
 * @author Ikryanov Vladimir
 */
public class ObjectCaptureSample {
    public static void main(String[] args) {
        System.out.println("Please press Shift key in order to complete operation");
        Capture.captureObject(new CaptureAdapter() {
            public void complete(BufferedImage image) {
                try {
                    ImageIO.write(image, "PNG", new File("C:/objectWindow.png"));
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }

            public void cancel() {
                System.out.println("Cancel");
            }
        });
        System.out.println("Done.");
    }
}
