/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxdesktop.win32.gdi;

import com.jniwrapper.DataBufferFactory;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.MemoryBuffer;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.Str;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.UInt8;
import com.jniwrapper.util.ImageUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import teamdev.jxdesktop.win32.Handle;
import teamdev.jxdesktop.win32.LastErrorException;
import teamdev.jxdesktop.win32.gdi.Bitmap;
import teamdev.jxdesktop.win32.gdi.BitmapInfo;
import teamdev.jxdesktop.win32.gdi.BitmapInfoHeader;
import teamdev.jxdesktop.win32.gdi.BitmapStructure;
import teamdev.jxdesktop.win32.gdi.DC;
import teamdev.jxdesktop.win32.gdi.DDBitmap;
import teamdev.jxdesktop.win32.gdi.DibSection;
import teamdev.jxdesktop.win32.gdi.Gdi32;
import teamdev.jxdesktop.win32.gdi.GdiObject;
import teamdev.jxdesktop.win32.gdi.WindowDC;
import teamdev.jxdesktop.win32.gdi.bitmap.BitmapBuilder;
import teamdev.jxdesktop.win32.ui.User32;

public class DIBitmap
extends Bitmap {
    private static String f = "GetDIBColorTable";
    static Class d;
    static Class e;

    public DIBitmap() {
        this.setSize(0, 0);
    }

    public DIBitmap(long l2) {
        super(l2);
        this.setSize(0, 0);
    }

    public DIBitmap(int n2, int n3) {
        this(new DDBitmap(n2, n3));
    }

    public DIBitmap(DDBitmap dDBitmap) {
        BitmapInfoHeader bitmapInfoHeader = dDBitmap.getBitmapInfoHeader();
        int n2 = (int)bitmapInfoHeader.getHeight();
        int n3 = (int)bitmapInfoHeader.getWidth();
        int n4 = (int)bitmapInfoHeader.getSizeImage();
        PrimitiveArray primitiveArray = new PrimitiveArray(d == null ? (d = DIBitmap.a("com.jniwrapper.UInt8")) : d, n4);
        Pointer pointer = new Pointer((Parameter)primitiveArray);
        this.createDIBSection(this, new WindowDC(null), dDBitmap.getBitmapInfo(), 0, new Pointer((Parameter)pointer), new Handle(), 0);
        dDBitmap.getDIBits((DC)new WindowDC(null), 0, n2, pointer, dDBitmap.getBitmapInfo(), 0);
        this.setSize(n3, n2);
    }

    public DIBitmap(BitmapInfo bitmapInfo) {
        int n2 = (int)bitmapInfo.getBitmapInfoHeader().getHeight();
        int n3 = (int)bitmapInfo.getBitmapInfoHeader().getWidth();
        PrimitiveArray primitiveArray = new PrimitiveArray((Parameter)new UInt8(0), (int)bitmapInfo.getBitmapInfoHeader().getSizeImage());
        Pointer pointer = new Pointer((Parameter)primitiveArray);
        this.createDIBSection(this, new WindowDC(null), bitmapInfo, 0, new Pointer((Parameter)pointer), new Handle(), 0);
        this.setSize(n3, n2);
    }

    public DIBitmap(String string) {
        this.loadFromFile(string);
    }

    public DIBitmap(Image image) {
        BufferedImage bufferedImage = ImageUtils.createBufferedImage((Image)image);
        this.a(bufferedImage);
        this.setSize((int)this.getBitmapInfoHeader().getWidth(), (int)this.getBitmapInfoHeader().getHeight());
    }

    public void loadFromFile(String string) {
        Function function = User32.getInstance().getFunction(User32.FUNCTION_LOAD_IMAGE.toString());
        Handle handle = new Handle();
        long l2 = function.invoke((Parameter)handle, new Parameter[]{new Pointer(null, true), new Str(string), new UInt((long)GdiObject.ImageType.BITMAP.getValue()), new Int(0L), new Int(0L), new UInt(41040L)});
        if (handle.isNull()) {
            throw new LastErrorException(l2, "Failed to load resource.", true);
        }
        this.setValue(handle.getValue());
        BitmapInfoHeader bitmapInfoHeader = this.getBitmapInfoHeader();
        this.setSize((int)bitmapInfoHeader.getWidth(), (int)bitmapInfoHeader.getHeight());
    }

    private void a(BufferedImage bufferedImage) {
        BitmapBuilder bitmapBuilder = _builderFactory.createBuilder(bufferedImage);
        BitmapInfo bitmapInfo = bitmapBuilder.getBitmapInfo();
        this.createDIBSection(this, new Pointer((Parameter)new Pointer((Parameter)bitmapBuilder.getBitmapData())), bitmapInfo);
        bitmapBuilder.setBitmapColors();
        Image image = bitmapBuilder.getTransparentMask();
        if (image != null) {
            this.setTransparentMask(image);
        }
    }

    public BitmapInfoHeader getBitmapInfoHeader() {
        DibSection dibSection = new DibSection();
        this.getObject(this, (Parameter)dibSection);
        return dibSection.getBitmapInfoHeader();
    }

    public BitmapStructure getBitmapStructure() {
        DibSection dibSection = new DibSection();
        this.getObject(this, (Parameter)dibSection);
        return dibSection.getBitmap();
    }

    public BitmapInfo getBitmapInfo() {
        BitmapInfo bitmapInfo = new BitmapInfo();
        bitmapInfo.a(this.getBitmapInfoHeader());
        int n2 = (int)this.getBitmapInfoHeader().getBitCount();
        if (n2 <= 8) {
            Function function = Gdi32.getInstance().getFunction(f);
            DC dC = DC.createCompatibleDC(new WindowDC(null));
            dC.selectObject(this);
            UInt uInt = new UInt();
            PrimitiveArray primitiveArray = new PrimitiveArray(e == null ? (e = DIBitmap.a("teamdev.jxdesktop.win32.gdi.RGBQuad")) : e, (int)Math.pow(2.0, n2));
            function.invoke((Parameter)uInt, new Parameter[]{dC, new UInt(0L), new UInt((long)((int)Math.pow(2.0, n2))), new Pointer((Parameter)primitiveArray)});
            dC.release();
            bitmapInfo.a(primitiveArray);
        }
        return bitmapInfo;
    }

    public DibSection getDIBSection() {
        DibSection dibSection = new DibSection();
        this.getObject(this, (Parameter)dibSection);
        return dibSection;
    }

    public DDBitmap toDDBitmap(DC dC) {
        DDBitmap dDBitmap = new DDBitmap(dC, this.getWidth(), this.getHeight());
        PrimitiveArray primitiveArray = this.getDIBytes();
        Function function = Gdi32.getInstance().getFunction("CreateDIBitmap");
        function.invoke((Parameter)dDBitmap, new Parameter[]{dC, new Pointer((Parameter)this.getDIBSection().getBitmapInfoHeader()), new UInt32(4L), new Pointer((Parameter)primitiveArray), new Pointer((Parameter)this.getBitmapInfo()), new UInt(0L)});
        return dDBitmap;
    }

    public PrimitiveArray getDIBytes() {
        BitmapStructure bitmapStructure = this.getBitmapStructure();
        PrimitiveArray primitiveArray = new PrimitiveArray(d == null ? (d = DIBitmap.a("com.jniwrapper.UInt8")) : d, (int)this.getBitmapInfoHeader().getSizeImage());
        bitmapStructure.getBits().castTo(new Pointer((Parameter)primitiveArray));
        return primitiveArray;
    }

    public byte[] getBytes() {
        BitmapStructure bitmapStructure = this.getBitmapStructure();
        int n2 = (int)this.getBitmapInfoHeader().getSizeImage();
        MemoryBuffer memoryBuffer = DataBufferFactory.getInstance().createExternMemoryBuffer(bitmapStructure.getBits().getValue(), n2);
        return memoryBuffer.readByteArray(0, n2);
    }

    public long getRGBbyIndex(long l2) {
        long l3 = l2 & 0xFFFFL | 0x10FF0000L;
        long l4 = (byte)l3 & 0xFF;
        long l5 = (byte)(l3 >> 8) & 0xFF;
        long l6 = (byte)(l3 >> 16) & 0xFF;
        return l3;
    }

    public void setDIBytes(PrimitiveArray primitiveArray) {
        BitmapInfo bitmapInfo = this.getBitmapInfo();
        PrimitiveArray primitiveArray2 = primitiveArray;
        this.setDIBits(new WindowDC(null), 0, this.getHeight(), new Pointer((Parameter)primitiveArray2), bitmapInfo, 0);
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

