/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxdesktop.win32.gdi;

import com.jniwrapper.Bool;
import com.jniwrapper.ComplexArray;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.IntegerParameter;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Str;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.ULongInt;
import com.jniwrapper.UShortInt;
import com.jniwrapper.WideString;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.util.Enums;
import java.awt.Color;
import teamdev.jxdesktop.win32.FunctionName;
import teamdev.jxdesktop.win32.Handle;
import teamdev.jxdesktop.win32.LastErrorException;
import teamdev.jxdesktop.win32.Rect;
import teamdev.jxdesktop.win32.Size;
import teamdev.jxdesktop.win32.gdi.Bitmap;
import teamdev.jxdesktop.win32.gdi.BlendFunction;
import teamdev.jxdesktop.win32.gdi.Brush;
import teamdev.jxdesktop.win32.gdi.ColorRef;
import teamdev.jxdesktop.win32.gdi.DDBitmap;
import teamdev.jxdesktop.win32.gdi.DevMode;
import teamdev.jxdesktop.win32.gdi.Font;
import teamdev.jxdesktop.win32.gdi.Gdi32;
import teamdev.jxdesktop.win32.gdi.GdiObject;
import teamdev.jxdesktop.win32.gdi.GradientRect;
import teamdev.jxdesktop.win32.gdi.Icon;
import teamdev.jxdesktop.win32.gdi.LogBrush;
import teamdev.jxdesktop.win32.gdi.Msimg32;
import teamdev.jxdesktop.win32.gdi.Pen;
import teamdev.jxdesktop.win32.gdi.PolyFillMode;
import teamdev.jxdesktop.win32.gdi.Region;
import teamdev.jxdesktop.win32.gdi.TriVertex;
import teamdev.jxdesktop.win32.ui.User32;

public class DC
extends Handle {
    public static final int DC_PEN = 19;
    static final Function d = Gdi32.getInstance().getFunction("SelectObject");
    static final Function a = Gdi32.getInstance().getFunction("CreateCompatibleDC");
    static final Function e = Gdi32.getInstance().getFunction("DeleteObject");
    static final Function k = Gdi32.getInstance().getFunction("BitBlt");
    static final Function j = Gdi32.getInstance().getFunction("DeleteDC");
    static final Function h = Gdi32.getInstance().getFunction("CreateDCW");
    static final FunctionName g = new FunctionName("TextOut");
    static final FunctionName c = new FunctionName("DrawText");
    static final FunctionName f = new FunctionName("GetTextExtentPoint32");
    public static final int BKMODE_TRANSPARENT = 1;
    public static final int BKMODE_OPAQUE = 2;
    public static final int BKMODE_LAST = 2;
    public static final long GRADIENT_FILL_RECT_H = 0L;
    public static final long GRADIENT_FILL_RECT_V = 1L;
    public static final int DT_RIGHT = 2;
    static Class i;

    public DC() {
    }

    public DC(long l2) {
        super(l2);
    }

    public static DC createCompatibleDC(DC dC) {
        DC dC2 = new DC();
        a.invoke((Parameter)dC2, (Parameter)(dC == null ? new Pointer(null, true) : dC));
        return dC2;
    }

    private long a(GdiObject gdiObject) {
        Handle handle = new Handle();
        d.invoke((Parameter)handle, (Parameter)this, (Parameter)gdiObject);
        return handle.getValue();
    }

    public static long deleteObject(GdiObject gdiObject) {
        Handle handle = new Handle();
        e.invoke((Parameter)handle, (Parameter)gdiObject);
        return handle.getValue();
    }

    public Brush selectObject(Brush brush) {
        long l2 = this.a(brush);
        return new Brush(l2);
    }

    public Pen selectObject(Pen pen) {
        long l2 = this.a(pen);
        return new Pen(l2);
    }

    public Bitmap selectObject(Bitmap bitmap) {
        long l2 = this.a(bitmap);
        return new DDBitmap(l2);
    }

    public Font selectObject(Font font) {
        long l2 = this.a(font);
        return new Font(l2);
    }

    public Region selectObject(Region region) {
        long l2 = this.a(region);
        return new Region(l2);
    }

    public static void bitBlt(DC dC, int n2, int n3, int n4, int n5, DC dC2, int n6, int n7, RasterOperation rasterOperation) {
        k.invoke(null, new Parameter[]{dC, new Int((long)n2), new Int((long)n3), new Int((long)n4), new Int((long)n5), dC2, new Int((long)n6), new Int((long)n7), new UInt32((long)rasterOperation.getValue())});
    }

    public static boolean stretchBlt(DC dC, int n2, int n3, int n4, int n5, DC dC2, int n6, int n7, int n8, int n9, RasterOperation rasterOperation) {
        Int intVal = new Int();
        Function function = Gdi32.get("StretchBlt");
        function.invoke((Parameter)intVal, new Parameter[]{dC, new Int((long)n2), new Int((long)n3), new Int((long)n4), new Int((long)n5), dC2, new Int((long)n6), new Int((long)n7), new Int((long)n8), new Int((long)n9), new UInt32((long)rasterOperation.getValue())});
        return intVal.getValue() > 0L;
    }

    public boolean patBlt(int n2, int n3, int n4, int n5, RasterOperation rasterOperation) {
        Bool bool = new Bool();
        Function function = Gdi32.get("PatBlt");
        function.invoke((Parameter)bool, new Parameter[]{this, new Int((long)n2), new Int((long)n3), new Int((long)n4), new Int((long)n5), new UInt32((long)rasterOperation.getValue())});
        return bool.getValue();
    }

    public void release() {
        DC.deleteDC(this);
    }

    public static void deleteDC(DC dC) {
        Int intVal = new Int();
        long l2 = j.invoke((Parameter)intVal, (Parameter)dC);
        if (intVal.getValue() == 0L) {
            throw new LastErrorException(l2);
        }
    }

    public void textOut(int n2, int n3, String string) {
        Function function = Gdi32.get(g.toString());
        UShortInt uShortInt = new UShortInt();
        long l2 = function.invoke((Parameter)uShortInt, new Parameter[]{this, new Int((long)n2), new Int((long)n3), new Str(string), new Int((long)string.length())});
        if (uShortInt.getValue() == 0L) {
            throw new LastErrorException(l2);
        }
    }

    public void drawText(String string, Rect rect, UInt uInt) {
        Function function = User32.getInstance().getFunction(c.toString());
        Int intVal = new Int();
        long l2 = function.invoke((Parameter)intVal, new Parameter[]{this, new Str(string), new Int((long)string.length()), new Pointer((Parameter)rect), new UInt((IntegerParameter)uInt)});
        if (intVal.getValue() == 0L) {
            throw new LastErrorException(l2);
        }
    }

    public Size getTextExtentPoint32(DC dC, String string) {
        Size size = new Size();
        Gdi32.getInstance().getFunction(f.toString()).invoke(null, new Parameter[]{this, new Str(string), new UInt((long)string.length()), new Pointer((Parameter)size)});
        return size;
    }

    public void drawIconEx(int n2, int n3, Icon icon, int n4, int n5, int n6, Handle handle, int n7) {
        Function function = User32.getInstance().getFunction("DrawIconEx");
        UShortInt uShortInt = new UShortInt();
        long l2 = function.invoke((Parameter)uShortInt, new Parameter[]{this, new Int((long)n2), new Int((long)n3), icon, new Int((long)n4), new Int((long)n5), new UInt((long)n6), handle, new UInt((long)n7)});
        if (uShortInt.getValue() == 0L) {
            throw new LastErrorException(l2);
        }
    }

    public boolean drawIcon(int n2, int n3, Icon icon) {
        Function function = User32.getInstance().getFunction("DrawIcon");
        Bool bool = new Bool();
        function.invoke((Parameter)bool, (Parameter)this, (Parameter)new Int((long)n2), (Parameter)new Int((long)n3), (Parameter)icon);
        return bool.getValue();
    }

    public int setBkMode(int n2) {
        Function function = Gdi32.get("SetBkMode");
        UShortInt uShortInt = new UShortInt();
        long l2 = function.invoke((Parameter)uShortInt, (Parameter)this, (Parameter)new Int((long)n2));
        if (uShortInt.getValue() == 0L) {
            throw new LastErrorException(l2);
        }
        return (int)uShortInt.getValue();
    }

    public ColorRef setBkColor(ColorRef colorRef) {
        ColorRef colorRef2 = new ColorRef();
        Function function = Gdi32.get("SetBkColor");
        long l2 = function.invoke((Parameter)colorRef2, (Parameter)this, (Parameter)colorRef);
        if (colorRef2.isInvalid()) {
            throw new LastErrorException(l2, "Error while changing text color");
        }
        return colorRef2;
    }

    public ColorRef setTextColor(ColorRef colorRef) {
        ColorRef colorRef2 = new ColorRef();
        Function function = Gdi32.get("SetTextColor");
        long l2 = function.invoke((Parameter)colorRef2, (Parameter)this, (Parameter)colorRef);
        if (colorRef2.isInvalid()) {
            throw new LastErrorException(l2, "Error while changing text color");
        }
        return colorRef2;
    }

    public void selectClipRgn(Region region) {
        Int intVal = new Int();
        Function function = Gdi32.getInstance().getFunction("SelectClipRgn");
        long l2 = function.invoke((Parameter)intVal, (Parameter)this, (Parameter)region);
        if (0L == intVal.getValue()) {
            throw new LastErrorException(l2, "Failed to select region");
        }
    }

    public void fillRegion(Region region, Brush brush) {
        Bool bool = new Bool();
        Function function = Gdi32.getInstance().getFunction("FillRgn");
        long l2 = function.invoke((Parameter)bool, (Parameter)this, (Parameter)region, (Parameter)brush);
        if (!bool.getValue()) {
            throw new LastErrorException(l2, "Failed to fill region");
        }
    }

    public void frameRegion(Region region, Brush brush, int n2, int n3) {
        Bool bool = new Bool();
        Function function = Gdi32.getInstance().getFunction("FrameRgn");
        long l2 = function.invoke((Parameter)bool, new Parameter[]{this, region, brush, new Int((long)n2), new Int((long)n3)});
        if (!bool.getValue()) {
            throw new LastErrorException(l2, "Failed to frame region");
        }
    }

    public int getPolyFillMode() {
        Int intVal = new Int();
        Function function = Gdi32.getInstance().getFunction("GetPolyFillMode");
        function.invoke((Parameter)intVal, (Parameter)this);
        return (int)intVal.getValue();
    }

    public boolean invertRegion(Region region) {
        Bool bool = new Bool();
        Function function = Gdi32.getInstance().getFunction("InvertRgn");
        function.invoke((Parameter)bool, (Parameter)this, (Parameter)region);
        return bool.getValue();
    }

    public boolean paintRegion(Region region) {
        Bool bool = new Bool();
        Function function = Gdi32.getInstance().getFunction("PaintRgn");
        function.invoke((Parameter)bool, (Parameter)this, (Parameter)region);
        return bool.getValue();
    }

    public void setPolyFillMode(PolyFillMode polyFillMode) {
        Function function = Gdi32.getInstance().getFunction("SetPolyFillMode");
        function.invoke(null, (Parameter)this, (Parameter)new Int((long)polyFillMode.getValue()));
    }

    public ColorRef getPixel(int n2, int n3) {
        ColorRef colorRef = new ColorRef();
        Function function = Gdi32.get("GetPixel");
        function.invoke((Parameter)colorRef, (Parameter)this, (Parameter)new Int((long)n2), (Parameter)new Int((long)n3));
        return colorRef;
    }

    public static ColorRef setDCBrushColor(DC dC, ColorRef colorRef) {
        ColorRef colorRef2 = new ColorRef();
        Function function = Gdi32.get("SetDCBrushColor");
        function.invoke((Parameter)colorRef2, (Parameter)dC, (Parameter)colorRef);
        return colorRef2;
    }

    public ColorRef setDCPenColor(DC dC, ColorRef colorRef) {
        ColorRef colorRef2 = new ColorRef();
        Function function = Gdi32.get("SetDCPenColor");
        function.invoke((Parameter)colorRef2, (Parameter)dC, (Parameter)colorRef);
        return colorRef2;
    }

    private void a(Bitmap bitmap, int n2, int n3) {
        DC dC = DC.createCompatibleDC(this);
        Bitmap bitmap2 = dC.selectObject(bitmap);
        BlendFunction blendFunction = new BlendFunction();
        blendFunction.setSourceConstantAlpha(255);
        blendFunction.setAlphaFormat(1);
        this.alphaBlend(n2, n3, bitmap.getWidth(), bitmap.getHeight(), dC, 0, 0, bitmap.getWidth(), bitmap.getHeight(), blendFunction);
        dC.selectObject(bitmap2);
        DC.deleteDC(dC);
    }

    public void transparentBlt(Bitmap bitmap, int n2, int n3) {
        if (bitmap.getBitCount() == 32) {
            this.a(bitmap, n2, n3);
        } else if (bitmap.getTransparentMask() != null) {
            this.a(bitmap, bitmap.getTransparentMask(), n2, n3);
        }
    }

    public void paintBitmap(Bitmap bitmap, int n2, int n3) {
        if (bitmap.isTransparent()) {
            this.transparentBlt(bitmap, n2, n3);
        } else {
            this.paintOpaqueBitmap(bitmap, n2, n3);
        }
    }

    public void paintOpaqueBitmap(Bitmap bitmap, int n2, int n3) {
        DC dC = DC.createCompatibleDC(this);
        Bitmap bitmap2 = dC.selectObject(bitmap);
        DC.bitBlt(this, n2, n3, bitmap.getWidth(), bitmap.getHeight(), dC, 0, 0, RasterOperation.SRCCOPY);
        dC.selectObject(bitmap2);
        DC.deleteDC(dC);
    }

    private void a(Bitmap bitmap, Bitmap bitmap2, int n2, int n3) {
        Size size = bitmap.getSize();
        DC dC = DC.createCompatibleDC(this);
        DC dC2 = DC.createCompatibleDC(this);
        DC dC3 = DC.createCompatibleDC(this);
        DDBitmap dDBitmap = new DDBitmap(this, size.getCx(), size.getCy());
        DDBitmap dDBitmap2 = new DDBitmap(this, size.getCx(), size.getCy());
        Bitmap bitmap3 = dC2.selectObject(dDBitmap2);
        Bitmap bitmap4 = dC3.selectObject(dDBitmap);
        Bitmap bitmap5 = dC.selectObject(bitmap);
        this.a(dC3, size, dC);
        dC.selectObject(bitmap2);
        this.a(dC2, size, dC);
        this.a(dC3, dC2, size);
        this.a(n2, n3, size, dC2, dC3);
        dC.selectObject(bitmap5);
        dC2.selectObject(bitmap3);
        dC3.selectObject(bitmap4);
        dDBitmap.deleteObject();
        DC.deleteDC(dC3);
        DC.deleteDC(dC2);
        DC.deleteDC(dC);
    }

    private void a(DC dC, DC dC2, Size size) {
        dC.setBkColor(new ColorRef(Color.black));
        dC.setTextColor(new ColorRef(Color.white));
        DC.bitBlt(dC, 0, 0, size.getCx(), size.getCy(), dC2, 0, 0, RasterOperation.SRCAND);
    }

    private void a(DC dC, Size size, DC dC2) {
        DC.bitBlt(dC, 0, 0, size.getCx(), size.getCy(), dC2, 0, 0, RasterOperation.SRCCOPY);
    }

    private void a(int n2, int n3, Size size, DC dC, DC dC2) {
        dC.patBlt(0, 0, size.getCx(), size.getCy(), RasterOperation.DSTINVERT);
        DC.bitBlt(this, n2, n3, size.getCx(), size.getCy(), dC, 0, 0, RasterOperation.SRCAND);
        DC.bitBlt(this, n2, n3, size.getCx(), size.getCy(), dC2, 0, 0, RasterOperation.SRCPAINT);
    }

    public boolean alphaBlend(int n2, int n3, int n4, int n5, DC dC, int n6, int n7, int n8, int n9, BlendFunction blendFunction) {
        Bool bool = new Bool();
        Msimg32.getInstance().getFunction("AlphaBlend").invoke((Parameter)bool, new Parameter[]{this, new Int((long)n2), new Int((long)n3), new Int((long)n4), new Int((long)n5), dC, new Int((long)n6), new Int((long)n7), new Int((long)n8), new Int((long)n9), blendFunction});
        return bool.getValue();
    }

    public void drawGrayed(DC dC, Rect rect) {
        int n2 = rect.getWidth();
        int n3 = rect.getHeight();
        int n4 = (int)rect.getLeft();
        int n5 = (int)rect.getTop();
        DC dC2 = DC.createCompatibleDC(this);
        DDBitmap dDBitmap = new DDBitmap(this, n2, n3);
        Bitmap bitmap = dC2.selectObject(dDBitmap);
        DC dC3 = DC.createCompatibleDC(this);
        DDBitmap dDBitmap2 = new DDBitmap(this, n2, n3);
        Bitmap bitmap2 = dC3.selectObject(dDBitmap2);
        DC.bitBlt(dC2, 0, 0, n2, n3, dC, 0, 0, RasterOperation.SRCCOPY);
        DC.bitBlt(this, n4 + 1, n5 + 1, n2, n3, dC2, 0, 0, RasterOperation.MERGEPAINT);
        DC.bitBlt(this, n4, n5, n2, n3, dC2, 0, 0, RasterOperation.SRCAND);
        Rect rect2 = new Rect(0L, 0L, n2, n3);
        LogBrush logBrush = new LogBrush();
        logBrush.setColor(new ColorRef(new Color(127, 127, 127)));
        Brush brush = Brush.createBrushIndirect(logBrush);
        dC3.fillRect(rect2, brush);
        brush.deleteObject();
        dC2.patBlt(0, 0, n2, n3, RasterOperation.DSTINVERT);
        DC.bitBlt(dC3, 0, 0, n2, n3, dC2, 0, 0, RasterOperation.SRCAND);
        DC.bitBlt(this, n4, n5, n2, n3, dC3, 0, 0, RasterOperation.SRCPAINT);
        dC3.selectObject(bitmap2);
        dDBitmap2.deleteObject();
        DC.deleteDC(dC3);
        dC2.selectObject(bitmap);
        dDBitmap.deleteObject();
        DC.deleteDC(dC2);
    }

    public void fillRect(Rect rect, Brush brush) {
        Region region = Region.createRectRegion(rect);
        this.fillRegion(region, brush);
        region.deleteObject();
    }

    public void maskBlt(Bitmap.PredefinedBitmap predefinedBitmap, int n2, int n3, Brush brush) {
        DC dC = DC.createCompatibleDC(this);
        DDBitmap dDBitmap = new DDBitmap(predefinedBitmap);
        Bitmap bitmap = dC.selectObject(dDBitmap);
        Size size = dDBitmap.getSize();
        int n4 = size.getCx();
        int n5 = size.getCy();
        DC dC2 = DC.createCompatibleDC(this);
        DDBitmap dDBitmap2 = new DDBitmap(this, n4, n5);
        Bitmap bitmap2 = dC2.selectObject(dDBitmap2);
        DC dC3 = DC.createCompatibleDC(this);
        DDBitmap dDBitmap3 = new DDBitmap(this, n4, n5);
        Bitmap bitmap3 = dC3.selectObject(dDBitmap3);
        DC.bitBlt(dC2, 0, 0, n4, n5, dC, 0, 0, RasterOperation.SRCCOPY);
        DC.bitBlt(this, n2, n3, n4, n5, dC2, 0, 0, RasterOperation.SRCAND);
        dC2.patBlt(0, 0, n4, n5, RasterOperation.DSTINVERT);
        Brush brush2 = dC3.selectObject(brush);
        DC.bitBlt(dC3, 0, 0, n4, n5, dC2, 0, 0, RasterOperation.MERGECOPY);
        dC3.selectObject(brush2);
        DC.bitBlt(this, n2, n3, n4, n5, dC3, 0, 0, RasterOperation.SRCPAINT);
        dC3.selectObject(bitmap3);
        dDBitmap3.deleteObject();
        DC.deleteDC(dC3);
        dC2.selectObject(bitmap2);
        dDBitmap2.deleteObject();
        DC.deleteDC(dC2);
        dC.selectObject(bitmap);
        dDBitmap.deleteObject();
        DC.deleteDC(dC);
    }

    public boolean gradientFill(Rect rect, Color color, Color color2) {
        Function function = Msimg32.getInstance().getFunction("GradientFill");
        TriVertex triVertex = new TriVertex();
        TriVertex triVertex2 = new TriVertex();
        this.a(triVertex, color, rect.getLeft(), rect.getTop());
        this.a(triVertex2, color2, rect.getRight(), rect.getBottom());
        GradientRect gradientRect = new GradientRect();
        gradientRect.setUpperLeft(0L);
        gradientRect.setLowerRight(1L);
        ComplexArray complexArray = new ComplexArray((Parameter)new TriVertex(), 2);
        complexArray.setElement(0, (Parameter)triVertex);
        complexArray.setElement(1, (Parameter)triVertex2);
        Bool bool = new Bool();
        function.invoke((Parameter)bool, new Parameter[]{this, new Pointer((Parameter)complexArray), new ULongInt(2L), new Pointer((Parameter)new ComplexArray(new Parameter[]{gradientRect})), new ULongInt(1L), new ULongInt(0L)});
        return bool.getValue();
    }

    private void a(TriVertex triVertex, Color color, long l2, long l3) {
        triVertex.setX(l2);
        triVertex.setY(l3);
        triVertex.setRed(color.getRed() << 8);
        triVertex.setGreen(color.getGreen() << 8);
        triVertex.setBlue(color.getBlue() << 8);
        triVertex.setAlpha(0);
    }

    public boolean lineTo(int n2, int n3) {
        Function function = Gdi32.getInstance().getFunction("LineTo");
        Bool bool = new Bool();
        function.invoke((Parameter)bool, (Parameter)this, (Parameter)new Int((long)n2), (Parameter)new Int((long)n3));
        return bool.getValue();
    }

    public boolean moveTo(int n2, int n3) {
        Function function = Gdi32.getInstance().getFunction("MoveToEx");
        Bool bool = new Bool();
        function.invoke((Parameter)bool, (Parameter)this, (Parameter)new Int((long)n2), (Parameter)new Int((long)n3), (Parameter)new Handle());
        return bool.getValue();
    }

    public boolean drawRectangle(Rect rect) {
        this.moveTo(rect.getLeftAsInt(), rect.getTopAsInt());
        this.lineTo(rect.getRightAsInt(), rect.getTopAsInt());
        this.lineTo(rect.getRightAsInt(), rect.getBottomAsInt());
        this.lineTo(rect.getLeftAsInt(), rect.getBottomAsInt());
        this.lineTo(rect.getLeftAsInt(), rect.getTopAsInt());
        return true;
    }

    public MappingMode setMapMode(MappingMode mappingMode) {
        Function function = Gdi32.get("SetMapMode");
        Int intVal = new Int();
        function.invoke((Parameter)intVal, (Parameter)this, (Parameter)new Int((long)mappingMode.getValue()));
        return (MappingMode)Enums.getItem((Class)(i == null ? (i = DC.a("teamdev.jxdesktop.win32.gdi.DC$MappingMode")) : i), (int)((int)intVal.getValue()));
    }

    public int getDeviceCaps(int n2) {
        Function function = Gdi32.get("GetDeviceCaps");
        Int intVal = new Int();
        function.invoke((Parameter)intVal, (Parameter)this, (Parameter)new Int((long)n2));
        return (int)intVal.getValue();
    }

    public int intersectClipRect(int n2, int n3, int n4, int n5) {
        Function function = Gdi32.get("IntersectClipRect");
        Int intVal = new Int();
        function.invoke((Parameter)intVal, new Parameter[]{this, new Int((long)n2), new Int((long)n3), new Int((long)n4), new Int((long)n5)});
        return (int)intVal.getValue();
    }

    public boolean rectangle(int n2, int n3, int n4, int n5) {
        Function function = Gdi32.get("Rectangle");
        Bool bool = new Bool();
        function.invoke((Parameter)bool, new Parameter[]{this, new Int((long)n2), new Int((long)n3), new Int((long)n4), new Int((long)n5)});
        return bool.getValue();
    }

    public boolean roundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        Function function = Gdi32.get("RoundRect");
        Bool bool = new Bool();
        function.invoke((Parameter)bool, new Parameter[]{this, new Int((long)n2), new Int((long)n3), new Int((long)n4), new Int((long)n5), new Int((long)n6), new Int((long)n7)});
        return bool.getValue();
    }

    public boolean fillRectangle(int n2, int n3, int n4, int n5) {
        Function function = User32.getInstance().getFunction("FillRect");
        Bool bool = new Bool();
        function.invoke((Parameter)bool, new Parameter[]{this, new Int((long)n2), new Int((long)n3), new Int((long)n4), new Int((long)n5)});
        return bool.getValue();
    }

    public static DC createDC(String string, String string2, String string3, DevMode devMode) {
        DC dC = new DC();
        h.invoke((Parameter)dC, new Parameter[]{new Pointer((Parameter)(string == null ? null : new WideString(string))), new Pointer((Parameter)(string2 == null ? null : new WideString(string2))), new Pointer((Parameter)(string3 == null ? null : new WideString(string3))), new Pointer((Parameter)(devMode == null ? null : devMode))});
        return dC;
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class MappingMode
    extends EnumItem {
        public static MappingMode TEXT = new MappingMode(1);
        public static MappingMode LOMETRIC = new MappingMode(2);
        public static MappingMode HIMETRIC = new MappingMode(3);
        public static MappingMode LOENGLISH = new MappingMode(4);
        public static MappingMode HIENGLISH = new MappingMode(5);
        public static MappingMode TWIPS = new MappingMode(6);
        public static MappingMode ISOTROPIC = new MappingMode(7);
        public static MappingMode ANISOTROPIC = new MappingMode(8);

        private MappingMode(int n2) {
            super(n2);
        }
    }

    public static class RasterOperation
    extends EnumItem {
        public static final RasterOperation BLACKNESS = new RasterOperation(66L);
        public static final RasterOperation CAPTUREBLT = new RasterOperation(0x40000000L);
        public static final RasterOperation DSTINVERT = new RasterOperation(0x550009L);
        public static final RasterOperation MERGECOPY = new RasterOperation(0xC000CAL);
        public static final RasterOperation MERGEPAINT = new RasterOperation(12255782L);
        public static final RasterOperation NOMIRRORBITMAP = new RasterOperation(Integer.MIN_VALUE);
        public static final RasterOperation NOTSRCCOPY = new RasterOperation(0x330008L);
        public static final RasterOperation NOTSRCERASE = new RasterOperation(1114278L);
        public static final RasterOperation PATCOPY = new RasterOperation(15728673L);
        public static final RasterOperation PATINVERT = new RasterOperation(5898313L);
        public static final RasterOperation PATPAINT = new RasterOperation(16452105L);
        public static final RasterOperation SRCAND = new RasterOperation(8913094L);
        public static final RasterOperation SRCCOPY = new RasterOperation(0xCC0020L);
        public static final RasterOperation SRCERASE = new RasterOperation(4457256L);
        public static final RasterOperation SRCINVERT = new RasterOperation(0x660046L);
        public static final RasterOperation SRCPAINT = new RasterOperation(15597702L);
        public static final RasterOperation WHITENESS = new RasterOperation(16711778L);

        public RasterOperation(long l2) {
            super(l2);
        }
    }
}

