/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxdesktop.win32.gdi;

import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.util.EnumItem;
import teamdev.jxdesktop.win32.Handle;
import teamdev.jxdesktop.win32.Point;
import teamdev.jxdesktop.win32.gdi.Bitmap;
import teamdev.jxdesktop.win32.gdi.ColorRef;
import teamdev.jxdesktop.win32.gdi.DC;
import teamdev.jxdesktop.win32.gdi.Gdi32;
import teamdev.jxdesktop.win32.gdi.GdiObject;
import teamdev.jxdesktop.win32.gdi.LogBrush;
import teamdev.jxdesktop.win32.ui.User32;

public class Brush
extends GdiObject {
    public Brush() {
    }

    public Brush(long l2) {
        super(l2);
    }

    public Brush(BrushStyle brushStyle) {
        super(brushStyle.getValue());
    }

    public static Brush getStockObject(StockBrush stockBrush) {
        if (stockBrush.getValue() < StockBrush.WHITE_BRUSH.getValue() || stockBrush.getValue() > StockBrush.HOLLOW_BRUSH.getValue()) {
            throw new IllegalArgumentException("Unknown stock brush kind: " + (Object)((Object)stockBrush));
        }
        Handle handle = Gdi32.getStockObject(stockBrush.getValue());
        return new Brush(handle.getValue());
    }

    public static Brush createBrushIndirect(LogBrush logBrush) {
        Brush brush = new Brush();
        Function function = Gdi32.get("CreateBrushIndirect");
        function.invoke((Parameter)brush, (Parameter)new Pointer((Parameter)logBrush));
        return brush;
    }

    public static Brush createHatchBrush(HatchStyle hatchStyle, ColorRef colorRef) {
        Brush brush = new Brush();
        Function function = Gdi32.get("CreateHatchBrush");
        function.invoke((Parameter)brush, (Parameter)new Int((long)hatchStyle.getValue()), (Parameter)colorRef);
        return brush;
    }

    public static Brush createPatternBrush(Bitmap bitmap) {
        Brush brush = new Brush();
        Function function = Gdi32.get("CreatePatternBrush");
        function.invoke((Parameter)brush, (Parameter)bitmap);
        return brush;
    }

    public static Brush createSolidBrush(ColorRef colorRef) {
        Brush brush = new Brush();
        Function function = Gdi32.get("CreateSolidBrush");
        function.invoke((Parameter)brush, (Parameter)colorRef);
        return brush;
    }

    public static Point getBrushOrigin(DC dC) {
        Int intVal = new Int();
        Point point = new Point();
        Function function = Gdi32.get("GetBrushOrgEx");
        function.invoke((Parameter)intVal, (Parameter)dC, (Parameter)new Pointer((Parameter)point));
        if (intVal.getValue() > 0L) {
            return new Point(point.getX(), point.getY());
        }
        return null;
    }

    public static Brush getSysColorBrush(int n2) {
        Brush brush = new Brush();
        Function function = User32.getInstance().getFunction("GetSysColorBrush");
        function.invoke((Parameter)brush, (Parameter)new Int((long)n2));
        return brush;
    }

    public static Point setBrushOrigin(DC dC, int n2, int n3) {
        Int intVal = new Int();
        Point point = new Point();
        Function function = Gdi32.get("SetBrushOrgEx");
        function.invoke((Parameter)intVal, (Parameter)dC, (Parameter)new Int((long)n2), (Parameter)new Int((long)n3), (Parameter)new Pointer((Parameter)point));
        if (intVal.getValue() > 0L) {
            return new Point(point.getX(), point.getY());
        }
        return null;
    }

    public static class StockBrush
    extends EnumItem {
        public static final StockBrush WHITE_BRUSH = new StockBrush(0);
        public static final StockBrush LTGRAY_BRUSH = new StockBrush(1);
        public static final StockBrush GRAY_BRUSH = new StockBrush(2);
        public static final StockBrush DKGRAY_BRUSH = new StockBrush(3);
        public static final StockBrush BLACK_BRUSH = new StockBrush(4);
        public static final StockBrush NULL_BRUSH;
        public static final StockBrush HOLLOW_BRUSH;

        private StockBrush(int n2) {
            super(n2);
        }

        static {
            HOLLOW_BRUSH = NULL_BRUSH = new StockBrush(5);
        }
    }

    public static class HatchStyle
    extends EnumItem {
        public static final HatchStyle BDIAGONAL = new HatchStyle(3);
        public static final HatchStyle CROSS = new HatchStyle(4);
        public static final HatchStyle DIAGCROSS = new HatchStyle(5);
        public static final HatchStyle FDIAGONAL = new HatchStyle(2);
        public static final HatchStyle VERTICAL = new HatchStyle(1);
        public static final HatchStyle HORIZONTAL = new HatchStyle(0);

        private HatchStyle(int n2) {
            super(n2);
        }
    }

    public static class BrushStyle
    extends EnumItem {
        public static final BrushStyle SOLID = new BrushStyle(0);
        public static final BrushStyle NULL;
        public static final BrushStyle HOLLOW;
        public static final BrushStyle HATCHED;
        public static final BrushStyle PATTERN;
        public static final BrushStyle DIBPATTERN;
        public static final BrushStyle DIBPATTERNPT;
        public static final BrushStyle PATTERN8X8;
        public static final BrushStyle DIBPATTERN8X8;

        private BrushStyle(int n2) {
            super(n2);
        }

        static {
            HOLLOW = NULL = new BrushStyle(1);
            HATCHED = new BrushStyle(2);
            PATTERN = new BrushStyle(3);
            DIBPATTERN = new BrushStyle(5);
            DIBPATTERNPT = new BrushStyle(6);
            PATTERN8X8 = new BrushStyle(7);
            DIBPATTERN8X8 = new BrushStyle(8);
        }
    }
}

