/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxdesktop;

import java.awt.event.KeyListener;
import java.util.LinkedList;
import java.util.List;
import teamdev.jxdesktop.PlatformContext;
import teamdev.jxdesktop.win32.WindowsKeyboard;

public abstract class Keyboard {
    protected List listeners = new LinkedList();

    protected Keyboard() {
    }

    public static Keyboard createKeyboard() {
        if (PlatformContext.isWindows()) {
            return new WindowsKeyboard();
        }
        throw new UnsupportedOperationException("Unsupported operating system.");
    }

    public void addKeyListener(KeyListener keyListener) {
        if (!this.listeners.contains(keyListener)) {
            this.listeners.add(keyListener);
        }
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.listeners.remove(keyListener);
    }

    public KeyListener[] getKeyListeners() {
        return (KeyListener[])this.listeners.toArray();
    }

    public abstract void dispose();
}

