/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxcapture.samples.demo;

import java.awt.Component;
import java.io.File;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Resource;
import org.jdesktop.application.ResourceMap;
import teamdev.jxcapture.samples.demo.ApplicationSettings;
import teamdev.jxcapture.samples.demo.CaptureOperations;
import teamdev.jxcapture.samples.demo.ImageFileChooser;
import teamdev.jxcapture.samples.demo.ImageViewer;

public class TrayPopupMenu
extends JPopupMenu {
    @Resource
    private String[] captureActions;
    private boolean captureOperationEnabled = true;
    private ApplicationSettings settings = ApplicationSettings.getInstance();
    private CaptureOperations operations = CaptureOperations.getInstance();

    public TrayPopupMenu() {
        this.createGUI();
        this.configCaptureOperations();
    }

    private void createGUI() {
        ApplicationContext applicationContext = Application.getInstance().getContext();
        ResourceMap resourceMap = applicationContext.getResourceMap(TrayPopupMenu.class);
        ApplicationActionMap applicationActionMap = applicationContext.getActionMap(TrayPopupMenu.class, (Object)this);
        this.captureActions = new String[resourceMap.getInteger("captureActions.size").intValue()];
        resourceMap.injectFields((Object)this);
        resourceMap.injectComponents((Component)this);
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(applicationActionMap.get((Object)"captureToViewer"));
        JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(applicationActionMap.get((Object)"captureToFile"));
        JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem(applicationActionMap.get((Object)"captureToClipboard"));
        jRadioButtonMenuItem.setSelected(this.settings.isCaptureToViewer());
        jRadioButtonMenuItem2.setSelected(this.settings.isCaptureToFile());
        jRadioButtonMenuItem3.setSelected(this.settings.isCaptureToClipboard());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem3);
        buttonGroup.add(jRadioButtonMenuItem2);
        JMenu jMenu = new JMenu("Capture To");
        jMenu.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem3);
        jMenu.add(jRadioButtonMenuItem2);
        JMenuItem jMenuItem = new JMenuItem(applicationActionMap.get((Object)"settings"));
        jMenuItem.setIcon(resourceMap.getIcon("settings.menu.icon"));
        jMenuItem.setAccelerator(null);
        this.addMenuItems((ActionMap)applicationActionMap, this.captureActions);
        this.addSeparator();
        this.add(jMenu);
        this.addSeparator();
        this.add(jMenuItem);
        this.addMenuItems((ActionMap)applicationActionMap, new String[]{"about"});
        this.addSeparator();
        this.addMenuItems((ActionMap)applicationActionMap, new String[]{"quit"});
    }

    private void configCaptureOperations() {
        this.operations.addCaptureOperationsListener(new CaptureOperations.CaptureOperationsListener(){

            @Override
            public void operationBegin() {
                TrayPopupMenu.this.setCaptureOperationEnabled(false);
            }

            @Override
            public void operationComplete(boolean bl) {
                TrayPopupMenu.this.setCaptureOperationEnabled(true);
            }
        });
    }

    private void addMenuItems(ActionMap actionMap, String[] stringArray) {
        for (String string : stringArray) {
            this.add(new JMenuItem(actionMap.get(string)));
        }
    }

    public boolean isCaptureOperationEnabled() {
        return this.captureOperationEnabled;
    }

    public void setCaptureOperationEnabled(boolean bl) {
        boolean bl2 = this.captureOperationEnabled;
        this.captureOperationEnabled = bl;
        this.firePropertyChange("captureOperationEnabled", bl2, this.captureOperationEnabled);
    }

    @Action(enabledProperty="captureOperationEnabled")
    public void activeWindowCapture() {
        this.operations.activeWindowCapture();
    }

    @Action(enabledProperty="captureOperationEnabled")
    public void objectCapture() {
        this.operations.objectCapture();
    }

    @Action(enabledProperty="captureOperationEnabled")
    public void regionCapture() {
        this.operations.regionCapture();
    }

    @Action(enabledProperty="captureOperationEnabled")
    public void desktopCapture() {
        this.operations.desktopCapture();
    }

    @Action(enabledProperty="captureOperationEnabled")
    public void openImage() {
        ImageViewer imageViewer;
        ImageFileChooser imageFileChooser = new ImageFileChooser();
        File file = imageFileChooser.openImageFile();
        if (file != null && (imageViewer = new ImageViewer()).setImage(file)) {
            imageViewer.setVisible(true);
            imageViewer.toFront();
        }
    }

    @Action
    public void captureToViewer() {
        this.settings.setCaptureToViewer();
    }

    @Action
    public void captureToFile() {
        this.settings.setCaptureToFile();
    }

    @Action
    public void captureToClipboard() {
        this.settings.setCaptureToClipboard();
    }
}

