/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxcapture.samples.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class TimerDialog {
    private final Rectangle rectangle = new Rectangle(74, 46, 69, 23);
    private final Dimension dialogSize = new Dimension(150, 75);
    private final ImageIcon mouseEnterImage = new ImageIcon(TimerDialog.class.getResource("resources/images/mouseEnter.png"));
    private final ImageIcon mouseLeaveImage = new ImageIcon(TimerDialog.class.getResource("resources/images/mouseLeave.png"));
    private final ImageIcon mousePressImage = new ImageIcon(TimerDialog.class.getResource("resources/images/mousePress.png"));
    private ImageIcon currentImage = this.mouseLeaveImage;
    private JWindow dialog;
    private TimerListener timerListener;
    private Timer dialogTimer = new Timer();
    private int delayTime;
    private boolean mousePressed;

    public TimerDialog(int n) {
        this.delayTime = n;
        this.dialog = new JWindow();
        this.dialog.setContentPane(this.createContentPane());
        this.dialog.setSize(this.dialogSize);
        this.dialog.setLocation(this.getLocation());
        this.dialog.setAlwaysOnTop(true);
    }

    private JComponent createContentPane() {
        final TimerPane timerPane = new TimerPane();
        timerPane.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                this.updateDialog(mouseEvent.getPoint());
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                this.updateDialog(mouseEvent.getPoint());
            }

            private void updateDialog(Point point) {
                if (TimerDialog.this.rectangle.contains(point)) {
                    TimerDialog.this.currentImage = TimerDialog.this.mousePressed ? TimerDialog.this.mousePressImage : TimerDialog.this.mouseEnterImage;
                    timerPane.repaint();
                } else {
                    TimerDialog.this.currentImage = TimerDialog.this.mouseLeaveImage;
                    timerPane.repaint();
                }
            }
        });
        timerPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (TimerDialog.this.rectangle.contains(mouseEvent.getPoint())) {
                    TimerDialog.this.mousePressed = true;
                    TimerDialog.this.currentImage = TimerDialog.this.mousePressImage;
                    timerPane.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (TimerDialog.this.rectangle.contains(mouseEvent.getPoint()) && TimerDialog.this.mousePressed) {
                    TimerDialog.this.currentImage = TimerDialog.this.mouseEnterImage;
                    timerPane.repaint();
                    TimerDialog.this.complete(true);
                }
                TimerDialog.this.mousePressed = false;
            }
        });
        return timerPane;
    }

    private Point getLocation() {
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        return new Point(rectangle.width - this.dialogSize.width, rectangle.height - this.dialogSize.height);
    }

    private void complete(boolean bl) {
        this.dialogTimer.cancel();
        this.dialog.setVisible(false);
        this.dialog.dispose();
        if (this.timerListener != null) {
            this.timerListener.complete(bl);
        }
    }

    public void show(TimerListener timerListener) {
        this.timerListener = timerListener;
        this.dialog.setVisible(true);
        this.dialogTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TimerDialog.this.delayTime--;
                        TimerDialog.this.dialog.repaint();
                        if (TimerDialog.this.delayTime == 0) {
                            TimerDialog.this.complete(false);
                        }
                    }
                });
            }
        }, 0L, 1000L);
    }

    public static interface TimerListener {
        public void complete(boolean var1);
    }

    private class TimerPane
    extends JPanel {
        private TimerPane() {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.drawImage(TimerDialog.this.currentImage.getImage(), 0, 0, null);
            graphics2D.setFont(new Font("Verdana", 0, 45));
            graphics2D.setColor(Color.WHITE);
            graphics2D.drawString(String.valueOf(TimerDialog.this.delayTime), 15, 55);
        }
    }
}

