/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxcapture.samples.demo;

import java.awt.SystemTray;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.EventObject;
import java.util.List;
import javax.swing.JPopupMenu;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import teamdev.jxcapture.samples.demo.AboutDialog;
import teamdev.jxcapture.samples.demo.ApplicationSettings;
import teamdev.jxcapture.samples.demo.CaptureOperations;
import teamdev.jxcapture.samples.demo.ImageViewer;
import teamdev.jxcapture.samples.demo.SettingsDialog;
import teamdev.jxcapture.samples.demo.TrayPopupMenu;
import teamdev.jxdesktop.Keyboard;
import teamdev.jxdesktop.win32.gdi.Icon;
import teamdev.jxdesktop.win32.shell.TrayIcon;
import teamdev.jxdesktop.win32.shell.TrayMessage;

public class JxCaptureDemo
extends SingleFrameApplication {
    private TrayIcon trayIcon;
    private InputStream inputStream;
    private Keyboard keyboard = Keyboard.createKeyboard();
    private KeyListener keyboardListener = new KeyListener();

    protected void startup() {
        System.setProperty("javax.swing.adjustPopupLocationToFit", "false");
        ApplicationSettings.getInstance().loadSettings();
        if (SystemTray.isSupported()) {
            ApplicationContext applicationContext = Application.getInstance().getContext();
            ResourceMap resourceMap = applicationContext.getResourceMap(JxCaptureDemo.class);
            String string = resourceMap.getString("TrayIcon.tooltip", new Object[0]);
            String string2 = resourceMap.getString("TrayIcon.caption", new Object[0]);
            String string3 = resourceMap.getString("TrayIcon.text", new Object[0]);
            this.trayIcon = new TrayIcon();
            this.trayIcon.setToolTip(string);
            this.trayIcon.setIcon(this.getTrayIcon());
            this.trayIcon.setPopupMenu((JPopupMenu)new TrayPopupMenu());
            this.trayIcon.setVisible(true);
            this.trayIcon.showMessage((TrayMessage)new TrayMessage.Info(string2, string3));
        } else {
            this.showApplicationWindow();
        }
        this.keyboard.addKeyListener((java.awt.event.KeyListener)this.keyboardListener);
        this.addExitListener(new ExitListener());
    }

    protected void shutdown() {
        super.shutdown();
        if (this.trayIcon != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            this.trayIcon.setVisible(false);
            this.trayIcon.dispose();
            this.trayIcon = null;
        }
        this.keyboard.removeKeyListener((java.awt.event.KeyListener)this.keyboardListener);
        this.keyboard.dispose();
        ApplicationSettings.getInstance().saveSettings();
    }

    @Action
    public void about() {
        AboutDialog.getInstance().setVisible(true);
    }

    @Action
    public void settings() {
        SettingsDialog.getInstance().setVisible(true);
    }

    @Action
    public void quit() {
        this.exit();
    }

    private Icon getTrayIcon() {
        URL uRL = JxCaptureDemo.class.getResource("resources/images/JxCapture.ico");
        try {
            this.inputStream = uRL.openStream();
            return new Icon(this.inputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private void showApplicationWindow() {
        throw new UnsupportedOperationException("JxCapture Demo window is not supported yet.");
    }

    public static void main(String[] stringArray) throws Exception {
        JxCaptureDemo.launch(JxCaptureDemo.class, (String[])stringArray);
    }

    private class KeyListener
    extends KeyAdapter {
        private CaptureOperations operations = CaptureOperations.getInstance();

        private KeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isControlDown() && keyEvent.isShiftDown() && !this.operations.isBusy()) {
                switch (keyEvent.getKeyCode()) {
                    case 65: {
                        this.operations.activeWindowCapture();
                        break;
                    }
                    case 87: {
                        this.operations.objectCapture();
                        break;
                    }
                    case 82: {
                        this.operations.regionCapture();
                        break;
                    }
                    case 70: {
                        this.operations.desktopCapture();
                    }
                }
            }
        }
    }

    private class ExitListener
    implements Application.ExitListener {
        private ExitListener() {
        }

        public boolean canExit(EventObject eventObject) {
            List<ImageViewer> list = CaptureOperations.getInstance().getActiveViewers();
            for (ImageViewer imageViewer : list) {
                if (imageViewer.close()) continue;
                return false;
            }
            return true;
        }

        public void willExit(EventObject eventObject) {
        }
    }
}

