/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxcapture.samples.demo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Resource;
import org.jdesktop.application.ResourceMap;

public final class ApplicationSettings {
    private static ApplicationSettings instance;
    @Resource
    private int maxDelayTime;
    @Resource
    private String[] imageFormats;
    @Resource
    private String[] formatDescriptions;
    @Resource
    private String configFileName;
    private Map imageFormatExtensions = new HashMap();
    private boolean captureToViewer = true;
    private boolean captureToFile;
    private boolean captureToClipboard;
    private boolean includeCursor;
    private boolean captureTransparentWindows;
    private boolean delayBeforeCapture;
    private boolean autoSave;
    private String templateFileName = "ScreenShot#";
    private String outputFolder = "";
    private int delayTime = 1000;
    private int imageFormatIndex;
    private int templateNumber;

    private ApplicationSettings() {
        ApplicationContext applicationContext = Application.getInstance().getContext();
        ResourceMap resourceMap = applicationContext.getResourceMap(ApplicationSettings.class);
        this.imageFormats = new String[resourceMap.getInteger("ApplicationSettings.imageFormats.length").intValue()];
        this.formatDescriptions = new String[resourceMap.getInteger("ApplicationSettings.formatDescriptions.length").intValue()];
        resourceMap.injectFields((Object)this);
        this.imageFormatExtensions.put(this.imageFormats[0], new String[]{"png", "PNG"});
        this.imageFormatExtensions.put(this.imageFormats[1], new String[]{"jpeg", "JPEG", "jpg", "JPG"});
        this.imageFormatExtensions.put(this.imageFormats[2], new String[]{"bmp", "BMP"});
        this.imageFormatExtensions.put(this.imageFormats[3], new String[]{"gif", "GIF"});
    }

    public static ApplicationSettings getInstance() {
        return instance == null ? (instance = new ApplicationSettings()) : instance;
    }

    public void saveSettings() {
        Properties properties = new Properties();
        properties.setProperty(Property.CAPTURE_TO_FILE.getName(), String.valueOf(this.captureToFile));
        properties.setProperty(Property.CAPTURE_TO_VIEWER.getName(), String.valueOf(this.captureToViewer));
        properties.setProperty(Property.CAPTURE_TO_CLIPBOARD.getName(), String.valueOf(this.captureToClipboard));
        properties.setProperty(Property.INCLUDE_CURSOR.getName(), String.valueOf(this.includeCursor));
        properties.setProperty(Property.CAPTURE_TRANSPARENT_WINDOWS.getName(), String.valueOf(this.captureTransparentWindows));
        properties.setProperty(Property.DELAY_BEFORE_CAPTURE.getName(), String.valueOf(this.delayBeforeCapture));
        properties.setProperty(Property.AUTO_SAVE.getName(), String.valueOf(this.autoSave));
        properties.setProperty(Property.TEMPLATE_FILE_NAME.getName(), this.templateFileName);
        properties.setProperty(Property.OUTPUT_FOLDER.getName(), this.outputFolder);
        properties.setProperty(Property.DELAY_TIME.getName(), String.valueOf(this.delayTime));
        properties.setProperty(Property.IMAGE_FORMAT_INDEX.getName(), String.valueOf(this.imageFormatIndex));
        properties.setProperty(Property.TEMPLATE_NUMBER.getName(), String.valueOf(this.templateNumber));
        try {
            File file = new File(this.configFileName);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            properties.storeToXML(fileOutputStream, "JxCapture Demo Application Settings");
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void loadSettings() {
        Properties properties = new Properties();
        try {
            File file = new File(this.configFileName);
            if (!file.exists()) {
                return;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            properties.loadFromXML(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        this.captureToFile = Boolean.valueOf(properties.getProperty(Property.CAPTURE_TO_FILE.getName()));
        this.captureToViewer = Boolean.valueOf(properties.getProperty(Property.CAPTURE_TO_VIEWER.getName()));
        this.captureToClipboard = Boolean.valueOf(properties.getProperty(Property.CAPTURE_TO_CLIPBOARD.getName()));
        this.includeCursor = Boolean.valueOf(properties.getProperty(Property.INCLUDE_CURSOR.getName()));
        this.captureTransparentWindows = Boolean.valueOf(properties.getProperty(Property.CAPTURE_TRANSPARENT_WINDOWS.getName()));
        this.delayBeforeCapture = Boolean.valueOf(properties.getProperty(Property.DELAY_BEFORE_CAPTURE.getName()));
        this.autoSave = Boolean.valueOf(properties.getProperty(Property.AUTO_SAVE.getName()));
        this.templateFileName = properties.getProperty(Property.TEMPLATE_FILE_NAME.getName());
        this.outputFolder = properties.getProperty(Property.OUTPUT_FOLDER.getName());
        this.delayTime = Integer.valueOf(properties.getProperty(Property.DELAY_TIME.getName()));
        this.imageFormatIndex = Integer.valueOf(properties.getProperty(Property.IMAGE_FORMAT_INDEX.getName()));
        this.templateNumber = Integer.valueOf(properties.getProperty(Property.TEMPLATE_NUMBER.getName()));
    }

    public boolean isIncludeCursor() {
        return this.includeCursor;
    }

    public void setIncludeCursor(boolean bl) {
        this.includeCursor = bl;
    }

    public boolean isCaptureTransparentWindows() {
        return this.captureTransparentWindows;
    }

    public void setCaptureTransparentWindows(boolean bl) {
        this.captureTransparentWindows = bl;
    }

    public boolean isDelayBeforeCapture() {
        return this.delayBeforeCapture;
    }

    public void setDelayBeforeCapture(boolean bl) {
        this.delayBeforeCapture = bl;
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }

    public void setAutoSave(boolean bl) {
        this.autoSave = bl;
    }

    public int getDelayTime() {
        return this.delayTime;
    }

    public void setDelayTime(int n) {
        this.delayTime = n;
    }

    public int getImageFormatIndex() {
        return this.imageFormatIndex;
    }

    public void setImageFormatIndex(int n) {
        this.imageFormatIndex = n;
    }

    public int getTemplateNumber() {
        return this.templateNumber;
    }

    public void setTemplateNumber(int n) {
        this.templateNumber = n < 0 ? 0 : n;
    }

    public String getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(String string) {
        this.outputFolder = string;
    }

    public String getTemplateFileName() {
        return this.templateFileName;
    }

    public void setTemplateFileName(String string) {
        this.templateFileName = string;
    }

    public boolean isCaptureToViewer() {
        return this.captureToViewer;
    }

    public void setCaptureToViewer() {
        this.resetCaptureToValues();
        this.captureToViewer = true;
    }

    public boolean isCaptureToFile() {
        return this.captureToFile;
    }

    public void setCaptureToFile() {
        this.resetCaptureToValues();
        this.captureToFile = true;
    }

    public boolean isCaptureToClipboard() {
        return this.captureToClipboard;
    }

    public void setCaptureToClipboard() {
        this.resetCaptureToValues();
        this.captureToClipboard = true;
    }

    public String[] getImageFormats() {
        return this.imageFormats;
    }

    public String[] getFormatExtensions(String string) {
        Object v = this.imageFormatExtensions.get(string);
        if (v == null) {
            return new String[0];
        }
        return (String[])v;
    }

    public String[] getFormatDescriptions() {
        return this.formatDescriptions;
    }

    public int getMaxDelayTime() {
        return this.maxDelayTime;
    }

    private void resetCaptureToValues() {
        this.captureToViewer = false;
        this.captureToFile = false;
        this.captureToClipboard = false;
    }

    private static enum Property {
        CAPTURE_TO_VIEWER,
        CAPTURE_TO_FILE,
        CAPTURE_TO_CLIPBOARD,
        INCLUDE_CURSOR,
        CAPTURE_TRANSPARENT_WINDOWS,
        DELAY_BEFORE_CAPTURE,
        AUTO_SAVE,
        DELAY_TIME,
        TEMPLATE_FILE_NAME,
        OUTPUT_FOLDER,
        IMAGE_FORMAT_INDEX,
        TEMPLATE_NUMBER;


        public String getName() {
            return this.toString();
        }
    }
}

