/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxcapture.samples.demo;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import teamdev.jxcapture.samples.demo.ApplicationSettings;
import teamdev.jxcapture.samples.demo.EscapeDialog;

public class SettingsDialog
extends EscapeDialog {
    private static SettingsDialog instance;
    private JCheckBox delay = new JCheckBox();
    private JCheckBox includeCursor = new JCheckBox();
    private JCheckBox transparentWindows = new JCheckBox();
    private JCheckBox autoSave = new JCheckBox();
    private JLabel folderLabel = new JLabel();
    private JLabel formatLabel = new JLabel();
    private JLabel delayTimeLabel = new JLabel();
    private JTextField outputFolder;
    private JTextField templateName;
    private JSpinner templateNumber = new JSpinner();
    private JSpinner delayTime = new JSpinner();
    private JComboBox formats;
    private JButton chooseFolder = new JButton();
    private ApplicationSettings settings = ApplicationSettings.getInstance();
    private ResourceBundle resource = ApplicationSettings.getResourceBundle();

    private SettingsDialog() {
        this.createGUI();
        this.pack();
        this.setTitle(this.resource.getString("SettingsDialog.Title"));
        this.setLocationRelativeTo(null);
        this.setResizable(false);
    }

    public static SettingsDialog getInstance() {
        return instance == null ? (instance = new SettingsDialog()) : instance;
    }

    private void createGUI() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.createContentPane(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add(Box.createGlue(), new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.createActionPane(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setContentPane(jPanel);
    }

    private JPanel createContentPane() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.createCapturePane(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.createFilePane(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createFilePane() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        String string = this.resource.getString("SettingsDialog.Border.File.Text");
        jPanel.setBorder(new BorderUIResource.TitledBorderUIResource(string));
        this.templateName = new JTextField(this.settings.getTemplateFileName(), 10);
        int n = this.settings.getTemplateNumber();
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(n, 0, 1000, 1);
        this.templateNumber.setModel(spinnerNumberModel);
        this.templateNumber.setPreferredSize(new Dimension(45, 20));
        this.outputFolder = new JTextField(this.settings.getOutputFolder(), 20);
        this.chooseFolder.setPreferredSize(new Dimension(20, 20));
        this.formats = new JComboBox<String>(this.settings.getImageFormats());
        this.formats.setPreferredSize(new Dimension(60, 20));
        this.formats.setSelectedIndex(this.settings.getImageFormatIndex());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)this.outputFolder, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 3), 0, 0));
        jPanel2.add((Component)this.chooseFolder, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 0, 0), 0, 0));
        this.chooseFolder.setAction(new ChooseFolderAction());
        this.folderLabel.setText(this.resource.getString("SettingsDialog.Label.Folder.Text"));
        this.formatLabel.setText(this.resource.getString("SettingsDialog.Label.Format.Text"));
        this.autoSave.setAction(new AutoSaveAction());
        this.autoSave.setSelected(this.settings.isAutoSave());
        JLabel jLabel = new JLabel(this.resource.getString("SettingsDialog.Label.FileNameTmp.Text"));
        JLabel jLabel2 = new JLabel(this.resource.getString("SettingsDialog.Label.StartsFrom.Text"));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 17, new Insets(0, 10, 0, 0), 0, 0));
        jPanel.add((Component)this.templateName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 6, 0, 3), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 17, new Insets(0, 3, 0, 3), 0, 0));
        jPanel.add((Component)this.templateNumber, new GridBagConstraints(3, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 0, 10), 0, 0));
        jPanel.add((Component)this.autoSave, new GridBagConstraints(0, 1, 4, 1, 1.0, 0.0, 17, 17, new Insets(11, 10, 0, 0), 0, 0));
        jPanel.add((Component)this.folderLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 13, new Insets(7, 3, 0, 3), 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(1, 2, 4, 1, 0.0, 0.0, 17, 2, new Insets(7, 3, 0, 10), 0, 0));
        jPanel.add((Component)this.formatLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 13, new Insets(7, 3, 10, 3), 0, 0));
        jPanel.add((Component)this.formats, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 17, new Insets(7, 3, 10, 10), 0, 0));
        this.updateAutoSave();
        return jPanel;
    }

    private JPanel createCapturePane() {
        this.includeCursor.setText(this.resource.getString("SettingsDialog.Label.IncludeCursor.Text"));
        this.includeCursor.setSelected(this.settings.isIncludeCursor());
        this.transparentWindows.setText(this.resource.getString("SettingsDialog.Label.CaptureTransparentWindows.Text"));
        this.transparentWindows.setSelected(this.settings.isCaptureTransparentWindows());
        JPanel jPanel = new JPanel(new GridBagLayout());
        String string = this.resource.getString("SettingsDialog.Border.Capture.Text");
        jPanel.setBorder(new BorderUIResource.TitledBorderUIResource(string));
        jPanel.add((Component)this.includeCursor, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 17, new Insets(0, 10, 3, 10), 0, 0));
        jPanel.add((Component)this.transparentWindows, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 17, new Insets(0, 10, 3, 10), 0, 0));
        jPanel.add((Component)this.createDelayTimePane(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 17, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createDelayTimePane() {
        int n = this.settings.getDelayTime() / 1000;
        int n2 = this.settings.getMaxDelayTime() / 1000;
        this.delayTime.setModel(new SpinnerNumberModel(n, 1, n2, 1));
        this.delayTime.setPreferredSize(new Dimension(50, 20));
        this.delay.setAction(new DelayBeforeCaptureAction());
        this.delay.setSelected(this.settings.isDelayBeforeCapture());
        this.delayTimeLabel.setText(this.resource.getString("SettingsDialog.Label.Seconds.Text"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.delay, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 10, 0), 0, 0));
        jPanel.add((Component)this.delayTime, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 10, 3), 0, 0));
        jPanel.add((Component)this.delayTimeLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 10, 10), 0, 0));
        this.updateDelayArea();
        return jPanel;
    }

    private JPanel createActionPane() {
        Dimension dimension = new Dimension(75, 23);
        JButton jButton = new JButton(new ApplyAction());
        jButton.setPreferredSize(dimension);
        JButton jButton2 = new JButton(new CancelAction());
        jButton2.setPreferredSize(dimension);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jButton2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 6, 0, 0), 0, 0));
        jPanel.setBorder(new EmptyBorder(10, 0, 0, 0));
        return jPanel;
    }

    private void updateDelayArea() {
        boolean bl = this.delay.isSelected();
        this.delayTime.setEnabled(bl);
        this.delayTimeLabel.setEnabled(bl);
    }

    private void updateAutoSave() {
        boolean bl = this.autoSave.isSelected();
        this.folderLabel.setEnabled(bl);
        this.formatLabel.setEnabled(bl);
        this.outputFolder.setEnabled(bl);
        this.chooseFolder.setEnabled(bl);
        this.formats.setEnabled(bl);
    }

    private String getOutputFolder() {
        String string = this.outputFolder.getText();
        if (string.length() == 0) {
            String string2 = this.resource.getString("SettingsDialog.Error.EmptyFolder.Title");
            String string3 = this.resource.getString("SettingsDialog.Error.EmptyFolder.Message");
            JOptionPane.showMessageDialog(this, string3, string2, 0);
            return null;
        }
        if (!new File(string).exists()) {
            String string4 = this.resource.getString("SettingsDialog.Error.ExistFolder.Title");
            String string5 = this.resource.getString("SettingsDialog.Error.ExistFolder.Message");
            JOptionPane.showMessageDialog(this, string5, string4, 0);
            return null;
        }
        return string;
    }

    private class CancelAction
    extends AbstractAction {
        private CancelAction() {
            this.putValue("Name", SettingsDialog.this.resource.getString("SettingsDialog.Action.Cancel.Text"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            instance.dispose();
            instance = null;
        }
    }

    private class ApplyAction
    extends AbstractAction {
        private ApplyAction() {
            this.putValue("Name", SettingsDialog.this.resource.getString("SettingsDialog.Action.Apply.Text"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = SettingsDialog.this.templateName.getText();
            if (string.length() == 0) {
                String string2 = SettingsDialog.this.resource.getString("SettingsDialog.Error.EmptyFileName.Title");
                String string3 = SettingsDialog.this.resource.getString("SettingsDialog.Error.EmptyFileName.Message");
                JOptionPane.showMessageDialog(SettingsDialog.this, string3, string2, 0);
                return;
            }
            if (SettingsDialog.this.autoSave.isSelected()) {
                String string4 = SettingsDialog.this.getOutputFolder();
                if (string4 == null) {
                    return;
                }
                SettingsDialog.this.settings.setOutputFolder(string4);
                SettingsDialog.this.settings.setImageFormatIndex(SettingsDialog.this.formats.getSelectedIndex());
            }
            SettingsDialog.this.settings.setIncludeCursor(SettingsDialog.this.includeCursor.isSelected());
            SettingsDialog.this.settings.setCaptureTransparentWindows(SettingsDialog.this.transparentWindows.isSelected());
            SettingsDialog.this.settings.setAutoSave(SettingsDialog.this.autoSave.isSelected());
            SettingsDialog.this.settings.setTemplateFileName(string);
            SettingsDialog.this.settings.setTemplateNumber((Integer)SettingsDialog.this.templateNumber.getValue());
            SettingsDialog.this.settings.setDelayBeforeCapture(SettingsDialog.this.delay.isSelected());
            if (SettingsDialog.this.settings.isDelayBeforeCapture()) {
                SettingsDialog.this.settings.setDelayTime((Integer)SettingsDialog.this.delayTime.getValue() * 1000);
            }
            instance.dispose();
            instance = null;
        }
    }

    private class DelayBeforeCaptureAction
    extends AbstractAction {
        private DelayBeforeCaptureAction() {
            this.putValue("Name", SettingsDialog.this.resource.getString("SettingsDialog.Action.DelayBefore.Text"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SettingsDialog.this.updateDelayArea();
        }
    }

    private class AutoSaveAction
    extends AbstractAction {
        private AutoSaveAction() {
            this.putValue("Name", SettingsDialog.this.resource.getString("SettingsDialog.Action.AutoSave.Text"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SettingsDialog.this.updateAutoSave();
        }
    }

    private class ChooseFolderAction
    extends AbstractAction {
        private ChooseFolderAction() {
            this.putValue("Name", "...");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(1);
            int n = jFileChooser.showOpenDialog(SettingsDialog.this);
            if (n == 0) {
                String string = jFileChooser.getSelectedFile().getAbsolutePath();
                SettingsDialog.this.outputFolder.setText(string);
            }
        }
    }
}

