/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxcapture.samples.demo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import teamdev.jxcapture.samples.demo.AboutDialog;
import teamdev.jxcapture.samples.demo.ApplicationSettings;
import teamdev.jxcapture.samples.demo.CaptureOperations;
import teamdev.jxcapture.samples.demo.ImageComponent;
import teamdev.jxcapture.samples.demo.ImageFileChooser;
import teamdev.jxcapture.samples.demo.SettingsDialog;

public class ImageViewer
extends JFrame {
    private static final String ZOOM_IN_PROPERTY = "zoomInEnabled";
    private static final String ZOOM_OUT_PROPERTY = "zoomOutEnabled";
    private ResourceBundle resource = ApplicationSettings.getResourceBundle();
    private OpenAction openAction = new OpenAction();
    private SaveAction saveAction = new SaveAction();
    private CloseAction closeAction = new CloseAction();
    private ZoomInAction zoomInAction = new ZoomInAction();
    private ZoomOutAction zoomOutAction = new ZoomOutAction();
    private ZoomToAction zoomToAction = new ZoomToAction();
    private ActualSizeAction actualSizeAction = new ActualSizeAction();
    private FitToWindowAction fitToWindowAction = new FitToWindowAction();
    private CopyAction copyAction = new CopyAction();
    private SettingsAction settingsAction = new SettingsAction();
    private AboutAction aboutAction = new AboutAction();
    private ImageComponent imageComponent;
    private JButton zoomToButton;
    private boolean zoomInEnabled = true;
    private boolean zoomOutEnabled = true;
    private boolean imageModified = false;
    private List percentActions = new LinkedList();
    private JPopupMenu zoomToPopupMenu = new JPopupMenu();
    static /* synthetic */ Class class$teamdev$jxcapture$samples$demo$ImageViewer;

    public ImageViewer() throws HeadlessException {
        this.setSize(750, 500);
        this.setLocationRelativeTo(null);
        this.setTitle(this.resource.getString("ImageViewer.Title"));
        URL uRL = this.getClass().getResource("resources/images/JxCapture.png");
        this.setIconImage(new ImageIcon(uRL).getImage());
        this.createMenuBar();
        this.createContentPane();
        this.setDefaultCloseOperation(0);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals(ImageViewer.ZOOM_IN_PROPERTY)) {
                    ImageViewer.this.zoomInAction.setEnabled((Boolean)propertyChangeEvent.getNewValue());
                } else if (string.equals(ImageViewer.ZOOM_OUT_PROPERTY)) {
                    ImageViewer.this.zoomOutAction.setEnabled((Boolean)propertyChangeEvent.getNewValue());
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ImageViewer.this.close();
            }
        });
    }

    private void createMenuBar() {
        JMenuItem jMenuItem = new JMenuItem(this.openAction);
        JMenuItem jMenuItem2 = new JMenuItem(this.saveAction);
        JMenuItem jMenuItem3 = new JMenuItem(this.closeAction);
        JMenuItem jMenuItem4 = new JMenuItem(this.zoomInAction);
        JMenuItem jMenuItem5 = new JMenuItem(this.zoomOutAction);
        JMenuItem jMenuItem6 = new JMenuItem(this.actualSizeAction);
        JMenuItem jMenuItem7 = new JMenuItem(this.fitToWindowAction);
        JMenuItem jMenuItem8 = new JMenuItem(this.copyAction);
        JMenuItem jMenuItem9 = new JMenuItem(this.settingsAction);
        JMenuItem jMenuItem10 = new JMenuItem(this.aboutAction);
        JMenu jMenu = new JMenu(this.resource.getString("ImageViewer.Action.ZoomTo.Text"));
        this.configZoomToMenu(jMenu);
        jMenuItem.setIcon(this.getIcon("Open", "Menu"));
        jMenuItem2.setIcon(this.getIcon("Save", "Menu"));
        jMenuItem3.setIcon(this.getIcon("Close", "Menu"));
        jMenuItem4.setIcon(this.getIcon("ZoomIn", "Menu"));
        jMenuItem5.setIcon(this.getIcon("ZoomOut", "Menu"));
        jMenu.setIcon(this.getIcon("ZoomTo", "Menu"));
        jMenuItem8.setIcon(this.getIcon("Copy", "Menu"));
        jMenuItem9.setIcon(this.getIcon("Settings", "Menu"));
        JMenu jMenu2 = new JMenu(this.resource.getString("ImageViewer.Menu.FileMenu.Text"));
        JMenu jMenu3 = new JMenu(this.resource.getString("ImageViewer.Menu.ViewMenu.Text"));
        JMenu jMenu4 = new JMenu(this.resource.getString("ImageViewer.Menu.EditMenu.Text"));
        JMenu jMenu5 = new JMenu(this.resource.getString("ImageViewer.Menu.SettingsMenu.Text"));
        JMenu jMenu6 = new JMenu(this.resource.getString("ImageViewer.Menu.HelpMenu.Text"));
        jMenu2.add(jMenuItem);
        jMenu2.add(jMenuItem2);
        jMenu2.addSeparator();
        jMenu2.add(jMenuItem3);
        jMenu3.add(jMenuItem4);
        jMenu3.add(jMenuItem5);
        jMenu3.add(jMenu);
        jMenu3.addSeparator();
        jMenu3.add(jMenuItem6);
        jMenu3.add(jMenuItem7);
        jMenu4.add(jMenuItem8);
        jMenu5.add(jMenuItem9);
        jMenu6.add(jMenuItem10);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        jMenuBar.add(jMenu4);
        jMenuBar.add(jMenu5);
        jMenuBar.add(jMenu6);
        this.setJMenuBar(jMenuBar);
    }

    private Icon getIcon(String string, String string2) {
        String string3 = this.resource.getString("ImageViewer.Action." + string + "." + string2 + ".Icon");
        URL uRL = (class$teamdev$jxcapture$samples$demo$ImageViewer == null ? (class$teamdev$jxcapture$samples$demo$ImageViewer = ImageViewer.class$("teamdev.jxcapture.samples.demo.ImageViewer")) : class$teamdev$jxcapture$samples$demo$ImageViewer).getResource(string3);
        return new ImageIcon(uRL);
    }

    private JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setBorderPainted(false);
        jToolBar.add(this.createToolBarButton(this.openAction, "Open"));
        jToolBar.add(this.createToolBarButton(this.saveAction, "Save"));
        jToolBar.addSeparator();
        jToolBar.add(this.createToolBarButton(this.copyAction, "Copy"));
        jToolBar.addSeparator();
        jToolBar.add(this.createToolBarButton(this.zoomInAction, "ZoomIn"));
        jToolBar.add(this.createToolBarButton(this.zoomOutAction, "ZoomOut"));
        jToolBar.add(this.createZoomToButton());
        jToolBar.addSeparator();
        jToolBar.add(this.createToolBarButton(this.settingsAction, "Settings"));
        return jToolBar;
    }

    private JButton createToolBarButton(AbstractAction abstractAction, String string) {
        JButton jButton = new JButton();
        jButton.setBorder(new EmptyBorder(5, 5, 5, 5));
        jButton.setVerticalTextPosition(3);
        jButton.setHorizontalTextPosition(0);
        jButton.setAction(abstractAction);
        jButton.setIcon(this.getIcon(string, "Button"));
        jButton.setFocusable(false);
        return jButton;
    }

    private ImageComponent getImageComponent() {
        return this.imageComponent == null ? (this.imageComponent = new ImageComponent()) : this.imageComponent;
    }

    private JButton createZoomToButton() {
        this.zoomToButton = this.createToolBarButton(this.zoomToAction, "ZoomTo");
        this.zoomToPopupMenu.add(new JMenuItem(this.actualSizeAction));
        this.zoomToPopupMenu.add(new JMenuItem(this.fitToWindowAction));
        this.zoomToPopupMenu.addSeparator();
        List list = this.getZoomToActions();
        for (int i = 0; i < list.size(); ++i) {
            PercentAction percentAction = (PercentAction)list.get(i);
            this.zoomToPopupMenu.add(new JMenuItem(percentAction));
        }
        this.zoomToPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                ImageViewer.this.zoomToButton.setSelected(true);
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                ImageViewer.this.zoomToButton.setSelected(false);
            }

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        return this.zoomToButton;
    }

    private void configZoomToMenu(JMenu jMenu) {
        List list = this.getZoomToActions();
        for (int i = 0; i < list.size(); ++i) {
            PercentAction percentAction = (PercentAction)list.get(i);
            jMenu.add(new JMenuItem(percentAction));
        }
    }

    private List getZoomToActions() {
        if (this.percentActions == null || this.percentActions.isEmpty()) {
            int[] nArray = this.getImageComponent().getPercents();
            for (int i = 0; i < nArray.length; ++i) {
                this.percentActions.add(new PercentAction(nArray[i], i));
            }
        }
        return this.percentActions;
    }

    private void createContentPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.createToolBar(), "North");
        jPanel.add((Component)new JScrollPane(this.getImageComponent()), "Center");
        this.setContentPane(jPanel);
    }

    private void updateZoomActionState() {
        this.setZoomInEnabled(this.getImageComponent().canZoomIn());
        this.setZoomOutEnabled(this.getImageComponent().canZoomOut());
    }

    private boolean isImageModified() {
        return this.imageModified;
    }

    private void setImageModified(boolean bl) {
        this.imageModified = bl;
    }

    private boolean confirmSaveImage() {
        String string = this.resource.getString("ImageViewer.Confirm.SaveImageDialog.Title");
        String string2 = this.resource.getString("ImageViewer.Confirm.SaveImageDialog.Message");
        int n = JOptionPane.showConfirmDialog(this, string2, string, 1);
        switch (n) {
            case 0: {
                return this.save();
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public void setImage(BufferedImage bufferedImage) {
        this.getImageComponent().setImage(bufferedImage);
        this.setImageModified(true);
    }

    public boolean setImage(File file) {
        try {
            this.getImageComponent().setImage(file);
        }
        catch (Exception exception) {
            String string = this.resource.getString("ImageViewer.Error.OpenImageDialog.Title");
            String string2 = this.resource.getString("ImageViewer.Error.OpenImageDialog.Message");
            JOptionPane.showMessageDialog(this, string2, string, 0);
            return false;
        }
        this.setImageModified(false);
        return true;
    }

    public void setZoomInEnabled(boolean bl) {
        boolean bl2 = this.zoomInEnabled;
        this.zoomInEnabled = bl;
        this.firePropertyChange(ZOOM_IN_PROPERTY, bl2, this.zoomInEnabled);
    }

    public void setZoomOutEnabled(boolean bl) {
        boolean bl2 = this.zoomOutEnabled;
        this.zoomOutEnabled = bl;
        this.firePropertyChange(ZOOM_OUT_PROPERTY, bl2, this.zoomOutEnabled);
    }

    public boolean close() {
        if (this.isImageModified() && !this.confirmSaveImage()) {
            return false;
        }
        this.getImageComponent().dispose();
        this.setVisible(false);
        this.dispose();
        return true;
    }

    public boolean save() {
        ImageFileChooser imageFileChooser = new ImageFileChooser(this);
        File file = imageFileChooser.saveImageFile();
        if (file != null) {
            try {
                this.getImageComponent().saveImage(file);
                this.setImageModified(false);
                return true;
            }
            catch (Exception exception) {
                String string = this.resource.getString("ImageViewer.Error.SaveImageDialog.Title");
                String string2 = this.resource.getString("ImageViewer.Error.SaveImageDialog.Message");
                JOptionPane.showMessageDialog(this, string2, string, 0);
                return false;
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private abstract class FullAction
    extends SimpleAction {
        protected FullAction(String string) {
            super(string);
            String string2 = ImageViewer.this.resource.getString("ImageViewer.Action." + string + ".Accelerator");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(string2));
        }
    }

    private abstract class SimpleAction
    extends AbstractAction {
        protected SimpleAction(String string) {
            String string2 = ImageViewer.this.resource.getString("ImageViewer.Action." + string + ".ShortDescription");
            this.putValue("ShortDescription", string2);
            this.putValue("Name", ImageViewer.this.resource.getString("ImageViewer.Action." + string + ".Text"));
        }
    }

    private class PercentAction
    extends AbstractAction {
        private int index = 0;

        public PercentAction(int n, int n2) {
            this.index = n2;
            this.putValue("Name", n + " %");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(String.valueOf(n2 + 1)));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImageViewer.this.getImageComponent().zoomTo(this.index);
            ImageViewer.this.updateZoomActionState();
        }
    }

    private class FitToWindowAction
    extends FullAction {
        private FitToWindowAction() {
            super("FitToWindow");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImageComponent imageComponent = ImageViewer.this.getImageComponent();
            Dimension dimension = imageComponent.getParent().getSize();
            imageComponent.fitToWindow(dimension);
        }
    }

    private class ActualSizeAction
    extends FullAction {
        private ActualSizeAction() {
            super("ActualSize");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImageViewer.this.getImageComponent().actualSize();
            ImageViewer.this.updateZoomActionState();
        }
    }

    private class ZoomToAction
    extends SimpleAction {
        private ZoomToAction() {
            super("ZoomTo");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImageViewer.this.zoomToPopupMenu.show(ImageViewer.this.zoomToButton, 0, ((ImageViewer)ImageViewer.this).zoomToButton.getBounds().height);
        }
    }

    private class ZoomOutAction
    extends FullAction {
        private ZoomOutAction() {
            super("ZoomOut");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImageComponent imageComponent = ImageViewer.this.getImageComponent();
            if (imageComponent.canZoomOut()) {
                imageComponent.zoomOut();
            }
            ImageViewer.this.updateZoomActionState();
        }
    }

    private class ZoomInAction
    extends FullAction {
        private ZoomInAction() {
            super("ZoomIn");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImageComponent imageComponent = ImageViewer.this.getImageComponent();
            if (imageComponent.canZoomIn()) {
                imageComponent.zoomIn();
            }
            ImageViewer.this.updateZoomActionState();
        }
    }

    private class CopyAction
    extends FullAction {
        private CopyAction() {
            super("Copy");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CaptureOperations.getInstance().copyToClipboard(ImageViewer.this.getImageComponent().getImage());
        }
    }

    private class SaveAction
    extends FullAction {
        private SaveAction() {
            super("Save");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImageViewer.this.save();
        }
    }

    private class OpenAction
    extends FullAction {
        private OpenAction() {
            super("Open");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ImageViewer.this.isImageModified() && !ImageViewer.this.confirmSaveImage()) {
                return;
            }
            ImageFileChooser imageFileChooser = new ImageFileChooser(ImageViewer.this);
            File file = imageFileChooser.openImageFile();
            if (file != null) {
                ImageViewer.this.setImage(file);
            }
        }
    }

    private class CloseAction
    extends FullAction {
        private CloseAction() {
            super("Close");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImageViewer.this.close();
        }
    }

    private class SettingsAction
    extends FullAction {
        private SettingsAction() {
            super("Settings");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ SettingsAction this$1;
                {
                    this.this$1 = settingsAction;
                }

                public void run() {
                    SettingsDialog settingsDialog = SettingsDialog.getInstance();
                    settingsDialog.setLocationRelativeTo(SettingsAction.access$1500(this.this$1));
                    settingsDialog.setModal(true);
                    settingsDialog.setVisible(true);
                    settingsDialog.toFront();
                }
            });
        }

        static /* synthetic */ ImageViewer access$1500(SettingsAction settingsAction) {
            return settingsAction.ImageViewer.this;
        }
    }

    private class AboutAction
    extends FullAction {
        private AboutAction() {
            super("About");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ AboutAction this$1;
                {
                    this.this$1 = aboutAction;
                }

                public void run() {
                    AboutDialog aboutDialog = AboutDialog.getInstance();
                    aboutDialog.setLocationRelativeTo(AboutAction.access$1400(this.this$1));
                    aboutDialog.setModal(true);
                    aboutDialog.setVisible(true);
                    aboutDialog.toFront();
                }
            });
        }

        static /* synthetic */ ImageViewer access$1400(AboutAction aboutAction) {
            return aboutAction.ImageViewer.this;
        }
    }
}

