/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxcapture.samples.demo;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import teamdev.jxcapture.samples.demo.ApplicationSettings;

public class ImageFileChooser {
    private Component owner;

    public ImageFileChooser() {
        this(null);
    }

    public ImageFileChooser(Component component) {
        this.owner = component;
    }

    public File openImageFile() {
        return this.showDialog(false);
    }

    public File saveImageFile() {
        File file = this.showDialog(true);
        if (file != null && file.exists()) {
            ResourceBundle resourceBundle = ApplicationSettings.getResourceBundle();
            String string = resourceBundle.getString("FileChooser.Confirm.FileExistsDialog.Title");
            String string2 = resourceBundle.getString("FileChooser.Confirm.FileExistsDialog.Message");
            int n = JOptionPane.showConfirmDialog(this.owner, string2 = string2.replaceAll("%s", file.getName()), string, 0);
            if (n == 1) {
                ApplicationSettings applicationSettings = ApplicationSettings.getInstance();
                int n2 = applicationSettings.getTemplateNumber();
                applicationSettings.setTemplateNumber(--n2);
                return this.saveImageFile();
            }
        }
        return file;
    }

    private File showDialog(boolean bl) {
        Object object;
        int n;
        Object object2;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setAcceptAllFileFilterUsed(false);
        FileFilter[] fileFilterArray = this.getFilters();
        for (int i = 0; i < fileFilterArray.length; ++i) {
            object2 = fileFilterArray[i];
            jFileChooser.addChoosableFileFilter((FileFilter)object2);
        }
        if (!bl) {
            jFileChooser.addChoosableFileFilter(new AllImageFilesFilter());
        }
        jFileChooser.setAccessory(new ImagePreview(jFileChooser));
        jFileChooser.setDialogTitle(bl ? "Save As" : "Open");
        if (bl) {
            String string = this.getFileName();
            jFileChooser.setSelectedFile(new File(string));
        }
        JFrame jFrame = new JFrame();
        object2 = this.getClass().getResource("resources/images/JxCapture.png");
        jFrame.setIconImage(new ImageIcon((URL)object2).getImage());
        Component component = this.owner != null ? this.owner : jFrame;
        int n2 = n = bl ? jFileChooser.showSaveDialog(component) : jFileChooser.showOpenDialog(component);
        if (n == 0 && (object = jFileChooser.getSelectedFile()) != null) {
            String string = ((File)object).getName();
            int n3 = string.lastIndexOf(".");
            if (n3 == -1) {
                FileFilter fileFilter = jFileChooser.getFileFilter();
                ImageFileFilter imageFileFilter = (ImageFileFilter)fileFilter;
                String string2 = imageFileFilter.getExtension();
                String string3 = ((File)object).getAbsolutePath();
                return new File(string3 + "." + string2);
            }
            return object;
        }
        object = ApplicationSettings.getInstance();
        ((ApplicationSettings)object).setTemplateNumber(((ApplicationSettings)object).getTemplateNumber() - 1);
        return null;
    }

    private String getFileName() {
        ApplicationSettings applicationSettings = ApplicationSettings.getInstance();
        String string = applicationSettings.getTemplateFileName();
        int n = applicationSettings.getTemplateNumber();
        applicationSettings.setTemplateNumber(++n);
        return string.replaceAll("#", String.valueOf(n));
    }

    public FileFilter[] getFilters() {
        ApplicationSettings applicationSettings = ApplicationSettings.getInstance();
        String[] stringArray = applicationSettings.getFormatDescriptions();
        String[] stringArray2 = applicationSettings.getImageFormats();
        FileFilter[] fileFilterArray = new ImageFileFilter[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            String[] stringArray3 = applicationSettings.getFormatExtensions(stringArray2[i]);
            if (stringArray3.length <= 0) continue;
            fileFilterArray[i] = new ImageFileFilter(stringArray3, stringArray[i]);
        }
        return fileFilterArray;
    }

    public class ImagePreview
    extends JComponent
    implements PropertyChangeListener {
        ImageIcon thumbnail = null;
        File file = null;

        public ImagePreview(JFileChooser jFileChooser) {
            this.setPreferredSize(new Dimension(100, 50));
            jFileChooser.addPropertyChangeListener(this);
        }

        public void loadImage() {
            if (this.file == null) {
                this.thumbnail = null;
                return;
            }
            ImageIcon imageIcon = new ImageIcon(this.file.getPath());
            this.thumbnail = imageIcon.getIconWidth() > 90 ? new ImageIcon(imageIcon.getImage().getScaledInstance(90, -1, 1)) : imageIcon;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            boolean bl = false;
            String string = propertyChangeEvent.getPropertyName();
            if ("directoryChanged".equals(string)) {
                this.file = null;
                bl = true;
            } else if ("SelectedFileChangedProperty".equals(string)) {
                this.file = (File)propertyChangeEvent.getNewValue();
                bl = true;
            }
            if (bl) {
                this.thumbnail = null;
                if (this.isShowing()) {
                    this.loadImage();
                    this.repaint();
                }
            }
        }

        protected void paintComponent(Graphics graphics) {
            if (this.thumbnail == null) {
                this.loadImage();
            }
            if (this.thumbnail != null) {
                int n = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
                int n2 = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2;
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n < 5) {
                    n = 5;
                }
                this.thumbnail.paintIcon(this, graphics, n, n2);
            }
        }
    }

    private class AllImageFilesFilter
    extends FileFilter {
        private AllImageFilesFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String[] stringArray = ApplicationSettings.getInstance().getImageFormats();
            for (int i = 0; i < stringArray.length; ++i) {
                if (file.getName().endsWith("." + stringArray[i].toUpperCase())) {
                    return true;
                }
                if (!file.getName().endsWith("." + stringArray[i].toLowerCase())) continue;
                return true;
            }
            return false;
        }

        public String getDescription() {
            return "All Formats";
        }
    }

    private class ImageFileFilter
    extends FileFilter {
        private String[] extensions;
        private String description;

        public ImageFileFilter(String[] stringArray, String string) {
            this.extensions = stringArray;
            this.description = string;
        }

        public boolean accept(File file) {
            if (file.isFile()) {
                String string = file.getName();
                for (int i = 0; i < this.extensions.length; ++i) {
                    if (!string.endsWith("." + this.extensions[i])) continue;
                    return true;
                }
                return false;
            }
            return file.isDirectory();
        }

        public String getDescription() {
            return this.description;
        }

        public String getExtension() {
            return this.extensions[0];
        }

        public String toString() {
            return this.description;
        }
    }
}

