/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxcapture.samples.demo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.BorderUIResource;
import teamdev.jxcapture.samples.demo.ApplicationSettings;

public class HelperComponent
extends JComponent {
    private static final int ZOOM_VALUE = 5;
    private static final int IMAGE_SIZE = 180;
    private static final int BORDER_OFFSET = 36;
    private static final int AREA_OFFSET = 18;
    private final Color borderColor1 = new Color(105, 105, 105);
    private final Color borderColor2 = new Color(210, 210, 210);
    private final Color backgroundColor = new Color(149, 149, 149);
    private BufferedImage backgroundImage;
    private Image currentThumbnail;
    private Rectangle currentRect = new Rectangle();
    private Point currentPoint = new Point();
    private JLabel navigationBar = new JLabel();

    public HelperComponent(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth() + 36;
        int n2 = bufferedImage.getHeight() + 36;
        this.backgroundImage = new BufferedImage(n, n2, 1);
        Graphics graphics = this.backgroundImage.getGraphics();
        graphics.drawImage(bufferedImage, 18, 18, null);
        Dimension dimension = new Dimension(200, 370);
        this.setPreferredSize(dimension);
        this.setSize(dimension);
        this.createHelpPane();
        this.updateNavigationBar();
    }

    public void updateComponent(Point point, Rectangle rectangle) {
        this.currentPoint = point;
        this.currentRect = rectangle;
        this.updateNavigationBar();
        this.updateThumbnail();
    }

    private void createHelpPane() {
        this.setBorder(new BorderUIResource.EmptyBorderUIResource(200, 10, 10, 10));
        this.setLayout(new BorderLayout());
        ResourceBundle resourceBundle = ApplicationSettings.getResourceBundle();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel(resourceBundle.getString("HelpDialog.Label.Selection1.Text"));
        JLabel jLabel2 = new JLabel(resourceBundle.getString("HelpDialog.Label.Selection2.Text"));
        JLabel jLabel3 = new JLabel(resourceBundle.getString("HelpDialog.Label.Cancel.Text"));
        JLabel jLabel4 = new JLabel(resourceBundle.getString("HelpDialog.Label.Help.Text"));
        jLabel.setForeground(Color.WHITE);
        jLabel2.setForeground(Color.WHITE);
        jLabel3.setForeground(Color.WHITE);
        jLabel4.setForeground(Color.DARK_GRAY);
        this.navigationBar.setHorizontalAlignment(0);
        this.navigationBar.setForeground(Color.WHITE);
        jPanel.add((Component)this.navigationBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 5, 0), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel4, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 11, 2, new Insets(10, 0, 0, 0), 0, 0));
        jPanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel, "Center");
    }

    private void updateThumbnail() {
        if (this.currentThumbnail != null) {
            this.currentThumbnail.flush();
            this.currentThumbnail = null;
        }
        this.currentThumbnail = this.createThumbnail(this.currentPoint, this.currentRect, 180);
        this.repaint();
    }

    private void updateNavigationBar() {
        this.navigationBar.setText("<html><b><p align='center'>X = " + this.currentPoint.x + ", Y = " + this.currentPoint.y + "</p>Width = " + this.currentRect.width + ", Height = " + this.currentRect.height);
    }

    private Image createThumbnail(Point point, Rectangle rectangle, int n) {
        int n2 = point.x;
        int n3 = point.y;
        this.drawSelectedRect(rectangle);
        BufferedImage bufferedImage = this.backgroundImage.getSubimage(n2, n3, 36, 36);
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
        Graphics graphics = bufferedImage2.getGraphics();
        graphics.drawImage(bufferedImage, 0, 0, null);
        this.drawSelectedRect(rectangle);
        if (rectangle.isEmpty()) {
            graphics.setXORMode(Color.RED);
            graphics.drawLine(18, 13, 18, 23);
            graphics.drawLine(13, 18, 23, 18);
        }
        return bufferedImage2.getScaledInstance(n, n, 2);
    }

    private void drawSelectedRect(Rectangle rectangle) {
        if (!rectangle.isEmpty()) {
            Graphics graphics = this.backgroundImage.getGraphics();
            graphics.setXORMode(Color.BLACK);
            graphics.drawRect(rectangle.x + 18, rectangle.y + 18, rectangle.width, rectangle.height);
        }
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Rectangle rectangle = this.getBounds();
        graphics.setColor(this.borderColor1);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        graphics.setColor(this.borderColor2);
        graphics.drawRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 3, rectangle.height - 3);
        graphics.setColor(this.backgroundColor);
        graphics.fillRect(rectangle.x + 2, rectangle.y + 2, rectangle.width - 4, rectangle.height - 4);
        if (this.currentThumbnail != null) {
            graphics.drawImage(this.currentThumbnail, 10, 10, null);
        }
    }
}

