Option Strict Off
Option Explicit On 
Imports System.Runtime.InteropServices


Module HDiskInfo
    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Ansi)> Structure DiskInfo
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=20)> Public SerialNumber As String
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=40)> Public ModelNumber As String
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=8)> Public RevisionNo As String
        Dim BufferSize As Integer
        Dim Cylinders As Integer
        Dim Heads As Integer
        Dim Sectors As Integer
    End Structure

    Public Declare Function GetIdeDiskInfo Lib "GetDiskSerial.dll" (ByVal DriveNo As Short, ByRef DiskInfo As DiskInfo, ByVal sRegNumber As String) As Integer
    Public Declare Function GetSerialNumber Lib "GetDiskSerial.dll" (ByVal DriveNo As Short, ByVal sRegNumber As String) As String
    Public Declare Function GetModelNumber Lib "GetDiskSerial.dll" (ByVal DriveNo As Short, ByVal sRegNumber As String) As String
    Public Declare Function GetRevisionNo Lib "GetDiskSerial.dll" (ByVal DriveNo As Short, ByVal sRegNumber As String) As String
    Public Declare Function GetBufferSize Lib "GetDiskSerial.dll" (ByVal DriveNo As Short, ByVal sRegNumber As String) As Short
    Public Declare Function GetCylinders Lib "GetDiskSerial.dll" (ByVal DriveNo As Short, ByVal sRegNumber As String) As Short
    Public Declare Function GetHeads Lib "GetDiskSerial.dll" (ByVal DriveNo As Short, ByVal sRegNumber As String) As Short
    Public Declare Function GetSectors Lib "GetDiskSerial.dll" (ByVal DriveNo As Short, ByVal sRegNumber As String) As Short
End Module