#include "Python.h"
#include "dislin.h"
#include "dislinmodule.h"

static int nspline = 200;
static char *clegbf;
static int ilegop = 0;
static int g_imetfl = 0;
static float x3len = 2., y3len = 2., z3len = 2.;
static float x3view = 4., y3view = -5., z3view = 4.;

void swgfoc (int i);
void winupd ();
void sclpax (int i);

int  qqsetvar (int ivar);
void get_scale (float *p, int n, float *x);
void set_scaling (float *x, int iax, float *xa);
int check_var (char *s);
void rpoint (float x, float y, float z, int npb, int nph);
static PyObject *qqplot (PyObject *self, PyObject *args, int iopt);
static PyObject *qqsurface (PyObject *self, PyObject *args, int iopt);
static PyObject *qqcontour (PyObject *self, PyObject *args, int iopt);

void dis_callbck (int ip, int *i1);
void dis_callbck2 (int ip);
float dis_funcbck (float x, float y, int iopt);
float dis_funcbck2 (float x, float y);
static int ncbray = 0;
static int icbray[MAX_CB];
static PyObject *ocbray[MAX_CB], *ocbfunc;
static PyObject *ocbpar[MAX_CB];

static getlength (PyObject *o)
{ int m;

  if (!PySequence_Check (o))
  { PyErr_SetString (PyExc_ValueError, "parameter is not a sequence");
      return -1;
  }

  m = PyObject_Length (o);
  if (m < 0)
  { PyErr_SetString (PyExc_ValueError, "sequence has no length");
      return -1;
  }
  
  return m;
}

static int fltarray (PyObject **o, float **p, int n)
{ float  *f;
  PyObject *item;  
  int    i, m;

  if ((m = getlength (*o)) < 0) return 0;
  
  if (m < n)
  { PyErr_SetString (PyExc_MemoryError, "out of range");
    return 0;
  }
 
  if ((*p = (float *) calloc (n, 4)) == NULL)
  { PyErr_SetString (PyExc_MemoryError, "out of memory");
    return 0;
  }

  f = *p;
  for (i = 0; i < n; i++)
  { item = PySequence_GetItem (*o, i);
    if (item == NULL)
    { PyErr_SetString (PyExc_ValueError, "sequence error");
      free (*p);
      return 0;
    }
    if (PyFloat_Check(item))
      f[i] = (float) PyFloat_AsDouble (item);       
    else if (PyInt_Check(item))
      f[i] = (float) PyInt_AsLong (item);       
    else
    { PyErr_SetString (PyExc_ValueError, 
                       "no floatingpoint element in sequence");
      free (*p);
      Py_DECREF(item);
      return 0;
    }

    Py_DECREF(item);
  }

  return 1;
}

static int fltmatrix (PyObject **o, float **p, int n1, int n2)
{ float  *f;
  int    i, j, k, n, m, m1, m2;
  PyObject *item, *item2;

  /* n1 : number of rows, n2: number of columns */

  if (!PySequence_Check (*o))
  { PyErr_SetString (PyExc_ValueError, "parameter is not a sequence");
      return 0;
  }

  m1 = PyObject_Length (*o);
  if (m1 < 0)
  { PyErr_SetString (PyExc_ValueError, "sequence has no length");
      return 0;
  }

  item = PySequence_GetItem (*o, 0);
  if (item == NULL)
  { PyErr_SetString (PyExc_ValueError, "sequence error");
    return 0;
  }

  if (!PySequence_Check (item))      /* Matrix seems to a 1 dim array    */
    m2 = 1;
  else
  { m2 = PyObject_Length (item);     /* Matrix seems to be a 2 dim array */
    if (m2 < 0)
    { PyErr_SetString (PyExc_ValueError, "sequence has no length");
      Py_DECREF(item);
      return 0;
    }
  }
  Py_DECREF(item);
  
  n = n1 * n2;
  m = m1 * m2;

  if (m < n)
  { PyErr_SetString (PyExc_MemoryError, "out of range");
    return 0;
  }
 
  if ((*p = (float *) calloc (m, 4)) == NULL)
  { PyErr_SetString (PyExc_MemoryError, "out of memory");
    return 0;
  }

  f = *p;
  k=0;
  for (i = 0; i < m1; i++)
  { item = PySequence_GetItem (*o, i);
    if (item == NULL)
    { PyErr_SetString (PyExc_ValueError, "sequence error");
      free (*p);
      return 0;
    }
    if (PySequence_Check (item))
    { j = PyObject_Length (item);
      if (j != m2)
      { PyErr_SetString (PyExc_ValueError, 
                  "matrix rows have different lengths");
        free (*p);
        Py_DECREF(item);
        return 0;
      }
      for (j = 0; j < m2; j++)
      { item2 = PySequence_GetItem (item, j);
        if (item2 == NULL)
        { PyErr_SetString (PyExc_MemoryError, "sequence error");
          free (*p);
          Py_DECREF(item);
          return 0;
        }
        if (PyFloat_Check(item2))
          f[k++] = (float) PyFloat_AsDouble (item2);       
        else if (PyInt_Check(item2))
          f[k++] = (float) PyInt_AsLong (item2);       
        else
        { PyErr_SetString (PyExc_ValueError, 
                          "no floatingpoint element in sequence");
          free (*p);
          Py_DECREF(item2);
          Py_DECREF(item);
          return 0;
        }
        Py_DECREF(item2);
      }
    }
    else if (PyFloat_Check(item))
      f[k++] = (float) PyFloat_AsDouble (item);       
    else if (PyInt_Check(item))
      f[k++] = (float) PyInt_AsLong (item);       
    else
    { PyErr_SetString (PyExc_ValueError, 
                      "no floatingpoint element in sequence");
      free (*p);
      Py_DECREF(item);
      return 0;
    }

    Py_DECREF(item);
  }
  return 1;
}

static int fltmatrix3 (PyObject **o, float **p, int n1, int n2, int n3)
{ float  *f;
  int    i, j, jj, k, n, m, m1, m2, m3;
  PyObject *item, *item2, *item3;

  if (!PySequence_Check (*o))
  { PyErr_SetString (PyExc_ValueError, "parameter is not a sequence");
      return 0;
  }

  m1 = PyObject_Length (*o);
  if (m1 < 0)
  { PyErr_SetString (PyExc_ValueError, "sequence has no length");
      return 0;
  }

  item = PySequence_GetItem (*o, 0);
  if (item == NULL)
  { PyErr_SetString (PyExc_ValueError, "sequence error");
    return 0;
  }

  if (!PySequence_Check (item))      /* Matrix seems to a 1 dim array    */
  { m2 = 1;
    m3 = 1;
  }
  else
  { m2 = PyObject_Length (item);     /* Matrix seems to be a 3 dim array */

    if (m2 < 0)
    { PyErr_SetString (PyExc_ValueError, "sequence has no length");
      Py_DECREF(item);
      return 0;
    }

    item2 = PySequence_GetItem (item, 0);
    if (item2 == NULL)
    { PyErr_SetString (PyExc_ValueError, "sequence error");
      Py_DECREF(item);
      return 0;
    } 
    m3= PyObject_Length (item2);

    if (m3 < 0)
    { PyErr_SetString (PyExc_ValueError, "sequence has no length");
      Py_DECREF(item);
      Py_DECREF(item2);
      return 0;
    }
    Py_DECREF(item2);
  }
  Py_DECREF(item);
  
  n = n1 * n2 * n3;
  m = m1 * m2 * m3;

  if (m < n)
  { PyErr_SetString (PyExc_MemoryError, "out of range");
    return 0;
  }
 
  if ((*p = (float *) calloc (m, 4)) == NULL)
  { PyErr_SetString (PyExc_MemoryError, "out of memory");
    return 0;
  }

  f = *p;
  k=0;
  for (i = 0; i < m1; i++)
  { item = PySequence_GetItem (*o, i);
    if (item == NULL)
    { PyErr_SetString (PyExc_ValueError, "sequence error");
      free (*p);
      return 0;
    }
    if (PySequence_Check (item))
    { j = PyObject_Length (item);
      if (j != m2)
      { PyErr_SetString (PyExc_ValueError, 
                  "matrix rows have different lengths");
        free (*p);
        Py_DECREF(item);
        return 0;
      }
      for (j = 0; j < m2; j++)
      { item2 = PySequence_GetItem (item, j);
        if (item2 == NULL)
        { PyErr_SetString (PyExc_MemoryError, "sequence error");
          free (*p);
          Py_DECREF(item);
          return 0;
        }
        for (jj = 0; jj < m3; jj++)
        { item3 = PySequence_GetItem (item2, jj);
          if (item3 == NULL)
          { PyErr_SetString (PyExc_MemoryError, "sequence error");
            free (*p);
            Py_DECREF(item);
            Py_DECREF(item2);
            return 0;
          }

          if (PyFloat_Check(item3))
            f[k++] = (float) PyFloat_AsDouble (item3);       
          else if (PyInt_Check(item3))
            f[k++] = (float) PyInt_AsLong (item3);       
          else
          { PyErr_SetString (PyExc_ValueError, 
                            "no floatingpoint element in sequence");
            free (*p);
            Py_DECREF(item3);
            Py_DECREF(item2);
            Py_DECREF(item);
            return 0;
          }
          Py_DECREF(item3);
        }
        Py_DECREF(item2);
      }
    }
    else if (PyFloat_Check(item))
      f[k++] = (float) PyFloat_AsDouble (item);       
    else if (PyInt_Check(item))
      f[k++] = (float) PyInt_AsLong (item);       
    else
    { PyErr_SetString (PyExc_ValueError, 
                      "no floatingpoint element in sequence");
      free (*p);
      Py_DECREF(item);
      return 0;
    }

    Py_DECREF(item);
  }
  return 1;
}

static int intarray (PyObject **o, int **p, int n)
{ int  i, m;
  PyObject *item;  
  int  *f;

  if ((m = getlength (*o)) < 0) return 0;
  
  if (m < n)
  { PyErr_SetString (PyExc_MemoryError, "out of range");
    return 0;
  }
 
  if ((*p = (int *) calloc (n, 4)) == NULL)
  { PyErr_SetString (PyExc_MemoryError, "out of memory");
    return 0;
  }

  f = *p;
  for (i = 0; i < n; i++)
  { item = PySequence_GetItem (*o, i);
    if (item == NULL)
    { PyErr_SetString (PyExc_MemoryError, "sequence error");
      free (*p);
      return 0;
    }
    if (PyInt_Check(item))
      f[i] = (int) PyInt_AsLong (item);       
    else
    { PyErr_SetString (PyExc_ValueError, "no integer element in sequence");
      free (*p);
      Py_DECREF(item);
      return 0;
    }

    Py_DECREF(item);
  }

  return 1;
}

static int longarray (PyObject **o, long **p, int n)
{ int  i, m;
  PyObject *item;  
  long  *f;

  if ((m = getlength (*o)) < 0) return 0;

  if (m < n)
  { PyErr_SetString (PyExc_MemoryError, "out of range");
    return 0;
  }
 
  if ((*p = (long *) calloc (n, 4)) == NULL)
  { PyErr_SetString (PyExc_MemoryError, "out of memory");
    return 0;
  }

  f = *p;
  for (i = 0; i < n; i++)
  { item = PySequence_GetItem (*o, i);
    if (item == NULL)
    { PyErr_SetString (PyExc_MemoryError, "sequence error");
      free (*p);
      return 0;
    }
    if (PyInt_Check(item))
      f[i] = PyLong_AsLong (item);       
    else
    { PyErr_SetString (PyExc_ValueError, "no integer element in sequence");
      free (*p);
      Py_DECREF(item);
      return 0;
    }

    Py_DECREF(item);
  }

  return 1;
}

static int copyintarray (int *p, PyObject *o, int n)
{ PyObject *item;
  int i;

  for (i = 0; i < n; i++)
  { item = PyInt_FromLong ((long) p[i]);
    PySequence_SetItem (o, i, item);
    Py_DECREF (item);
  }

  return 0;
}

static int copyfloatarray (float *p, PyObject *o, int n)
{ PyObject *item;
  int i;

  for (i = 0; i < n; i++)
  { item = PyFloat_FromDouble ((double) p[i]);
    PySequence_SetItem (o, i, item);
    Py_DECREF (item);
  }

  return 0;
}

static PyObject *dislin_abs3pt (PyObject *self, PyObject *args)
{ float x, y, z, xp, yp;

  if (!PyArg_ParseTuple (args, "fff", &x, &y, &z)) return NULL;
  abs3pt (x, y, z, &xp, &yp);
  return Py_BuildValue ("ff", xp, yp);
}

static PyObject *dislin_addlab (PyObject *self, PyObject *args)
{ char *s1, *s2;
  float v;
  int i; 
  if (!PyArg_ParseTuple (args, "sfis", &s1, &v, &i, &s2)) return NULL;
  addlab (s1, v, i, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_angle (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  angle (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_arcell (PyObject *self, PyObject *args)
{ int nx, ny, na, nb;
  float a, b, t;
  
  if (!PyArg_ParseTuple (args, "iiiifff", &nx, &ny, &na, &nb,
                         &a, &b, &t)) return NULL;
  arcell (nx, ny, na, nb, a, b, t);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_areaf (PyObject *self, PyObject *args)
{ PyObject *o1, *o2;
  int  *p1, *p2;
  int  n, i1, i2;

  if (!PyArg_ParseTuple (args, "OOi", &o1, &o2, &n)) return NULL;
  if (n < 1) goto L1;

  i1 = intarray (&o1, &p1, n);
  i2 = intarray (&o2, &p2, n);

  if (i1 != 0 && i2 != 0) areaf (p1, p2, n);
  
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i1 == 0 || i2 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_autres (PyObject *self, PyObject *args)
{ int i1, i2;
  if (!PyArg_ParseTuple (args, "ii", &i1, &i2)) return NULL;
  autres (i1, i2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_ax2grf (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  ax2grf();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_ax3len (PyObject *self, PyObject *args)
{ int nx, ny, nz;

  if (!PyArg_ParseTuple (args, "iii", &nx, &ny, &nz)) return NULL;
  ax3len (nx, ny, nz);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_axclrs (PyObject *self, PyObject *args)
{ char *s1, *s2;
  int n;

  if (!PyArg_ParseTuple (args, "iss", &n, &s1, &s2)) return NULL;
  axclrs (n, s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_axends (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  axends (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_axgit (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  axgit();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_axis3d (PyObject *self, PyObject *args)
{ float x, y, z;

  if (!PyArg_ParseTuple (args, "fff", &x, &y, &z)) return NULL;
  axis3d (x, y, z);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_axsbgd (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  axsbgd (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_axslen (PyObject *self, PyObject *args)
{ int nx, ny;

  if (!PyArg_ParseTuple (args, "ii", &nx, &ny)) return NULL;
  axslen (nx, ny);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_axsorg (PyObject *self, PyObject *args)
{ int nx, ny;

  if (!PyArg_ParseTuple (args, "ii", &nx, &ny)) return NULL;
  axsorg (nx, ny);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_axspos (PyObject *self, PyObject *args)
{ int nx, ny;

  if (!PyArg_ParseTuple (args, "ii", &nx, &ny)) return NULL;
  axspos (nx, ny);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_axstyp (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  axstyp (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_barbor (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  barbor (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_barclr (PyObject *self, PyObject *args)
{ int i1, i2, i3;

  if (!PyArg_ParseTuple (args, "iii", &i1, &i2, &i3)) return NULL;
  barclr (i1, i2, i3);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_bargrp (PyObject *self, PyObject *args)
{ int n;
  float x;

  if (!PyArg_ParseTuple (args, "if", &n, &x)) return NULL;
  bargrp (n, x);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_barmod (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  barmod (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_baropt (PyObject *self, PyObject *args)
{ float x1, x2;

  if (!PyArg_ParseTuple (args, "ff", &x1, &x2)) return NULL;
  baropt (x1, x2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_barpos (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  barpos (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_bars (PyObject *self, PyObject *args)
{ PyObject *o1, *o2, *o3;
  float *p1, *p2, *p3;
  int  n, i1, i2, i3;

  if (!PyArg_ParseTuple (args, "OOOi", &o1, &o2, &o3, &n)) return NULL;
  if (n < 1) goto L1;

  i1 = fltarray (&o1, &p1, n);
  i2 = fltarray (&o2, &p2, n);
  i3 = fltarray (&o3, &p3, n);

  if (i1 != 0 && i2 != 0 && i3 != 0) bars (p1, p2, p3, n);
  
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i3 == 1) free (p3);
  if (i1 == 0 || i2 == 0 || i3 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_bars3d (PyObject *self, PyObject *args)
{ PyObject *o1, *o2, *o3, *o4, *o5, *o6, *o7;
  float *p1, *p2, *p3, *p4, *p5, *p6;
  int  n, i1, i2, i3, i4, i5, i6, i7, *p7;

  if (!PyArg_ParseTuple (args, "OOOOOOOi", &o1, &o2, &o3, 
           &o4, &o5, &o6, &o7, &n)) return NULL;
  if (n < 1) goto L1;

  i1 = fltarray (&o1, &p1, n);
  i2 = fltarray (&o2, &p2, n);
  i3 = fltarray (&o3, &p3, n);
  i4 = fltarray (&o4, &p4, n);
  i5 = fltarray (&o5, &p5, n);
  i6 = fltarray (&o6, &p6, n);
  i7 = intarray (&o7, &p7, n);

  if (i1 != 0 && i2 != 0 && i3 != 0 && i4 != 0 && i5 != 0 &&
      i6 != 0 && i7 != 0) bars3d (p1, p2, p3, p4, p5, p6, p7, n);
  
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i3 == 1) free (p3);
  if (i4 == 1) free (p4);
  if (i5 == 1) free (p5);
  if (i6 == 1) free (p6);
  if (i7 == 1) free (p7);
  if (i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0 || i5 == 0 ||
      i6 == 0 || i7 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_bartyp (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  bartyp (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_barwth (PyObject *self, PyObject *args)
{ float x;

  if (!PyArg_ParseTuple (args, "f", &x)) return NULL;
  barwth (x);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_basalf (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  basalf (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_basdat (PyObject *self, PyObject *args)
{ int id, im, iy;

  if (!PyArg_ParseTuple (args, "iii", &id, &im, &iy)) return NULL;
  basdat (id, im, iy);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_bezier (PyObject *self, PyObject *args)
{ PyObject *o1, *o2, *o3, *o4;
  float *p1, *p2, *p3, *p4;
  char  *s;
  int  n, i1, i2, i3, i4, i, np;

  if (!PyArg_ParseTuple (args, "OOiOOi", &o1, &o2, &n, 
                         &o3, &o4, &np)) return NULL;
  if (n < 1 || np < 1) goto L1;

  i1 = fltarray (&o1, &p1, n);
  i2 = fltarray (&o2, &p2, n);
  i3 = fltarray (&o3, &p3, np);
  i4 = fltarray (&o4, &p4, np);  

  if (i1 != 0 && i2 != 0 && i3 != 0 && i4 != 0)
  { bezier (p1, p2, n, p3, p4, np);
    if (i3 == 1) copyfloatarray (p3, o3, np);
    if (i4 == 1) copyfloatarray (p4, o4, np);
  }
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i3 == 1) free (p3);
  if (i4 == 1) free (p4);
  if (i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}


static PyObject *dislin_bitsi2 (PyObject *self, PyObject *args)
{ int nbits, mher, iher, mhin, ihin, i;

  if (!PyArg_ParseTuple (args, "iiiii", &nbits, &mher, &iher,
                         &mhin, &ihin)) return NULL;
  i = bitsi2 (nbits, (short) mher, iher, (short) mhin, ihin);
  return Py_BuildValue ("i", i);
}

static PyObject *dislin_bitsi4 (PyObject *self, PyObject *args)
{ int nbits, mher, iher, mhin, ihin, i;

  if (!PyArg_ParseTuple (args, "iiiii", &nbits, &mher, &iher,
                         &mhin, &ihin)) return NULL;
  i = bitsi4 (nbits, mher, iher, mhin, ihin);
  return Py_BuildValue ("i", i);
}

static PyObject *dislin_bmpfnt (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  bmpfnt (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_box2d (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  box2d();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_box3d (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  box3d();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_center (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  center();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_cgmbgd (PyObject *self, PyObject *args)
{ float xr, xg, xb;
  if (!PyArg_ParseTuple (args, "fff", &xr, &xg, &xb)) return NULL;
  cgmbgd (xr, xg, xb);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_cgmpic (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  cgmpic (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_cgmver (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  cgmver (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_chaang (PyObject *self, PyObject *args)
{ float x;

  if (!PyArg_ParseTuple (args, "f", &x)) return NULL;
  chaang (x);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_chacod (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  chacod (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_chaspc (PyObject *self, PyObject *args)
{ float x;

  if (!PyArg_ParseTuple (args, "f", &x)) return NULL;
  chaspc (x);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_chawth (PyObject *self, PyObject *args)
{ float x;

  if (!PyArg_ParseTuple (args, "f", &x)) return NULL;
  chawth (x);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_chnatt (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  chnatt();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_chncrv (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  chncrv (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_chndot (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  chndot();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_chndsh (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  chndsh();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_chnbar (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  chnbar (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_chnpie (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  chnpie (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_circ3p (PyObject *self, PyObject *args)
{ float x1, y1, x2, y2, x3, y3, xm, ym, r;

  if (!PyArg_ParseTuple (args, "ffffff", &x1, &y1, &x2, &y2, &x3, &y3))
      return NULL;
  circ3p (x1, y1, x2, y2, x3, y3, &xm, &ym, &r);
  return Py_BuildValue ("fff", xm, ym, r);
}

static PyObject *dislin_circle (PyObject *self, PyObject *args)
{ int nx, ny, nr;
  float x;

  if (!PyArg_ParseTuple (args, "iii", &nx, &ny, &nr)) return NULL;
  circle (nx, ny, nr);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_circsp (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  circsp (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_clip3d (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  clip3d (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_closfl (PyObject *self, PyObject *args)
{ int n, i;

  if (!PyArg_ParseTuple (args, "i", &i)) return NULL;
  n = closfl (i);
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_clpbor (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  clpbor (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_clpmod (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  clpmod (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_clpwin (PyObject *self, PyObject *args)
{ int nx, ny, nw, nh;

  if (!PyArg_ParseTuple (args, "iiii", &nx, &ny, &nw, &nh)) return NULL;
  clpwin (nx, ny, nw, nh);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_clrcyc (PyObject *self, PyObject *args)
{ int nx, ny;

  if (!PyArg_ParseTuple (args, "ii", &nx, &ny)) return NULL;
  clrcyc (nx, ny);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_clrmod (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  clrmod (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_clswin (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  clswin (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_color (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  color (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_colran (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "ii", &i1, &i2)) return NULL;
  colran (i1, i2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_colray (PyObject *self, PyObject *args)
{ PyObject *o1, *o2;
  float *p1;
  int   *p2;
  int  n, i1, i2;

  if (!PyArg_ParseTuple (args, "OOi", &o1, &o2, &n)) return NULL;
  if (n < 1) goto L1;

  i1 = fltarray (&o1, &p1, n);
  i2 = intarray (&o2, &p2, n);

  if (i1 != 0 && i2 != 0)
  { colray (p1, p2, n);
    copyintarray (p2, o2, n);
  }
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i1 == 0 || i2 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_complx (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  complx();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_conclr (PyObject *self, PyObject *args)
{ PyObject *o1;
  int  *p1;
  int  n, i1;

  if (!PyArg_ParseTuple (args, "Oi", &o1, &n)) return NULL;
  if (n < 1) goto L1;

  i1 = intarray (&o1, &p1, n);

  if (i1 != 0) conclr (p1, n);
  
  if (i1 == 1) free (p1);
  if (i1 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_concrv (PyObject *self, PyObject *args)
{ PyObject *o1, *o2;
  float *p1, *p2, zlev;
  int  n, i1, i2;

  if (!PyArg_ParseTuple (args, "OOif", &o1, &o2, &n, &zlev)) return NULL;
  if (n < 1) goto L1;

  i1 = fltarray (&o1, &p1, n);
  i2 = fltarray (&o2, &p2, n);

  if (i1 != 0 && i2 != 0) concrv (p1, p2, n, zlev);
  
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i1 == 0 || i2 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_confll (PyObject *self, PyObject *args)
{ PyObject *o1, *o2, *o3, *o4, *o5, *o6, *o7;
  float *p1, *p2, *p3, *p7;
  int   *p4, *p5, *p6;  
  int i1, i2, i3, i4, i5, i6, i7, n, ntri, nlev;

  if (!PyArg_ParseTuple (args, "OOOiOOOiOi", &o1, &o2, &o3, &n,
                         &o4, &o5, &o6, &ntri, &o7, &nlev))  return NULL;
  if (n < 1 || ntri < 1) goto L1;

  i1 = fltarray  (&o1, &p1, n);
  i2 = fltarray  (&o2, &p2, n);
  i3 = fltarray  (&o3, &p3, n);
  i4 = intarray  (&o4, &p4, ntri);
  i5 = intarray  (&o5, &p5, ntri);
  i6 = intarray  (&o6, &p6, ntri);
  i7 = fltarray  (&o7, &p7, nlev);
  
  if (i1 != 0 && i2 != 0 && i3 != 0 &&
      i4 != 0 && i5 != 0 && i6 != 0) 
    confll (p1, p2, p3, n, p4, p5, p6, ntri, p7, nlev);
  
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i3 == 1) free (p3);
  if (i4 == 1) free (p4);
  if (i5 == 1) free (p5);
  if (i6 == 1) free (p6);
  if (i7 == 1) free (p7);

  if (i1 == 0 || i2 == 0 || i3 == 0 || 
      i4 == 0 || i5 == 0 || i6 == 0 || i7 == 0)  return NULL;
  
L1:
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_congap (PyObject *self, PyObject *args)
{ float x;

  if (!PyArg_ParseTuple (args, "f", &x)) return NULL;
  congap (x);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_conlab (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  conlab (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_conmat (PyObject *self, PyObject *args)
{ PyObject *o;
  float *p, zlev;
  int  n, m, i;

  if (!PyArg_ParseTuple (args, "Oiif", &o, &n, &m, &zlev)) return NULL;
  if (n < 1 || m < 1) goto L1;

  i = fltmatrix (&o, &p, n, m);
  if (i != 0) conmat (p, n, m, zlev);
  
  if (i == 1) free (p);
  if (i == 0) return NULL;
  
L1:
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_conmod (PyObject *self, PyObject *args)
{ float x, y;

  if (!PyArg_ParseTuple (args, "ff", &x, &y)) return NULL;
  conmod (x, y);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_conn3d (PyObject *self, PyObject *args)
{ float x, y, z;

  if (!PyArg_ParseTuple (args, "fff", &x, &y, &z)) return NULL;
  conn3d (x, y, z);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_connpt (PyObject *self, PyObject *args)
{ float x, y;

  if (!PyArg_ParseTuple (args, "ff", &x, &y)) return NULL;
  connpt (x, y);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_conpts (PyObject *self, PyObject *args)
{ PyObject *o1, *o2, *o3, *o4, *o5, *o6;
  float *p1, *p2, *p3, *p4, *p5, zlev;
  int i1, i2, i3, i4, i5, i6, *p6, n, m, i = 0, maxpts, maxray;

  if (!PyArg_ParseTuple (args, "OiOiOfOOiOi", &o1, &n, &o2, &m,
                &o3, &zlev, &o4, &o5, &maxpts, &o6, &maxray))  return NULL;
  if (n < 1 || m < 1 || maxpts < 1 || maxray < 1) goto L1;

  i1 = fltarray  (&o1, &p1, n);
  i2 = fltarray  (&o2, &p2, m);
  i3 = fltmatrix (&o3, &p3, n, m);
  i4 = fltarray  (&o4, &p4, maxpts);
  i5 = fltarray  (&o5, &p5, maxpts);
  i6 = intarray  (&o6, &p6, maxray);
  
  if (i1 != 0 && i2 != 0 && i3 != 0 && i4 != 0 && i5 != 0 && i6 != 0)
  { conpts (p1, n, p2, m, p3, zlev, p4, p5, maxpts, p6, maxray, &i);
    if (i4 == 1) copyfloatarray (p4, o4, maxpts);
    if (i5 == 1) copyfloatarray (p5, o5, maxpts);
    if (i6 == 1) copyintarray   (p6, o6, maxray);
  }
  
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i3 == 1) free (p3);
  if (i4 == 1) free (p4);
  if (i5 == 1) free (p5);
  if (i6 == 1) free (p6);
  if (i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0 || i5 == 0 || i6 == 0)
     return NULL;
  
L1:
  return Py_BuildValue ("i", i);
}

static PyObject *dislin_conshd (PyObject *self, PyObject *args)
{ PyObject *o1, *o2, *o3, *o4;
  float *p1, *p2, *p3, *p4;
  int i1, i2, i3, i4, n, m, nn, nlev;

  if (!PyArg_ParseTuple (args, "OiOiOOi", &o1, &n, &o2, &m,
                         &o3, &o4, &nlev)) return NULL;
  nn = n * m;
  if (n < 1 || m < 1 || nn < 1 || nlev < 1) goto L1;

  i1 = fltarray  (&o1, &p1, n);
  i2 = fltarray  (&o2, &p2, m);
  i3 = fltmatrix (&o3, &p3, n, m);
  i4 = fltarray  (&o4, &p4, nlev);
  
  if (i1 != 0 && i2 != 0 && i3 != 0 && i4 != 0)
     conshd (p1, n, p2, m, p3, p4, nlev);
  
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i3 == 1) free (p3);
  if (i4 == 1) free (p4);
  if (i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0) return NULL;
  
L1:
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_contri (PyObject *self, PyObject *args)
{ PyObject *o1, *o2, *o3, *o4, *o5, *o6;
  float *p1, *p2, *p3, zlev;
  int   *p4, *p5, *p6;  
  int i1, i2, i3, i4, i5, i6, n, ntri;

  if (!PyArg_ParseTuple (args, "OOOiOOOif", &o1, &o2, &o3, &n,
                         &o4, &o5, &o6, &ntri, &zlev))  return NULL;
  if (n < 1 || ntri < 1) goto L1;

  i1 = fltarray  (&o1, &p1, n);
  i2 = fltarray  (&o2, &p2, n);
  i3 = fltarray  (&o3, &p3, n);
  i4 = intarray  (&o4, &p4, ntri);
  i5 = intarray  (&o5, &p5, ntri);
  i6 = intarray  (&o6, &p6, ntri);
  
  if (i1 != 0 && i2 != 0 && i3 != 0 &&
      i4 != 0 && i5 != 0 && i6 != 0) 
    contri (p1, p2, p3, n, p4, p5, p6, ntri, zlev);
  
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i3 == 1) free (p3);
  if (i4 == 1) free (p4);
  if (i5 == 1) free (p5);
  if (i6 == 1) free (p6);

  if (i1 == 0 || i2 == 0 || i3 == 0 || 
      i4 == 0 || i5 == 0 || i6 == 0)  return NULL;
  
L1:
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_contur (PyObject *self, PyObject *args)
{ PyObject *o1, *o2, *o3;
  float *p1, *p2, *p3, zlev;
  int i1, i2, i3, n, m;

  if (!PyArg_ParseTuple (args, "OiOiOf", &o1, &n, &o2, &m,
                         &o3, &zlev))  return NULL;
  if (n < 1 || m < 1) goto L1;

  i1 = fltarray  (&o1, &p1, n);
  i2 = fltarray  (&o2, &p2, m);
  i3 = fltmatrix (&o3, &p3, n, m);

  
  if (i1 != 0 && i2 != 0 && i3 != 0) contur (p1, n, p2, m, p3, zlev);
  
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i3 == 1) free (p3);
  if (i1 == 0 || i2 == 0 || i3 == 0) return NULL;
  
L1:
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_cross (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  cross();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_crvmat (PyObject *self, PyObject *args)
{ PyObject *o;
  float *p;
  int  n, m, i, nn, ix, iy;

  if (!PyArg_ParseTuple (args, "Oiiii", &o, &n, &m, &ix, &iy)) return NULL;
  nn = n * m;
  if (nn < 1) goto L1;

  i = fltmatrix (&o, &p, n, m);
  if (i != 0) crvmat (p, n, m, ix, iy);
  
  if (i == 1) free (p);
  if (i == 0) return NULL;
  
L1:
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_crvtri (PyObject *self, PyObject *args)
{ PyObject *o1, *o2, *o3, *o4, *o5, *o6;
  float *p1, *p2, *p3;
  int   *p4, *p5, *p6;  
  int i1, i2, i3, i4, i5, i6, n, ntri;

  if (!PyArg_ParseTuple (args, "OOOiOOOi", &o1, &o2, &o3, &n,
                         &o4, &o5, &o6, &ntri))  return NULL;
  if (n < 1 || ntri < 1) goto L1;

  i1 = fltarray  (&o1, &p1, n);
  i2 = fltarray  (&o2, &p2, n);
  i3 = fltarray  (&o3, &p3, n);
  i4 = intarray  (&o4, &p4, ntri);
  i5 = intarray  (&o5, &p5, ntri);
  i6 = intarray  (&o6, &p6, ntri);
  
  if (i1 != 0 && i2 != 0 && i3 != 0 &&
      i4 != 0 && i5 != 0 && i6 != 0) 
    crvtri (p1, p2, p3, n, p4, p5, p6, ntri);
  
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i3 == 1) free (p3);
  if (i4 == 1) free (p4);
  if (i5 == 1) free (p5);
  if (i6 == 1) free (p6);

  if (i1 == 0 || i2 == 0 || i3 == 0 || 
      i4 == 0 || i5 == 0 || i6 == 0)  return NULL;
  
L1:
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_csrmod (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  csrmod (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_csrmov (PyObject *self, PyObject *args)
{ PyObject *o1, *o2;
  int *p1, *p2;
  int  i1, i2, n, nmax, iret;

  if (!PyArg_ParseTuple (args, "OOi", &o1, &o2, &nmax)) return NULL;
  if (nmax < 1) goto L1;

  i1 = intarray (&o1, &p1, nmax);
  i2 = intarray (&o2, &p2, nmax);

  if (i1 != 0 && i2 != 0)
  { csrmov (p1, p2, nmax, &n, &iret);
    copyintarray (p1, o1, n);
    copyintarray (p2, o2, n);
  }
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i1 == 0 || i2 == 0) return NULL;

L1:

  return Py_BuildValue ("i", n);
}

static PyObject *dislin_csrpt1 (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  csrpt1 (&i1, &i2);

  return Py_BuildValue ("ii", i1, i2);
}

static PyObject *dislin_csrpos (PyObject *self, PyObject *args)
{ int i1, i2, i3;

  if (!PyArg_ParseTuple (args, "ii", &i1, &i2)) return NULL;
  i3 = csrpos (&i1, &i2);

  return Py_BuildValue ("iii", i1, i2, i3);
}

static PyObject *dislin_csrpts (PyObject *self, PyObject *args)
{ PyObject *o1, *o2;
  int *p1, *p2;
  int  i1, i2, n, nmax, iret;

  if (!PyArg_ParseTuple (args, "OOi", &o1, &o2, &nmax)) return NULL;
  if (nmax < 1) goto L1;

  i1 = intarray (&o1, &p1, nmax);
  i2 = intarray (&o2, &p2, nmax);

  if (i1 != 0 && i2 != 0)
  { csrpts (p1, p2, nmax, &n, &iret);
    copyintarray (p1, o1, n);
    copyintarray (p2, o2, n);
  }
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i1 == 0 || i2 == 0) return NULL;

L1:

  return Py_BuildValue ("i", n);
}

static PyObject *dislin_csrtyp (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  csrtyp (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_csruni (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  csruni (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_curv3d (PyObject *self, PyObject *args)
{ PyObject *o1, *o2, *o3;
  float *p1, *p2, *p3;
  int  n, i1, i2, i3;

  if (!PyArg_ParseTuple (args, "OOOi", &o1, &o2, &o3, &n)) return NULL;
  if (n < 1) goto L1;

  i1 = fltarray (&o1, &p1, n);
  i2 = fltarray (&o2, &p2, n);
  i3 = fltarray (&o3, &p3, n);

  if (i1 != 0 && i2 != 0 && i3 != 0) curv3d (p1, p2, p3, n);
  
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i3 == 1) free (p3);
  if (i1 == 0 || i2 == 0 || i3 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_curve (PyObject *self, PyObject *args)
{ PyObject *o1, *o2;
  float *p1, *p2;
  int  n, i1, i2;

  if (!PyArg_ParseTuple (args, "OOi", &o1, &o2, &n)) return NULL;
  if (n < 1) goto L1;

  i1 = fltarray (&o1, &p1, n);
  i2 = fltarray (&o2, &p2, n);

  if (i1 != 0 && i2 != 0) curve (p1, p2, n);
  
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i1 == 0 || i2 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_curve3 (PyObject *self, PyObject *args)
{ PyObject *o1, *o2, *o3;
  float *p1, *p2, *p3;
  int  n, i1, i2, i3;

  if (!PyArg_ParseTuple (args, "OOOi", &o1, &o2, &o3, &n)) return NULL;
  if (n < 1) goto L1;

  i1 = fltarray (&o1, &p1, n);
  i2 = fltarray (&o2, &p2, n);
  i3 = fltarray (&o3, &p3, n);

  if (i1 != 0 && i2 != 0 && i3 != 0) curve3 (p1, p2, p3, n);
  
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i3 == 1) free (p3);
  if (i1 == 0 || i2 == 0 || i3 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_curvmp (PyObject *self, PyObject *args)
{ PyObject *o1, *o2;
  float *p1, *p2;
  int  n, i1, i2;

  if (!PyArg_ParseTuple (args, "OOi", &o1, &o2, &n)) return NULL;
  if (n < 1) goto L1;

  i1 = fltarray (&o1, &p1, n);
  i2 = fltarray (&o2, &p2, n);

  if (i1 != 0 && i2 != 0) curvmp (p1, p2, n);
  
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i1 == 0 || i2 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_curvx3 (PyObject *self, PyObject *args)
{ PyObject *o1, *o2;
  float y, *p1, *p2;
  int  n, i1, i2;

  if (!PyArg_ParseTuple (args, "OfOi", &o1, &y, &o2, &n)) return NULL;
  if (n < 1) goto L1;

  i1 = fltarray (&o1, &p1, n);
  i2 = fltarray (&o2, &p2, n);

  if (i1 != 0 && i2 != 0) curvx3 (p1, y, p2, n);
  
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i1 == 0 || i2 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_curvy3 (PyObject *self, PyObject *args)
{ PyObject *o1, *o2;
  float x, *p1, *p2;
  int  n, i1, i2;

  if (!PyArg_ParseTuple (args, "fOOi", &x, &o1, &o2, &n)) return NULL;
  if (n < 1) goto L1;

  i1 = fltarray (&o1, &p1, n);
  i2 = fltarray (&o2, &p2, n);

  if (i1 != 0 && i2 != 0) curvy3 (x, p1, p2, n);
  
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i1 == 0 || i2 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_dash (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  dash();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_dashl (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  dashl();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_dashm (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  dashm();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_dattim (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  dattim (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_delglb (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;

  delglb();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_digits (PyObject *self, PyObject *args)
{ char *s;
  int n;

  if (!PyArg_ParseTuple (args, "is", &n, &s)) return NULL;
  digits (n, s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_labdig (PyObject *self, PyObject *args)
{ char *s;
  int n;

  if (!PyArg_ParseTuple (args, "is", &n, &s)) return NULL;
  labdig (n, s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_disalf (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  disalf();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_disfin (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;

  disfin();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_disini (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;

  disini();
  qqsetvar (-1);
  nspline = 200;
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_dot (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;

  dot();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_dotl (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;

  dotl();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_duplx (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;

  duplx();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_dwgbut (PyObject *self, PyObject *args)
{ char *s;
  int i, n;
  if (!PyArg_ParseTuple (args, "si", &s, &i)) return NULL;
  n = dwgbut (s, i);
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_dwgfil (PyObject *self, PyObject *args)
{ char *s1, *s2, *s3, *s4;

  if (!PyArg_ParseTuple (args, "sss", &s1, &s2, &s3)) return NULL;
  s4 = dwgfil (s1, s2, s3);
  return Py_BuildValue ("s", s4);
}

static PyObject *dislin_dwglis (PyObject *self, PyObject *args)
{ char *s1, *s2;
  int i, n;
  if (!PyArg_ParseTuple (args, "ssi", &s1, &s2, &i)) return NULL;
  n = dwglis (s1, s2, i);
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_dwgmsg (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  dwgmsg (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_dwgtxt (PyObject *self, PyObject *args)
{ char *s1, *s2, *s3;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  s3 = dwgtxt (s1, s2);
  return Py_BuildValue ("s", s3);
}

static PyObject *dislin_ellips (PyObject *self, PyObject *args)
{ int nx, ny, na, nb;

  if (!PyArg_ParseTuple (args, "iiii", &nx, &ny, &na, &nb)) return NULL;
  ellips (nx, ny, na, nb);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_endgrf (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  endgrf();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_erase (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  erase();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_errbar (PyObject *self, PyObject *args)
{ PyObject *o1, *o2, *o3, *o4;
  float *p1, *p2, *p3, *p4;
  int  n, i1, i2, i3, i4;

  if (!PyArg_ParseTuple (args, "OOOOi", &o1, &o2, &o3, &o4, &n)) return NULL;
  if (n < 1) goto L1;

  i1 = fltarray (&o1, &p1, n);
  i2 = fltarray (&o2, &p2, n);
  i3 = fltarray (&o3, &p3, n);
  i4 = fltarray (&o4, &p4, n);

  if (i1 != 0 && i2 != 0 && i3 != 0 && i4 != 0)
     errbar (p1, p2, p3, p4, n);
  
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i3 == 1) free (p3);
  if (i4 == 1) free (p4);
  if (i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0) return NULL;

L1:
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_errdev (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  errdev (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_errfil (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  errfil (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_errmod (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  errmod (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_eushft (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  eushft (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_expzlb (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  expzlb (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_fcha (PyObject *self, PyObject *args)
{ char s[41];
  int ndig, nl;
  float x;

  if (!PyArg_ParseTuple (args, "fi", &x, &ndig)) return NULL;
  nl = fcha (x, ndig, s);
  return Py_BuildValue ("s", s);
}

static PyObject *dislin_field (PyObject *self, PyObject *args)
{ PyObject *o1, *o2, *o3, *o4;
  float *p1, *p2, *p3, *p4;
  int  n, i1, i2, i3, i4, ivec;

  if (!PyArg_ParseTuple (args, "OOOOii", &o1, &o2, &o3, &o4, &n, &ivec))
       return NULL;
  if (n < 1) goto L1;

  i1 = fltarray (&o1, &p1, n);
  i2 = fltarray (&o2, &p2, n);
  i3 = fltarray (&o3, &p3, n);
  i4 = fltarray (&o4, &p4, n);

  if (i1 != 0 && i2 != 0 && i3 != 0 && i4 != 0) 
      field (p1, p2, p3, p4, n, ivec);
  
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i3 == 1) free (p3);
  if (i4 == 1) free (p4);
  if (i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}


static PyObject *dislin_filbox (PyObject *self, PyObject *args)
{ int nx, ny, nw, nh;

  if (!PyArg_ParseTuple (args, "iiii", &nx, &ny, &nw, &nh)) return NULL;
  filbox (nx, ny, nw, nh);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_filclr (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  filclr (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_filmod (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  filmod (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_fixspc (PyObject *self, PyObject *args)
{ float x;

  if (!PyArg_ParseTuple (args, "f", &x)) return NULL;
  fixspc (x);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_flab3d (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  flab3d();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_flen (PyObject *self, PyObject *args)
{ int  i, n;
  float x;
  if (!PyArg_ParseTuple (args, "fi", &x, &i)) return NULL;
  n = flen (x, i);
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_frmclr (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  frmclr (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_frame (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  frame (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_frmess (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  frmess (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_gapcrv (PyObject *self, PyObject *args)
{ float x;

  if (!PyArg_ParseTuple (args, "f", &x)) return NULL;
  gapcrv (x);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_getalf (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  s = getalf ();
  return Py_BuildValue ("s", s);
}

static PyObject *dislin_getang (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  n = getang ();
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_getbpp (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  n = getbpp ();
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_getclr (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  n = getclr ();
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_getclp (PyObject *self, PyObject *args)
{ int i1, i2, i3, i4;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  getclp (&i1, &i2, &i3, &i4);

  return Py_BuildValue ("iiii", i1, i2, i3, i4);
}

static PyObject *dislin_getdig (PyObject *self, PyObject *args)
{ int i1, i2, i3;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  getdig (&i1, &i2, &i3);

  return Py_BuildValue ("iii", i1, i2, i3);
}

static PyObject *dislin_getdsp (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  s = getdsp ();
  return Py_BuildValue ("s", s);
}

static PyObject *dislin_getfil (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  s = getfil ();
  return Py_BuildValue ("s", s);
}

static PyObject *dislin_getgrf (PyObject *self, PyObject *args)
{ float x1, x2, x3, x4;
  char *s;
  
  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  getgrf (&x1, &x2, &x3, &x4, s);
  return Py_BuildValue ("ffff", x1, x2, x3, x4);
}

static PyObject *dislin_gethgt (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  n = gethgt ();
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_gethnm (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  n = gethnm ();
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_getind (PyObject *self, PyObject *args)
{ int i;
  float xr, xg, xb;
  
  if (!PyArg_ParseTuple (args, "i", &i)) return NULL;
  getind (i, &xr, &xg, &xb);
  return Py_BuildValue ("fff", xr, xg, xb);
}

static PyObject *dislin_getlab (PyObject *self, PyObject *args)
{ static char s1[9], s2[9], s3[9];

  if (!PyArg_ParseTuple (args, "")) return NULL;
  getlab (s1, s2, s3);

  return Py_BuildValue ("sss", s1, s2, s3);
}

static PyObject *dislin_getlen (PyObject *self, PyObject *args)
{ int i1, i2, i3;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  getlen (&i1, &i2, &i3);

  return Py_BuildValue ("iii", i1, i2, i3);
}

static PyObject *dislin_getlev (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  n = getlev ();
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_getlin (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  n = getlin ();
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_getlit (PyObject *self, PyObject *args)
{ int n;
  float xp, yp, zp, xn, yn, zn;

  if (!PyArg_ParseTuple (args, "ffffff", &xp, &yp, &zp, &xn, &yn, &zn)) 
       return NULL;
  n = getlit (xp, yp, zp, xn, yn, zn);
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_getmat (PyObject *self, PyObject *args)
{ PyObject *o1, *o2, *o3, *o4;
  float *p1, *p2, *p3, *p4, *p6, zval;
  int  n, i1, i2, i3, i4, nx, ny, *p5;

  if (!PyArg_ParseTuple (args, "OOOiOiif", &o1, &o2, &o3, &n,
                         &o4, &nx, &ny, &zval)) return NULL;
  if (n < 1 || nx < 1 || ny < 1) goto L1;

  if ((p6 = (float *) calloc (nx*ny, 4)) == NULL)
  { PyErr_SetString (PyExc_MemoryError, "out of memory");
    return NULL;
  }
  if ((p5 = (int *) calloc (nx*ny, 4)) == NULL)
  { PyErr_SetString (PyExc_MemoryError, "out of memory");
    free (p6);
    return NULL;
  }

  i1 = fltarray (&o1, &p1, n);
  i2 = fltarray (&o2, &p2, n);
  i3 = fltarray (&o3, &p3, n);
  i4 = fltmatrix (&o4, &p4, nx, ny);

  if (i1 != 0 && i2 != 0 && i3 != 0 && i4 != 0)
  { getmat (p1, p2, p3, n, p4, nx, ny, zval, p5, p6);
    if (i4 == 1) copyfloatarray (p4, o4, nx*ny);
  }

  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i3 == 1) free (p3);
  if (i4 == 1) free (p4);
  free (p5);
  free (p6);
  if (i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0)
     return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_getmfl (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  s = getmfl ();
  return Py_BuildValue ("s", s);
}

static PyObject *dislin_getmix (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "s", &s2)) return NULL;
  s1 = getmix (s2);
  return Py_BuildValue ("s", s1);
}

static PyObject *dislin_getor (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  getor (&i1, &i2);

  return Py_BuildValue ("ii", i1, i2);
}

static PyObject *dislin_getpag (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  getpag (&i1, &i2);

  return Py_BuildValue ("ii", i1, i2);
}

static PyObject *dislin_getpat (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  n = (int) getpat ();
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_getpos (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  getpos (&i1, &i2);

  return Py_BuildValue ("ii", i1, i2);
}

static PyObject *dislin_getran (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  getran (&i1, &i2);

  return Py_BuildValue ("ii", i1, i2);
}

static PyObject *dislin_getres (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  getres (&i1, &i2);

  return Py_BuildValue ("ii", i1, i2);
}

static PyObject *dislin_getrgb (PyObject *self, PyObject *args)
{ int n;
  float xr, xg, xb;

  if (!PyArg_ParseTuple (args, "fff", &xr,&xg,&xb)) return NULL;
  if (!PyArg_ParseTuple (args, "")) return NULL;
  getrgb (&xr, &xg, &xb);
  return Py_BuildValue ("fff", xr,xg,xb);
}

static PyObject *dislin_getscl (PyObject *self, PyObject *args)
{ int i1, i2, i3;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  getscl (&i1, &i2, &i3);

  return Py_BuildValue ("iii", i1, i2, i3);
}

static PyObject *dislin_getscr (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  getscr (&i1, &i2);

  return Py_BuildValue ("ii", i1, i2);
}

static PyObject *dislin_getshf (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "s", &s2)) return NULL;
  s1 = getshf (s2);
  return Py_BuildValue ("s", s1);
}

static PyObject *dislin_getsp1 (PyObject *self, PyObject *args)
{ int i1, i2, i3;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  getsp1 (&i1, &i2, &i3);

  return Py_BuildValue ("iii", i1, i2, i3);
}

static PyObject *dislin_getsp2 (PyObject *self, PyObject *args)
{ int i1, i2, i3;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  getsp2 (&i1, &i2, &i3);

  return Py_BuildValue ("iii", i1, i2, i3);
}

static PyObject *dislin_getsym (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  getsym (&i1, &i2);

  return Py_BuildValue ("ii", i1, i2);
}

static PyObject *dislin_gettcl (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  gettcl (&i1, &i2);

  return Py_BuildValue ("ii", i1, i2);
}

static PyObject *dislin_gettic (PyObject *self, PyObject *args)
{ int i1, i2, i3;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  gettic (&i1, &i2, &i3);

  return Py_BuildValue ("iii", i1, i2, i3);
}

static PyObject *dislin_gettyp (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  n = gettyp ();
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_getuni (PyObject *self, PyObject *args)
{ int n;
  FILE *fp;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  fp = (FILE *) getuni ();
  if (fp == NULL)
    n = 0;
  else 
    n = 6;

  return Py_BuildValue ("i", n);
}

static PyObject *dislin_getver (PyObject *self, PyObject *args)
{ float x;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  x = getver ();
  return Py_BuildValue ("f", x);
}

static PyObject *dislin_getvk (PyObject *self, PyObject *args)
{ int i1, i2, i3;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  getvk (&i1, &i2, &i3);

  return Py_BuildValue ("iii", i1, i2, i3);
}

static PyObject *dislin_getvlt (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  s = getvlt ();
  return Py_BuildValue ("s", s);
}

static PyObject *dislin_getwid (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  n = getwid ();
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_getwin (PyObject *self, PyObject *args)
{ int i1, i2, i3, i4;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  getwin (&i1, &i2, &i3, &i4);

  return Py_BuildValue ("iiii", i1, i2, i3, i4);
}

static PyObject *dislin_getxid (PyObject *self, PyObject *args)
{ int n;
  char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  n = getxid (s);
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_gifmod (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  gifmod (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_gmxalf (PyObject *self, PyObject *args)
{ int n;
  char *s1, s2[2], s3[2];

  if (!PyArg_ParseTuple (args, "s", &s1)) return NULL;
  n = gmxalf (s1, s2, s3);
  return Py_BuildValue ("ssi", s2,s3,n);
}

static PyObject *dislin_gothic (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  gothic();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_grace (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  grace (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_graf (PyObject *self, PyObject *args)
{ float xa, xe, xor, xstp, ya, ye, yor, ystp;
  if (!PyArg_ParseTuple (args, "ffffffff", &xa, &xe, &xor, &xstp,
                         &ya, &ye, &yor, &ystp)) return NULL;
  graf (xa, xe, xor, xstp, ya, ye, yor, ystp);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_graf3 (PyObject *self, PyObject *args)
{ float xa, xe, xor, xstp, ya, ye, yor, ystp, za, ze, zor, zstp;
  if (!PyArg_ParseTuple (args, "ffffffffffff", &xa, &xe, &xor, &xstp,
             &ya, &ye, &yor, &ystp, &za, &ze, &zor, &zstp)) return NULL;
  graf3 (xa, xe, xor, xstp, ya, ye, yor, ystp, za, ze, zor, zstp);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_graf3d (PyObject *self, PyObject *args)
{ float xa, xe, xor, xstp, ya, ye, yor, ystp, za, ze, zor, zstp;
  if (!PyArg_ParseTuple (args, "ffffffffffff", &xa, &xe, &xor, &xstp,
             &ya, &ye, &yor, &ystp, &za, &ze, &zor, &zstp)) return NULL;
  graf3d (xa, xe, xor, xstp, ya, ye, yor, ystp, za, ze, zor, zstp);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_grafmp (PyObject *self, PyObject *args)
{ float xa, xe, xor, xstp, ya, ye, yor, ystp;
  if (!PyArg_ParseTuple (args, "ffffffff", &xa, &xe, &xor, &xstp,
                                           &ya, &ye, &yor, &ystp)) return NULL;
  grafmp (xa, xe, xor, xstp, ya, ye, yor, ystp);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_grffin (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  grffin();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_grfini (PyObject *self, PyObject *args)
{ float x1, y1, z1, x2, y2, z2, x3, y3, z3;
  if (!PyArg_ParseTuple (args, "fffffffff", &x1, &y1, &z1, &x2, &y2, &z2,
                         &x3, &y3, &z3)) return NULL;
  grfini (x1, y1, z1, x2, y2, z2, x3, y3, z3);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_grdpol (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "ii", &i1, &i2)) return NULL;
  grdpol (i1, i2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_grid (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "ii", &i1, &i2)) return NULL;
  grid (i1, i2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_grid3d (PyObject *self, PyObject *args)
{ char *s;
  int nx, ny;

  if (!PyArg_ParseTuple (args, "iis", &nx, &ny, &s)) return NULL;
  grid3d (nx, ny, s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_gridmp (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "ii", &i1, &i2)) return NULL;
  gridmp (i1, i2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_gwgatt (PyObject *self, PyObject *args)
{ int n, i;
  char *s;

  if (!PyArg_ParseTuple (args, "is", &i, &s)) return NULL;
  n = gwgatt (i, s);
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_gwgbox (PyObject *self, PyObject *args)
{ int n, i;

  if (!PyArg_ParseTuple (args, "i", &i)) return NULL;
  n = gwgbox (i);
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_gwgbut (PyObject *self, PyObject *args)
{ int n, i;

  if (!PyArg_ParseTuple (args, "i", &i)) return NULL;
  n = gwgbut (i);
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_gwgfil (PyObject *self, PyObject *args)
{ int n, i;
  char s[256];
  
  if (!PyArg_ParseTuple (args, "i", &i)) return NULL;
  gwgfil (i, s);
  return Py_BuildValue ("s", s);
}

static PyObject *dislin_gwglis (PyObject *self, PyObject *args)
{ int n, i;

  if (!PyArg_ParseTuple (args, "i", &i)) return NULL;
  n = gwglis (i);
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_gwgscl (PyObject *self, PyObject *args)
{ int i;
  float x;

  if (!PyArg_ParseTuple (args, "i", &i)) return NULL;
  x = gwgscl (i);
  return Py_BuildValue ("f", x);
}

static PyObject *dislin_gwgtxt (PyObject *self, PyObject *args)
{ int n, i;
  char s[512];
  
  if (!PyArg_ParseTuple (args, "i", &i)) return NULL;
  gwgtxt (i, s);
  return Py_BuildValue ("s", s);
}

static PyObject *dislin_gwgxid (PyObject *self, PyObject *args)
{ int n, i;

  if (!PyArg_ParseTuple (args, "i", &i)) return NULL;
  n = gwgxid (i);
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_height (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  height (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_helve (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  helve();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_helves (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  helves();
  Py_INCREF (Py_None);
  return Py_None;
}


static PyObject *dislin_histog (PyObject *self, PyObject *args)
{ PyObject *o1, *o2, *o3;
  float *p1, *p2, *p3;
  int  n, i1, i2, i3, i, np = 0;

  if (!PyArg_ParseTuple (args, "OiOO", &o1, &n, &o2, &o3)) return NULL;
  if (n < 1) goto L1;

  i1 = fltarray (&o1, &p1, n);
  i2 = fltarray (&o2, &p2, n);
  i3 = fltarray (&o3, &p3, n);

  if (i1 != 0 && i2 != 0 && i3 != 0)
  { histog (p1, n, p2, p3, &np);
    if (i2 == 1) copyfloatarray (p2, o2, np);
    if (i3 == 1) copyfloatarray (p3, o3, np);
  }
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i3 == 1) free (p3);
  if (i1 == 0 || i2 == 0 || i3 == 0) return NULL;

L1:

  return Py_BuildValue ("i", np);
}

static PyObject *dislin_hname (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  hname (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_hsvrgb (PyObject *self, PyObject *args)
{ float xh, xs, xv, xr, xg, xb;

  if (!PyArg_ParseTuple (args, "fff", &xh, &xs, &xv)) return NULL;
  hsvrgb (xh, xs, xv, &xr, &xg, &xb);
  return Py_BuildValue ("fff", xr, xg, xb);
}

static PyObject *dislin_hsymbl (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  hsymbl (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_htitle (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  htitle (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_hwfont (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  hwfont();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_hworig (PyObject *self, PyObject *args)
{ int nx, ny;

  if (!PyArg_ParseTuple (args, "ii", &nx, &ny)) return NULL;
  hworig (nx, ny);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_hwpage (PyObject *self, PyObject *args)
{ int nx, ny;

  if (!PyArg_ParseTuple (args, "ii", &nx, &ny)) return NULL;
  hwpage (nx, ny);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_imgbox (PyObject *self, PyObject *args)
{ int nx, ny, nw, nh;

  if (!PyArg_ParseTuple (args, "iiii", &nx, &ny, &nw, &nh)) return NULL;
  imgbox (nx, ny, nw, nh);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_imgclp (PyObject *self, PyObject *args)
{ int nx, ny, nw, nh;

  if (!PyArg_ParseTuple (args, "iiii", &nx, &ny, &nw, &nh)) return NULL;
  imgclp (nx, ny, nw, nh);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_imgfin (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  imgfin();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_imgfmt (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  imgfmt (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_imgini (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  imgini();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_imgmod (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  imgmod (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_imgsiz (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "ii", &i1, &i2)) return NULL;
  imgsiz (i1, i2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_inccrv (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  inccrv (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_incdat (PyObject *self, PyObject *args)
{ int  n, id, im, iy;
  if (!PyArg_ParseTuple (args, "iii", &id, &im, &iy)) return NULL;
  n = incdat (id, im, iy);
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_incfil (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  incfil (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_incmrk (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  incmrk (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_indrgb (PyObject *self, PyObject *args)
{ int  n;
  float xr, xg, xb;
  if (!PyArg_ParseTuple (args, "fff", &xr, &xg, &xb)) return NULL;
  n = indrgb (xr, xg, xb);
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_intax (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  intax();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_intcha (PyObject *self, PyObject *args)
{ char s[41];
  int nx, nl;

  if (!PyArg_ParseTuple (args, "i", &nx)) return NULL;
  nl = intcha (nx, s);
  return Py_BuildValue ("s", s);
}

static PyObject *dislin_intlen (PyObject *self, PyObject *args)
{ int n, i;

  if (!PyArg_ParseTuple (args, "i", &i)) return NULL;
  n = intlen (i);
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_intrgb (PyObject *self, PyObject *args)
{ int  n;
  float xr, xg, xb;
  if (!PyArg_ParseTuple (args, "fff", &xr, &xg, &xb)) return NULL;
  n = intrgb (xr, xg, xb);
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_itmcat (PyObject *self, PyObject *args)
{ char *s1, *s2, *p;
  int n1, n2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  n1 = trmlen (s1);
  n2 = trmlen (s2);
  p = (char *) malloc (n1 + n2 + 2);
  if (p == NULL)
  { PyErr_SetString (PyExc_MemoryError, "out of memory in imtcat");
    return NULL;
  }

  strcpy (p, s1);
  itmcat (p, s2);
  return Py_BuildValue ("s", p);
}

static PyObject *dislin_itmcnt (PyObject *self, PyObject *args)
{ int n;
  char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  n = itmcnt (s);
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_itmstr (PyObject *self, PyObject *args)
{ int n;
  char *s1, *s2;

  if (!PyArg_ParseTuple (args, "si", &s1, &n)) return NULL;
  s2 = itmstr (s1, n);
  return Py_BuildValue ("s", s2);
}

static PyObject *dislin_labclr (PyObject *self, PyObject *args)
{ int n;
  char *s;

  if (!PyArg_ParseTuple (args, "is", &n, &s)) return NULL;
  labclr (n, s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_labdis (PyObject *self, PyObject *args)
{ int n;
  char *s;

  if (!PyArg_ParseTuple (args, "is", &n, &s)) return NULL;
  labdis (n, s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_labels (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  labels (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_labjus (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  labjus (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_labl3d (PyObject *self, PyObject *args)
{ char *s1;

  if (!PyArg_ParseTuple (args, "s", &s1)) return NULL;
  labl3d (s1);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_labmod (PyObject *self, PyObject *args)
{ char *s1, *s2, *s3;

  if (!PyArg_ParseTuple (args, "sss", &s1, &s2, &s3)) return NULL;
  labmod (s1, s2, s3);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_labpos (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  labpos (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_labtyp (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  labtyp (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_legclr (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  legclr();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_legend (PyObject *self, PyObject *args)
{ int n;
  char *s;

  if (!PyArg_ParseTuple (args, "si", &s, &n)) return NULL;
  legend (clegbf, n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_legini (PyObject *self, PyObject *args)
{ int n;
  char *s;
  int nlin, nmaxln, i;

  if (!PyArg_ParseTuple (args, "sii", &s, &nlin, &nmaxln)) return NULL;

  if (ilegop != 0) free (clegbf);
  clegbf = (char *) malloc (nlin * nmaxln + 1);
  if (clegbf == NULL)
  { PyErr_SetString (PyExc_MemoryError, "out of memory in legini");
    return NULL;
  }
  for (i = 0; i < nlin * nmaxln; i++)
     clegbf[i] = ' ';
  clegbf[nlin*nmaxln] = '\0';

  ilegop = 1;
  legini (clegbf, nlin, nmaxln);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_leglin (PyObject *self, PyObject *args)
{ int n;
  char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ssi", &s1, &s2, &n)) return NULL;
  leglin (clegbf, s2, n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_legopt (PyObject *self, PyObject *args)
{ float x, y, z;

  if (!PyArg_ParseTuple (args, "fff", &x, &y, &z)) return NULL;
  legopt (x, y, z);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_legpat (PyObject *self, PyObject *args)
{ int i1, i2, i3, i4, i5, i6;
  char *s;

  if (!PyArg_ParseTuple (args, "iiiiii", &i1, &i2, &i3,
                         &i4, &i5, &i6)) return NULL;
  legpat (i1, i2, i3, i4, (long) i5, i6);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_legpos (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "ii", &i1, &i2)) return NULL;
  legpos (i1, i2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_legtit (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  legtit (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_lfttit (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  lfttit();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_light (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  light (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_lincyc (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "ii", &i1, &i2)) return NULL;
  lincyc (i1, i2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_line (PyObject *self, PyObject *args)
{ int nx, ny, nu, nv;

  if (!PyArg_ParseTuple (args, "iiii", &nx, &ny, &nu, &nv)) return NULL;
  line (nx, ny, nu, nv);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_linesp (PyObject *self, PyObject *args)
{ float x;

  if (!PyArg_ParseTuple (args, "f", &x)) return NULL;
  linesp (x);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_lintyp (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  lintyp (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_linwid (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  linwid (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_litmod (PyObject *self, PyObject *args)
{ char *s;
  int i;

  if (!PyArg_ParseTuple (args, "is", &i, &s)) return NULL;
  litmod (i, s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_litop3 (PyObject *self, PyObject *args)
{ char *s;
  int i;
  float xr, xg, xb;

  if (!PyArg_ParseTuple (args, "ifffs", &i, &xr, &xg, &xb, &s)) return NULL;
  litop3 (i, xr, xg, xb, s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_litopt (PyObject *self, PyObject *args)
{ char *s;
  int i;
  float x;

  if (!PyArg_ParseTuple (args, "ifs", &i, &x, &s)) return NULL;
  litopt (i, x, s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_litpos (PyObject *self, PyObject *args)
{ char *s;
  int i;
  float x, y, z;

  if (!PyArg_ParseTuple (args, "ifffs", &i, &x, &y, &z, &s)) return NULL;
  litpos (i, x, y, z, s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_lncap (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  lncap (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_lnjoin (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  lnjoin (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_lnmlt (PyObject *self, PyObject *args)
{ float x;

  if (!PyArg_ParseTuple (args, "f", &x)) return NULL;
  lnmlt (x);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_logtic (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  logtic (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_mapbas (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  mapbas (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_mapfil (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  mapfil (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_maplev (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  maplev (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_mapmod (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  mapmod (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_mappol (PyObject *self, PyObject *args)
{ float x, y;

  if (!PyArg_ParseTuple (args, "ff", &x, &y)) return NULL;
  mappol (x, y);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_mapref (PyObject *self, PyObject *args)
{ float x, y;

  if (!PyArg_ParseTuple (args, "ff", &x, &y)) return NULL;
  mapref (x, y);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_mapsph (PyObject *self, PyObject *args)
{ float x;

  if (!PyArg_ParseTuple (args, "f", &x)) return NULL;
  mapsph (x);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_marker (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  marker (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_matop3 (PyObject *self, PyObject *args)
{ char *s;
  float xr, xg, xb;

  if (!PyArg_ParseTuple (args, "fffs", &xr, &xg, &xb, &s)) return NULL;
  matop3 (xr, xg, xb, s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_matopt (PyObject *self, PyObject *args)
{ char *s;
  float x;

  if (!PyArg_ParseTuple (args, "fs", &x, &s)) return NULL;
  matopt (x, s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_mdfmat (PyObject *self, PyObject *args)
{ int i1, i2;
  float x;

  if (!PyArg_ParseTuple (args, "iif", &i1, &i2, &x)) return NULL;
  mdfmat (i1, i2, x);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_messag (self, args)
PyObject *self;
PyObject *args;
{ char *s;
  int nx, ny;
  if (!PyArg_ParseTuple (args, "sii", &s,&nx,&ny)) return NULL;
  messag(s,nx,ny);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_metafl (self, args)
PyObject *self;
PyObject *args;
{ char *s;
  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  metafl(s);
  g_imetfl = 1;
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_mixalf (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  mixalf();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_mixleg (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  mixleg();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_moment (PyObject *self, PyObject *args)
{ PyObject *o1;
  float *p1, x = 0.;
  int  n, i1;
  char *s;
  
  if (!PyArg_ParseTuple (args, "Ois", &o1, &n, &s)) return NULL;
  if (n < 1) goto L1;

  i1 = fltarray (&o1, &p1, n);
  if (i1 != 0) x = moment (p1, n, s);
  
  if (i1 == 1) free (p1);
  if (i1 == 0) return NULL;

L1:

  return Py_BuildValue ("f", x);
}

static PyObject *dislin_mpaepl (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  mpaepl (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_mplang (PyObject *self, PyObject *args)
{ float x;

  if (!PyArg_ParseTuple (args, "f", &x)) return NULL;
  mplang (x);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_mplclr (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "ii", &i1, &i2)) return NULL;
  mplclr (i1, i2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_mplpos (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "ii", &i1, &i2)) return NULL;
  mplpos (i1, i2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_mplsiz (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  mplsiz (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_mpslogo (PyObject *self, PyObject *args)
{ char *s;
 int i1, i2, i3;

  if (!PyArg_ParseTuple (args, "iiis", &i1, &i2, &i3, &s)) return NULL;
  mpslogo (i1, i2, i3, s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_msgbox (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  msgbox (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_mshclr (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  mshclr (n);
  Py_INCREF (Py_None);
  return Py_None;
}


static PyObject *dislin_mylab (PyObject *self, PyObject *args)
{ int n;
  char *s1, *s2;

  if (!PyArg_ParseTuple (args, "sis", &s1, &n, &s2)) return NULL;
  mylab (s1, n, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_myline (PyObject *self, PyObject *args)
{ PyObject *o1;
  int  *p1;
  int  n, i1;

  if (!PyArg_ParseTuple (args, "Oi", &o1, &n)) return NULL;
  if (n < 1) goto L1;

  i1 = intarray (&o1, &p1, n);

  if (i1 != 0) myline (p1, n);
  
  if (i1 == 1) free (p1);
  if (i1 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_mypat (PyObject *self, PyObject *args)
{ int i1, i2, i3, i4;

  if (!PyArg_ParseTuple (args, "iiii", &i1, &i2, &i3, &i4 )) return NULL;
  mypat (i1, i2, i3, i4);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_mysymb (PyObject *self, PyObject *args)
{ PyObject *o1, *o2;
  float *p1, *p2;
  int  n, i1, i2, isym, iflag;

  if (!PyArg_ParseTuple (args, "OOiii", &o1, &o2, &n, &isym, &iflag)) 
       return NULL;
  if (n < 1) goto L1;

  i1 = fltarray (&o1, &p1, n);
  i2 = fltarray (&o2, &p2, n);

  if (i1 != 0 && i2 != 0) mysymb (p1, p2, n, isym, iflag);
  
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i1 == 0 || i2 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_myvlt (PyObject *self, PyObject *args)
{ PyObject *o1, *o2, *o3;
  float *p1, *p2, *p3;
  int  n, i1, i2, i3;

  if (!PyArg_ParseTuple (args, "OOOi", &o1, &o2, &o3, &n)) return NULL;
  if (n < 1) goto L1;

  i1 = fltarray (&o1, &p1, n);
  i2 = fltarray (&o2, &p2, n);
  i3 = fltarray (&o3, &p3, n);

  if (i1 != 0 && i2 != 0 && i3 != 0) myvlt (p1, p2, p3, n);
  
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i3 == 1) free (p3);
  if (i1 == 0 || i2 == 0 || i3 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_namdis (PyObject *self, PyObject *args)
{ int n;
  char *s;

  if (!PyArg_ParseTuple (args, "is", &n, &s)) return NULL;
  namdis (n, s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_name (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  name (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_namjus (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  namjus (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_neglog (PyObject *self, PyObject *args)
{ float x;

  if (!PyArg_ParseTuple (args, "f", &x)) return NULL;
  neglog (x);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_newmix (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  newmix();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_newpag (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  newpag();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_nlmess (PyObject *self, PyObject *args)
{ int  n;
  char *s;
  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  n = nlmess (s);
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_nlnumb (PyObject *self, PyObject *args)
{ int n, i;
  float x;
  if (!PyArg_ParseTuple (args, "fi", &x, &i)) return NULL;
  n = nlnumb (x, i);
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_noarln (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  noarln();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_nobar (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  nobar();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_nobgd (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  nobgd();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_nochek (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  nochek();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_noclip (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  noclip();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_nofill (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  nofill();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_nograf (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  nograf();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_nohide (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  nohide();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_noline (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  noline (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_number (PyObject *self, PyObject *args)
{ float x;
  int i1, i2, i3; 

  if (!PyArg_ParseTuple (args, "fiii", &x, &i1, &i2, &i3)) return NULL;
  number (x, i1, i2, i3);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_numfmt (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  numfmt (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_numode (PyObject *self, PyObject *args)
{ char *s1, *s2, *s3, *s4;

  if (!PyArg_ParseTuple (args, "ssss", &s1, &s2, &s3, &s4)) return NULL;
  numode (s1, s2, s3, s4);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_nwkday (PyObject *self, PyObject *args)
{ int  n, id, im, iy;
  if (!PyArg_ParseTuple (args, "iii", &id, &im, &iy)) return NULL;
  n = nwkday (id, im, iy);
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_nxlegn (PyObject *self, PyObject *args)
{ int  n;
  char *s;
  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  n = nxlegn (clegbf);
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_nxposn (PyObject *self, PyObject *args)
{ int  n;
  float x;
  if (!PyArg_ParseTuple (args, "f", &x)) return NULL;
  n = nxposn (x);
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_nylegn (PyObject *self, PyObject *args)
{ int  n;
  char *s;
  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  n = nylegn (clegbf);
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_nyposn (PyObject *self, PyObject *args)
{ int  n;
  float x;
  if (!PyArg_ParseTuple (args, "f", &x)) return NULL;
  n = nyposn (x);
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_nzposn (PyObject *self, PyObject *args)
{ int  n;
  float x;
  if (!PyArg_ParseTuple (args, "f", &x)) return NULL;
  n = nzposn (x);
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_openfl (PyObject *self, PyObject *args)
{ int  n, nu, irw;
  char *s;  
  if (!PyArg_ParseTuple (args, "sii", &s, &nu, &irw)) return NULL;
  n = openfl (s, nu, irw);
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_opnwin (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  opnwin (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_origin (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "ii", &i1, &i2)) return NULL;
  origin (i1, i2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_page (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "ii", &i1, &i2)) return NULL;
  page (i1, i2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_pagera (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  pagera();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_pagfll (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  pagfll (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_paghdr (PyObject *self, PyObject *args)
{ int i1, i2;
  char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ssii", &s1, &s2, &i1, &i2)) return NULL;
  paghdr (s1, s2, i1, i2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_pagmod (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  pagmod (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_pagorg (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  pagorg (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_patcyc (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "ii", &i1, &i2)) return NULL;
  patcyc (i1, (long) i2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_pdfbuf (PyObject *self, PyObject *args)
{ PyObject *o;
  char *p = NULL;
  int  n = 0, nmax;

  if (!PyArg_ParseTuple (args, "i", &nmax)) return NULL;
  if (nmax < 0) return Py_BuildValue ("si", "", 0);

  if (nmax == 0)
  { n = pdfbuf (NULL, 0);
  }
  else
  { p = (char *) malloc (nmax);
    if (p == NULL)
    { PyErr_SetString (PyExc_MemoryError, "out of memory in pdfbuf");
      return NULL;
    }
    n = pdfbuf (p, nmax);
  }

  if (nmax == 0)
    return Py_BuildValue ("si", "", n);
  else 
  { o = Py_BuildValue ("s#i", p, n, n);
    free (p);
    return o;
  }
}

static PyObject *dislin_pdfmod (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  pdfmod (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_pdfmrk (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  pdfmrk (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_penwid (PyObject *self, PyObject *args)
{ float x;

  if (!PyArg_ParseTuple (args, "f", &x)) return NULL;
  penwid (x);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_pie (PyObject *self, PyObject *args)
{ int i1, i2, i3;
  float a, b;

  if (!PyArg_ParseTuple (args, "iiiff", &i1, &i2, &i3, &a, &b)) return NULL;
  pie (i1, i2, i3, a, b);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_piebor (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  piebor (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_pieclr (PyObject *self, PyObject *args)
{ PyObject *o1, *o2;
  int  *p1, *p2;
  int  n, i1, i2;

  if (!PyArg_ParseTuple (args, "OOi", &o1, &o2, &n)) return NULL;
  if (n < 1) goto L1;

  i1 = intarray (&o1, &p1, n);
  i2 = intarray (&o2, &p2, n);

  if (i1 != 0 && i2 != 0) pieclr (p1, p2, n);
  
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i1 == 0 || i2 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_pieexp (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  pieexp();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_piegrf (PyObject *self, PyObject *args)
{ PyObject *o1;
  float *p1; 
  int   nlin, n, i1;
  char *s; 

  if (!PyArg_ParseTuple (args, "siOi", &s, &nlin, &o1, &n)) return NULL;
  if (n < 1) goto L1;

  i1 = fltarray (&o1, &p1, n);
  if (i1 != 0) 
  { if (nlin == 0)
      piegrf (" ", nlin, p1, n);
    else 
      piegrf (clegbf, nlin, p1, n);
  }
  if (i1 == 1) free (p1);
  if (i1 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_pielab (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  pielab (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_pieopt (PyObject *self, PyObject *args)
{ float x1, x2;

  if (!PyArg_ParseTuple (args, "ff", &x1, &x2)) return NULL;
  pieopt (x1, x2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_pietyp (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  pietyp (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_pievec (PyObject *self, PyObject *args)
{ int n;
  char *s;

  if (!PyArg_ParseTuple (args, "is", &n, &s)) return NULL;
  pievec (n, s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_pngmod (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  pngmod (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_point (PyObject *self, PyObject *args)
{ int i1, i2, i3, i4, i5;

  if (!PyArg_ParseTuple (args, "iiiii", &i1, &i2, &i3,
                         &i4, &i5)) return NULL;
  point (i1, i2, i3, i4, i5);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_polar (PyObject *self, PyObject *args)
{ float xe, xor, xstp, yor, ystp;
  if (!PyArg_ParseTuple (args, "fffff", &xe, &xor, &xstp,
                          &yor, &ystp)) return NULL;
  polar (xe, xor, xstp, yor, ystp);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_polcrv (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  polcrv (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_polmod (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  polmod (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_pos2pt (PyObject *self, PyObject *args)
{ float x, y, xp, yp;

  if (!PyArg_ParseTuple (args, "ff", &x, &y)) return NULL;
  pos2pt (x, y, &xp, &yp);
  return Py_BuildValue ("ff", xp, yp);
}

static PyObject *dislin_pos3pt (PyObject *self, PyObject *args)
{ float x, y, z, xp, yp, zp;

  if (!PyArg_ParseTuple (args, "fff", &x, &y, &z)) return NULL;
  pos3pt (x, y, z, &xp, &yp, &zp);
  return Py_BuildValue ("fff", xp, yp, zp);
}

static PyObject *dislin_posifl (PyObject *self, PyObject *args)
{ int  n, nu, nbyte;  
  if (!PyArg_ParseTuple (args, "ii", &nu, &nbyte)) return NULL;
  n = posifl (nu, nbyte);
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_projct (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  projct (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_psfont (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  psfont (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_psmode (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  psmode (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_qplbar (PyObject *self, PyObject *args)
{ PyObject *o1;
  float *p1;
  int  n, i1;

  if (!PyArg_ParseTuple (args, "Oi", &o1, &n)) return NULL;
  if (n < 1) goto L1;

  i1 = fltarray (&o1, &p1, n);

  if (i1 != 0) qplbar (p1, n);
  
  if (i1 == 1) free (p1);
  if (i1 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_qplclr (PyObject *self, PyObject *args)
{ PyObject *o;
  float *p;
  int  n, m, i;

  if (!PyArg_ParseTuple (args, "Oii", &o, &n, &m)) return NULL;
  if (n < 1 || m < 1) goto L1;

  i = fltmatrix (&o, &p, n, m);
  if (i != 0) qplclr (p, n, m);
  
  if (i == 1) free (p);
  if (i == 0) return NULL;
  
L1:
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_qplcon (PyObject *self, PyObject *args)
{ PyObject *o;
  float *p;
  int  n, m, i, nlev;

  if (!PyArg_ParseTuple (args, "Oiii", &o, &n, &m, &nlev)) return NULL;
  if (n < 1 || m < 1) goto L1;

  i = fltmatrix (&o, &p, n, m);
  if (i != 0) qplcon (p, n, m, nlev);
  
  if (i == 1) free (p);
  if (i == 0) return NULL;
  
L1:
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_qplot (PyObject *self, PyObject *args)
{ PyObject *o1, *o2;
  float *p1, *p2;
  int  n, i1, i2;

  if (!PyArg_ParseTuple (args, "OOi", &o1, &o2, &n)) return NULL;
  if (n < 1) goto L1;

  i1 = fltarray (&o1, &p1, n);
  i2 = fltarray (&o2, &p2, n);

  if (i1 != 0 && i2 != 0) qplot (p1, p2, n);
  
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i1 == 0 || i2 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_qplpie (PyObject *self, PyObject *args)
{ PyObject *o1;
  float *p1;
  int  n, i1;

  if (!PyArg_ParseTuple (args, "Oi", &o1, &n)) return NULL;
  if (n < 1) goto L1;

  i1 = fltarray (&o1, &p1, n);

  if (i1 != 0) qplpie (p1, n);
  
  if (i1 == 1) free (p1);
  if (i1 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_qplsca (PyObject *self, PyObject *args)
{ PyObject *o1, *o2;
  float *p1, *p2;
  int  n, i1, i2;

  if (!PyArg_ParseTuple (args, "OOi", &o1, &o2, &n)) return NULL;
  if (n < 1) goto L1;

  i1 = fltarray (&o1, &p1, n);
  i2 = fltarray (&o2, &p2, n);

  if (i1 != 0 && i2 != 0) qplsca (p1, p2, n);
  
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i1 == 0 || i2 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_qplsur (PyObject *self, PyObject *args)
{ PyObject *o;
  float *p;
  int  n, m, i;

  if (!PyArg_ParseTuple (args, "Oii", &o, &n, &m)) return NULL;
  if (n < 1 || m < 1) goto L1;

  i = fltmatrix (&o, &p, n, m);
  if (i != 0) qplsur (p, n, m);
  
  if (i == 1) free (p);
  if (i == 0) return NULL;
  
L1:
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_rbmp (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  rbmp (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_rbfpng (PyObject *self, PyObject *args)
{ PyObject *o;
  char *p = NULL;
  int  n = 0, nmax;

  if (!PyArg_ParseTuple (args, "i", &nmax)) return NULL;
  if (nmax < 0) return Py_BuildValue ("si", "", 0);

  if (nmax == 0)
  { n = rbfpng (NULL, 0);
  }
  else
  { p = (char *) malloc (nmax);
    if (p == NULL)
    { PyErr_SetString (PyExc_MemoryError, "out of memory in rbfpng");
      return NULL;
    }
    n = rbfpng (p, nmax);
  }

  if (nmax == 0)
    return Py_BuildValue ("si", "", n);
  else 
  { o = Py_BuildValue ("s#i", p, n, n);
    free (p);
    return o;
  }
}

static PyObject *dislin_readfl (PyObject *self, PyObject *args)
{ PyObject *o;
  char *p;
  int  nu, nbyte, n = 0;

  if (!PyArg_ParseTuple (args, "ii", &nu, &nbyte)) return NULL;
  if (nbyte < 1) return Py_BuildValue ("si", "", 0);

  p = (char *) malloc (nbyte);
  if (p == NULL)
  { PyErr_SetString (PyExc_MemoryError, "out of memory in readfl");
    return NULL;
  }
  n = readfl (nu, (unsigned char *) p, nbyte);
  o = Py_BuildValue ("s#i", p, n, n);
  free (p);
  return o;
}

static PyObject *dislin_reawgt (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  reawgt();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_recfll (PyObject *self, PyObject *args)
{ int i1, i2, i3, i4, i5;

  if (!PyArg_ParseTuple (args, "iiiii", &i1, &i2, &i3,
                         &i4, &i5)) return NULL;
  recfll (i1, i2, i3, i4, i5);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_rectan (PyObject *self, PyObject *args)
{ int i1, i2, i3, i4;

  if (!PyArg_ParseTuple (args, "iiii", &i1, &i2, &i3, &i4)) return NULL;
  rectan (i1, i2, i3, i4);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_rel3pt (PyObject *self, PyObject *args)
{ float x, y, z, xp, yp;

  if (!PyArg_ParseTuple (args, "fff", &x, &y, &z)) return NULL;
  rel3pt (x, y, z, &xp, &yp);
  return Py_BuildValue ("ff", xp, yp);
}

static PyObject *dislin_resatt (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  resatt();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_reset (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  reset (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_revscr (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  revscr();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_rgbhsv (PyObject *self, PyObject *args)
{ float xh, xs, xv, xr, xg, xb;

  if (!PyArg_ParseTuple (args, "fff", &xr, &xg, &xb)) return NULL;
  rgbhsv (xr, xg, xb, &xh, &xs, &xv);
  return Py_BuildValue ("fff", xh, xs, xv);
}

static PyObject *dislin_rgif (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  rgif (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_rgtlab (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  rgtlab();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_rimage (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  rimage (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_rlarc (PyObject *self, PyObject *args)
{ float xm, ym, xa, xb, a, b, t;

  if (!PyArg_ParseTuple (args, "fffffff", &xm, &ym, &xa, &xb,
                         &a, &b, &t)) return NULL;
  rlarc (xm, ym, xa, xb, a, b, t);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_rlarea (PyObject *self, PyObject *args)
{ PyObject *o1, *o2;
  float *p1, *p2;
  int  n, i1, i2;

  if (!PyArg_ParseTuple (args, "OOi", &o1, &o2, &n)) return NULL;
  if (n < 1) goto L1;

  i1 = fltarray (&o1, &p1, n);
  i2 = fltarray (&o2, &p2, n);

  if (i1 != 0 && i2 != 0) rlarea (p1, p2, n);
  
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i1 == 0 || i2 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_rlcirc (PyObject *self, PyObject *args)
{ float xm, ym, r;

  if (!PyArg_ParseTuple (args, "fff", &xm, &ym, &r)) return NULL;
  rlcirc (xm, ym, r);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_rlconn (PyObject *self, PyObject *args)
{ float x, y;

  if (!PyArg_ParseTuple (args, "ff", &x, &y)) return NULL;
  rlconn (x, y);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_rlell (PyObject *self, PyObject *args)
{ float xm, ym, xa, xb;

  if (!PyArg_ParseTuple (args, "ffff", &xm, &ym, &xa, &xb)) return NULL;
  rlell (xm, ym, xa, xb);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_rline (PyObject *self, PyObject *args)
{ float xm, ym, xa, xb;

  if (!PyArg_ParseTuple (args, "ffff", &xm, &ym, &xa, &xb)) return NULL;
  rline (xm, ym, xa, xb);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_rlmess (PyObject *self, PyObject *args)
{ float x, y;
  char *s;

  if (!PyArg_ParseTuple (args, "sff", &s, &x, &y)) return NULL;
  rlmess (s, x, y);
  Py_INCREF (Py_None);
  return Py_None;
}


static PyObject *dislin_rlnumb (PyObject *self, PyObject *args)
{ float x, xp, yp;
  int n;

  if (!PyArg_ParseTuple (args, "fiff", &x, &n, &xp, &yp)) return NULL;
  rlnumb(x, n, xp, yp);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_rlpie (PyObject *self, PyObject *args)
{ float xm, ym, r, a, b;

  if (!PyArg_ParseTuple (args, "fffff", &xm, &ym, &r, &a, &b)) return NULL;
  rlpie (xm, ym, r, a, b);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_rlpoin (PyObject *self, PyObject *args)
{ float x, y;
  int   nb, nh, ncol;

  if (!PyArg_ParseTuple (args, "ffiii", &x, &y, &nb, &nh, &ncol)) return NULL;
  rlpoin (x, y, nb, nh, ncol);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_rlrec (PyObject *self, PyObject *args)
{ float x, y, xw, xh;

  if (!PyArg_ParseTuple (args, "ffff", &x, &y, &xw, &xh)) return NULL;
  rlrec (x, y, xw, xh);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_rlrnd (PyObject *self, PyObject *args)
{ float x, y, xw, xh;
  int i;
  if (!PyArg_ParseTuple (args, "ffffi", &x, &y, &xw, &xh, &i)) return NULL;
  rlrnd (x, y, xw, xh, i);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_rlsec (PyObject *self, PyObject *args)
{ float x, y, r1, r2, a, b;
  int i;
  if (!PyArg_ParseTuple (args, "ffffffi", &x, &y, &r1, &r2,
                         &a, &b, &i)) return NULL;
  rlsec (x, y, r1, r2, a, b, i);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_rlstrt (PyObject *self, PyObject *args)
{ float x, y;

  if (!PyArg_ParseTuple (args, "ff", &x, &y)) return NULL;
  rlstrt (x, y);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_rlsymb (PyObject *self, PyObject *args)
{ float x, y;
  int n;

  if (!PyArg_ParseTuple (args, "iff", &n, &x, &y)) return NULL;
  rlsymb (n, x, y);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_rlvec (PyObject *self, PyObject *args)
{ float x1, y1, x2, y2;
  int i;

  if (!PyArg_ParseTuple (args, "ffffi", &x1, &y1, &x2, &y2, &i)) return NULL;
  rlvec (x1, y1, x2, y2, i);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_rlwind (PyObject *self, PyObject *args)
{ float x, y, xk, a;
  int nw;

  if (!PyArg_ParseTuple (args, "fffif", &xk, &x, &y, &nw, &a)) return NULL;
  rlwind (xk, x, y, nw, a);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_rndrec (PyObject *self, PyObject *args)
{ int nx, ny, nu, nv, i;

  if (!PyArg_ParseTuple (args, "iiiii", &nx, &ny, &nu, &nv, &i)) return NULL;
  rndrec (nx, ny, nu, nv, i);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_rpixel (PyObject *self, PyObject *args)
{ int iclr, ix, iy;

  if (!PyArg_ParseTuple (args, "ii", &ix, &iy)) return NULL;
  rpixel (ix, iy, &iclr);
  return Py_BuildValue ("i", iclr);
}

static PyObject *dislin_rpixls (PyObject *self, PyObject *args)
{ PyObject *o;
  char *p;
  int  nx, ny, nw, nh, n;

  if (!PyArg_ParseTuple (args, "iiii", &nx, &ny, &nw, &nh)) return NULL;
  if (nw < 1 || nh < 1) return Py_BuildValue ("s", "");
  n = nw * nh;

  p = (char *) malloc (n);
  if (p == NULL)
  { PyErr_SetString (PyExc_MemoryError, "out of memory in rpixls");
    return NULL;
  }
 
  rpixls ((unsigned char *) p, nx, ny, nw, nh);
  o = Py_BuildValue ("s#i", p, n);
  free (p);
  return o;
}

static PyObject *dislin_rpng (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  rpng (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_rppm (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  rppm (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_rpxrow (PyObject *self, PyObject *args)
{ PyObject *o;
  char *p;
  int  nx, ny, n;

  if (!PyArg_ParseTuple (args, "iii", &nx, &ny, &n)) return NULL;
  if (n < 1) return Py_BuildValue ("s", "");

  p = (char *) malloc (n);
  if (p == NULL)
  { PyErr_SetString (PyExc_MemoryError, "out of memory in rpxrow");
    return NULL;
  }
  rpxrow ((unsigned char *) p, nx, ny, n);
  o = Py_BuildValue ("s#i", p, n);
  free (p);
  return o;
}

static PyObject *dislin_rtiff (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  rtiff (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_rvynam (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  rvynam();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_scale (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  scale (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_axsscl (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  axsscl (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_sclfac (PyObject *self, PyObject *args)
{ float x;

  if (!PyArg_ParseTuple (args, "f", &x)) return NULL;
  sclfac (x);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_sclmod (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  sclmod (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_scrmod (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  scrmod (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_sector (PyObject *self, PyObject *args)
{ int nx, ny, nr1, nr2, ncol;
  float a, b;

  if (!PyArg_ParseTuple (args, "iiiiffi", &nx, &ny, &nr1, &nr2,
                         &a, &b, &ncol)) return NULL;
  sector (nx, ny, nr1, nr2, a, b, ncol);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_selwin (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  selwin (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_sendbf (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  sendbf();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_sendmb (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  sendmb();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_sendok (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  sendok();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_serif (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  serif();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_setbas (PyObject *self, PyObject *args)
{ float x;

  if (!PyArg_ParseTuple (args, "f", &x)) return NULL;
  setbas (x);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_setclr (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  setclr (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_setcsr (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  setcsr (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_setexp (PyObject *self, PyObject *args)
{ float x;

  if (!PyArg_ParseTuple (args, "f", &x)) return NULL;
  setexp (x);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_setfil (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  setfil (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_setgrf (PyObject *self, PyObject *args)
{ char *s1, *s2, *s3, *s4;

  if (!PyArg_ParseTuple (args, "ssss", &s1, &s2, &s3, &s4)) return NULL;
  setgrf (s1, s2, s3, s4);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_setind (PyObject *self, PyObject *args)
{ int i;
  float xr, xg, xb;
  if (!PyArg_ParseTuple (args, "ifff", &i, &xr, &xg, &xb)) return NULL;
  setind (i, xr, xg, xb);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_setmix (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  setmix (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_setpag (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  setpag (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_setres (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "ii", &i1, &i2)) return NULL;
  setres (i1, i2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_setrgb (PyObject *self, PyObject *args)
{ float xr, xg, xb;

  if (!PyArg_ParseTuple (args, "fff", &xr, &xg, &xb)) return NULL;
  setrgb (xr, xg, xb);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_setscl (PyObject *self, PyObject *args)
{ PyObject *o1;
  float *p1;
  char  *s;
  int  n, i1;

  if (!PyArg_ParseTuple (args, "Ois", &o1, &n, &s)) return NULL;
  if (n < 1) goto L1;

  i1 = fltarray (&o1, &p1, n);
  if (i1 != 0) setscl (p1, n, s);
  
  if (i1 == 1) free (p1);
  if (i1 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_setvlt (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  setvlt (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_setxid (PyObject *self, PyObject *args)
{ int i;
  char *s;
  if (!PyArg_ParseTuple (args, "is", &i, &s)) return NULL;
  setxid (i, s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_shdafr (PyObject *self, PyObject *args)
{ PyObject *o1, *o2, *o3;
  int  *p1, *p3;
  long *p2;
  int  n, i1, i2, i3;
  
  if (!PyArg_ParseTuple (args, "OOOi", &o1, &o2, &o3, &n)) return NULL;
  if (n < 1) goto L1;

  i1 = intarray  (&o1, &p1, n);
  i2 = longarray (&o2, &p2, n);
  i3 = intarray  (&o3, &p3, n);

  if (i1 != 0 && i2 != 0 && i3 != 0) shdafr (p1, p2, p3, n);

  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i3 == 1) free (p3);
  if (i1 == 0 || i2 == 0 || i3 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_shdcha (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  shdcha ();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_shdcrv (PyObject *self, PyObject *args)
{ PyObject *o1, *o2, *o3, *o4;
  float *p1, *p2, *p3, *p4;
  int  n1, n2, i1, i2, i3, i4;

  if (!PyArg_ParseTuple (args, "OOiOOi", &o1, &o2, &n1, &o3, &o4, &n2)) 
                           return NULL;
  if (n1 < 1 || n2 < 1) goto L1;

  i1 = fltarray (&o1, &p1, n1);
  i2 = fltarray (&o2, &p2, n1);
  i3 = fltarray (&o3, &p3, n2);
  i4 = fltarray (&o4, &p4, n2);

  if (i1 != 0 && i2 != 0 && i3 != 0 && i4 != 0)
     shdcrv (p1, p2, n1, p3, p4, n2);
  
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i3 == 1) free (p3);
  if (i4 == 1) free (p4);
  if (i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0) return NULL;

L1:
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_shdeur (PyObject *self, PyObject *args)
{ PyObject *o1, *o2, *o3;
  int  *p1, *p3;
  long *p2;
  int  n, i1, i2, i3;
  
  if (!PyArg_ParseTuple (args, "OOOi", &o1, &o2, &o3, &n)) return NULL;
  if (n < 1) goto L1;

  i1 = intarray  (&o1, &p1, n);
  i2 = longarray (&o2, &p2, n);
  i3 = intarray  (&o3, &p3, n);

  if (i1 != 0 && i2 != 0 && i3 != 0) shdeur (p1, p2, p3, n);

  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i3 == 1) free (p3);
  if (i1 == 0 || i2 == 0 || i3 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_shdmap (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  shdmap (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_shdmod (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  shdmod (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_shdpat (PyObject *self, PyObject *args)
{ int i;
  if (!PyArg_ParseTuple (args, "i", &i)) return NULL;
  shdpat ((long) i);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_shdusa (PyObject *self, PyObject *args)
{ PyObject *o1, *o2, *o3;
  int  *p1, *p3;
  long *p2;
  int  n, i1, i2, i3;
  
  if (!PyArg_ParseTuple (args, "OOOi", &o1, &o2, &o3, &n)) return NULL;
  if (n < 1) goto L1;

  i1 = intarray  (&o1, &p1, n);
  i2 = longarray (&o2, &p2, n);
  i3 = intarray  (&o3, &p3, n);

  if (i1 != 0 && i2 != 0 && i3 != 0) shdusa (p1, p2, p3, n);

  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i3 == 1) free (p3);
  if (i1 == 0 || i2 == 0 || i3 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_shield (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  shield (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_shlcir (PyObject *self, PyObject *args)
{ int nx, ny, nr;
  if (!PyArg_ParseTuple (args, "iii", &nx, &ny, &nr)) return NULL;
  shlcir (nx, ny, nr);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_shldel (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  shldel (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_shlell (PyObject *self, PyObject *args)
{ int i1, i2, i3, i4;
  float x;

  if (!PyArg_ParseTuple (args, "iiiif", &i1, &i2, &i3, &i4, &x)) return NULL;
  shlell (i1, i2, i3, i4, x);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_shlind (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  n = shlind ();
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_shlpie (PyObject *self, PyObject *args)
{ int i1, i2, i3;
  float a, b;

  if (!PyArg_ParseTuple (args, "iiiff", &i1, &i2, &i3, &a, &b)) return NULL;
  shlpie (i1, i2, i3, a, b);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_shlpol (PyObject *self, PyObject *args)
{ PyObject *o1, *o2;
  int  *p1, *p2;
  int  n, i1, i2;

  if (!PyArg_ParseTuple (args, "OOi", &o1, &o2, &n)) return NULL;
  if (n < 1) goto L1;

  i1 = intarray (&o1, &p1, n);
  i2 = intarray (&o2, &p2, n);

  if (i1 != 0 && i2 != 0) shlpol (p1, p2, n);
  
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i1 == 0 || i2 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_shlrct (PyObject *self, PyObject *args)
{ int i1, i2, i3, i4;
  float x;

  if (!PyArg_ParseTuple (args, "iiiif", &i1, &i2, &i3, &i4, &x)) return NULL;
  shlrct (i1, i2, i3, i4, x);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_shlrec (PyObject *self, PyObject *args)
{ int i1, i2, i3, i4;

  if (!PyArg_ParseTuple (args, "iiii", &i1, &i2, &i3, &i4)) return NULL;
  shlrec (i1, i2, i3, i4);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_shlres (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  shlres (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_shlsur (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  shlsur();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_shlvis (PyObject *self, PyObject *args)
{ int i;
  char *s;
  if (!PyArg_ParseTuple (args, "is", &i, &s)) return NULL;
  shlvis (i, s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_simplx (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  simplx();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_skipfl (PyObject *self, PyObject *args)
{ int  n, nu, nbyte;  
  if (!PyArg_ParseTuple (args, "ii", &nu, &nbyte)) return NULL;
  n = skipfl (nu, nbyte);
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_smxalf (PyObject *self, PyObject *args)
{ char *s1, *s2, *s3;
  int n;

  if (!PyArg_ParseTuple (args, "sssi", &s1, &s2, &s3, &n)) return NULL;
  smxalf (s1, s2, s3, n);
  Py_INCREF (Py_None);
  return Py_None;
}
 
static PyObject *dislin_solid (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  solid();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_sortr1 (PyObject *self, PyObject *args)
{ PyObject *o1;
  float *p1;
  char  *s;
  int  n, i1;

  if (!PyArg_ParseTuple (args, "Ois", &o1, &n, &s)) return NULL;
  if (n < 1) goto L1;

  i1 = fltarray (&o1, &p1, n);

  if (i1 != 0)
  { sortr1 (p1, n, s);
    if (i1 == 1) copyfloatarray (p1, o1, n);
  }
  if (i1 == 1) free (p1);
  if (i1 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_sortr2 (PyObject *self, PyObject *args)
{ PyObject *o1, *o2;
  float *p1, *p2;
  char  *s;
  int  n, i1, i2;

  if (!PyArg_ParseTuple (args, "OOis", &o1, &o2, &n, &s)) return NULL;
  if (n < 1) goto L1;

  i1 = fltarray (&o1, &p1, n);
  i2 = fltarray (&o2, &p2, n);

  if (i1 != 0 && i2 != 0)
  { sortr2 (p1, p2, n, s);
    if (i1 == 1) copyfloatarray (p1, o1, n);
    if (i2 == 1) copyfloatarray (p2, o2, n);
  }
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i1 == 0 || i2 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_sphe3d (PyObject *self, PyObject *args)
{ float xm, ym, zm, r;
  int n, m;
  if (!PyArg_ParseTuple (args, "ffffii", &xm, &ym, &zm, &r, &n, &m)) 
        return NULL;
  sphe3d (xm, ym, zm, r, n, m);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_spline (PyObject *self, PyObject *args)
{ PyObject *o1, *o2, *o3, *o4;
  float *p1, *p2, *p3, *p4;
  int  n, i1, i2, i3, i4, nspl = 0;

  if (!PyArg_ParseTuple (args, "OOiOO", &o1, &o2, &n, &o3, &o4)) return NULL;
  if (n < 1) goto L1;

  i1 = fltarray (&o1, &p1, n);
  i2 = fltarray (&o2, &p2, n);
  i3 = fltarray (&o3, &p3, nspline);
  i4 = fltarray (&o4, &p4, nspline);  

  if (i1 != 0 && i2 != 0 && i3 != 0 && i4 != 0)
  { spline (p1, p2, n, p3, p4, &nspl);
    if (i3 == 1) copyfloatarray (p3, o3, nspl);
    if (i4 == 1) copyfloatarray (p4, o4, nspl);
  }
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i3 == 1) free (p3);
  if (i4 == 1) free (p4);
  if (i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0) return NULL;

L1:

  return Py_BuildValue ("i", nspl);
}

static PyObject *dislin_splmod (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "ii", &i1, &i2)) return NULL;
  splmod (i1, i2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_strt3d (PyObject *self, PyObject *args)
{ float x, y, z;

  if (!PyArg_ParseTuple (args, "fff", &x, &y, &z)) return NULL;
  strt3d (x, y, z);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_strtpt (PyObject *self, PyObject *args)
{ float x, y;

  if (!PyArg_ParseTuple (args, "ff", &x, &y)) return NULL;
  strtpt (x, y);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_surclr (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "ii", &i1, &i2)) return NULL;
  surclr (i1, i2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_surfce (PyObject *self, PyObject *args)
{ PyObject *o1, *o2, *o3;
  float *p1, *p2, *p3;
  int i1, i2, i3, n, m, nn;

  if (!PyArg_ParseTuple (args, "OiOiO", &o1, &n, &o2, &m, &o3)) return NULL;
  nn = n * m;
  if (n < 1 || m < 1) goto L1;

  i1 = fltarray  (&o1, &p1, n);
  i2 = fltarray  (&o2, &p2, m);
  i3 = fltmatrix (&o3, &p3, n, m);
  
  if (i1 != 0 && i2 != 0 && i3 != 0) surfce (p1, n, p2, m, p3);
  
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i3 == 1) free (p3);
  if (i1 == 0 || i2 == 0 || i3 == 0) return NULL;
  
L1:
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_surfun (PyObject *self, PyObject *args)
{ PyObject *cb_func;
  float xdel, ydel;
  int ixp, iyp;

  if (!PyArg_ParseTuple (args, "Oifif", &cb_func, &ixp, &xdel,
                                                    &iyp, &ydel)) 
     return NULL;

  ocbfunc = cb_func;
  surfun (dis_funcbck2, ixp, xdel, iyp, ydel);

  Py_INCREF (Py_None);
  return Py_None;
}


static PyObject *dislin_surfcp (PyObject *self, PyObject *args)
{  PyObject *cb_func;
  float a1, a2, astep, b1, b2, bstep;

  if (!PyArg_ParseTuple (args, "Offffff", &cb_func, &a1, &a2, &astep,
                                                    &b1, &b2, &bstep)) 
     return NULL;

  ocbfunc = cb_func;
  surfcp (dis_funcbck, a1, a2, astep, b1, b2, bstep);

  Py_INCREF (Py_None);
  return Py_None;
}

float dis_funcbck (float x, float y, int iopt)
{ PyObject *arglist, *result;
  float xv = 0.;

  arglist = Py_BuildValue ("(ffi)", x, y, iopt);
  result = PyEval_CallObject (ocbfunc, arglist);
  if (result == NULL) return xv;

  if (PyFloat_Check(result))
    xv = (float) PyFloat_AsDouble (result);
  Py_DECREF(result);
  return xv;
}

float dis_funcbck2 (float x, float y)
{ PyObject *arglist, *result;
  float xv = 0.;

  arglist = Py_BuildValue ("(ff)", x, y);
  result = PyEval_CallObject (ocbfunc, arglist);
  if (result == NULL) return xv;

  if (PyFloat_Check(result))
    xv = (float) PyFloat_AsDouble (result);
  Py_DECREF(result);
  return xv;
}

static PyObject *dislin_suriso (PyObject *self, PyObject *args)
{ PyObject *o1, *o2, *o3, *o4;
  float *p1, *p2, *p3, *p4, wlev;
  int i1, i2, i3, i4, nx, ny, nz, nn;
  

  if (!PyArg_ParseTuple (args, "OiOiOiOf", 
      &o1, &nx, &o2, &ny, &o3, &nz, &o4, &wlev)) return NULL;
  nn = nx * ny * nz;
  if (nx < 1 || ny < 1 || nz < 1) goto L1;

  i1 = fltarray   (&o1, &p1, nx);
  i2 = fltarray   (&o2, &p2, ny);
  i3 = fltarray   (&o3, &p3, nz);
  i4 = fltmatrix3 (&o4, &p4, nx, ny, nz);
  
  if (i1 != 0 && i2 != 0 && i3 != 0 && i4 != 0) 
     suriso (p1, nx, p2, ny, p3, nz, p4, wlev);
  
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i3 == 1) free (p3);
  if (i4 == 1) free (p4);
  if (i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0) return NULL;
  
L1:
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_surmat (PyObject *self, PyObject *args)
{ PyObject *o;
  float *p;
  int  n, m, i, nn, ix, iy;

  if (!PyArg_ParseTuple (args, "Oiiii", &o, &n, &m, &ix, &iy)) return NULL;
  nn = n * m;
  if (n < 1 || m < 1) goto L1;

  i = fltmatrix (&o, &p, n, m);
  if (i != 0) surmat (p, n, m, ix, iy);
  
  if (i == 1) free (p);
  if (i == 0) return NULL;
  
L1:
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_surtri (PyObject *self, PyObject *args)
{ PyObject *o1, *o2, *o3, *o4, *o5, *o6;
  float *p1, *p2, *p3;
  int   *p4, *p5, *p6;  
  int i1, i2, i3, i4, i5, i6, n, ntri;

  if (!PyArg_ParseTuple (args, "OOOiOOOi", &o1, &o2, &o3, &n,
                         &o4, &o5, &o6, &ntri))  return NULL;
  if (n < 1 || ntri < 1) goto L1;

  i1 = fltarray  (&o1, &p1, n);
  i2 = fltarray  (&o2, &p2, n);
  i3 = fltarray  (&o3, &p3, n);
  i4 = intarray  (&o4, &p4, ntri);
  i5 = intarray  (&o5, &p5, ntri);
  i6 = intarray  (&o6, &p6, ntri);
  
  if (i1 != 0 && i2 != 0 && i3 != 0 &&
      i4 != 0 && i5 != 0 && i6 != 0) 
    surtri (p1, p2, p3, n, p4, p5, p6, ntri);
  
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i3 == 1) free (p3);
  if (i4 == 1) free (p4);
  if (i5 == 1) free (p5);
  if (i6 == 1) free (p6);

  if (i1 == 0 || i2 == 0 || i3 == 0 || 
      i4 == 0 || i5 == 0 || i6 == 0)  return NULL;
  
L1:
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_surmsh (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  surmsh (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_suropt (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  suropt (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_surshd (PyObject *self, PyObject *args)
{ PyObject *o1, *o2, *o3;
  float *p1, *p2, *p3;
  int i1, i2, i3, n, m, nn;

  if (!PyArg_ParseTuple (args, "OiOiO", &o1, &n, &o2, &m, &o3)) return NULL;
  nn = n * m;
  if (n < 1 || m < 1) goto L1;

  i1 = fltarray  (&o1, &p1, n);
  i2 = fltarray  (&o2, &p2, m);
  i3 = fltmatrix (&o3, &p3, n, m);
  
  if (i1 != 0 && i2 != 0 && i3 != 0) surshd (p1, n, p2, m, p3);
  
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i3 == 1) free (p3);
  if (i1 == 0 || i2 == 0 || i3 == 0) return NULL;
  
L1:
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_sursze (PyObject *self, PyObject *args)
{ float x1, x2, y1, y2;

  if (!PyArg_ParseTuple (args, "ffff", &x1, &x2, &y1, &y2)) return NULL;
  sursze (x1, x2, y1, y2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_survis (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  survis (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_swgatt (PyObject *self, PyObject *args)
{ char *s1, *s2;
  int id;

  if (!PyArg_ParseTuple (args, "iss", &id, &s1, &s2)) return NULL;
  swgatt (id, s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_swgbox (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "ii", &i1, &i2)) return NULL;
  swgbox (i1, i2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_swgbut (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "ii", &i1, &i2)) return NULL;
  swgbut (i1, i2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_swgcb (PyObject *self, PyObject *args)
{  PyObject *cb_func, *cb_parm;
  int id;

  if (!PyArg_ParseTuple (args, "iOO", &id, &cb_func, &cb_parm)) 
     return NULL;

  if (ncbray < MAX_CB)
  { icbray[ncbray] = id;
    ocbray[ncbray] = cb_func;
    ocbpar[ncbray] = cb_parm;
    ncbray++;
  }
  else
  { PyErr_SetString (PyExc_ValueError, "Too many callback routines");
    return NULL;
  }

  swgcb (id, dis_callbck, (INTEG4 *) NULL);

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_swgcbk (PyObject *self, PyObject *args)
{  PyObject *cb_func;
  int id;

  if (!PyArg_ParseTuple (args, "iO", &id, &cb_func)) 
     return NULL;

  if (ncbray < MAX_CB)
  { icbray[ncbray] = id;
    ocbray[ncbray] = cb_func;
    ncbray++;
  }
  else
  { PyErr_SetString (PyExc_ValueError, "Too many callback routines");
    return NULL;
  }

  swgcbk (id, dis_callbck2);

  Py_INCREF (Py_None);
  return Py_None;
}

void dis_callbck (int id, int *i1)
{ int i; 
  PyObject *arglist, *result;

  for (i = ncbray - 1; i >= 0; i--)
  { if (id == icbray[i])
    { arglist = Py_BuildValue ("(iO)", id,ocbpar[i]);
      result = PyEval_CallObject (ocbray[i], arglist);
      if (result == NULL) return;
      Py_DECREF(result);
      return;
    }
  }
  return;
}

void dis_callbck2 (int id)
{ int i; 
  PyObject *arglist, *result;

  for (i = ncbray - 1; i >= 0; i--)
  { if (id == icbray[i])
    { arglist = Py_BuildValue ("(i)", id);
      result = PyEval_CallObject (ocbray[i], arglist);
      if (result == NULL) return;
      Py_DECREF(result);
      return;
    }
  }
  return;
}

static PyObject *dislin_swgclr (PyObject *self, PyObject *args)
{ float xr, xg, xb;
  char *s;
  if (!PyArg_ParseTuple (args, "fffs", &xr, &xg, &xb, &s)) return NULL;
  swgclr (xr, xg, xb, s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_swgdrw (PyObject *self, PyObject *args)
{ float x;

  if (!PyArg_ParseTuple (args, "f", &x)) return NULL;
  swgdrw (x);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_swgfil (PyObject *self, PyObject *args)
{ char *s;
  int ip;

  if (!PyArg_ParseTuple (args, "is", &ip, &s)) return NULL;
  swgfil (ip, s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_swgfoc (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  swgfoc (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_swgfnt (PyObject *self, PyObject *args)
{ char *s;
  int i;

  if (!PyArg_ParseTuple (args, "si", &s, &i)) return NULL;
  swgfnt (s, i);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_swghlp (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  swghlp (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_swgjus (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  swgjus (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_swglis (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "ii", &i1, &i2)) return NULL;
  swglis (i1, i2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_swgmix (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  swgmix (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_swgmod (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  swgmod (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_swgmrg (PyObject *self, PyObject *args)
{ char *s;
  int ip;

  if (!PyArg_ParseTuple (args, "is", &ip, &s)) return NULL;
  swgmrg (ip, s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_swgoff (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "ii", &i1, &i2)) return NULL;
  swgoff (i1, i2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_swgopt (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  swgopt (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_swgpop (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  swgpop (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_swgpos (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "ii", &i1, &i2)) return NULL;
  swgpos (i1, i2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_swgscl (PyObject *self, PyObject *args)
{ float xscl;
  int ip;

  if (!PyArg_ParseTuple (args, "if", &ip, &xscl)) return NULL;
  swgscl (ip, xscl);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_swgsiz (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "ii", &i1, &i2)) return NULL;
  swgsiz (i1, i2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_swgspc (PyObject *self, PyObject *args)
{ float x, y;

  if (!PyArg_ParseTuple (args, "ff", &x, &y)) return NULL;
  swgspc (x, y);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_swgstp (PyObject *self, PyObject *args)
{ float x;

  if (!PyArg_ParseTuple (args, "f", &x)) return NULL;
  swgstp (x);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_swgtit (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  swgtit (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_swgtxt (PyObject *self, PyObject *args)
{ char *s;
  int ip;

  if (!PyArg_ParseTuple (args, "is", &ip, &s)) return NULL;
  swgtxt (ip, s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_swgtyp (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  swgtyp (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_swgwin (PyObject *self, PyObject *args)
{ int nx, ny, nw, nh;

  if (!PyArg_ParseTuple (args, "iiii", &nx, &ny, &nw, &nh)) return NULL;
  swgwin (nx, ny, nw, nh);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_swgwth (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  swgwth (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_symbol (PyObject *self, PyObject *args)
{ int i1, i2, i3;

  if (!PyArg_ParseTuple (args, "iii", &i1, &i2, &i3)) return NULL;
  symbol (i1, i2, i3);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_symfil (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  symfil (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_symrot (PyObject *self, PyObject *args)
{ float x;

  if (!PyArg_ParseTuple (args, "f", &x)) return NULL;
  symrot (x);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_tellfl (PyObject *self, PyObject *args)
{ int  n, nu;  
  if (!PyArg_ParseTuple (args, "i", &nu)) return NULL;
  n = tellfl (nu);
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_thkcrv (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  thkcrv (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_thrfin (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;

  thrfin();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_thrini (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  thrini (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_ticks (PyObject *self, PyObject *args)
{ char *s;
  int n;

  if (!PyArg_ParseTuple (args, "is", &n, &s)) return NULL;
  ticks (n, s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_ticlen (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "ii", &i1, &i2)) return NULL;
  ticlen (i1, i2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_ticmod (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  ticmod (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_tifmod (PyObject *self, PyObject *args)
{ int i1;
 char *s1, *s2;

  if (!PyArg_ParseTuple (args, "iss", &i1, &s1, &s2)) return NULL;
  tifmod (i1, s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_ticpos (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  ticpos (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_tiforg (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "ii", &i1, &i2)) return NULL;
  tiforg (i1, i2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_tifwin (PyObject *self, PyObject *args)
{ int nx, ny, nw, nh;

  if (!PyArg_ParseTuple (args, "iiii", &nx, &ny, &nw, &nh)) return NULL;
  tifwin (nx, ny, nw, nh);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_timopt (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  timopt();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_titjus (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  titjus (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_title (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  title();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_titlin (PyObject *self, PyObject *args)
{ char *s;
  int i;

  if (!PyArg_ParseTuple (args, "si", &s, &i)) return NULL;
  titlin (s, i);
  Py_INCREF (Py_None);
  return Py_None;
}

void  titlin (char *cstr, int n);

static PyObject *dislin_titpos (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  titpos (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_trfco1 (PyObject *self, PyObject *args)
{ PyObject *o1;
  float *p1;
  char  *s1, *s2;
  int  n, i1;

  if (!PyArg_ParseTuple (args, "Oiss", &o1, &n, &s1, &s2)) return NULL;
  if (n < 1) goto L1;

  i1 = fltarray (&o1, &p1, n);

  if (i1 != 0)
  { trfco1 (p1, n, s1, s2);
    if (i1 == 1) copyfloatarray (p1, o1, n);
  }
  if (i1 == 1) free (p1);
  if (i1 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_trfco2 (PyObject *self, PyObject *args)
{ PyObject *o1, *o2;
  float *p1, *p2;
  char *s1, *s2;
  int  n, i1, i2;

  if (!PyArg_ParseTuple (args, "OOiss", &o1, &o2, &n, &s1, &s2)) return NULL;
  if (n < 1) goto L1;

  i1 = fltarray (&o1, &p1, n);
  i2 = fltarray (&o2, &p2, n);

  if (i1 != 0 && i2 != 0)
  { trfco2 (p1, p2, n, s1, s2);
    if (i1 == 1) copyfloatarray (p1, o1, n);
    if (i2 == 1) copyfloatarray (p2, o2, n);
  }
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i1 == 0 || i2 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_trfco3 (PyObject *self, PyObject *args)
{ PyObject *o1, *o2, *o3;
  float *p1, *p2, *p3;
  char *s1, *s2;
  int  n, i1, i2, i3;

  if (!PyArg_ParseTuple (args, "OOOiss", &o1, &o2, &o3,
                         &n, &s1, &s2)) return NULL;
  if (n < 1) goto L1;

  i1 = fltarray (&o1, &p1, n);
  i2 = fltarray (&o2, &p2, n);
  i3 = fltarray (&o3, &p3, n);

  if (i1 != 0 && i2 != 0 && i3 != 0)
  { trfco3 (p1, p2, p3, n, s1, s2);
    if (i1 == 1) copyfloatarray (p1, o1, n);
    if (i2 == 1) copyfloatarray (p2, o2, n);
    if (i3 == 1) copyfloatarray (p3, o3, n);
  }
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i3 == 1) free (p3);
  if (i1 == 0 || i2 == 0 || i3 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_trfdat (PyObject *self, PyObject *args)
{ int i1, i2, i3, n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  trfdat (n, &i1, &i2, &i3);

  return Py_BuildValue ("iii", i1, i2, i3);
}

static PyObject *dislin_trfrel (PyObject *self, PyObject *args)
{ PyObject *o1, *o2;
  float *p1, *p2;
  int  n, i1, i2;

  if (!PyArg_ParseTuple (args, "OOi", &o1, &o2, &n)) return NULL;
  if (n < 1) goto L1;

  i1 = fltarray (&o1, &p1, n);
  i2 = fltarray (&o2, &p2, n);

  if (i1 != 0 && i2 != 0)
  { trfrel (p1, p2, n);
    if (i1 == 1) copyfloatarray (p1, o1, n);
    if (i2 == 1) copyfloatarray (p2, o2, n);
  }
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i1 == 0 || i2 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_trfres (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  trfres();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_trfmat (PyObject *self, PyObject *args)
{ PyObject *o1, *o2;
  float *p1, *p2;
  int  nx, ny, i1, i2, nx2, ny2;

  if (!PyArg_ParseTuple (args, "OiiOii", &o1, &nx, &ny, &o2, &nx2, &ny2)) 
       return NULL;
  if (nx < 1 || ny < 1 || nx2 < 1 || ny2 < 1) goto L1;

  i1 = fltmatrix (&o1, &p1, nx, ny);
  i2 = fltmatrix (&o2, &p2, nx2, ny2);

  if (i1 != 0 && i2 != 0) 
  { trfmat (p1, nx, ny, p2, nx2, ny2);
    if (i2 == 1) copyfloatarray (p2, o2, nx2*ny2);
  } 
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i1 == 0 || i2 == 0) return NULL;
  
L1:
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_trfrot (PyObject *self, PyObject *args)
{ float x;
  int nx, ny;

  if (!PyArg_ParseTuple (args, "fii", &x, &nx, &ny)) return NULL;
  trfrot (x, nx, ny);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_trfscl (PyObject *self, PyObject *args)
{ float x, y;

  if (!PyArg_ParseTuple (args, "ff", &x, &y)) return NULL;
  trfscl (x, y);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_trfshf (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "ii", &i1, &i2)) return NULL;
  trfshf (i1, i2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_triang (PyObject *self, PyObject *args)
{ PyObject *o1, *o2, *o3, *o4, *o5;
  float *p1, *p2;
  int   *p3, *p4, *p5;  
  int i1, i2, i3, i4, i5, n, nmax, ntri;

  if (!PyArg_ParseTuple (args, "OOiOOOi", &o1, &o2, &n, &o3,
                         &o4, &o5, &nmax))  return NULL;
  if (n < 1 || nmax < 1) goto L1;

  i1 = fltarray  (&o1, &p1, n+3);
  i2 = fltarray  (&o2, &p2, n+3);
  i3 = intarray  (&o3, &p3, nmax);
  i4 = intarray  (&o4, &p4, nmax);
  i5 = intarray  (&o5, &p5, nmax);
  
  if (i1 != 0 && i2 != 0 && i3 != 0 &&
      i4 != 0 && i5 != 0) 
  { ntri = triang (p1, p2, n, p3, p4, p5, nmax);
    if (i3 == 1) copyintarray   (p3, o3, nmax);
    if (i4 == 1) copyintarray   (p4, o4, nmax);
    if (i5 == 1) copyintarray   (p5, o5, nmax);
  }
 
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i3 == 1) free (p3);
  if (i4 == 1) free (p4);
  if (i5 == 1) free (p5);

  if (i1 == 0 || i2 == 0 || i3 == 0 || 
      i4 == 0 || i5 == 0)  return NULL;
  
L1:

  return Py_BuildValue ("i", ntri);
}

static PyObject *dislin_trifll (PyObject *self, PyObject *args)
{ PyObject *o1, *o2;
  float *p1, *p2;
  int i1, i2;

  if (!PyArg_ParseTuple (args, "OO", &o1, &o2)) return NULL;

  i1 = fltarray (&o1, &p1, 3);
  i2 = fltarray (&o2, &p2, 3);

  if (i1 != 0 && i2 != 0) trifll (p1, p2);
  
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i1 == 0 || i2 == 0) return NULL;

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_triplx (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  triplx();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_tripts (PyObject *self, PyObject *args)
{ PyObject *o1, *o2, *o3, *o4, *o5, *o6, *o7, *o8, *o9;
  float *p1, *p2, *p3, zlev, *p7, *p8;
  int   *p4, *p5, *p6, *p9;  
  int i = 0, i1, i2, i3, i4, i5, i6, i7, i8, i9, n, ntri, maxpts, maxray;

  if (!PyArg_ParseTuple (args, "OOOiOOOif", &o1, &o2, &o3, &n,
                         &o4, &o5, &o6, &ntri, &zlev, &o7, &o8, 
                         &maxpts, &o9, &maxray))  return NULL;
  if (n < 1 || ntri < 1 || maxpts < 1 || maxray < 1) goto L1;

  i1 = fltarray  (&o1, &p1, n);
  i2 = fltarray  (&o2, &p2, n);
  i3 = fltarray  (&o3, &p3, n);
  i4 = intarray  (&o4, &p4, ntri);
  i5 = intarray  (&o5, &p5, ntri);
  i6 = intarray  (&o6, &p6, ntri);
  i7 = fltarray  (&o7, &p7, maxpts);
  i8 = fltarray  (&o8, &p8, maxpts);
  i9 = intarray  (&o9, &p9, maxray);
  
  if (i1 != 0 && i2 != 0 && i3 != 0 && i4 != 0 && i5 != 0 && 
      i6 != 0 && i7 != 0 && i8 != 0 && i9 != 0) 
  { tripts (p1, p2, p3, n, p4, p5, p6, ntri, zlev,
            p7, p8, maxpts, p9, maxray, &i);
    if (i7 == 1) copyfloatarray (p7, o7, maxpts);
    if (i8 == 1) copyfloatarray (p8, o8, maxpts);
    if (i9 == 1) copyintarray   (p9, o9, maxray);
  }
  
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i3 == 1) free (p3);
  if (i4 == 1) free (p4);
  if (i5 == 1) free (p5);
  if (i6 == 1) free (p6);
  if (i7 == 1) free (p7);
  if (i8 == 1) free (p8);
  if (i9 == 1) free (p9);

  if (i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0 || i5 == 0 || i6 == 0 ||
      i7 == 0 || i8 == 0 || i9 == 0)  return NULL;
  
L1:
  return Py_BuildValue ("i", i);
}

static PyObject *dislin_trmlen (PyObject *self, PyObject *args)
{ int  n;
  char *s;
  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  n = trmlen (s);
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_texmod (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  texmod (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_texopt (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  texopt (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_texval (PyObject *self, PyObject *args)
{ char *s;
  float x;

  if (!PyArg_ParseTuple (args, "fs", &x, &s)) return NULL;
  texval (x, s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_txtjus (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  txtjus (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_unit (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  if (n == 0)
    unit (NULL);
  else
    unit ((void *) stdout);
 
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_units (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  units (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_upstr (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  upstr (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_vang3d (PyObject *self, PyObject *args)
{ float x;

  if (!PyArg_ParseTuple (args, "f", &x)) return NULL;
  vang3d (x);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_vclp3d (PyObject *self, PyObject *args)
{ float x1, x2;

  if (!PyArg_ParseTuple (args, "ff", &x1, &x2)) return NULL;
  vclp3d (x1, x2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_vector (PyObject *self, PyObject *args)
{ int nx1, ny1, nx2, ny2, ivec;

  if (!PyArg_ParseTuple (args, "iiiii", &nx1, &ny1, &nx2, &ny2,
                         &ivec)) return NULL;
  vector (nx1, ny1, nx2, ny2, ivec);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_vectr3 (PyObject *self, PyObject *args)
{ float x1, y1, z1, x2, y2, z2;
  int ivec;

  if (!PyArg_ParseTuple (args, "ffffffi", &x1, &y1, &z1,
                                          &x2, &y2, &z2, &ivec)) return NULL;
  vectr3 (x1, y1, z1, x2, y2, z2, ivec);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_vfoc3d (PyObject *self, PyObject *args)
{ float x, y, z;
  char *s;

  if (!PyArg_ParseTuple (args, "fffs", &x, &y, &z, &s)) return NULL;
  vfoc3d (x, y, z, s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_view3d (PyObject *self, PyObject *args)
{ float x, y, z;
  char *s;

  if (!PyArg_ParseTuple (args, "fffs", &x, &y, &z, &s)) return NULL;
  view3d (x, y, z, s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_vkxbar (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  vkxbar (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_vkybar (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  vkybar (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_vkytit (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  vkytit (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_vltfil (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  vltfil (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_vup3d (PyObject *self, PyObject *args)
{ float x;

  if (!PyArg_ParseTuple (args, "f", &x)) return NULL;
  vup3d (x);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_wgapp (PyObject *self, PyObject *args)
{ int  ip, i;
  char *s;
  if (!PyArg_ParseTuple (args, "is", &ip, &s)) return NULL;
  i = wgapp (ip, s);
  return Py_BuildValue ("i", i);
}

static PyObject *dislin_wgbas (PyObject *self, PyObject *args)
{ int  ip, i;
  char *s;
  if (!PyArg_ParseTuple (args, "is", &ip, &s)) return NULL;
  i = wgbas (ip, s);
  return Py_BuildValue ("i", i);
}

static PyObject *dislin_wgbox (PyObject *self, PyObject *args)
{ int  ip, i, isel;
  char *s;
  if (!PyArg_ParseTuple (args, "isi", &ip, &s, &isel)) return NULL;
  i = wgbox (ip, s, isel);
  return Py_BuildValue ("i", i);
}

static PyObject *dislin_wgbut (PyObject *self, PyObject *args)
{ int  ip, i, isel;
  char *s;
  if (!PyArg_ParseTuple (args, "isi", &ip, &s, &isel)) return NULL;
  i = wgbut (ip, s, isel);
  return Py_BuildValue ("i", i);
}

static PyObject *dislin_wgcmd (PyObject *self, PyObject *args)
{ int  ip, i;
  char *s1, *s2;
  if (!PyArg_ParseTuple (args, "iss", &ip, &s1, &s2)) return NULL;
  i = wgcmd (ip, s1, s2);
  return Py_BuildValue ("i", i);
}

static PyObject *dislin_wgdraw (PyObject *self, PyObject *args)
{ int  ip, i;
  if (!PyArg_ParseTuple (args, "i", &ip)) return NULL;
  i = wgdraw (ip);
  return Py_BuildValue ("i", i);
}

static PyObject *dislin_wgfil (PyObject *self, PyObject *args)
{ int  ip, i;
  char *s1, *s2, *s3;
  if (!PyArg_ParseTuple (args, "isss", &ip, &s1, &s2, &s3)) return NULL;
  i = wgfil (ip, s1, s2, s3);
  return Py_BuildValue ("i", i);
}

static PyObject *dislin_wgfin (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  wgfin ();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_wgini (PyObject *self, PyObject *args)
{ int  n;
  char *s;
  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  n = wgini (s);
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_wglab (PyObject *self, PyObject *args)
{ int  ip, i;
  char *s;
  if (!PyArg_ParseTuple (args, "is", &ip, &s)) return NULL;
  i = wglab (ip, s);
  return Py_BuildValue ("i", i);
}

static PyObject *dislin_wglis (PyObject *self, PyObject *args)
{ int  ip, i, isel;
  char *s;
  if (!PyArg_ParseTuple (args, "isi", &ip, &s, &isel)) return NULL;
  i = wglis (ip, s, isel);
  return Py_BuildValue ("i", i);
}

static PyObject *dislin_wgdlis (PyObject *self, PyObject *args)
{ int  ip, i, isel;
  char *s;
  if (!PyArg_ParseTuple (args, "isi", &ip, &s, &isel)) return NULL;
  i = wgdlis (ip, s, isel);
  return Py_BuildValue ("i", i);
}

static PyObject *dislin_wgok (PyObject *self, PyObject *args)
{ int  ip, i;
  if (!PyArg_ParseTuple (args, "i", &ip)) return NULL;
  i = wgok (ip);
  return Py_BuildValue ("i", i);
}

static PyObject *dislin_wgpop (PyObject *self, PyObject *args)
{ int  ip, i;
  char *s;
  if (!PyArg_ParseTuple (args, "is", &ip, &s)) return NULL;
  i = wgpop (ip, s);
  return Py_BuildValue ("i", i);
}

static PyObject *dislin_wgquit (PyObject *self, PyObject *args)
{ int  ip, i;
  if (!PyArg_ParseTuple (args, "i", &ip)) return NULL;
  i = wgquit (ip);
  return Py_BuildValue ("i", i);
}

static PyObject *dislin_wgltxt (PyObject *self, PyObject *args)
{ int  ip, i, iper;
  char *s1, *s2;
  if (!PyArg_ParseTuple (args, "issi", &ip, &s1, &s2, &iper)) return NULL;
  i = wgltxt (ip, s1, s2, iper);
  return Py_BuildValue ("i", i);
}

static PyObject *dislin_wgpbut (PyObject *self, PyObject *args)
{ int  ip, i;
  char *s;
  if (!PyArg_ParseTuple (args, "is", &ip, &s)) return NULL;
  i = wgpbut (ip, s);
  return Py_BuildValue ("i", i);
}

static PyObject *dislin_wgscl (PyObject *self, PyObject *args)
{ int  ip, i, ndez;
  char *s;
  float x1, x2, xval;

  if (!PyArg_ParseTuple (args, "isfffi", &ip, &s, &x1, &x2, &xval, 
                         &ndez)) return NULL;
  i = wgscl (ip, s, x1, x2, xval, ndez);
  return Py_BuildValue ("i", i);
}

static PyObject *dislin_wgstxt (PyObject *self, PyObject *args)
{ int  ip, nsize, nmax, i;
  if (!PyArg_ParseTuple (args, "iii", &ip, &nsize, &nmax)) return NULL;
  i = wgstxt (ip, nsize, nmax);
  return Py_BuildValue ("i", i);
}

static PyObject *dislin_wgtxt (PyObject *self, PyObject *args)
{ int  ip, i;
  char *s;
  if (!PyArg_ParseTuple (args, "is", &ip, &s)) return NULL;
  i = wgtxt (ip, s);
  return Py_BuildValue ("i", i);
}

static PyObject *dislin_widbar (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "i", &n)) return NULL;
  widbar (n);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_wimage (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  wimage (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_winapp (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  winapp (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_windbr (PyObject *self, PyObject *args)
{ float xk, a;
  int nx, ny, nw;

  if (!PyArg_ParseTuple (args, "fiiif", &xk, &nx, &ny, &nw, &a)) return NULL;
  windbr (xk, nx, ny, nw, a);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_winfnt (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  winfnt (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_winkey (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  winkey (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_winmod (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  winmod (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_winopt (PyObject *self, PyObject *args)
{ char *s;
  int iopt;

  if (!PyArg_ParseTuple (args, "is", &iopt, &s)) return NULL;
  winopt (iopt, s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_window (PyObject *self, PyObject *args)
{ int nx, ny, nw, nh;

  if (!PyArg_ParseTuple (args, "iiii", &nx, &ny, &nw, &nh)) return NULL;
  window (nx, ny, nw, nh);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_winid (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  n = winid ();
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_winsiz (PyObject *self, PyObject *args)
{ int i1, i2;

  if (!PyArg_ParseTuple (args, "ii", &i1, &i2)) return NULL;
  winsiz (i1, i2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_wintit (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  wintit (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_wmfmod (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  wmfmod (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_world (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  world();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_wpixel (PyObject *self, PyObject *args)
{ int i1, i2, i3;

  if (!PyArg_ParseTuple (args, "iii", &i1, &i2, &i3)) return NULL;
  wpixel (i1, i2, i3);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_wpixls (PyObject *self, PyObject *args)
{ char *p;
  int  nl, nx, ny, nw, nh;

  if (!PyArg_ParseTuple (args, "s#iiii", &p, &nl, &nx, &ny, &nw, &nh)) 
      return NULL;
  if (nw < 1 || nh < 1) goto L1;

  wpixls ((unsigned char *) p, nx, ny, nw, nh);

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_wpxrow (PyObject *self, PyObject *args)
{ char *p;
  int  nl, nx, ny, n;

  if (!PyArg_ParseTuple (args, "s#iii", &p, &nl, &nx, &ny, &n)) return NULL;
  if (n < 1) goto L1;

  wpxrow ((unsigned char *) p, nx, ny, n);

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_writfl (PyObject *self, PyObject *args)
{ char *p;
  int nl, nu, nbyte, n = 0;

  if (!PyArg_ParseTuple (args, "is#i", &nu, &p, &nl, &nbyte)) return NULL;
  if (nbyte < 1) goto L1;

  n  = writfl (nu, (unsigned char *) p, nbyte);

 L1:
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_wtiff (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  wtiff (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_x11fnt (PyObject *self, PyObject *args)
{ char *s1, *s2;

  if (!PyArg_ParseTuple (args, "ss", &s1, &s2)) return NULL;
  x11fnt (s1, s2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_x11mod (PyObject *self, PyObject *args)
{ char *s;

  if (!PyArg_ParseTuple (args, "s", &s)) return NULL;
  x11mod (s);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_x2dpos (PyObject *self, PyObject *args)
{ float x, y, w;
  if (!PyArg_ParseTuple (args, "ff", &x, &y)) return NULL;
  w = x2dpos (x, y);
  return Py_BuildValue ("f", w);
}

static PyObject *dislin_x3dabs (PyObject *self, PyObject *args)
{ float x, y, z, w;
  if (!PyArg_ParseTuple (args, "fff", &x, &y, &z)) return NULL;
  w = x3dabs (x, y, z);
  return Py_BuildValue ("f", w);
}

static PyObject *dislin_x3dpos (PyObject *self, PyObject *args)
{ float x, y, z, w;
  if (!PyArg_ParseTuple (args, "fff", &x, &y, &z)) return NULL;
  w = x3dpos (x, y, z);
  return Py_BuildValue ("f", w);
}

static PyObject *dislin_x3drel (PyObject *self, PyObject *args)
{ float x, y, z, w;
  if (!PyArg_ParseTuple (args, "fff", &x, &y, &z)) return NULL;
  w = x3drel (x, y, z);
  return Py_BuildValue ("f", w);
}

static PyObject *dislin_xaxgit (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  xaxgit();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_xaxis (PyObject *self, PyObject *args)
{ float xa, xe, xor, xstp;
  int   nl, it, nx, ny;
  char  *s;
  if (!PyArg_ParseTuple (args, "ffffisiii", &xa, &xe, &xor, &xstp,
                         &nl, &s, &it, &nx, &ny)) return NULL;
  xaxis (xa, xe, xor, xstp, nl, s, it, nx, ny);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_xaxlg (PyObject *self, PyObject *args)
{ float xa, xe, xor, xstp;
  int   nl, it, nx, ny;
  char  *s;
  if (!PyArg_ParseTuple (args, "ffffisiii", &xa, &xe, &xor, &xstp,
                         &nl, &s, &it, &nx, &ny)) return NULL;
  xaxlg (xa, xe, xor, xstp, nl, s, it, nx, ny);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_xaxmap (PyObject *self, PyObject *args)
{ float xa, xe, xor, xstp;
  int   it, ny;
  char  *s;
  if (!PyArg_ParseTuple (args, "ffffsii", &xa, &xe, &xor, &xstp,
                         &s, &it, &ny)) return NULL;
  xaxmap (xa, xe, xor, xstp, s, it, ny);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_xcross (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  xcross();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_xdraw (PyObject *self, PyObject *args)
{ float x, y;

  if (!PyArg_ParseTuple (args, "ff", &x, &y)) return NULL;
  xdraw (x, y);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_xinvrs (PyObject *self, PyObject *args)
{ float w;
  int ix;
  if (!PyArg_ParseTuple (args, "i", &ix)) return NULL;
  w = xinvrs (ix);
  return Py_BuildValue ("f", w);
}

static PyObject *dislin_xmove (PyObject *self, PyObject *args)
{ float x, y;

  if (!PyArg_ParseTuple (args, "ff", &x, &y)) return NULL;
  xmove (x, y);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_xposn (PyObject *self, PyObject *args)
{ float x, w;
  if (!PyArg_ParseTuple (args, "f", &x)) return NULL;
  w = xposn (x);
  return Py_BuildValue ("f", w);
}

static PyObject *dislin_y2dpos (PyObject *self, PyObject *args)
{ float x, y, w;
  if (!PyArg_ParseTuple (args, "ff", &x, &y)) return NULL;
  w = y2dpos (x, y);
  return Py_BuildValue ("f", w);
}

static PyObject *dislin_y3dabs (PyObject *self, PyObject *args)
{ float x, y, z, w;
  if (!PyArg_ParseTuple (args, "fff", &x, &y, &z)) return NULL;
  w = y3dabs (x, y, z);
  return Py_BuildValue ("f", w);
}

static PyObject *dislin_y3dpos (PyObject *self, PyObject *args)
{ float x, y, z, w;
  if (!PyArg_ParseTuple (args, "fff", &x, &y, &z)) return NULL;
  w = y3dpos (x, y, z);
  return Py_BuildValue ("f", w);
}

static PyObject *dislin_y3drel (PyObject *self, PyObject *args)
{ float x, y, z, w;
  if (!PyArg_ParseTuple (args, "fff", &x, &y, &z)) return NULL;
  w = y3drel (x, y, z);
  return Py_BuildValue ("f", w);
}

static PyObject *dislin_yaxgit (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  yaxgit();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_yaxis (PyObject *self, PyObject *args)
{ float xa, xe, xor, xstp;
  int   nl, it, nx, ny;
  char  *s;
  if (!PyArg_ParseTuple (args, "ffffisiii", &xa, &xe, &xor, &xstp,
                         &nl, &s, &it, &nx, &ny)) return NULL;
  yaxis (xa, xe, xor, xstp, nl, s, it, nx, ny);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_yaxlg (PyObject *self, PyObject *args)
{ float xa, xe, xor, xstp;
  int   nl, it, nx, ny;
  char  *s;
  if (!PyArg_ParseTuple (args, "ffffisiii", &xa, &xe, &xor, &xstp,
                         &nl, &s, &it, &nx, &ny)) return NULL;
  yaxlg (xa, xe, xor, xstp, nl, s, it, nx, ny);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_yaxmap (PyObject *self, PyObject *args)
{ float xa, xe, xor, xstp;
  int   it, ny;
  char  *s;
  if (!PyArg_ParseTuple (args, "ffffsii", &xa, &xe, &xor, &xstp,
                         &s, &it, &ny)) return NULL;
  yaxmap (xa, xe, xor, xstp, s, it, ny);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_ycross (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;
  ycross();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_yinvrs (PyObject *self, PyObject *args)
{ float w;
  int ix;
  if (!PyArg_ParseTuple (args, "i", &ix)) return NULL;
  w = yinvrs (ix);
  return Py_BuildValue ("f", w);
}

static PyObject *dislin_yposn (PyObject *self, PyObject *args)
{ float x, w;
  if (!PyArg_ParseTuple (args, "f", &x)) return NULL;
  w = yposn (x);
  return Py_BuildValue ("f", w);
}

static PyObject *dislin_z3dpos (PyObject *self, PyObject *args)
{ float x, y, z, w;
  if (!PyArg_ParseTuple (args, "fff", &x, &y, &z)) return NULL;
  w = z3dpos (x, y, z);
  return Py_BuildValue ("f", w);
}

static PyObject *dislin_zaxis (PyObject *self, PyObject *args)
{ float xa, xe, xor, xstp;
  int   nl, it, id, nx, ny;
  char  *s;
  if (!PyArg_ParseTuple (args, "ffffisiiii", &xa, &xe, &xor, &xstp,
                         &nl, &s, &it, &id, &nx, &ny)) return NULL;
  zaxis (xa, xe, xor, xstp, nl, s, it, id, nx, ny);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_zaxlg (PyObject *self, PyObject *args)
{ float xa, xe, xor, xstp;
  int   nl, it, id, nx, ny;
  char  *s;
  if (!PyArg_ParseTuple (args, "ffffisiiii", &xa, &xe, &xor, &xstp,
                         &nl, &s, &it, &id, &nx, &ny)) return NULL;
  zaxlg (xa, xe, xor, xstp, nl, s, it, id, nx, ny);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_zbffin (PyObject *self, PyObject *args)
{ if (!PyArg_ParseTuple (args, "")) return NULL;

  zbffin();
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_zbfini (PyObject *self, PyObject *args)
{ int n;

  if (!PyArg_ParseTuple (args, "")) return NULL;
  n = zbfini ();
  return Py_BuildValue ("i", n);
}

static PyObject *dislin_zbflin (PyObject *self, PyObject *args)
{ float x1, y1, z1, x2, y2, z2;

  if (!PyArg_ParseTuple (args, "ffffff", 
      &x1, &y1, &z1, &x2, &y2, &z2)) return NULL;
  zbflin (x1, y1, z1, x2, y2, z2);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_zbftri (PyObject *self, PyObject *args)
{ PyObject *o1, *o2, *o3, *o4;
  float *p1, *p2, *p3;
  int  i1, i2, i3, i4, *p4;

  if (!PyArg_ParseTuple (args, "OOOO", &o1, &o2, &o3, &o4)) return NULL;

  i1 = fltarray (&o1, &p1, 3);
  i2 = fltarray (&o2, &p2, 3);
  i3 = fltarray (&o3, &p3, 3);
  i4 = intarray (&o4, &p4, 3);

  if (i1 != 0 && i2 != 0 && i3 != 0 && i4 != 0) 
      zbftri (p1, p2, p3, p4);
  
  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i3 == 1) free (p3);
  if (i4 == 1) free (p4);
  if (i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0) return NULL;

L1:

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_zscale (PyObject *self, PyObject *args)
{ float x, y;

  if (!PyArg_ParseTuple (args, "ff", &x, &y)) return NULL;
  zscale (x, y);
  Py_INCREF (Py_None);
  return Py_None;
}

/* >>>>>>>>>> QQSETVAR <<<<<<<<<< */
int qqsetvar (int ivar)
{ int i, j, i1 = 0, iv, n, ix, iy, iz;
  float x;
  char *p;

  if (getlev() == 0) return 0;
  
  if (ivar == -1)
  { i1 = 0;
    n = NSYSV;
  }
  else
  { i1 = ivar;
    n  = ivar + 1;
  }  

  for (i = i1; i < n; i++)
  { if (sysv[i].flag == F_UNDEF) continue;
    j = sysv[i].type;
    
    if (j == V_STRING)
      p  = sysv[i].value.s;
    else if (j == V_INT)
      iv = sysv[i].value.i;  
    else if (j == V_FLOAT)
      x  = sysv[i].value.f;  
    
    switch (i)
    { case X_SYSV:  
        name (p, "x");
        break;
      case Y_SYSV:  
        name (p, "y");
        break;
      case Z_SYSV:  
        name (p, "z");
        break;
      case T1_SYSV:  
        titlin (p, 1);
        break;
      case T2_SYSV:  
        titlin (p, 2);
        break;
      case T3_SYSV:  
        titlin (p, 3);
        break;
      case T4_SYSV:  
        titlin (p, 4);
        break;
      case POLCRV_SYSV:
        polcrv (p);
        break;
      case XTIC_SYSV:
        ticks (iv, "x");
        break;
      case YTIC_SYSV:
        ticks (iv, "y");
        break;
      case ZTIC_SYSV:
        ticks (iv, "z");
        break;
      case XDIG_SYSV:
        digits (iv, "x");
        break;
      case YDIG_SYSV:
        digits (iv, "y");
        break;
      case ZDIG_SYSV:
        digits (iv, "z");
        break;
      case XSCL_SYSV:
        scale (p, "x");
        break;
      case YSCL_SYSV:
        scale (p, "y");
        break;
      case ZSCL_SYSV:
        scale (p, "z");
        break;
      case XLAB_SYSV:
        labels (p, "x");
        break;
      case YLAB_SYSV:
        labels (p, "y");
        break;
      case ZLAB_SYSV:
        labels (p, "z");
        break;
      case HTITLE_SYSV:
        htitle (iv);
        break;
      case HNAME_SYSV:
        hname (iv);
        break;
      case HSYMBL_SYSV:
        hsymbl (iv);
        break;
      case H_SYSV:  
        height (iv);
        break;
      case MARKER_SYSV:
        marker (iv);
        break;
      case XLEN_SYSV:
        getlen (&ix, &iy, &iz);
        axslen (iv, iy);
        break;
      case YLEN_SYSV:
        getlen (&ix, &iy, &iz);
        axslen (ix, iv);
        break;
      case ZLEN_SYSV:
        getlen (&ix, &iy, &iz);
        ax3len (ix, iy, iv);
        break;
      case XPOS_SYSV:
        getpos (&ix, &iy);
        axspos (iv, iy);
        break;
      case YPOS_SYSV:
        getpos (&ix, &iy);
        axspos (ix, iv);
        break;
      case XRES_SYSV:
        getres (&ix, &iy);
        setres (iv, iy);
        break;
      case YRES_SYSV:
        getres (&ix, &iy);
        setres (ix, iv);
        break;
      case INCMRK_SYSV:
        incmrk (iv);
        break;
      case X3LEN_SYSV:
        axis3d (x, y3len, z3len);
        if (x > 0.) x3len = x;
        break;
      case Y3LEN_SYSV:
        axis3d (x3len, x, z3len);
        if (x > 0.) y3len = x;
        break;
      case Z3LEN_SYSV:
        axis3d (x3len, y3len, x);
        if (x > 0.) z3len = x;
        break;
      case X3VIEW_SYSV:
        view3d (x, y3view, z3view, "ABS");
        x3view = x;
        break;
      case Y3VIEW_SYSV:
        view3d (x3view, x, z3view, "ABS");
        y3view = x;
        break;
      case Z3VIEW_SYSV:
        view3d (x3view, y3view, x, "ABS");
        z3view = x;
        break;
      case VTITLE_SYSV:
        vkytit (iv);
        break;
      case CONSHD_SYSV:
        shdmod (p, "CONTOUR");
        break;
    }
  }
  return 0;
}

static PyObject *dislin_plot (PyObject *self, PyObject *args)
{ return qqplot (self, args, 1);
}

static PyObject *dislin_scattr (PyObject *self, PyObject *args)
{ return qqplot (self, args, 0);
}

static PyObject *qqplot (PyObject *self, PyObject *args, int iopt)
{ PyObject *o1, *o2;
  float *p1, *p2, xa[4], ya[4], x[2], y[2];
  int  i, n1, n2, i1, i2;

  if (!PyArg_ParseTuple (args, "OO", &o1, &o2)) return NULL;

  if ((n1 = getlength (o1)) < 0) return NULL;
  if ((n2 = getlength (o2)) < 0) return NULL;

  if (n1 != n2)
  { PyErr_SetString (PyExc_ValueError, "mismatch of array sizes");
    return NULL;
  }

  i1 = fltarray (&o1, &p1, n1);
  i2 = fltarray (&o2, &p2, n2);
  if (i1 == 0 || i2 == 0) goto L1;

  if (getlev() == 0)
  { if (g_imetfl == 0) metafl("xwin");
    lsechk("off");
    disini ();
    complx ();
    nochek ();
  }
  else
  { i = check_var ("ERASE");
    if (i == -1)
      erase ();
    else if (sysv[i].value.i == 1)
      erase ();

    reset ("setscl");
  }

  if (getlev() >= 2) endgrf();
  pagera ();
  if (iopt == 1)
    incmrk (0);
  else
  { incmrk (-1);
    marker (3);
    hsymbl (10);
  }

  qqsetvar (-1);

  get_scale (p1, n1, x);
  get_scale (p2, n2, y);
  set_scaling (x, 1, xa);
  set_scaling (y, 2, ya);

  graf (xa[0], xa[1], xa[2], xa[3], ya[0], ya[1], ya[2], ya[3]);
  title ();
  curve (p1, p2, n1);
  sendbf ();
  
L1:  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i1 == 0 || i2 == 0) return NULL;

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_plot3 (PyObject *self, PyObject *args)
{ PyObject *o1, *o2, *o3;
  float *p1, *p2, *p3, xa[4], ya[4], za[4], x[2], y[2], z[2];
  int  i, n1, n2, n3, i1, i2, i3;

  if (!PyArg_ParseTuple (args, "OOO", &o1, &o2, &o3)) return NULL;

  if ((n1 = getlength (o1)) < 0) return NULL;
  if ((n2 = getlength (o2)) < 0) return NULL;
  if ((n3 = getlength (o3)) < 0) return NULL;

  if (n1 != n2 || n1 != n3)
  { PyErr_SetString (PyExc_ValueError, "mismatch of array sizes");
    return NULL;
  }

  i1 = fltarray (&o1, &p1, n1);
  i2 = fltarray (&o2, &p2, n2);
  i3 = fltarray (&o3, &p3, n3);
  if (i1 == 0 || i2 == 0 || i3 ==0) goto L1;

  if (getlev() == 0)
  { if (g_imetfl == 0) metafl("xwin");
    lsechk("off");
    disini ();
    complx ();
    nochek ();
  }
  else
  { i = check_var ("ERASE");
    if (i == -1)
      erase ();
    else if (sysv[i].value.i == 1)
      erase ();

    reset ("setscl");
  }

  if (getlev() >= 2) endgrf();
  pagera ();
  qqsetvar (-1);

  get_scale (p1, n1, x);
  get_scale (p2, n2, y);
  get_scale (p3, n3, z);
  set_scaling (x, 1, xa);
  set_scaling (y, 2, ya);
  set_scaling (z, 3, za);

  graf3 (xa[0], xa[1], xa[2], xa[3], ya[0], ya[1], ya[2], ya[3],
         za[0], za[1], za[2], za[3]);
  title ();
  curve3 (p1, p2, p3, n1);
  sendbf ();
  
L1:  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i3 == 1) free (p3);
  if (i1 == 0 || i2 == 0 || i3 == 0) return NULL;

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_surf3 (PyObject *self, PyObject *args)
{
  return qqsurface (self, args, 0);
}

static PyObject *dislin_surface (PyObject *self, PyObject *args)
{
  return qqsurface (self, args, 1);
}

static PyObject *dislin_surshade (PyObject *self, PyObject *args)
{
  return qqsurface (self, args, 2);
}

static PyObject *qqsurface (PyObject *self, PyObject *args, int iopt)
{ PyObject *o1, *o2, *o3;
  float *p1, *p2, *p3, xa[4], ya[4], za[4], x[2], y[2], z[2], xsft = 0.;
  int  i, k, ii, nx, ny, n2, n3, i1, i2 = 0, i3 = 0, ncold, nph, npb,
       ierr = 1;

  if (!PyArg_ParseTuple (args, "OOO", &o1, &o2, &o3)) return NULL;
  if ((nx = getlength (o2)) < 0) return NULL;
  if ((ny = getlength (o3)) < 0) return NULL;

  i2 = fltarray (&o2, &p2, nx);
  i3 = fltarray (&o3, &p3, ny);
  if (i2 == 0 || i3 == 0) goto L1;

  i1 = fltmatrix (&o1, &p1, nx, ny);
  if (i1 == 0) goto L1;

  if (iopt == 0) xsft = 0.5;

  if (getlev() == 0)
  { if (g_imetfl == 0) metafl("xwin");
    lsechk("off");
    disini ();
    complx ();
    nochek ();
  }
  else
  { i = check_var ("ERASE");
    if (i == -1)
      erase ();
    else if (sysv[i].value.i == 1)
      erase ();

    reset ("setscl");
  }

  if (getlev() >= 2) endgrf();
  pagera ();
  qqsetvar (-1);

  get_scale (p2, nx, x);
  get_scale (p3, ny, y);
  get_scale (p1, nx*ny, z);

  set_scaling (x, 1, xa);
  set_scaling (y, 2, ya);
  set_scaling (z, 3, za);

  if (iopt == 0)
  { graf3 (xa[0], xa[1], xa[2], xa[3], ya[0], ya[1], ya[2], ya[3],
         za[0], za[1], za[2], za[3]);
    title ();

    ncold = getclr ();
    sclpax (0);

    for (i = 0; i < nx; i++)
    { if (i != (nx - 1))
        npb = nxposn (p2[i+1]) - nxposn (p2[i]);
      else
        npb = nxposn (p2[i]) - nxposn (p2[i-1]);
      npb = (npb < 0) ? -npb : npb;
      npb++;

      ii = i * ny;
      for (k = 0; k < ny; k++)
      { if (k != (ny - 1))
          nph = nyposn (p3[k+1]) - nyposn (p3[k]);
        else
          nph = nyposn (p3[k]) - nyposn (p3[k-1]);
        nph = (nph < 0) ? -nph : nph;
        nph++;

        rpoint (p2[i], p3[k], p1[ii+k], npb, nph);
      }
    } 
    sclpax (1);
    setclr (ncold);
  }
  else
  { noclip ();
    graf3d (xa[0], xa[1], xa[2], xa[3], ya[0], ya[1], ya[2], ya[3],
            za[0], za[1], za[2], za[3]);
    title ();
    if (iopt == 1)
      surfce (p2, nx, p3, ny, p1);
    else
      surshd (p2, nx, p3, ny, p1);
    reset ("noclip");
  }

  sendbf ();
  ierr = 0;  

L1:  

  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i3 == 1) free (p3);
  if (ierr == 1) return NULL;

  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject *dislin_contour (PyObject *self, PyObject *args)
{
  return qqcontour (self, args, 0);
}

static PyObject *dislin_conshade (PyObject *self, PyObject *args)
{
  return qqcontour (self, args, 1);
}

static PyObject *qqcontour (PyObject *self, PyObject *args, int iopt)
{ PyObject *o1, *o2, *o3, *o4;
  float *p1, *p2, *p3, *p4, xa[4], ya[4], za[4], x[2], y[2], z[2];
  int  i, nx, ny, n2, n3, n4, i1, i2 = 0, i3 = 0, ip, i4 = 0, ierr = 1,
       nhold;

  ip = 3;
  o4 = NULL;

  if (!PyArg_ParseTuple (args, "OOO|O", &o1, &o2, &o3, &o4)) return NULL;
  if (o4 != NULL) ip++;

  if ((nx = getlength (o2)) < 0) return NULL;
  if ((ny = getlength (o3)) < 0) return NULL;

  i2 = fltarray (&o2, &p2, nx);
  i3 = fltarray (&o3, &p3, ny);
  if (i2 == 0 || i3 == 0) goto L1;

  i1 = fltmatrix (&o1, &p1, nx, ny);
  if (i1 == 0) goto L1;

  if (ip == 3)
  { p4 = (float *) calloc (10, 4);
    if (p4 == NULL)
    { PyErr_SetString (PyExc_MemoryError, "out of memory");
      goto L1;
    }
    i4 = 1;
    n4 = 10;
  }
  else if (ip == 4)
  { if ((n4 = getlength (o4)) < 0) return NULL;
    i4 = fltarray (&o4, &p4, n4);
    if (i4 == 0) goto L1;
  }

  if (getlev() == 0)
  { if (g_imetfl == 0) metafl("xwin");
    lsechk("off");
    disini ();
    complx ();
    nochek ();
  }
  else
  { i = check_var ("ERASE");
    if (i == -1)
      erase ();
    else if (sysv[i].value.i == 1)
      erase ();

    reset ("setscl");
  }

  if (getlev() >= 2) endgrf();
  pagera ();
  labels ("float", "contour");
  qqsetvar (-1);

  get_scale (p2, nx, x);
  get_scale (p3, ny, y);
  get_scale (p1, nx*ny, z);

  if (ip == 3)
  { for (i = 0; i < n4; i++)
      p4[i] = z[0] + i * (z[1] - z[0]) / (n4 - 1);
  }

  set_scaling (x, 1, xa);
  set_scaling (y, 2, ya);

  graf (xa[0], xa[1], xa[2], xa[3], ya[0], ya[1], ya[2], ya[3]);
  title ();
  if (iopt == 0)
  { nhold = gethgt ();
    height (25);
    for (i = 0; i < n4; i++)
      contur (p2, nx, p3, ny, p1, p4[i]);
    height (nhold);
  }
  else
    conshd (p2, nx, p3, ny, p1, p4, n4);

  sendbf ();
  ierr = 0;
  
L1:  

  if (i1 == 1) free (p1);
  if (i2 == 1) free (p2);
  if (i3 == 1) free (p3);
  if (i4 == 1) free (p4);
  if (ierr == 1) return NULL;

  Py_INCREF (Py_None);
  return Py_None;
}

void get_scale (float *p, int n, float *x)
{ int i;

  x[0] = p[0];
  x[1] = p[0];

  for (i = 1; i < n; i++)
  { if (p[i] < x[0]) x[0] = p[i];
    if (p[i] > x[1]) x[1] = p[i];
  }
}

/* >>>>>>>>>> SET_SCALING <<<<<<<<<< */
void set_scaling (float *x, int iax, float *xa)
{ int i, iray[4], iscl[3];
  static char *cray[4] = {"XMIN", "XMAX", "XOR", "XSTEP"},
              cauto[]  = "XAUTO",
              *cax[3]  = {"X", "Y", "Z"};
  char s[10];

  iax--;
  cauto[0] = 'X' + iax;       
  if ((i = check_var (cauto)) >= 0)
  { if (sysv[i].value.i != 0)
    { setscl (x, 2, cax[iax]);
      return;
    }
  }

  getscl (&iscl[0], &iscl[1], &iscl[2]);
  for (i = 0; i < 4; i++)
  { strcpy (s, cray[i]);
    s[0] = 'X' + iax;
    iray[i]  = check_var (s);
  }  

  if (iray[0] == -1 || iray[1] == -1)
    setscl (x, 2, cax[iax]);
  else if (iray[2] == -1 || iray[3] == -1)       
  { if (iscl[iax] == 1)
    { x[0] = (float) pow (10., (double) sysv[iray[0]].value.f);
      x[1] = (float) pow (10., (double) sysv[iray[1]].value.f);
    }
    else
    { x[0] = sysv[iray[0]].value.f;
      x[1] = sysv[iray[1]].value.f;
    }
    setscl (x, 2, cax[iax]);
  }
  else
  { xa[0] = sysv[iray[0]].value.f;
    xa[1] = sysv[iray[1]].value.f;
    xa[2] = sysv[iray[2]].value.f;
    xa[3] = sysv[iray[3]].value.f;
  }
  return;
}

int check_var (char *s)
{ int i;

  for (i = 0; i < NSYSV; i++)
  { if (strcmp (sysv[i].name,s ) == 0)
    { if (sysv[i].flag == F_DEF) 
        return i;
      else
        return -1;
    }
  }
  return -1;
}
    
static PyObject *dislin_setvar (PyObject *self, PyObject *args)
{ PyObject *o1;
  char *s;
  float xval;
  char *sval;
  int  ival, i, idx, itype;

  if (!PyArg_ParseTuple (args, "sO", &s, &o1)) return NULL;

  idx = -1;
  upstr (s);

  for (i = 0; i < NSYSV; i++)
  {  if (strcmp (sysv[i].name, s) == 0)
     { idx = i;
       itype = sysv[i].type;
       break;
     }
  }

  if (idx == -1)
  { PyErr_SetString (PyExc_ValueError, "undefined variable");
    return NULL;
  }

  if (itype == V_INT)
  { if (!PyArg_ParseTuple (args, "si", &s, &ival)) return NULL;
    sysv[idx].value.i = ival;
  }  
  else if (itype == V_FLOAT)
  { if (!PyArg_ParseTuple (args, "sf", &s, &xval)) return NULL;
    sysv[idx].value.f = xval;
  }
  else
  { if (!PyArg_ParseTuple (args, "ss", &s, &sval)) return NULL;
    if (sysv[idx].flag == F_DEF)
    { free (sysv[idx].value.s);
      sysv[idx].flag = F_UNDEF;
    }
    i = strlen (sval);
    if ((sysv[idx].value.s = (char *) malloc (i+1)) == NULL)
    { PyErr_SetString (PyExc_MemoryError, "no memory in SETVAR");
      return NULL;
    }
    strcpy (sysv[idx].value.s, sval);
  }

  sysv[idx].flag = F_DEF;
  qqsetvar (idx);

  Py_INCREF (Py_None);
  return Py_None;
}

static PyMethodDef DislinMethods[] = {
  { "abs3pt", dislin_abs3pt, 1 },
  { "addlab", dislin_addlab, 1 },
  { "angle",  dislin_angle,  1 },
  { "arcell", dislin_arcell, 1 },
  { "areaf",  dislin_areaf,  1 },
  { "autres", dislin_autres, 1 },
  { "ax2grf", dislin_ax2grf, 1 },
  { "ax3len", dislin_ax3len, 1 },
  { "axclrs", dislin_axclrs, 1 },
  { "axends", dislin_axends, 1 },
  { "axgit",  dislin_axgit,  1 },
  { "axis3d", dislin_axis3d, 1 },
  { "axsbgd", dislin_axsbgd, 1 },
  { "axslen", dislin_axslen, 1 },
  { "axsorg", dislin_axsorg, 1 },
  { "axspos", dislin_axspos, 1 },
  { "axsscl", dislin_axsscl, 1 },
  { "axstyp", dislin_axstyp, 1 },
  { "barbor", dislin_barbor, 1 },
  { "barclr", dislin_barclr, 1 },
  { "bargrp", dislin_bargrp, 1 },
  { "barmod", dislin_barmod, 1 },
  { "baropt", dislin_baropt, 1 },
  { "barpos", dislin_barpos, 1 },
  { "bars",   dislin_bars,   1 },
  { "bars3d", dislin_bars3d, 1 },
  { "bartyp", dislin_bartyp, 1 },
  { "barwth", dislin_barwth, 1 },
  { "basalf", dislin_basalf, 1 },
  { "basdat", dislin_basdat, 1 },
  { "bezier", dislin_bezier, 1 }, 
  { "bitsi2", dislin_bitsi2, 1 },
  { "bitsi4", dislin_bitsi4, 1 },
  { "box2d",  dislin_box2d,  1 },
  { "bmpfnt", dislin_bmpfnt, 1 },
  { "box3d",  dislin_box3d,  1 },
  { "center", dislin_center, 1 },
  { "cgmbgd", dislin_cgmbgd, 1 },
  { "cgmpic", dislin_cgmpic, 1 },
  { "cgmver", dislin_cgmver, 1 },
  { "chaang", dislin_chaang, 1 },
  { "chacod", dislin_chacod, 1 },
  { "chaspc", dislin_chaspc, 1 },
  { "chawth", dislin_chawth, 1 },
  { "chnatt", dislin_chnatt, 1 },
  { "chncrv", dislin_chncrv, 1 },
  { "chndot", dislin_chndot, 1 },
  { "chndsh", dislin_chndsh, 1 },
  { "chnbar", dislin_chnbar, 1 },
  { "chnpie", dislin_chnpie, 1 },
  { "circ3p", dislin_circ3p, 1 },
  { "circle", dislin_circle, 1 },
  { "circsp", dislin_circsp, 1 },
  { "clip3d", dislin_clip3d, 1 },
  { "closfl", dislin_closfl, 1 },
  { "clpbor", dislin_clpbor, 1 },
  { "clpmod", dislin_clpmod, 1 },
  { "clpwin", dislin_clpwin, 1 },
  { "clrcyc", dislin_clrcyc, 1 },
  { "clrmod", dislin_clrmod, 1 },
  { "clswin", dislin_clswin, 1 },
  { "color",  dislin_color,  1 },
  { "colran", dislin_colran, 1 },
  { "colray", dislin_colray, 1 },
  { "complx", dislin_complx, 1 },
  { "conclr", dislin_conclr, 1 },
  { "concrv", dislin_concrv, 1 },
  { "confll", dislin_confll, 1 },
  { "congap", dislin_congap, 1 },
  { "conlab", dislin_conlab, 1 },
  { "conmat", dislin_conmat, 1 },
  { "conmod", dislin_conmod, 1 },
  { "conn3d", dislin_conn3d, 1 },
  { "connpt", dislin_connpt, 1 },
  { "conpts", dislin_conpts, 1 }, 
  { "conshd", dislin_conshd, 1 },
  { "contri", dislin_contri, 1 },
  { "contur", dislin_contur, 1 },
  { "cross",  dislin_cross,  1 },
  { "crvmat", dislin_crvmat, 1 },
  { "crvtri", dislin_crvtri, 1 },
  { "csrmod", dislin_csrmod, 1 },
  { "csrmov", dislin_csrmov, 1 },
  { "csrpos", dislin_csrpos, 1 },
  { "csrpt1", dislin_csrpt1, 1 },
  { "csrpts", dislin_csrpts, 1 },
  { "csrtyp", dislin_csrtyp, 1 },
  { "csruni", dislin_csruni, 1 },
  { "curv3d", dislin_curv3d, 1 },
  { "curve",  dislin_curve,  1 },
  { "curve3", dislin_curve3, 1 },
  { "curvmp", dislin_curvmp, 1 },
  { "curvx3", dislin_curvx3, 1 },
  { "curvy3", dislin_curvy3, 1 },
  { "dash",   dislin_dash,   1 },
  { "dashl",  dislin_dashl,  1 },
  { "dashm",  dislin_dashm,  1 },
  { "dattim", dislin_dattim, 1 },
  { "delglb", dislin_delglb, 1 },
  { "digits", dislin_digits, 1 },
  { "disalf", dislin_disalf, 1 },
  { "disfin", dislin_disfin, 1 },
  { "disini", dislin_disini, 1 },
  { "dot",    dislin_dot,    1 },
  { "dotl",   dislin_dotl,   1 },
  { "duplx",  dislin_duplx,  1 },
  { "dwgbut", dislin_dwgbut, 1 },
  { "dwgfil", dislin_dwgfil, 1 },
  { "dwglis", dislin_dwglis, 1 },
  { "dwgmsg", dislin_dwgmsg, 1 },
  { "dwgtxt", dislin_dwgtxt, 1 },
  { "ellips", dislin_ellips, 1 },
  { "endgrf", dislin_endgrf, 1 },
  { "erase",  dislin_erase,  1 },
  { "errbar", dislin_errbar, 1 },
  { "errdev", dislin_errdev, 1 },
  { "errfil", dislin_errfil, 1 },
  { "errmod", dislin_errmod, 1 },
  { "eushft", dislin_eushft, 1 },
  { "expzlb", dislin_expzlb, 1 },
  { "fcha",   dislin_fcha,   1 },
  { "field",  dislin_field, 1 },
  { "filbox", dislin_filbox, 1 },
  { "filclr", dislin_filclr, 1 },
  { "filmod", dislin_filmod, 1 },
  { "fixspc", dislin_fixspc, 1 },
  { "flab3d", dislin_flab3d, 1 },
  { "flen",   dislin_flen,   1 },
  { "frmclr", dislin_frmclr, 1 },
  { "frame",  dislin_frame,  1 },
  { "frmess", dislin_frmess, 1 },
  { "gapcrv", dislin_gapcrv, 1 },
  { "getalf", dislin_getalf, 1 },
  { "getang", dislin_getang, 1 },
  { "getbpp", dislin_getbpp, 1 },
  { "getclr", dislin_getclr, 1 },
  { "getclp", dislin_getclp, 1 },
  { "getdig", dislin_getdig, 1 },
  { "getdsp", dislin_getdsp, 1 },
  { "getfil", dislin_getfil, 1 },
  { "getgrf", dislin_getgrf, 1 },
  { "gethgt", dislin_gethgt, 1 },
  { "gethnm", dislin_gethnm, 1 },
  { "getind", dislin_getind, 1 },
  { "getlab", dislin_getlab, 1 },
  { "getlen", dislin_getlen, 1 },
  { "getlev", dislin_getlev, 1 },
  { "getlin", dislin_getlin, 1 },
  { "getlit", dislin_getlit, 1 },
  { "getmat", dislin_getmat, 1 },
  { "getmfl", dislin_getmfl, 1 },
  { "getmix", dislin_getmix, 1 },
  { "getor",  dislin_getor,  1 },
  { "getpag", dislin_getpag, 1 },
  { "getpat", dislin_getpat, 1 },
  { "getpos", dislin_getpos, 1 },
  { "getran", dislin_getran, 1 },
  { "getres", dislin_getres, 1 },
  { "getrgb", dislin_getrgb, 1 },
  { "getscl", dislin_getscl, 1 },
  { "getscr", dislin_getscr, 1 },
  { "getshf", dislin_getshf, 1 },
  { "getsp1", dislin_getsp1, 1 },
  { "getsp2", dislin_getsp2, 1 },
  { "getsym", dislin_getsym, 1 },
  { "gettcl", dislin_gettcl, 1 },
  { "gettic", dislin_gettic, 1 },
  { "gettyp", dislin_gettyp, 1 },
  { "getuni", dislin_getuni, 1 },
  { "getver", dislin_getver, 1 },
  { "getvk",  dislin_getvk,  1 },
  { "getvlt", dislin_getvlt, 1 },
  { "getwid", dislin_getwid, 1 },
  { "getwin", dislin_getwin, 1 },
  { "getxid", dislin_getxid, 1 },
  { "gifmod", dislin_gifmod, 1 },
  { "gmxalf", dislin_gmxalf, 1 },
  { "gothic", dislin_gothic, 1 },
  { "grace",  dislin_grace,  1 },
  { "graf",   dislin_graf,   1 },
  { "graf3",  dislin_graf3,  1 },
  { "graf3d", dislin_graf3d, 1 },
  { "grafmp", dislin_grafmp, 1 },
  { "grffin", dislin_grffin, 1 },
  { "grfini", dislin_grfini, 1 },
  { "grdpol", dislin_grdpol, 1 },
  { "grid",   dislin_grid,   1 },
  { "grid3d", dislin_grid3d, 1 },
  { "gridmp", dislin_gridmp, 1 },
  { "gwgatt", dislin_gwgatt, 1 },
  { "gwgbox", dislin_gwgbox, 1 },
  { "gwgbut", dislin_gwgbut, 1 },
  { "gwgfil", dislin_gwgfil, 1 },
  { "gwglis", dislin_gwglis, 1 },
  { "gwgscl", dislin_gwgscl, 1 },
  { "gwgtxt", dislin_gwgtxt, 1 },
  { "gwgxid", dislin_gwgxid, 1 },
  { "height", dislin_height, 1 },
  { "helve",  dislin_helve,  1 },
  { "helves", dislin_helves, 1 },
  { "histog", dislin_histog, 1 },
  { "hname",  dislin_hname,  1 },
  { "hsvrgb", dislin_hsvrgb, 1 },
  { "hsymbl", dislin_hsymbl, 1 },
  { "htitle", dislin_htitle, 1 },
  { "hwfont", dislin_hwfont, 1 },
  { "hworig", dislin_hworig, 1 },
  { "hwpage", dislin_hwpage, 1 },
  { "imgbox", dislin_imgbox, 1 },
  { "imgclp", dislin_imgclp, 1 },
  { "imgfin", dislin_imgfin, 1 },
  { "imgfmt", dislin_imgfmt, 1 },
  { "imgini", dislin_imgini, 1 },
  { "imgmod", dislin_imgmod, 1 },
  { "imgsiz", dislin_imgsiz, 1 },
  { "inccrv", dislin_inccrv, 1 },
  { "incdat", dislin_incdat, 1 },
  { "incfil", dislin_incfil, 1 },
  { "incmrk", dislin_incmrk, 1 },
  { "indrgb", dislin_indrgb, 1 },
  { "intax",  dislin_intax,  1 },
  { "intcha", dislin_intcha, 1 },
  { "intlen", dislin_intlen, 1 },
  { "intrgb", dislin_intrgb, 1 },
  { "itmcat", dislin_itmcat, 1 },
  { "itmcnt", dislin_itmcnt, 1 },
  { "itmstr", dislin_itmstr, 1 },
  { "labclr", dislin_labclr, 1 },
  { "labdig", dislin_labdig, 1 },
  { "labdis", dislin_labdis, 1 },
  { "labels", dislin_labels, 1 },
  { "labjus", dislin_labjus, 1 },
  { "labl3d", dislin_labl3d, 1 },
  { "labmod", dislin_labmod, 1 },
  { "labpos", dislin_labpos, 1 },
  { "labtyp", dislin_labtyp, 1 },
  { "legclr", dislin_legclr, 1 },
  { "legend", dislin_legend, 1 },
  { "legini", dislin_legini, 1 },
  { "leglin", dislin_leglin, 1 },
  { "legopt", dislin_legopt, 1 },
  { "legpat", dislin_legpat, 1 },
  { "legpos", dislin_legpos, 1 },
  { "legtit", dislin_legtit, 1 },
  { "lfttit", dislin_lfttit, 1 },
  { "light",  dislin_light,  1 },
  { "lincyc", dislin_lincyc, 1 },
  { "line",   dislin_line,   1 },
  { "linesp", dislin_linesp, 1 },
  { "lintyp", dislin_lintyp, 1 },
  { "linwid", dislin_linwid, 1 },
  { "litmod", dislin_litmod, 1 },
  { "litop3", dislin_litop3, 1 },
  { "litopt", dislin_litopt, 1 },
  { "litpos", dislin_litpos, 1 },
  { "lncap",  dislin_lncap,  1 },
  { "lnjoin", dislin_lnjoin, 1 },
  { "lnmlt",  dislin_lnmlt,  1 },
  { "logtic", dislin_logtic, 1 },
  { "mapbas", dislin_mapbas, 1 },
  { "mapfil", dislin_mapfil, 1 },
  { "maplev", dislin_maplev, 1 },
  { "mapmod", dislin_mapmod, 1 },
  { "mappol", dislin_mappol, 1 },
  { "mapref", dislin_mapref, 1 },
  { "mapsph", dislin_mapsph, 1 },
  { "marker", dislin_marker, 1 },
  { "matop3", dislin_matop3, 1 },
  { "matopt", dislin_matopt, 1 },
  { "mdfmat", dislin_mdfmat, 1 },
  { "messag", dislin_messag, 1 },
  { "metafl", dislin_metafl, 1 },
  { "mixalf", dislin_mixalf, 1 },
  { "mixleg", dislin_mixleg, 1 },
  { "moment", dislin_moment, 1 },
  { "mpaepl", dislin_mpaepl, 1 },
  { "mplang", dislin_mplang, 1 },
  { "mplclr", dislin_mplclr, 1 },
  { "mplpos", dislin_mplpos, 1 },
  { "mplsiz", dislin_mplsiz, 1 },
  { "mpslogo",dislin_mpslogo,1 },
  { "msgbox", dislin_msgbox, 1 },
  { "mshclr", dislin_mshclr, 1 },
  { "mylab",  dislin_mylab,  1 },
  { "myline", dislin_myline, 1 },
  { "mypat",  dislin_mypat,  1 },
  { "mysymb", dislin_mysymb, 1 },
  { "myvlt",  dislin_myvlt,  1 },
  { "namdis", dislin_namdis, 1 },
  { "name",   dislin_name,   1 },
  { "namjus", dislin_namjus, 1 },
  { "neglog", dislin_neglog, 1 },
  { "newmix", dislin_newmix, 1 },
  { "newpag", dislin_newpag, 1 },
  { "nlmess", dislin_nlmess, 1 },
  { "nlnumb", dislin_nlnumb, 1 },
  { "noarln", dislin_noarln, 1 },
  { "nobar",  dislin_nobar,  1 },
  { "nobgd",  dislin_nobgd,  1 },
  { "nochek", dislin_nochek, 1 },
  { "noclip", dislin_noclip, 1 },
  { "nofill", dislin_nofill, 1 },
  { "nograf", dislin_nograf, 1 },
  { "nohide", dislin_nohide, 1 },
  { "noline", dislin_noline, 1 },
  { "number", dislin_number, 1 },
  { "numfmt", dislin_numfmt, 1 },
  { "numode", dislin_numode, 1 },
  { "nwkday", dislin_nwkday, 1 },
  { "nxlegn", dislin_nxlegn, 1 },
  { "nxposn", dislin_nxposn, 1 },
  { "nylegn", dislin_nylegn, 1 },
  { "nyposn", dislin_nyposn, 1 },
  { "nzposn", dislin_nzposn, 1 },
  { "openfl", dislin_openfl, 1 },
  { "opnwin", dislin_opnwin, 1 },
  { "origin", dislin_origin, 1 },
  { "page",   dislin_page,   1 },
  { "pagera", dislin_pagera, 1 },
  { "pagfll", dislin_pagfll, 1 },
  { "paghdr", dislin_paghdr, 1 },
  { "pagmod", dislin_pagmod, 1 },
  { "pagorg", dislin_pagorg, 1 },
  { "patcyc", dislin_patcyc, 1 },
  { "pdfbuf", dislin_pdfbuf, 1 },
  { "pdfmod", dislin_pdfmod, 1 },
  { "pdfmrk", dislin_pdfmrk, 1 },
  { "penwid", dislin_penwid, 1 },
  { "pie",    dislin_pie,    1 },
  { "piebor", dislin_piebor, 1 },
  { "pieclr", dislin_pieclr, 1 },
  { "pieexp", dislin_pieexp, 1 },
  { "piegrf", dislin_piegrf, 1 },
  { "pielab", dislin_pielab, 1 },
  { "pieopt", dislin_pieopt, 1 },
  { "pietyp", dislin_pietyp, 1 },
  { "pievec", dislin_pievec, 1 },
  { "pngmod", dislin_pngmod, 1 },
  { "point",  dislin_point,  1 },
  { "polar",  dislin_polar,  1 },
  { "polcrv", dislin_polcrv, 1 },
  { "polmod", dislin_polmod, 1 },
  { "pos2pt", dislin_pos2pt, 1 }, 
  { "pos3pt", dislin_pos3pt, 1 },
  { "posifl", dislin_posifl, 1 },
  { "projct", dislin_projct, 1 },
  { "psfont", dislin_psfont, 1 },
  { "psmode", dislin_psmode, 1 },
  { "qplbar", dislin_qplbar, 1 },
  { "qplclr", dislin_qplclr, 1 },
  { "qplcon", dislin_qplcon, 1 },
  { "qplot",  dislin_qplot,  1 },
  { "qplpie", dislin_qplpie, 1 },
  { "qplsca", dislin_qplsca, 1 },
  { "qplsur", dislin_qplsur, 1 },
  { "rbmp",   dislin_rbmp,   1 },
  { "rbfpng", dislin_rbfpng, 1 },
  { "readfl", dislin_readfl, 1 },
  { "reawgt", dislin_reawgt, 1 },
  { "recfll", dislin_recfll, 1 },
  { "rectan", dislin_rectan, 1 },
  { "rel3pt", dislin_rel3pt, 1 }, 
  { "resatt", dislin_resatt, 1 },
  { "reset",  dislin_reset,  1 },
  { "revscr", dislin_revscr, 1 },
  { "rgbhsv", dislin_rgbhsv, 1 },
  { "rgif",   dislin_rgif,   1 },
  { "rgtlab", dislin_rgtlab, 1 },
  { "rimage", dislin_rimage, 1 },
  { "rlarc",  dislin_rlarc,  1 },
  { "rlarea", dislin_rlarea, 1 },
  { "rlcirc", dislin_rlcirc, 1 },
  { "rlconn", dislin_rlconn, 1 },
  { "rlell",  dislin_rlell,  1 },
  { "rline",  dislin_rline,  1 },
  { "rlmess", dislin_rlmess, 1 },
  { "rlnumb", dislin_rlnumb, 1 },
  { "rlpie",  dislin_rlpie,  1 },
  { "rlpoin", dislin_rlpoin, 1 },
  { "rlrec",  dislin_rlrec,  1 },
  { "rlrnd",  dislin_rlrnd,  1 },
  { "rlsec",  dislin_rlsec,  1 },
  { "rlstrt", dislin_rlstrt, 1 },
  { "rlsymb", dislin_rlsymb, 1 },
  { "rlvec",  dislin_rlvec,  1 },
  { "rlwind", dislin_rlwind, 1 },
  { "rndrec", dislin_rndrec, 1 },
  { "rpixel", dislin_rpixel, 1 },
  { "rpixls", dislin_rpixls, 1 },
  { "rpng",   dislin_rpng,   1 },
  { "rppm",   dislin_rppm,   1 },
  { "rpxrow", dislin_rpxrow, 1 },
  { "rtiff",  dislin_rtiff,  1 },
  { "rvynam", dislin_rvynam, 1 },
  { "scale",  dislin_scale,  1 },
  { "sclfac", dislin_sclfac, 1 },
  { "sclmod", dislin_sclmod, 1 },
  { "scrmod", dislin_scrmod, 1 },
  { "sector", dislin_sector, 1 },
  { "selwin", dislin_selwin, 1 },
  { "sendbf", dislin_sendbf, 1 },
  { "sendmb", dislin_sendmb, 1 },
  { "sendok", dislin_sendok, 1 },
  { "serif",  dislin_serif,  1 },
  { "setbas", dislin_setbas, 1 },
  { "setclr", dislin_setclr, 1 },
  { "setcsr", dislin_setcsr, 1 },
  { "setexp", dislin_setexp, 1 },
  { "setfil", dislin_setfil, 1 },
  { "setgrf", dislin_setgrf, 1 },
  { "setind", dislin_setind, 1 },
  { "setmix", dislin_setmix, 1 },
  { "setpag", dislin_setpag, 1 },
  { "setres", dislin_setres, 1 },
  { "setrgb", dislin_setrgb, 1 },
  { "setscl", dislin_setscl, 1 },
  { "setvlt", dislin_setvlt, 1 },
  { "setxid", dislin_setxid, 1 },
  { "shdafr", dislin_shdafr, 1 },
  { "shdcha", dislin_shdcha, 1 },
  { "shdcrv", dislin_shdcrv, 1 },
  { "shdeur", dislin_shdeur, 1 },
  { "shdmap", dislin_shdmap, 1 },
  { "shdmod", dislin_shdmod, 1 },
  { "shdpat", dislin_shdpat, 1 },
  { "shdusa", dislin_shdusa, 1 },
  { "shield", dislin_shield, 1 },
  { "shlcir", dislin_shlcir, 1 },
  { "shldel", dislin_shldel, 1 },
  { "shlell", dislin_shlell, 1 },
  { "shlind", dislin_shlind, 1 },
  { "shlpie", dislin_shlpie, 1 },
  { "shlpol", dislin_shlpol, 1 },
  { "shlrct", dislin_shlrct, 1 },
  { "shlrec", dislin_shlrec, 1 },
  { "shlres", dislin_shlres, 1 },
  { "shlsur", dislin_shlsur, 1 },
  { "shlvis", dislin_shlvis, 1 },
  { "simplx", dislin_simplx, 1 },
  { "skipfl", dislin_skipfl, 1 },
  { "smxalf", dislin_smxalf, 1 },
  { "solid",  dislin_solid,  1 },
  { "sortr1", dislin_sortr1, 1 }, 
  { "sortr2", dislin_sortr2, 1 }, 
  { "sphe3d", dislin_sphe3d, 1 }, 
  { "spline", dislin_spline, 1 }, 
  { "splmod", dislin_splmod, 1 },
  { "strt3d", dislin_strt3d, 1 },
  { "strtpt", dislin_strtpt, 1 },
  { "surclr", dislin_surclr, 1 },
  { "surfce", dislin_surfce, 1 },
  { "surfcp", dislin_surfcp, 1 },
  { "surfun", dislin_surfun, 1 },
  { "suriso", dislin_suriso, 1 },
  { "surmat", dislin_surmat, 1 },
  { "surmsh", dislin_surmsh, 1 },
  { "suropt", dislin_suropt, 1 },
  { "surshd", dislin_surshd, 1 },
  { "sursze", dislin_sursze, 1 },
  { "surtri", dislin_surtri, 1 },
  { "survis", dislin_survis, 1 },
  { "swgatt", dislin_swgatt, 1 },
  { "swgbox", dislin_swgbox, 1 },
  { "swgbut", dislin_swgbut, 1 },
  { "swgcb",  dislin_swgcb,  1 },
  { "swgcbk", dislin_swgcbk, 1 },
  { "swgclr", dislin_swgclr, 1 },
  { "swgdrw", dislin_swgdrw, 1 },
  { "swgfil", dislin_swgfil, 1 },
  { "swgfnt", dislin_swgfnt, 1 },
  { "swgfoc", dislin_swgfoc, 1 },
  { "swghlp", dislin_swghlp, 1 },
  { "swgjus", dislin_swgjus, 1 },
  { "swglis", dislin_swglis, 1 },
  { "swgmix", dislin_swgmix, 1 },
  { "swgmod", dislin_swgmod, 1 },
  { "swgmrg", dislin_swgmrg, 1 },
  { "swgoff", dislin_swgoff, 1 },
  { "swgopt", dislin_swgopt, 1 },
  { "swgpop", dislin_swgpop, 1 },
  { "swgpos", dislin_swgpos, 1 },
  { "swgscl", dislin_swgscl, 1 },
  { "swgsiz", dislin_swgsiz, 1 },
  { "swgtit", dislin_swgtit, 1 },
  { "swgtxt", dislin_swgtxt, 1 },
  { "swgtyp", dislin_swgtyp, 1 },
  { "swgspc", dislin_swgspc, 1 },
  { "swgstp", dislin_swgstp, 1 },
  { "swgwin", dislin_swgwin, 1 },
  { "swgwth", dislin_swgwth, 1 },
  { "symbol", dislin_symbol, 1 },
  { "symfil", dislin_symfil, 1 },
  { "symrot", dislin_symrot, 1 },
  { "tellfl", dislin_tellfl, 1 },
  { "thkcrv", dislin_thkcrv, 1 },
  { "thrfin", dislin_thrfin, 1 },
  { "thrini", dislin_thrini, 1 },
  { "ticks",  dislin_ticks,  1 },
  { "ticlen", dislin_ticlen, 1 },
  { "ticmod", dislin_ticmod, 1 },
  { "ticpos", dislin_ticpos, 1 },
  { "tifmod", dislin_tifmod, 1 },
  { "tiforg", dislin_tiforg, 1 },
  { "tifwin", dislin_tifwin, 1 },
  { "timopt", dislin_timopt, 1 },
  { "titjus", dislin_titjus, 1 },
  { "title",  dislin_title,  1 },
  { "titlin", dislin_titlin, 1 },
  { "titpos", dislin_titpos, 1 },
  { "trfco1", dislin_trfco1, 1 }, 
  { "trfco2", dislin_trfco2, 1 }, 
  { "trfco3", dislin_trfco3, 1 }, 
  { "trfdat", dislin_trfdat, 1 }, 
  { "trfrel", dislin_trfrel, 1 }, 
  { "trfres", dislin_trfres, 1 },
  { "trfmat", dislin_trfmat, 1 },
  { "trfrot", dislin_trfrot, 1 },
  { "trfscl", dislin_trfscl, 1 },
  { "trfshf", dislin_trfshf, 1 },
  { "triang", dislin_triang, 1 },
  { "trifll", dislin_trifll, 1 },
  { "triplx", dislin_triplx, 1 },
  { "tripts", dislin_tripts, 1 },
  { "trmlen", dislin_trmlen, 1 },
  { "texmod", dislin_texmod, 1 },
  { "texopt", dislin_texopt, 1 },
  { "texval", dislin_texval, 1 },
  { "txtjus", dislin_txtjus, 1 },
  { "unit",   dislin_unit,   1 },
  { "units",  dislin_units,  1 },
  { "upstr",  dislin_upstr,  1 },
  { "vang3d", dislin_vang3d, 1 },
  { "vclp3d", dislin_vclp3d, 1 },
  { "vector", dislin_vector, 1 },
  { "vectr3", dislin_vectr3, 1 },
  { "vfoc3d", dislin_vfoc3d, 1 },
  { "view3d", dislin_view3d, 1 },
  { "vkxbar", dislin_vkxbar, 1 },
  { "vkybar", dislin_vkybar, 1 },
  { "vkytit", dislin_vkytit, 1 },
  { "vltfil", dislin_vltfil, 1 },
  { "vup3d",  dislin_vup3d,  1 },
  { "wgapp",  dislin_wgapp,  1 },
  { "wgbas",  dislin_wgbas,  1 },
  { "wgbox",  dislin_wgbox,  1 },
  { "wgbut",  dislin_wgbut,  1 },
  { "wgcmd",  dislin_wgcmd,  1 },
  { "wgdlis", dislin_wgdlis, 1 },
  { "wgdraw", dislin_wgdraw, 1 },
  { "wgfil",  dislin_wgfil,  1 },
  { "wgfin",  dislin_wgfin,  1 },
  { "wgini",  dislin_wgini,  1 },
  { "wglab",  dislin_wglab,  1 },
  { "wglis",  dislin_wglis,  1 },
  { "wgok",   dislin_wgok,   1 },
  { "wgpop",  dislin_wgpop,  1 },
  { "wgquit", dislin_wgquit, 1 },
  { "wgltxt", dislin_wgltxt, 1 },
  { "wgpbut", dislin_wgpbut, 1 },
  { "wgscl",  dislin_wgscl,  1 },
  { "wgstxt", dislin_wgstxt, 1 },
  { "wgtxt",  dislin_wgtxt,  1 },
  { "widbar", dislin_widbar, 1 },
  { "wimage", dislin_wimage, 1 },
  { "winapp", dislin_winapp, 1 },
  { "windbr", dislin_windbr, 1 },
  { "winfnt", dislin_winfnt, 1 },
  { "winkey", dislin_winkey, 1 },
  { "winmod", dislin_winmod, 1 },
  { "window", dislin_window, 1 },
  { "winid",  dislin_winid,  1 },
  { "winopt", dislin_winopt, 1 },
  { "winsiz", dislin_winsiz, 1 },
  { "wintit", dislin_wintit, 1 },
  { "wmfmod", dislin_wmfmod, 1 },
  { "world",  dislin_world,  1 },
  { "wpixel", dislin_wpixel, 1 },
  { "wpixls", dislin_wpixls, 1 },
  { "wpxrow", dislin_wpxrow, 1 },
  { "writfl", dislin_writfl, 1 },
  { "wtiff",  dislin_wtiff,  1 },
  { "x11fnt", dislin_x11fnt, 1 },
  { "x11mod", dislin_x11mod, 1 },
  { "x2dpos", dislin_x2dpos, 1 },
  { "x3dabs", dislin_x3dabs, 1 },
  { "x3dpos", dislin_x3dpos, 1 },
  { "x3drel", dislin_x3drel, 1 },
  { "xaxgit", dislin_xaxgit, 1 },
  { "xaxis",  dislin_xaxis,  1 },
  { "xaxlg",  dislin_xaxlg,  1 },
  { "xaxmap", dislin_xaxmap, 1 },
  { "xcross", dislin_xcross, 1 },
  { "xdraw",  dislin_xdraw,  1 },
  { "xinvrs", dislin_xinvrs, 1 },
  { "xmove",  dislin_xmove,  1 },
  { "xposn",  dislin_xposn,  1 },
  { "y2dpos", dislin_y2dpos, 1 },
  { "y3dabs", dislin_y3dabs, 1 },
  { "y3dpos", dislin_y3dpos, 1 },
  { "y3drel", dislin_y3drel, 1 },
  { "yaxgit", dislin_yaxgit, 1 },
  { "yaxis",  dislin_yaxis,  1 },
  { "yaxlg",  dislin_yaxlg,  1 },
  { "yaxmap", dislin_yaxmap, 1 },
  { "ycross", dislin_ycross, 1 },
  { "yinvrs", dislin_yinvrs, 1 },
  { "yposn",  dislin_yposn,  1 },
  { "z3dpos", dislin_z3dpos, 1 },
  { "zaxis",  dislin_zaxis,  1 },
  { "zaxlg",  dislin_zaxlg,  1 },
  { "zbffin", dislin_zbffin, 1 },
  { "zbfini", dislin_zbfini, 1 },
  { "zbflin", dislin_zbflin, 1 },
  { "zbftri", dislin_zbftri, 1 },
  { "zscale", dislin_zscale, 1 },
  { "plot",   dislin_plot,   1 },
  { "scattr", dislin_scattr, 1 },
  { "plot3",  dislin_plot3,  1 },
  { "surf3",  dislin_surf3,  1 },
  { "surface",  dislin_surface,  1 },
  { "surshade",  dislin_surshade,  1 },
  { "contour",  dislin_contour,  1 },
  { "conshade",  dislin_conshade,  1 },
  { "setvar", dislin_setvar, 1 },
  {NULL, NULL} };

void initdislin()
{ (void) Py_InitModule("dislin", DislinMethods);
}
