unit EditGroup;

{$IFDEF CONDITIONALEXPRESSIONS}
{$IF RTLVersion >= 14.0}
{$DEFINE D6_UP}
{$IFEND}
{$ENDIF}

interface

uses Classes, Controls, Forms, StdCtrls, WabObj;

type
  TEditGroupForm = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    EmailEd: TEdit;
    MobileEd: TEdit;
    PhoneEd: TEdit;
    HomePageEd: TEdit;
    DisplayNameEd: TEdit;
    HomeAddrCityEd: TEdit;
    HomeAddrStateEd: TEdit;
    HomeAddrPostalEd: TEdit;
    HomeAddrContryEd: TEdit;
    HomeAddrStreetEd: TMemo;
    NotesMem: TMemo;
    ContactsLB: TListBox;
    EditBtn: TButton;
    RemoveBtn: TButton;
    OKBtn: TButton;
    procedure FormShow(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure SelectBtnClick(Sender: TObject);
    procedure NewContBtnClick(Sender: TObject);
    procedure EditBtnClick(Sender: TObject);
    procedure RemoveBtnClick(Sender: TObject);
    procedure ContactsLBClick(Sender: TObject);
    procedure FormHide(Sender: TObject);
    procedure ContactsLBDblClick(Sender: TObject);
  private
    FSelContacts: TList;
    procedure UpdateContacts;
    procedure UpdateButtons;
  public
    WAB: TWAB;
    DistList: TWABDistList;
  end;

var
  EditGroupForm: TEditGroupForm;

implementation

uses {$IFDEF D6_UP} Variants, {$ENDIF} WabTags, EditCont, SelGrMemb;

{$R *.dfm}

procedure TEditGroupForm.FormShow(Sender: TObject);
var
  I: Integer;
begin
  FSelContacts := TList.Create;
  if DistList = nil then
  begin
   DisplayNameEd.Text := '';
   MobileEd.Text := '';
   PhoneEd.Text := '';
   EmailEd.Text := '';
   HomePageEd.Text := '';
   NotesMem.Text := '';
   HomeAddrStreetEd.Text := '';
   HomeAddrCityEd.Text := '';
   HomeAddrStateEd.Text := '';
   HomeAddrPostalEd.Text := '';
   HomeAddrContryEd.Text := '';
  end
  else
   with DistList do
   begin
    DisplayNameEd.Text := VarToStr(PropByTag[PR_DISPLAY_NAME]);
    MobileEd.Text := VarToStr(PropByTag[PR_MOBILE_TELEPHONE_NUMBER]);
    PhoneEd.Text := VarToStr(PropByTag[PR_HOME_TELEPHONE_NUMBER]);
    EmailEd.Text := VarToStr(PropByTag[PR_EMAIL_ADDRESS]);
    HomePageEd.Text := VarToStr(PropByTag[PR_PERSONAL_HOME_PAGE]);
    NotesMem.Text := VarToStr(PropByTag[PR_COMMENT]);
    HomeAddrStreetEd.Text := VarToStr(PropByTag[PR_HOME_ADDRESS_STREET]);
    HomeAddrCityEd.Text := VarToStr(PropByTag[PR_HOME_ADDRESS_CITY]);
    HomeAddrStateEd.Text := VarToStr(PropByTag[PR_HOME_ADDRESS_STATE_OR_PROVINCE]);
    HomeAddrPostalEd.Text := VarToStr(PropByTag[PR_HOME_ADDRESS_POSTAL_CODE]);
    HomeAddrContryEd.Text := VarToStr(PropByTag[PR_HOME_ADDRESS_COUNTRY]);
    for I := 0 to ContactCount - 1 do
     FSelContacts.Add(DistList[I]);
  end;
  UpdateContacts;
end;

procedure TEditGroupForm.FormHide(Sender: TObject);
begin
  FSelContacts.Free;
end;

procedure TEditGroupForm.UpdateContacts;
var
  I: Integer;
begin
  with ContactsLB.Items do
  begin
   BeginUpdate;
   try
    Clear;
    for I := 0 to FSelContacts.Count - 1 do
     AddObject(TWABcontact(FSelContacts[I]).PropByTag[PR_DISPLAY_NAME], FSelContacts[I]);
   finally
    EndUpdate;
   end;
  end;
  UpdateButtons;
end;

procedure TEditGroupForm.UpdateButtons;
begin
  EditBtn.Enabled := ContactsLB.ItemIndex >= 0;
  RemoveBtn.Enabled := ContactsLB.ItemIndex >= 0;
end;

procedure TEditGroupForm.OKBtnClick(Sender: TObject);
var
  I,J: Integer;
begin
  if DistList = nil then
   DistList := WAB.NewDistList;
  with DistList do
  begin
   PropByTag[PR_DISPLAY_NAME] := DisplayNameEd.Text;
   PropByTag[PR_MOBILE_TELEPHONE_NUMBER] := MobileEd.Text;
   PropByTag[PR_HOME_TELEPHONE_NUMBER] := PhoneEd.Text;
   PropByTag[PR_EMAIL_ADDRESS] := EmailEd.Text;
   PropByTag[PR_PERSONAL_HOME_PAGE] := HomePageEd.Text;
   PropByTag[PR_COMMENT] := NotesMem.Text;
   PropByTag[PR_HOME_ADDRESS_STREET] := HomeAddrStreetEd.Text;
   PropByTag[PR_HOME_ADDRESS_CITY] := HomeAddrCityEd.Text;
   PropByTag[PR_HOME_ADDRESS_STATE_OR_PROVINCE] := HomeAddrStateEd.Text;
   PropByTag[PR_HOME_ADDRESS_POSTAL_CODE] := HomeAddrPostalEd.Text;
   PropByTag[PR_HOME_ADDRESS_COUNTRY] := HomeAddrContryEd.Text;
   Save;
  end;
  for I := DistList.ContactCount - 1 downto 0 do
  begin
   J := FSelContacts.Count - 1;
   while (J >= 0) and (FSelContacts[J] <> DistList[I]) do Dec(J);
   if J < 0 then
    DistList.Delete(I);
  end;
  for I := 0 to FSelContacts.Count - 1 do
   DistList.Add(TWABContact(FSelContacts[I]));
end;

procedure TEditGroupForm.SelectBtnClick(Sender: TObject);
begin
  SelGrMembForm.WAB := WAB;
  SelGrMembForm.SelContacts := FSelContacts;
  if SelGrMembForm.ShowModal = mrOK then
   UpdateContacts;
end;

procedure TEditGroupForm.NewContBtnClick(Sender: TObject);
begin
  EditContForm.WAB := WAB;
  EditContForm.Contact := nil;
  if EditContForm.ShowModal = mrOK then
  begin
   FSelContacts.Add(EditContForm.Contact);
   ContactsLB.ItemIndex := ContactsLB.Items.Add(EditContForm.Contact.PropByTag[PR_DISPLAY_NAME]);
   UpdateButtons;
  end;
end;

procedure TEditGroupForm.EditBtnClick(Sender: TObject);
begin
  EditContForm.WAB := WAB;
  EditContForm.Contact := FSelContacts[ContactsLB.ItemIndex];
  if EditContForm.ShowModal = mrOK then
  begin
   ContactsLB.Items[ContactsLB.ItemIndex] := EditContForm.Contact.PropByTag[PR_DISPLAY_NAME];
   UpdateButtons;
  end;
end;

procedure TEditGroupForm.RemoveBtnClick(Sender: TObject);
begin
  FSelContacts.Delete(ContactsLB.ItemIndex);
  ContactsLB.Items.Delete(ContactsLB.ItemIndex);
  UpdateButtons;
end;

procedure TEditGroupForm.ContactsLBClick(Sender: TObject);
begin
  UpdateButtons;
end;

procedure TEditGroupForm.ContactsLBDblClick(Sender: TObject);
begin
  if ContactsLB.ItemIndex >= 0 then
   EditBtnClick(Self);
end;

end.  
