unit Main;

interface

uses
  Windows, Messages, Forms, Dialogs, Controls, StdCtrls, Sysutils, Classes,
  ComCtrls, ActnList, ExtCtrls;

type
  TfrmMain = class(TForm)
    Button2: TButton;
    StatusBar1: TStatusBar;
    PageControl1: TPageControl;
    tbsMath: TTabSheet;
    MathFuncs: TListBox;
    Label1: TLabel;
    mmoResult: TMemo;
    btnCalc: TButton;
    lblResult: TLabel;
    Label4: TLabel;
    GroupBox1: TGroupBox;
    btnRandom: TButton;
    edtBitLength: TEdit;
    btnClear: TButton;
    Label5: TLabel;
    Button3: TButton;
    tbsBooleanFuncs: TTabSheet;
    BoolFuncs: TListBox;
    Label6: TLabel;
    Panel1: TPanel;
    GroupBox2: TGroupBox;
    Label7: TLabel;
    Button5: TButton;
    Edit1: TEdit;
    Button6: TButton;
    ActionList1: TActionList;
    Action1: TAction;
    pnlB: TPanel;
    lblb: TLabel;
    lblParamB: TLabel;
    mmob: TMemo;
    pnla: TPanel;
    lbla: TLabel;
    lblParamA: TLabel;
    mmoa: TMemo;
    procedure btnCalcClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure mmoaChange(Sender: TObject);
    procedure mmobChange(Sender: TObject);
    procedure MathFuncsClick(Sender: TObject);
    procedure btnClearClick(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure btnRandomClick(Sender: TObject);
    procedure mmoResultChange(Sender: TObject);
    procedure tbsMathShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BoolFuncsClick(Sender: TObject);
    procedure Action1Update(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure MathTab;
    procedure BoolTab;
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.dfm}


uses HimeLib;

procedure TfrmMain.MathTab;
begin
  if MathFuncs.ItemIndex<0 then
  begin
    StatusBar1.Panels[0].Text:='Please select an operation to perform!';
    exit;
  end;
  Hime.PutReg(1,mmoa.Lines.Text,hi_Dec);
  Hime.PutReg(2,mmob.Lines.Text,hi_Dec);
  StatusBar1.Panels[0].Text:='Please wait while processing...';
  Application.ProcessMessages;
  case MathFuncs.ItemIndex of
    0:  Hime.HugeAdd(1,2,3);
    1:  Hime.HugeSub(1,2,3);
    2:  Hime.HugeMul(1,2,3);
    3:  Hime.HugeMulBy2(1,3);
    4:  Hime.HugeDiv(1,2,3,4);
    5:  Hime.HugeDivBy2(1,3,4);
    6:  Hime.HugePow(1,2,3);
    7:  Hime.HugeMod(1,2,3);
    8:  Hime.HugeModInv(1,2,3);
    9:  Hime.HugeGCD(1,2,3);
  end;
  StatusBar1.Panels[0].Text:='Formating data to display, this may take a while...';
  Application.ProcessMessages;
  mmoResult.Lines.Text:=Hime.GetReg(3,hi_Dec);
  case MathFuncs.ItemIndex of
    4,5: showmessage('Remainder: '+Hime.GetReg(4,hi_Dec));
  end;
  StatusBar1.Panels[0].Text:='Ready';
end;

procedure TfrmMain.BoolTab;
begin
  if BoolFuncs.ItemIndex<0 then
  begin
    StatusBar1.Panels[0].Text:='Please select an operation to perform!';
    exit;
  end;
  Hime.PutReg(1,mmoa.Lines.Text,hi_Dec);
  Hime.PutReg(2,mmob.Lines.Text,hi_Dec);
  StatusBar1.Panels[0].Text:='Please wait while processing...';
  Application.ProcessMessages;
  case BoolFuncs.ItemIndex of
    0: mmoResult.Lines.Text:=IntToStr(Hime.HugeIsEqual(1,2));
    1: mmoResult.Lines.Text:=IntToStr(Hime.HugeIsLess(1,2));
    2: mmoResult.Lines.Text:=IntToStr(Hime.HugeIsOdd(1));
  end;
  StatusBar1.Panels[0].Text:='Formating data to display, this may take a while...';
  Application.ProcessMessages;
  StatusBar1.Panels[0].Text:='Ready';
end;

procedure TfrmMain.btnCalcClick(Sender: TObject);
begin
  case PageControl1.ActivePageIndex of
    0: MathTab;
    1: BoolTab;
  end;
end;

procedure TfrmMain.Button2Click(Sender: TObject);
begin
  close;
end;

procedure TfrmMain.mmoaChange(Sender: TObject);
begin
  lbla.Caption:=inttostr(Length(mmoa.Lines.Text))+' decimal digits.';
end;

procedure TfrmMain.mmobChange(Sender: TObject);
begin
  lblb.Caption:=inttostr(Length(mmob.Lines.Text))+' decimal digits.';
end;

procedure TfrmMain.MathFuncsClick(Sender: TObject);
begin
  mmob.Enabled:= not (MathFuncs.ItemIndex in [3,5]);
  if not mmob.Enabled then mmob.Lines.Text:='';
end;

procedure TfrmMain.btnClearClick(Sender: TObject);
begin
  mmoa.Lines.Clear;
  mmob.Lines.Clear;
end;

procedure TfrmMain.Button3Click(Sender: TObject);
begin
 mmoResult.Lines.Clear;
end;

procedure TfrmMain.btnRandomClick(Sender: TObject);
begin
  Hime.GenerateRandom(StrtoInt(edtBitLength.Text),1);
  mmoa.lines.Text:=Hime.GetReg(1,hi_Dec);
  if mmob.Enabled then
  begin
    Hime.GenerateRandom(StrtoInt(edtBitLength.Text),2);
    mmob.lines.Text:=Hime.GetReg(2,hi_Dec);
  end;
end;

procedure TfrmMain.mmoResultChange(Sender: TObject);
begin
  lblResult.Caption:=inttostr(Length(mmoResult.Lines.Text))+' decimal digits.';
end;

procedure TfrmMain.tbsMathShow(Sender: TObject);
var x:integer;
begin
  Label1.Parent:=Sender as TTabSheet;
  lblResult.Parent:=Sender as TTabSheet;
  mmoResult.Parent:=Sender as TTabSheet;

  pnlA.Parent:=Sender as TTabSheet;
  pnlB.Parent:=Sender as TTabSheet;

  GroupBox1.Parent:=Sender as TTabSheet;
  btnCalc.Parent:=Sender as TTabSheet;
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  PageControl1.ActivePageIndex:=0;
		// Enter your own registration key here:
  Hime.RegisterHIME(1,'xxxx-yyyyyyyyyy');
end;

procedure TfrmMain.BoolFuncsClick(Sender: TObject);
begin
  mmob.Enabled:= not (BoolFuncs.ItemIndex in [0,2]);
  if not mmob.Enabled then mmob.Lines.Text:='';
end;

procedure TfrmMain.Action1Update(Sender: TObject);
begin
  pnlb.Visible:=mmob.Enabled;
end;

end.
