unit uRulerRemoteInterface;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, uRemoteInterfaceEventCodes, Buttons, Spin;

type
  TRemoteInterfaceForm = class(TForm)
    CheckForMBRulerTimer: TTimer;
    ModifyGroupBox: TGroupBox;
    MovePanel: TPanel;
    RotatePanel: TPanel;
    VisibleCheckBox: TCheckBox;
    InformationGroupBox: TGroupBox;
    xEdit: TEdit;
    yEdit: TEdit;
    Angle1Edit: TEdit;
    CalcDistEdit: TEdit;
    CalcAngleEdit: TEdit;
    xLabel: TLabel;
    yLabel: TLabel;
    Label3: TLabel;
    CalcDistLabel: TLabel;
    CalcAngleLabel: TLabel;
    ConnectionPanel: TPanel;
    MBRulerFoundCheckBox: TCheckBox;
    StartRulerButton: TButton;
    ResetPanel: TPanel;
    RulerModeComboBox: TComboBox;
    Angle2Edit: TEdit;
    Label1: TLabel;
    ScaleGroupBox: TGroupBox;
    PixelDistanceSpinEdit: TSpinEdit;
    PhysicalDistanceSpinEdit: TSpinEdit;
    DistanceUnitEdit: TEdit;
    SetScaleCheckBox: TCheckBox;
    PixelLabel: TLabel;
    ColorGroupBox: TGroupBox;
    SelectColorButton: TButton;
    ColorDialog: TColorDialog;
    procedure CheckForMBRulerTimerTimer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure MovePanelMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure MBRulerFoundCheckBoxClick(Sender: TObject);
    procedure StartRulerButtonClick(Sender: TObject);
    procedure MovePanelMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure RotatePanelMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure RotatePanelMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure ResetPanelMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure RulerModeComboBoxChange(Sender: TObject);
    procedure SetScaleCheckBoxClick(Sender: TObject);
    procedure ScaleInfoChange(Sender: TObject);
    procedure SelectColorButtonClick(Sender: TObject);
  private
    { Private-Deklarationen }
    procedure UpdateLabels;
    procedure SetScale;
  public
    { Public-Deklarationen }
    MBRulerHandle : HWND;

    procedure RemoteControlGenerell(var message : TMessage); message WM_MBRULER_GENERELL;
    procedure RemoteControlRuler(var message : TMessage); message WM_MB_RULER_RULER;    
  end;

var
  RemoteInterfaceForm: TRemoteInterfaceForm;

implementation

{$R *.DFM}

procedure TRemoteInterfaceForm.UpdateLabels;
begin
  case RulerModeComboBox.ItemIndex of
  1 : begin
        Label3.Caption := 'orient.';
        Label1.Visible := false;
        Angle2Edit.Visible := false;
        CalcDistLabel.Caption := 'dist';
        CalcAngleLabel.Caption := 'angle';
      end;
  2 : begin
        Label3.Caption := 'orient1.';
        Label1.Visible := true;
        Angle2Edit.Visible := true;
        CalcDistLabel.Caption := 'dist1';
        CalcAngleLabel.Caption := 'dist2';
      end;
  end;
end;

procedure TRemoteInterfaceForm.SetScale;
var
  ScaleUnit : array[1..5] of byte;
begin
  FillChar(ScaleUnit, 5, 0);
  StrPCopy(@ScaleUnit, DistanceUnitEdit.Text);
  SendMessage(MBRulerHandle, WM_MB_RULER_RULER, RULER_SET_SCALE, MakeLong(PixelDistanceSpinEdit.Value, PhysicalDistanceSpinEdit.Value));
  SendMessage(MBRulerHandle, WM_MB_RULER_RULER, RULER_SET_SCALE_UNIT, MakeLong(MakeWord(ScaleUnit[1] ,ScaleUnit[2]), MakeWord(ScaleUnit[3],ScaleUnit[4])));
end;

procedure TRemoteInterfaceForm.RemoteControlGenerell(var message : TMessage);
begin
  if (message.WParam = GENERELL_ADDCLIENT) then
  begin
    if (MBRulerHandle = message.LParam) then
      message.Result := Handle;
  end;
end;

procedure TRemoteInterfaceForm.RemoteControlRuler(var message : TMessage);
begin
  case message.WParam of
    RULER_POS        : begin
                         xEdit.Text := IntToStr(message.LParamLo);
                         yEdit.Text := IntToStr(message.LParamHi);
                        end;
    RULER_ANGLE      : begin
                         Angle1Edit.Text:= IntToStr(message.LParamLo);
                         Angle2Edit.Text:= IntToStr(message.LParamHi);
                       end;
    RULER_CALC_DIST  : CalcDistEdit.Text:= IntToStr(message.LParam);
    RULER_CALC_ANGLE : CalcAngleEdit.Text:= IntToStr(message.LParam);

    RULER_CALC_DIST1 : CalcDistEdit.Text:= IntToStr(message.LParam);
    RULER_CALC_DIST2 : CalcAngleEdit.Text:= IntToStr(message.LParam);

    RULER_SHOW       : begin
                         case message.LParam of
                           RULER_SHOW_HIDE         : RulerModeComboBox.ItemIndex := 0;
                           RULER_SHOW_TRIANGEL     : RulerModeComboBox.ItemIndex := 1;
                           RULER_SHOW_COORDSYSTEM  : RulerModeComboBox.ItemIndex := 2;
                         end;
                         UpdateLabels;
                       end;

  end;
end;

procedure TRemoteInterfaceForm.CheckForMBRulerTimerTimer(Sender: TObject);
begin
  if (MBRulerHandle <> FindWindow(nil,'MB-Ruler')) then
  begin
    MBRulerHandle := FindWindow(nil,'MB-Ruler');
    if (MBRulerHandle <> 0) then
    begin
      if (SendMessage(MBRulerHandle,WM_MBRULER_GENERELL, GENERELL_DETECTVERSION, REMOTEINTERFACE_VERSION) = 1) then
      begin
{$ifdef LOGIN_IN_WITH_FEEDBACK}
        SendMessage(MBRulerHandle, WM_MBRULER_GENERELL, GENERELL_ADDCLIENT, Handle);
        RulerModeComboBox.ItemIndex := SendMessage(MBRulerHandle, WM_MB_RULER_RULER, RULER_SHOW, RULER_SHOW_CHECK);
        UpdateLabels;
        MBRulerFoundCheckBox.Checked := true;
        MBRulerFoundCheckBox.Caption := 'MB-Ruler found (HWND='+IntTostr(MBRulerHandle)+')';
        StartRulerButton.Visible := false;
        StartRulerButton.Enabled := false;
{$else}
        SendMessage(MBRulerHandle, WM_MBRULER_GENERELL, GENERELL_ADDCLIENT, GENERELL_ADDCLIENT_WITHOUTLOGING);
{$endif}
        ColorGroupBox.Color := SendMessage(MBRulerHandle, WM_MB_RULER_RULER, RULER_GET_COLOR, 0);
      end
      else
      begin
        MBRulerHandle := 0;
        MBRulerFoundCheckBox.Checked := false;
        MBRulerFoundCheckBox.Caption := 'MB-Ruler not running';
        StartRulerButton.Visible := FileExists('MB-Ruler.exe');
        StartRulerButton.Enabled := true;
      end;
    end
    else
    begin
      MBRulerFoundCheckBox.Checked := false;
      MBRulerFoundCheckBox.Caption := 'MB-Ruler not running';
      StartRulerButton.Visible := FileExists('MB-Ruler.exe');
      StartRulerButton.Enabled := true;
    end;
  end;
end;

procedure TRemoteInterfaceForm.FormCreate(Sender: TObject);
begin
  MBRulerHandle := 1;
  CheckForMBRulerTimer.Enabled := true;
end;

procedure TRemoteInterfaceForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  SendMessage(MBRulerHandle, WM_MBRULER_GENERELL, GENERELL_DELCLIENT, Handle);
end;

procedure TRemoteInterfaceForm.MovePanelMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  d : integer;
begin
  d := MakeLong(X-50,Y-50);
  SendMessage(MBRulerHandle, WM_MB_RULER_RULER, RULER_MOVE_REL, d);
end;

procedure TRemoteInterfaceForm.MBRulerFoundCheckBoxClick(Sender: TObject);
begin
  MBRulerFoundCheckBox.Checked := MBRulerHandle <> 0;
end;

procedure TRemoteInterfaceForm.StartRulerButtonClick(Sender: TObject);
begin
  StartRulerButton.Enabled := false;
  WinExec('MB-Ruler.exe',0);
end;

procedure TRemoteInterfaceForm.MovePanelMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  MovePanel.Hint := 'Click here to move ruler '+IntToStr(X-50)+' pixel horizontal and '+IntToStr(Y-50)+' pixel vertival';
end;

procedure TRemoteInterfaceForm.RotatePanelMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  dw : integer;
begin
  case RulerModeComboBox.ItemIndex of
  0 : dw := 0;
  1 : dw := X-50;
  2 : dw := MakeLong(X-50,X-25);
  end;
  SendMessage(MBRulerHandle, WM_MB_RULER_RULER, RULER_ROTATE_REL, dw);
end;

procedure TRemoteInterfaceForm.RotatePanelMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  RotatePanel.Hint := 'Click here to rotate the ruler by '+IntToStr(X-90)+'';
end;

procedure TRemoteInterfaceForm.ResetPanelMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  SendMessage(MBRulerHandle, WM_MB_RULER_RULER, RULER_MOVE_ABS, MakeLong(screen.Width div 2, screen.Height div 2));
  case RulerModeComboBox.ItemIndex of
  0 : SendMessage(MBRulerHandle, WM_MB_RULER_RULER, RULER_ROTATE_ABS, 0);
  1 : SendMessage(MBRulerHandle, WM_MB_RULER_RULER, RULER_ROTATE_ABS, 0);
  2 : SendMessage(MBRulerHandle, WM_MB_RULER_RULER, RULER_ROTATE_ABS, MakeLong(0,90));
  end;
end;

procedure TRemoteInterfaceForm.RulerModeComboBoxChange(Sender: TObject);
begin
  case RulerModeComboBox.ItemIndex of
  0 : SendMessage(MBRulerHandle, WM_MB_RULER_RULER, RULER_SHOW, RULER_SHOW_HIDE);
  1 : SendMessage(MBRulerHandle, WM_MB_RULER_RULER, RULER_SHOW, RULER_SHOW_TRIANGEL);
  2 : SendMessage(MBRulerHandle, WM_MB_RULER_RULER, RULER_SHOW, RULER_SHOW_COORDSYSTEM);
  end;
  UpdateLabels;
end;

procedure TRemoteInterfaceForm.SetScaleCheckBoxClick(Sender: TObject);
begin
  PixelDistanceSpinEdit.Enabled := SetScaleCheckBox.Checked;
  PixelLabel.Enabled := SetScaleCheckBox.Checked;
  PhysicalDistanceSpinEdit.Enabled := SetScaleCheckBox.Checked;
  DistanceUnitEdit.Enabled := SetScaleCheckBox.Checked;
  if (SetScaleCheckBox.Checked)
  then SetScale
  else SendMessage(MBRulerHandle, WM_MB_RULER_RULER, RULER_SET_SCALE, 0);
end;

procedure TRemoteInterfaceForm.ScaleInfoChange(
  Sender: TObject);
begin
  SetScale;
end;

procedure TRemoteInterfaceForm.SelectColorButtonClick(Sender: TObject);
begin
  ColorDialog.Color := ColorGroupBox.Color;
  if ColorDialog.Execute then
    ColorGroupBox.Color := SendMessage(MBRulerHandle, WM_MB_RULER_RULER, RULER_SET_COLOR, ColorDialog.Color);
end;

end.
