unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ZylSerialPort, ExtCtrls;

type
  TForm1 = class(TForm)
    ZylSerialPort: TZylSerialPort;
    Memo: TMemo;
    btnOpen: TButton;
    Edit1: TEdit;
    btnSendStr: TButton;
    btnClose: TButton;
    lstPort: TListBox;
    btnSendData: TButton;
    rgMode: TRadioGroup;
    procedure ZylSerialPortReceive(Sender: TObject; Buffer: String);
    procedure btnOpenClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ZylSerialPortLineStatusChange(Sender: TObject;
      LineStatus: TLineStatusSet);
    procedure btnSendStrClick(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnSendDataClick(Sender: TObject);
    procedure ZylSerialPortDisconnect(Sender: TObject; Port: TCommPort);
    procedure ZylSerialPortConnect(Sender: TObject; Port: TCommPort);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.ZylSerialPortReceive(Sender: TObject; Buffer: String);
var
  strBuffer: String;
  i: Integer;
begin
  if rgMode.ItemIndex = 0 then
    Memo.Lines.Add(Buffer)
  else if rgMode.ItemIndex = 1 then
  begin
    strBuffer := '';
    for i := 1 to Length(Buffer) do
      strBuffer := strBuffer + IntToStr(Ord(Buffer[i]));
    Memo.Lines.Add(strBuffer)
  end
  else
  begin
    strBuffer := '';
    for i := 1 to Length(Buffer) do
      strBuffer := strBuffer + IntToHex(Ord(Buffer[i]), 1);
    Memo.Lines.Add(strBuffer)
  end
end;

procedure TForm1.btnOpenClick(Sender: TObject);
begin
  ZylSerialPort.InputBuffer := 1000;
  ZylSerialPort.Priority := tpNormal;
  ZylSerialPort.Port := TCommPort(lstPort.ItemIndex + 1);
  ZylSerialPort.Open;
  //ShowMessage(ZylSerialPort.CommPortToString(ZylSerialPort.IsConnected));
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  ZylSerialPort.Close();
end;

procedure TForm1.ZylSerialPortLineStatusChange(Sender: TObject;
  LineStatus: TLineStatusSet);
var
  strLine: String;
begin
  strLine := '';
  if lsCTS in LineStatus then
    strLine := strLine + 'CTS ';
  if lsDSR in LineStatus then
    strLine := strLine + 'DSR ';
  if lsRING in LineStatus then
    strLine := strLine + 'RING ';
  if lsCD in LineStatus then
    strLine := strLine + 'CD ';
  Memo.Lines.Add('Line Change: ' + strLine);    
end;

procedure TForm1.btnSendStrClick(Sender: TObject);
begin
  ZylSerialPort.SendString(edit1.Text); 
end;

procedure TForm1.btnCloseClick(Sender: TObject);
begin
  ZylSerialPort.Close;
  //ShowMessage(ZylSerialPort.CommPortToString(ZylSerialPort.IsConnected));  
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  comPorts: TCommPortSet;
  i: TCommPort;
begin
  comPorts := ZylSerialPort.GetExistingCommPorts();
  Memo.Lines.Add('Installed COMM Ports:');
  for i := spCOM1 to spCOM25 do
  begin
    if i in comPorts then
      Memo.Lines.Add(ZylSerialPort.CommPortToString(i));
  end;
end;

procedure TForm1.btnSendDataClick(Sender: TObject);
var
  tmp: ^Char;
begin
  GetMem(tmp, 20);
  FillChar(tmp^, 20, #0);
  ZylSerialPort.SendData(tmp, 20);
  FreeMem(tmp);
end;

procedure TForm1.ZylSerialPortDisconnect(Sender: TObject; Port: TCommPort);
begin
  Memo.Lines.Add('Disconnected from ' + ZylSerialPort.CommPortToString(Port));
end;

procedure TForm1.ZylSerialPortConnect(Sender: TObject; Port: TCommPort);
begin
  Memo.Lines.Add('Connected to ' + ZylSerialPort.CommPortToString(Port));
end;

end.
