program     CDEMO;
(**********************   CDEMO.DPR   ************************************
*                                                                        *
*                Simple Demo Program for                                 *
*                       C M A T H                                        *
*                                                                        *
*  Copyright 1996-2008 by OptiCode - Dr. Martin Sander Software Dev.     *
*                                                                        *
*       This sample program provides a very basic test                   *
*       for the correct installation of CMATH and for                    *
*       correct error handling.                                          *
*                                                                        *
**************************************************************************)

(*
    Open this file as a project in the Delphi IDE
    and add \YourCMATHDirectory\LIB to the search path in
    Project / Options / Directories and Conditionals / Search path.
    With the registered version, write "LIB4" or "LIB6" instead of "LIB"

    Alternatively, compile this demo program from the command-line as
    DCC32 -u"\YourCMATHDirectory\LIB" CDEMO.DPR
    and run the resulting CDEMO.EXE.

*)

{$E-} {$N+} {$D+}
uses CMATH, SysUtils;

var  x, y: fComplex;
     Msg, Msg1, Msg2:  array[0..120] of char;
begin
    V_printErrorMsg( 'Welcome to the CMATH installation check!'#13#13+
                     'Do not wonder, the next window shows'#13+
                     'a piece of error handling!');
    x.Re := 3;
    x.Im := 5;   {first method of initialization}
    fcplx( y, 0, 0 );  {second method of initialization}
    cf_sin( x, x );  { type-specific function-call form: most efficient way}
    y := inv( y );  { overloaded function and := operator - more intuitive,
                      but less efficient!
                      This call will produce an error message }
                    { now primitive way to show results }
    Str( x.Re, Msg1 ); Str( x.Im, Msg2 );
    StrECopy( StrECopy( StrECopy( StrECopy( Msg, 'The sine of { 3.0, 5.0 } is'#13+'{ ' ), Msg1 ), ', ' ), Msg2 );
    StrCat( Msg, ' }' );  V_printErrorMsg( Msg );
    Str( y.Re, Msg1 ); Str( y.Im, Msg2 );
    StrECopy( StrECopy( StrECopy( StrECopy( Msg, 'Within Single accuracy, complex 1/0 situations yield'#13+'{ ' ), Msg1 ), ', ' ), Msg2 );
    StrCat( Msg, ' }' );  V_printErrorMsg( Msg );
    V_printErrorMsg( 'Thank you!'#13+
                     'Enjoy using CMATH in your programs!' );
end.
