unit fSHX;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, IniFiles, sgConsts;

const
  sGeneral: string = 'General';
  sSettings: string = 'Settings.ini';
  sUseSHX: string = 'Use SHX';
  sSHXPaths: string = 'SHX search paths';
  sSHXPath: string = 'SHX default path';
  sSHXFont: string = 'SHX default font';

type
  TfmSHX = class(TForm)
    btnOk: TButton;
    btnCancel: TButton;
    lblSHXSearchPath: TLabel;
    edSHXSearchPath: TEdit;
    btnSHXSearchPath: TButton;
    btnSHXDefaultPath: TButton;
    edSHXDefaultPath: TEdit;
    lblDefautSHXPath: TLabel;
    lblDefaultSHXFont: TLabel;
    edSHXDefaultFont: TEdit;
    Panel1: TPanel;
    cbUseSHXFonts: TCheckBox;
    procedure cbUseSHXFontsClick(Sender: TObject);
    procedure btnSHXSearchPathClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnSHXDefaultPathClick(Sender: TObject);
    procedure btnOkClick(Sender: TObject);
  private
    { Private declarations }
    FOptions: TIniFile;
  protected
    procedure LoadOptions;
    procedure SaveOptions;
  public
    { Public declarations }
  end;

var
  fmSHX: TfmSHX;

  function SHXOptionsExecute(AOptions: TIniFile; AOwner: TComponent): boolean;

implementation

uses
  fPaths;

{$R *.dfm}

procedure TfmSHX.LoadOptions;
begin
  cbUseSHXFonts.Checked := bUseSHXFonts;
  edSHXSearchPath.Text := sSHXSearchPaths;
  edSHXDefaultPath.Text := sDefaultSHXPath;
  edSHXDefaultFont.Text := sDefaultSHXFont;
end;

procedure TfmSHX.SaveOptions;
begin
  bUseSHXFonts := cbUseSHXFonts.Checked;
  sSHXSearchPaths := edSHXSearchPath.Text;
  sDefaultSHXPath := edSHXDefaultPath.Text;
  sDefaultSHXFont := edSHXDefaultFont.Text;
  FOptions.WriteBool(sGeneral, sUseSHX, bUseSHXFonts);
  FOptions.WriteString(sGeneral, sSHXPaths, sSHXSearchPaths);
  FOptions.WriteString(sGeneral, sSHXPath, sDefaultSHXPath);
  FOptions.WriteString(sGeneral, sSHXFont, sDefaultSHXFont);
  {$IFNDEF VER100}
  FOptions.UpdateFile;
  {$ENDIF}
end;

function SHXOptionsExecute(AOptions: TIniFile; AOwner: TComponent): boolean;
begin
  fmSHX := TfmSHX.Create(AOwner);
  with fmSHX do
  begin
    FOptions := AOptions;
    LoadOptions;
    Result := ShowModal = mrOk;
    if Result then
    begin
      SaveOptions;
    end;
    Free;
  end;
  Result := True;
end;

procedure TfmSHX.cbUseSHXFontsClick(Sender: TObject);
var
  I: integer;
begin
  for I := 0 to Panel1.ControlCount - 1 do
  begin
    Panel1.Controls[I].Enabled := cbUseSHXFonts.Checked;
  end;
  bUseSHXFonts := cbUseSHXFonts.Checked;
end;

procedure TfmSHX.btnSHXSearchPathClick(Sender: TObject);
var
  S: string;
begin
  S := edSHXSearchPath.Text;
  if GetPathsExcute(S, True) then
  begin
    edSHXSearchPath.Text := S;
  end;
end;

procedure TfmSHX.FormCreate(Sender: TObject);
begin
  LoadOptions;
  cbUseSHXFontsClick(Sender);
end;

procedure TfmSHX.btnSHXDefaultPathClick(Sender: TObject);
var
  vDir: string;
  w: WideString;
begin
  if SelectDirectory('', '', w) then
  begin
    vDir := string(w);
    edSHXDefaultPath.Text := vDir;
  end;
end;

procedure TfmSHX.btnOkClick(Sender: TObject);
begin
  {$IFNDEF VER100}
  FOptions.UpdateFile;
  {$ENDIF}
end;

end.
 