unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ExtDlgs, ExtCtrls, StdCtrls, JPEG,
  {$IFNDEF sgDXFONLY}
  DWG, HPGL2, SVG, CGM,
  {$ENDIF}
  DXFImage;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Image1: TImage;
    OpenPictureDialog1: TOpenPictureDialog;
    Button2: TButton;
    PaintBox1: TPaintBox;
    Button3: TButton;
    SavePictureDialog1: TSavePictureDialog;
    Button4: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    procedure PaintAll(ACanvas: TCanvas);
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
begin
  if OpenPictureDialog1.Execute then
    Image1.Picture.LoadFromFile(OpenPictureDialog1.FileName);
end;

var
  CADImage: TsgDXFImage;
  BMPImage: TBitmap;

procedure TForm1.Button2Click(Sender: TObject);
begin
  if OpenPictureDialog1.Execute then
  begin
    if (LowerCase(ExtractFileExt(OpenPictureDialog1.FileName)) = '.dxf') then
    begin
      CADImage := TsgDXFImage.Create;
      CADImage.LoadFromFile(OpenPictureDialog1.FileName);
    end;
    if LowerCase(ExtractFileExt(OpenPictureDialog1.FileName)) = '.bmp' then
    begin
      BMPImage := TBitmap.Create;
      BMPImage.LoadFromFile(OpenPictureDialog1.FileName);
    end;
  end;
  PaintBox1.Invalidate;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  BMPImage.Free;
  CADImage.Free;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  PaintAll(PaintBox1.Canvas);
end;

procedure TForm1.PaintAll(ACanvas: TCanvas);
begin
  if CADImage <> nil then
    ACanvas.StretchDraw(Rect(5, 5, 150, 150), CADImage);
  if BMPImage <> nil then
    ACanvas.StretchDraw(Rect(5, 160, 150, 350), BMPImage);
end;

procedure TForm1.Button3Click(Sender: TObject);
var
  Bitmap:TBitmap;
begin
  if SavePictureDialog1.Execute then
  begin
    Bitmap := TBitmap.Create;
    try
      Bitmap.Width := 1000;
      Bitmap.Height := 1000;
      PaintAll(Bitmap.Canvas);
      Bitmap.SaveToFile(SavePictureDialog1.FileName);
    finally
      Bitmap.Free;
    end;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  OpenPictureDialog1.Filter := GraphicFilter(TGraphic);
end;

procedure TForm1.Button4Click(Sender: TObject);
var
  vBmp: TBitmap;
  vJPG: TJPEGImage;
  vDWG: TsgDXFImage;
begin
  vBmp := TBitmap.Create;
  vJPG := TJPEGImage.Create;
  if OpenPictureDialog1.Execute then
  begin
    try
      if (LowerCase(ExtractFileExt(OpenPictureDialog1.FileName)) = '.dwg') then
      begin
        vDWG := TsgDWGImage.Create;
        vDWG.LoadFromFile(OpenPictureDialog1.FileName);
      end;
      vBmp.Width := 1000; // for instance
      vBmp.Height := Round(1000 * vDWG.Height / vDWG.Width);
      vBmp.Canvas.StretchDraw(Rect(0, 0, vBmp.Width, vBmp.Height), vDWG);
      vJPG.Assign(vBmp);
      if SavePictureDialog1.Execute then
        vJPG.SaveToFile(SavePictureDialog1.FileName);
    finally
      vBmp.Free;
      vJPG.Free;
    end;
  end;
end;

end.
