//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Unit2.h"
#include "Unit1.h"
#include <sgConsts.hpp>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TfrmShowPoint *frmShowPoint;
bool LockChange = false;
//---------------------------------------------------------------------------
__fastcall TfrmShowPoint::TfrmShowPoint(TComponent* Owner)
  : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TfrmShowPoint::dtnOKClick(TObject *Sender)
{
  TFPoint SearchPoint;
  TFPoint vFPoint;
  double vScale;
  TFRect vExt;
  TFRect vFRect;
  char DS;

  DS = DecimalSeparator;
  try
  {
    vExt = ((TsgDXFImage *)(Form1->sgPaintBox->Picture->Graphic))->Extents;
    DecimalSeparator = '.';
    try
    {
      SearchPoint.X = StrToFloat(edtXCoord->Text.c_str());
      SearchPoint.Y = StrToFloat(edtYCoord->Text.c_str());
      SearchPoint.Z = StrToFloat(edtZCoord->Text.c_str());  //0.0;
      vScale = StrToFloat(edtScale->Text.c_str()) / 100.0;
      if ((vExt.Left > SearchPoint.X) || (vExt.Right < SearchPoint.X) ||
        (vExt.Top < SearchPoint.Y) || (vExt.Bottom > SearchPoint.Y))
        ShowMessage("This point not in drawing extents.");
      else
      {
        Form1->sgPaintBox->ShowPoint(SearchPoint, vScale);
        Close();
      }
    }
    __finally
    {
      DecimalSeparator = DS;
    }
  }
  catch (Exception &exception)
  {
    ShowMessage("Value incorrect");
  }
}
//---------------------------------------------------------------------------

void __fastcall TfrmShowPoint::edtKeyPress(TObject *Sender,
      char &Key)
{
  char TempKey = 0;
  char *S = (char *)malloc(StrLen(((TEdit *)(Sender))->Text.c_str())+1);
  StrCopy(S, ((TEdit *)(Sender))->Text.c_str());

  if ((Key == ',')||(Key == '.'))
  {
    Key = '.';
    if (AnsiPos(".", S) <= 0)
      TempKey = Key;
  }
  if ((Key == '+')||(Key == '-'))
  {
    if ((AnsiPos("+", S) <= 0) && (AnsiPos("-", S) <= 0))
      TempKey = Key;
  }
  if (((Key >= '0')&&(Key <= '9'))||(Key == '\b'))
    TempKey = Key;
  free(S);
  Key = TempKey;
}
//---------------------------------------------------------------------------

void __fastcall TfrmShowPoint::edtChange(TObject *Sender)
{
  int I, J = 0, vBeg = 0;
  int vLen = StrLen(((TEdit *)(Sender))->Text.c_str());
  if ((!LockChange)&&(vLen > 0))
  {
    char *S = (char *)malloc(vLen+1);
    StrLCopy(S, ((TEdit *)(Sender))->Text.c_str(), vLen);
    char *vS = (char *)malloc(vLen+1);
    if ((S[0] == '-')||(S[0] == '+'))
    {
      vS[J] = S[vBeg];
      vBeg++;
      J++;
    }
    for(I = vBeg; I < vLen; I++)
    {
      if ((S[I] != '-')&&(S[I] != '+'))
      {
        vS[J] = S[I];
        J++;
      }
    }
    vS[J] = (char)0;
    LockChange = true;
    ((TEdit *)(Sender))->Text = vS;
    LockChange = false;
    free(S);
    free(vS);
  }
}
//---------------------------------------------------------------------------

void __fastcall TfrmShowPoint::FormShow(TObject *Sender)
{
  char DC;
  DC = DecimalSeparator;
  try
  {
    DecimalSeparator = '.';
    edtScale->Text = FloatToStr(Form1->sgPaintBox->Scale * 100.0);
  }
  __finally
  {
    DecimalSeparator = DC;
  }
}
//---------------------------------------------------------------------------



