// Borland C++ Builder
// Copyright (c) 1995, 2002 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SHX.pas' rev: 6.00

#ifndef SHXHPP
#define SHXHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <SysUtils.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Shx
{
//-- type declarations -------------------------------------------------------
struct TsgSHXRecord;
typedef TsgSHXRecord *PsgSHXRecord;

struct TsgSHXRecord
{
	Word ShapeNumber;
	Word DefBytes;
	AnsiString ShapeName;
	unsigned BytesPos;
	char *ShapeBytes;
	Classes::TList* ShapePoly;
	Classes::TList* ShapePolyVert;
	double Xoff;
	double Yoff;
	double Scaleoff;
	double FirstDown;
	double LastDown;
	double Top;
	double Bottom;
	int Start;
} ;

#pragma option push -b-
enum TsgTextGeneration { ttNormal, ttBackward, ttUpSideDown };
#pragma option pop

struct TsgSHXVertex;
typedef TsgSHXVertex *PsgSHXVertex;

struct TsgSHXVertex
{
	double X;
	double Y;
	double Bulge;
	bool PenDown;
} ;

struct TsgTextStyle;
typedef TsgTextStyle *PsgTextStyle;

struct TsgTextStyle
{
	AnsiString FontPath;
	AnsiString BigFontPath;
	AnsiString Name;
	TsgTextGeneration TextGeneration;
	double ObliqueAngle;
	double Width;
	bool Vertical;
	bool UpSideDown;
	bool Backwards;
	int FontIndex;
	int BigFontIndex;
	bool FontExists;
} ;

#pragma option push -b-
enum TsgSHXKinds { tkNormSHX, tkBigSHX, tkUnicodeSHX };
#pragma option pop

class DELPHICLASS TsgSHXFont;
class PASCALIMPLEMENTATION TsgSHXFont : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	double FLineFeed;
	int FAbove;
	int FBelow;
	AnsiString FName;
	Word FNumChars;
	TsgSHXKinds FKind;
	bool FLoaded;
	Byte FModes;
	Byte FEmbtype;
	Byte FEncoding;
	Classes::TList* FShapes;
	Word NBigFontRanges;
	bool FExtndBig;
	Byte FCharHeight;
	Byte FCharWidth;
	Word BigFontRanges[64][2];
	Byte FixedTable[255];
	int __fastcall FindSymbol(Word N, bool FixedSize);
	void __fastcall CleareShapes(void);
	AnsiString __fastcall GetName();
	void __fastcall ParseBigSHX(Classes::TStream* AStream);
	void __fastcall ParseNormSHX(Classes::TStream* AStream);
	void __fastcall ParseUnicodeSHX(Classes::TStream* AStream);
	void __fastcall ReadUnicodeSHX(Word N);
	void __fastcall ReadNormSHX(Word N);
	void __fastcall ReadBigSHX(Word N);
	void __fastcall PrepareShapes(Classes::TList* AList, bool FixedSize);
	bool __fastcall ProcessSymb(Word N, double &InsX, double &InsY, double &Scale, bool Vert, bool Backward, Classes::TList* Poly);
	bool __fastcall SubSymb(Word N, double &InsX, double &InsY, double &Scale, bool Vert, bool Backward, Classes::TList* Poly);
	bool __fastcall ExtSubSymb(Word N, double &InsX, double &InsY, double &Scale, Byte CharWidth, Byte CharHeight, bool Vert, bool Backward, Classes::TList* Poly);
	int __fastcall GetAbove(void);
	double __fastcall GetLineFeed(void);
	int __fastcall GetBelow(void);
	Word __fastcall GetNumChars(void);
	bool __fastcall GetLoaded(void);
	bool __fastcall BigFontInRange(Byte c);
	bool __fastcall BigFontWordInRange(Word c);
	
public:
	__fastcall TsgSHXFont(const AnsiString AFontPath);
	__fastcall virtual ~TsgSHXFont(void);
	bool __fastcall GetSymbol(Word Symb, double InX, double InY, bool Vert, bool Backward, bool Underscore, bool Overscore, Classes::TList* Poly, double &OutX, double &OutY);
	bool __fastcall GetScaledSymbol(Word Symb, double InX, double InY, double Scale, bool Vert, bool Backward, bool Underscore, bool Overscore, Classes::TList* Poly, double &OutX, double &OutY);
	bool __fastcall Load(void);
	__property double LineFeed = {read=GetLineFeed};
	__property int Above = {read=GetAbove, nodefault};
	__property int Below = {read=GetBelow, nodefault};
	__property bool Loaded = {read=GetLoaded, nodefault};
	__property AnsiString Name = {read=GetName};
	__property Word NumChars = {read=GetNumChars, nodefault};
};


class DELPHICLASS TsgSHXFontList;
class PASCALIMPLEMENTATION TsgSHXFontList : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	AnsiString FDefaultFont;
	AnsiString FDefaultFontPath;
	Classes::TStringList* FFonts;
	Classes::TStringList* FStyles;
	Classes::TStringList* FSearchPath;
	Classes::TStringList* FMissedFonts;
	Classes::TStringList* FSubstFonts;
	AnsiString __fastcall GetDefaultFont();
	Classes::TStringList* __fastcall GetFonts(void);
	Classes::TStringList* __fastcall GetSearchPath(void);
	Classes::TStringList* __fastcall GetMissedFonts(void);
	Classes::TStringList* __fastcall GetStyles(void);
	AnsiString __fastcall GetDefaultFontPath();
	void __fastcall SetDefaultFontPath(const AnsiString Value);
	
public:
	__fastcall TsgSHXFontList(const AnsiString ASearchPath, const AnsiString ADefault);
	__fastcall virtual ~TsgSHXFontList(void);
	void __fastcall AddStyle(const AnsiString AName, const AnsiString AFontName, const AnsiString ABigFontName, bool AVertical, bool AUpSideDown, bool ABackwards, double AObliqueAngle, double AWidth);
	void __fastcall SetSubstFonts(Classes::TStrings* ASubstFonts);
	__property AnsiString DefaultFont = {read=GetDefaultFont};
	__property AnsiString DefaultFontPath = {read=GetDefaultFontPath, write=SetDefaultFontPath};
	__property Classes::TStringList* Fonts = {read=GetFonts};
	__property Classes::TStringList* Styles = {read=GetStyles};
	__property Classes::TStringList* SearchPath = {read=GetSearchPath};
	__property Classes::TStringList* MissedFonts = {read=GetMissedFonts};
};


//-- var, const, procedure ---------------------------------------------------
extern PACKAGE void __fastcall SHXFreePoly(Classes::TList* &Poly);
extern PACKAGE void __fastcall GetSHXTextBox(TsgSHXFontList* ASHXStyles, const AnsiString Style, const AnsiString Text, const WideString WideText, bool Vertical, int &Above, int &Below, double &Width, double &Height, double &RealLeft, double &RealBottom, double &RealRight, double &RealTop);
extern PACKAGE void __fastcall DrawSHXTextBox(TsgSHXFontList* ASHXStyles, const AnsiString Font, const AnsiString Text, const WideString WideText, bool Vertical, int &Above, int &Below, double &Width, double &Height, double &RealLeft, double &RealBottom, double &RealRight, double &RealTop);
extern PACKAGE void __fastcall GetSHXText(TsgSHXFontList* ASHXStyles, const AnsiString Style, AnsiString Text, WideString WideText, Classes::TList* Poly, int &Above, int &Below, double &Left, double &Bottom, double &Right, double &Top);
extern PACKAGE void __fastcall DrawSHXText(TsgSHXFontList* ASHXStyles, const AnsiString Font, AnsiString Text, WideString WideText, bool Vertical, bool Backward, Classes::TList* Poly, int &Above, int &Below, double &Left, double &Bottom, double &Right, double &Top);
extern PACKAGE bool __fastcall IsUnicodeSHX(TsgSHXFontList* ASHXStyles, const AnsiString AFontName);

}	/* namespace Shx */
using namespace Shx;
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SHX
