/*
 *
 *	PlSqlDebug - Oracle PL*SQL Debugging aid.
 *
 *	Copyright (c) 1997-2001 by Material Dreams
 *	All rights reserved.
 *	www.materialdreams.com
 *
 *	The user executing this procedure must have the right to execute
 *	the dbms_pipe package.
 *	Use GRANT EXECUTE ON dbms_pipe to <username> to grant the rights.
 *
 */

CREATE OR REPLACE PROCEDURE SendDebugMessage (theMessage IN VARCHAR2, thePipe IN VARCHAR2 DEFAULT 'plsql_debug') AS
status	NUMBER;
BEGIN
	dbms_pipe.pack_message(LENGTH(theMessage));
	dbms_pipe.pack_message(theMessage);
	status := dbms_pipe.send_message(thePipe);
	IF status != 0 THEN
		raise_application_error(20099, 'Debug error');
	END IF;
END SendDebugMessage;
/

CREATE OR REPLACE PROCEDURE SendTraceMessage (theMessage IN VARCHAR2, thePipe IN VARCHAR2 DEFAULT 'plsql_debug') AS
aMessage	VARCHAR2(2000);
BEGIN
	aMessage := TO_CHAR(SYSDATE) || ': ' || theMessage;
	SendDebugMessage(aMessage, thePipe);
END SendTraceMessage;
/

CREATE PUBLIC SYNONYM SendDebugMessage FOR SendDebugMessage;
CREATE PUBLIC SYNONYM SendTraceMessage FOR SendTraceMessage;
