int ReadMoleculeGAMESS(char* fname)
{
  char s[90],stype[8],ss[12];
  int i,cread=0,bread=0,a[6],ii,j,in[3];
  float it,x,y,z,b[6];
  FILE *f;

  f=fopen(fname,"r");
  if(f==NULL) return -1;
  printf("Open GAMESS/G98 OUT-file: %s\n",fname);

  do {
    fgets(s,80,f);
    if ((strstr(s,"ATOM      ATOMIC                      COORDINATES (BOHR)")!=NULL)) {
      puts("Found GAMESS bohr cartesian coordinates, reading ...");
      fgets(s,80,f);
      i=0;
      for (;;) {
        fgets(s,80,f);
        if (s[0]==0x0A) break;
        sscanf(s,"%s %f %f %f %f\n",&stype,&it,&x,&y,&z);
        atoms[i].x=(GLdouble)x*0.529177249;  atoms[i].y=(GLdouble)y*0.529177249;  atoms[i].z=(GLdouble)z*0.529177249;
        atoms[i].type=(int)it;
        if(debug)printf("%3d %9.6f %9.6f %9.6f\n",atoms[i].type,x,y,z);
        i++;
      }
      NumAtoms=i;
if(debug)printf("NumAtoms=%d\n",NumAtoms);
      cread=1;
    };
    if (strstr(s,"COORDINATES OF ALL ATOMS ARE (ANGS)")!=NULL) { 
      puts("Found GAMESS cartesian coordinates, reading ...");
      fgets(s,80,f); fgets(s,80,f);
      i=0;
      for (;;) {
        fgets(s,80,f);
        if ((s[0]==0x0A)||(strstr(s," COORDINATES OF")!=NULL)) break;
        sscanf(s,"%s %f %f %f %f\n",&stype,&it,&x,&y,&z);
        atoms[i].x=(GLdouble)x;  atoms[i].y=(GLdouble)y;  atoms[i].z=(GLdouble)z;
        atoms[i].type=(int)it;
        if(debug)printf("%3d %9.6f %9.6f %9.6f\n",atoms[i].type,x,y,z);
        i++;
      }
      NumAtoms=i;
if(debug)printf("NumAtoms=%d\n",NumAtoms);
      cread=1;
    };
    if (strstr(s,"Standard orientation:")!=NULL ||
        strstr(s,"Input orientation:"   )!=NULL ||
        strstr(s,"Z-Matrix orientation:")!=NULL) {
      puts("Found G98 cartesian coordinates, reading ...");
      fgets(s,80,f); fgets(s,80,f); fgets(s,80,f); fgets(s,80,f);
      i=0;
      for (;;) {
        fgets(s,80,f);
        if ((s[0]==0x0A)||(strstr(s,"------------------")!=NULL)) break;
        sscanf(s,"%d %d %d %f %f %f\n",&in[0],&in[1],&in[2],&x,&y,&z);
        atoms[i].x=(GLdouble)x;  atoms[i].y=(GLdouble)y;  atoms[i].z=(GLdouble)z;
        atoms[i].type=in[1];
        if(debug)printf("%3d %9.6f %9.6f %9.6f\n",atoms[i].type,x,y,z);
        i++;
      }
      NumAtoms=i;
if(debug)printf("NumAtoms=%d\n",NumAtoms);
      cread=1;
    };
    if (strstr(s,"BOND ORDER")!=NULL) {
      puts("Found bond orders, reading ...");
      fgets(s,80,f); fgets(s,80,f); fgets(s,80,f); fgets(s,80,f);
      i=0;
      for (;;) {
        fgets(s,80,f);
        if (s[0]==0x0A) break;
        a[0]=0; a[2]=0; a[4]=0;
        sscanf(s,"%d %d %f %f %d %d %f %f %d %d %f %f \n",
                                 &a[0],&a[1],&b[0],&b[1],
                                 &a[2],&a[3],&b[2],&b[3],
                                 &a[4],&a[5],&b[4],&b[5]);
        if((a[0]!=0)&&(b[1]>=BondTresh)) {
          bonds[i].a=a[0]; bonds[i].b=a[1]; bonds[i].o=b[1]/10;
          if(debug)printf("bond:%2d %3d - %3d : %5.3f\n",i,bonds[i].a,bonds[i].b,b[1]); i++;}
        if((a[2]!=0)&&(b[3]>=BondTresh)) {
          bonds[i].a=a[2]; bonds[i].b=a[3]; bonds[i].o=b[3]/10;
          if(debug)printf("bond:%2d %3d - %3d : %5.3f\n",i,bonds[i].a,bonds[i].b,b[3]); i++;}
        if((a[4]!=0)&&(b[5]>=BondTresh)) {
          bonds[i].a=a[4]; bonds[i].b=a[5]; bonds[i].o=b[5]/10;
          if(debug)printf("bond:%2d %3d - %3d : %5.3f\n",i,bonds[i].a,bonds[i].b,b[5]); i++;}
      }
      NumBonds=i;
      if(debug)printf("NumBonds=%d\n",NumBonds);
      bread=1;
    }
    if (strstr(s,"TOTAL MULLIKEN")!=NULL) {
      puts("Found mulliken charges, reading ...");
      fgets(s,80,f);
      i=0;
      for (;;) {
        fgets(s,80,f);
        if (s[0]==0x0A) break;
        sscanf(s,"%d %s %f %f %f %f\n",&a[0],stype,&b[0],&b[1],&b[2],&b[3]);
        atoms[i].c=b[1]/2;
        if(debug)printf("%3d %7.4f\n",i,b[1]);
        i++;
      }
    }
    if (strstr(s,"MOPAC CHARGES")!=NULL) {
      puts("Found MOPAC charges, reading ...");
      fgets(s,80,f);  fgets(s,80,f);
      i=0;
      for (;;) {
        fgets(s,80,f);
        if (s[0]==0x0A) break;
        sscanf(s,"%d %s %f %f\n",&a[0],stype,&b[0],&b[1]);
        atoms[i].c=b[0]/2;
        if(debug)printf("%3d %7.4f\n",i,b[1]);
        i++;
      }
    }
    if (strstr(s,"Total atomic charges:")!=NULL) {
      puts("Found G98 charges, reading ...");
      fgets(s,80,f);
      i=0;
      for (;;) {
        fgets(s,80,f);
        if ((s[0]==0x0A)||(strstr(s,"Sum of Mulliken charges")!=NULL)) break;
        sscanf(s,"%d %s %f\n",&a[0],&stype,&b[0]);
        atoms[i].c=b[0]/2;
        if(debug)printf("%3d %7.4f\n",i,b[1]);
        i++;
      }
    }
    if (strstr(s,"MULLIKEN ATOMIC POPULATION IN EACH MOLECULAR ORBITAL")!=NULL) {
      puts("Found Mulliken Atomic population in each MO, reading ...");
Ag:   fgets(s,80,f);
      for(i=0;i<5;i++) a[i]=0;
      fgets(s,80,f);            // 1 2 3 4 5
      sscanf(s,"%d %d %d %d %d\n",&a[0],&a[1],&a[2],&a[3],&a[4]);
//if(debug)printf("#MO: %d %d %d %d %d\n",a[0],a[1],a[2],a[3],a[4]);
      fgets(s,80,f);      fgets(s,80,f);      fgets(s,80,f);
      for(i=1;i<=NumAtoms;i++) {
        fgets(s,80,f);
        sscanf(s,"%d %f %f %f %f %f\n",&ii,&b[0],&b[1],&b[2],&b[3],&b[4]);
//if(debug)printf("%s\n",s);
if(debug)printf("Val: %d %f %f %f %f %f\n",ii,b[0],b[1],b[2],b[3],b[4]);
if(debug)printf("MulPop: ");
        for(j=0;j<5;j++) if(a[j]!=0) {
          MulPop[a[j]][i]=b[j];
          NumOrb=a[j];
if(debug)printf("%3d,%3d=%7.4f ",a[j],i,MulPop[a[j]][i]);
        }
if(debug)printf("\n");
      }
      if(a[4]!=0) goto Ag;
if(debug)printf("NumOrb=%d\n",NumOrb);
    }
    if (strstr(s,"FREQUENCIES IN CM**-1, IR INTENSITIES IN DEBYE**2/AMU-ANGSTROM**2")!=NULL) {
      puts("Found GAMESS frequencies, reading ...");
      freqss=1;
      for(i=1;i<=NumAtoms*3;i+=5) {
        fgets(s,90,f);          // Space
        fgets(s,90,f);          // Numbers of Freqs
        if (strstr(s,"***************")!=NULL) for(j=1;j<=5;j++) fgets(s,90,f);
        fgets(s,90,f);          // Freqs
        ss[8]=0;
        sscanf(strncpy(ss,s+22,8),"%f",&it); freqs[i  ].freqv=(GLdouble)it;
        sscanf(strncpy(ss,s+34,8),"%f",&it); freqs[i+1].freqv=(GLdouble)it;
        sscanf(strncpy(ss,s+46,8),"%f",&it); freqs[i+2].freqv=(GLdouble)it;
        sscanf(strncpy(ss,s+58,8),"%f",&it); freqs[i+3].freqv=(GLdouble)it;
        sscanf(strncpy(ss,s+70,8),"%f",&it); freqs[i+4].freqv=(GLdouble)it;
        ss[1]=0;
        if (strstr(strncpy(ss,s+31,1),"I")!=NULL) freqs[i  ].img=1; else  freqs[i  ].img=0;
        if (strstr(strncpy(ss,s+43,1),"I")!=NULL) freqs[i+1].img=1; else  freqs[i+1].img=0;
        if (strstr(strncpy(ss,s+55,1),"I")!=NULL) freqs[i+2].img=1; else  freqs[i+2].img=0;
        if (strstr(strncpy(ss,s+67,1),"I")!=NULL) freqs[i+3].img=1; else  freqs[i+3].img=0;
        if (strstr(strncpy(ss,s+79,1),"I")!=NULL) freqs[i+4].img=1; else  freqs[i+4].img=0;
        fgets(s,90,f);          // Intens
        if (strstr(s,"INTENSITY:")!=NULL) {
          sscanf(strncpy(ss,s+22,8),"%f",&it); freqs[i  ].inten=(GLdouble)it;
          sscanf(strncpy(ss,s+34,8),"%f",&it); freqs[i+1].inten=(GLdouble)it;
          sscanf(strncpy(ss,s+46,8),"%f",&it); freqs[i+2].inten=(GLdouble)it;
          sscanf(strncpy(ss,s+58,8),"%f",&it); freqs[i+3].inten=(GLdouble)it;
          sscanf(strncpy(ss,s+70,8),"%f",&it); freqs[i+4].inten=(GLdouble)it;
          fgets(s,90,f);          // Space
        } else for(j=0;j<5;j++) freqs[i+j].inten=0;
        ss[11]=0;
        for(j=1;j<=NumAtoms;j++) {
          fgets(s,90,f);        // x
          sscanf(strncpy(ss,s+21,11),"%f",&it); freqs[i  ].x[j]=(GLdouble)it;
          sscanf(strncpy(ss,s+33,11),"%f",&it); freqs[i+1].x[j]=(GLdouble)it;
          sscanf(strncpy(ss,s+45,11),"%f",&it); freqs[i+2].x[j]=(GLdouble)it;
          sscanf(strncpy(ss,s+57,11),"%f",&it); freqs[i+3].x[j]=(GLdouble)it;
          sscanf(strncpy(ss,s+69,11),"%f",&it); freqs[i+4].x[j]=(GLdouble)it;
          fgets(s,90,f);        // y
          sscanf(strncpy(ss,s+21,11),"%f",&it); freqs[i  ].y[j]=(GLdouble)it;
          sscanf(strncpy(ss,s+33,11),"%f",&it); freqs[i+1].y[j]=(GLdouble)it;
          sscanf(strncpy(ss,s+45,11),"%f",&it); freqs[i+2].y[j]=(GLdouble)it;
          sscanf(strncpy(ss,s+57,11),"%f",&it); freqs[i+3].y[j]=(GLdouble)it;
          sscanf(strncpy(ss,s+69,11),"%f",&it); freqs[i+4].y[j]=(GLdouble)it;
          fgets(s,90,f);        // z
          sscanf(strncpy(ss,s+21,11),"%f",&it); freqs[i  ].z[j]=(GLdouble)it;
          sscanf(strncpy(ss,s+33,11),"%f",&it); freqs[i+1].z[j]=(GLdouble)it;
          sscanf(strncpy(ss,s+45,11),"%f",&it); freqs[i+2].z[j]=(GLdouble)it;
          sscanf(strncpy(ss,s+57,11),"%f",&it); freqs[i+3].z[j]=(GLdouble)it;
          sscanf(strncpy(ss,s+69,11),"%f",&it); freqs[i+4].z[j]=(GLdouble)it;
        }
        for(j=1;j<=10;j++) {
          fgets(s,90,f);          // Fignya
        }
      }
    }
    if (strstr(s,"reduced masses (AMU), force constants (mDyne/A) and normal coordinates:")!=NULL) {
      puts("Found G98 frequencies, reading ...");
      freqss=1;
      for(i=1;i<=NumAtoms*3-6;i+=3) {
        fgets(s,90,f);          // Numbers of Freqs
        fgets(s,90,f);          // A'
        fgets(s,90,f);          // Freqs
        ss[9]=0;
        sscanf(strncpy(ss,s+17,9),"%f",&it); if(it<0) {it=-it; freqs[i  ].img=1;} else freqs[i  ].img=0; freqs[i  ].freqv=(GLdouble)it;
        sscanf(strncpy(ss,s+40,9),"%f",&it); if(it<0) {it=-it; freqs[i+1].img=1;} else freqs[i+1].img=0; freqs[i+1].freqv=(GLdouble)it;
        sscanf(strncpy(ss,s+63,9),"%f",&it); if(it<0) {it=-it; freqs[i+2].img=1;} else freqs[i+2].img=0; freqs[i+2].freqv=(GLdouble)it;
        fgets(s,90,f);          // Red. masses
        fgets(s,90,f);          // Frc consts
        fgets(s,90,f);          // IR Inten
        sscanf(strncpy(ss,s+17,9),"%f",&it); freqs[i  ].inten=(GLdouble)it;
        sscanf(strncpy(ss,s+40,9),"%f",&it); freqs[i+1].inten=(GLdouble)it;
        sscanf(strncpy(ss,s+63,9),"%f",&it); freqs[i+2].inten=(GLdouble)it;
        fgets(s,90,f);          // Raman Activ
        fgets(s,90,f);          // Depolar
        fgets(s,90,f);          // Atom AN
        ss[5]=0;
        for(j=1;j<=NumAtoms;j++) {
          fgets(s,90,f);        // x
          sscanf(strncpy(ss,s+12,5),"%f",&it); freqs[i  ].x[j]=(GLdouble)it;
          sscanf(strncpy(ss,s+19,5),"%f",&it); freqs[i  ].y[j]=(GLdouble)it;
          sscanf(strncpy(ss,s+26,5),"%f",&it); freqs[i  ].z[j]=(GLdouble)it;
          sscanf(strncpy(ss,s+35,5),"%f",&it); freqs[i+1].x[j]=(GLdouble)it;
          sscanf(strncpy(ss,s+42,5),"%f",&it); freqs[i+1].y[j]=(GLdouble)it;
          sscanf(strncpy(ss,s+49,5),"%f",&it); freqs[i+1].z[j]=(GLdouble)it;
          sscanf(strncpy(ss,s+58,5),"%f",&it); freqs[i+2].x[j]=(GLdouble)it;
          sscanf(strncpy(ss,s+65,5),"%f",&it); freqs[i+2].y[j]=(GLdouble)it;
          sscanf(strncpy(ss,s+72,5),"%f",&it); freqs[i+2].z[j]=(GLdouble)it;
        }
      }
    }
    if (strstr(s,"CARTESIAN COORDINATES")!=NULL) {
      puts("Found MOPAC cartesian coordinates, reading ...");
      fgets(s,80,f); fgets(s,80,f); fgets(s,80,f);
      i=0;
      for (;;) {
        fgets(s,80,f);
        if (s[0]==0x0A) break;
        sscanf(s,"%u %s %f %f %f\n",&ii,&s,&x,&y,&z);
        atoms[i].x=(GLdouble)x;  atoms[i].y=(GLdouble)y;  atoms[i].z=(GLdouble)z;
                       atoms[i].type=-1;
        if (s[0]=='H') atoms[i].type= 1;
        if (s[0]=='B') atoms[i].type= 5;
        if (s[0]=='C') atoms[i].type= 6;
        if (s[0]=='N') atoms[i].type= 7;
        if (s[0]=='O') atoms[i].type= 8;
        if (s[0]=='F') atoms[i].type= 9;
        if (s[0]=='P') atoms[i].type=15;
        if (s[0]=='S') atoms[i].type=16;
        if (s[0]=='I') atoms[i].type=53;
        if((s[0]=='S')&&(s[1]=='i')) atoms[i].type=14;
        if((s[0]=='C')&&(s[1]=='l')) atoms[i].type=17;
        if(atoms[i].type==-1) break;
if(debug)printf("%3d %9.6f %9.6f %9.6f\n",atoms[i].type,x,y,z);
        i++;
      }
      NumAtoms=i;
if(debug)printf("NumAtoms=%d\n",NumAtoms);
      cread=1;
    }
  } while (feof(f)==0);

  fclose(f);

  if(cread==0){puts("Cartesian coordinates not found."); return -1;}

  if(bread==0){
    CreateBond();
    bread=1;
  }

  return 0;
}