#include "vm_math.h"
#include "vm_func.h"

void myRender(GLenum mode)

{

  char anum[6];

  GLdouble rad, l, a;

  GLint i,sl;



  glMultMatrixf((GLfloat*)roma);

  revmat(roma,romb);

   

// Draw Atoms

    if(debug)printf("NumAtoms=%d\n",NumAtoms);

    if (bond==0) for(i=0;i<NumAtoms;i++)

        if (atoms[i].type!=-1) {

            glPushMatrix ();

            glTranslated (atoms[i].x, atoms[i].y, atoms[i].z);

            if (mode == GL_SELECT) glLoadName(at_level+i);

            if(debug)printf("at[%3d]xyz=%10.7f %10.7f %10.7f\n",i, atoms[i].x, atoms[i].y, atoms[i].z);

            if (morb==1) {

                glMaterialfv (GL_FRONT, GL_DIFFUSE, MulPopMat);

                rad=MulPop[monum][i+1]/2;

            } else if (chg==0) {

                glMaterialfv (GL_FRONT, GL_DIFFUSE, at_def[atoms[i].type-1]);

                if (trad==0) rad=at_rad [atoms[i].type-1]/2;

                else         rad=at_radv[atoms[i].type-1];

            } else {

                if(atoms[i].c>0) glMaterialfv (GL_FRONT, GL_DIFFUSE, PosChg);

                else             glMaterialfv (GL_FRONT, GL_DIFFUSE, NegChg);

                rad=fabs(atoms[i].c);

            }

            if(present) sl=32;else sl=16;

            if(wire) sl/=4;
	    OBJslices=sl;

            Sphere(rad);

            if(atnum && atoms[i].type!=-1) {

                glPushMatrix();

                glMultMatrixf((GLfloat*)romb);

                glColor4fv (White);

                glMaterialfv (GL_FRONT, GL_DIFFUSE, White);

                glNormal3f( 0, 0, 1 );

                glRasterPos3d (0, 0, rad + 0.05);

                sprintf (anum, "%d", i+1);

//                auxDrawStr (anum);

                glPopMatrix ();

            }

            glPopMatrix ();

        }

   


// Draw Bonds

    glMaterialfv(GL_FRONT, GL_DIFFUSE, bondmat);

    if(debug)printf("NumBonds=%d\n",NumBonds);

    if (trad==0) for(i=0;i<NumBonds;i++)

        if ((atoms[bonds[i].a-1].type!=-1)&&(atoms[bonds[i].b-1].type!=-1)) {

            if(dline) {

                if (mode == GL_SELECT) glLoadName(bn_level+i);

                glBegin    (GL_LINE_STRIP);

                glNormal3d (x1,y1,z1);

                glVertex3d (x1,y1,z1);

                glNormal3d (x2,y2,z2);

                glVertex3d (x2,y2,z2);

                glEnd ();

            } else {

                glPushMatrix ();

                if (mode == GL_SELECT) glLoadName(bn_level+i);

                glTranslatef(x1,y1,z1);

                l = len(x1,y1,z1,x2,y2,z2);

                if (l>0) {

                    a=acos((y2-y1)/l)/PI*180.0;

                    glRotatef(a, z2-z1, 0, x1-x2);

                }

                   if (wire) Cylinder (bonds[i].o, l);

                   else Cylinder (bonds[i].o, l);

                glPopMatrix ();

            }

        }



// Draw IR Vectors

    if(viewir==1&&freqss==1){

        glMaterialfv(GL_FRONT, GL_DIFFUSE, irmat);

        for(i=0;i<NumAtoms;i++){

            glPushMatrix ();

            glTranslatef(atoms[i].x, atoms[i].y, atoms[i].z);

            l = len(0,0,0,freqs[frcur].x[i+1],freqs[frcur].y[i+1],freqs[frcur].z[i+1]);

            l*=vt;

            if (l>0) {

                a=acos((atoms[i].y+vt*freqs[frcur].y[i+1]-atoms[i].y)/l)/PI*180.0;

                glRotatef(a,atoms[i].z+vt*freqs[frcur].z[i+1]-atoms[i].z,0,atoms[i].x-atoms[i].x-vt*freqs[frcur].x[i+1]);

            }

            Cylinder(0.05,l);

            glPopMatrix ();



            glPushMatrix ();

            glTranslatef(atoms[i].x+vt*freqs[frcur].x[i+1], atoms[i].y+vt*freqs[frcur].y[i+1], atoms[i].z+vt*freqs[frcur].z[i+1]);

            if (l>0) {

               glRotatef(a,atoms[i].z+vt*freqs[frcur].z[i+1]-atoms[i].z,0,atoms[i].x-atoms[i].x-vt*freqs[frcur].x[i+1]);

               glRotatef(-90,1,0,0);

            }

            glutSolidCone (0.1,0.3,10,10);

            glPopMatrix ();

        }

    }

  glPopMatrix();

}