/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.persistence.sql;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Category;
import org.nakedobjects.object.AggregateOid;
import org.nakedobjects.object.Naked;
import org.nakedobjects.object.NakedClass;
import org.nakedobjects.object.NakedCollection;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.NakedObjectStore;
import org.nakedobjects.object.ObjectNotFoundException;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.object.PersistenceType;
import org.nakedobjects.object.UpdateNotifier;
import org.nakedobjects.object.collection.InternalCollection;
import org.nakedobjects.object.reflect.Field;
import org.nakedobjects.persistence.sql.AutoSqlCollectionMapper;
import org.nakedobjects.persistence.sql.AutoSqlObjectMapper;
import org.nakedobjects.persistence.sql.DatabaseInitialisation;
import org.nakedobjects.persistence.sql.SqlCollectionMapper;
import org.nakedobjects.persistence.sql.SqlObjectMapper;
import org.nakedobjects.persistence.sql.SqlOid;
import org.nakedobjects.persistence.sql.SqlSerialNumbers;
import org.nakedobjects.utility.Log;

public class SqlObjectStore
implements NakedObjectStore {
    private static final Category LOG = Category.getInstance((Class)(class$org$nakedobjects$persistence$sql$SqlObjectStore == null ? (class$org$nakedobjects$persistence$sql$SqlObjectStore = SqlObjectStore.class$("org.nakedobjects.persistence.sql.SqlObjectStore")) : class$org$nakedobjects$persistence$sql$SqlObjectStore));
    private Hashtable objectMappers;
    private Hashtable collectionMappers;
    private SqlSerialNumbers serialNumbers = new SqlSerialNumbers(this);
    private Hashtable cache;
    private Log log;
    private UpdateNotifier notifier;
    static /* synthetic */ Class class$org$nakedobjects$persistence$sql$SqlObjectStore;

    public SqlObjectStore() throws ObjectStoreException {
        this.objectMappers = new Hashtable();
        this.collectionMappers = new Hashtable();
        this.cache = new Hashtable();
    }

    public void addElement(NakedCollection nakedCollection, NakedObject nakedObject) throws ObjectStoreException {
        this.collectionMapper(nakedCollection).add(nakedCollection.getOid(), nakedObject);
        this.notifier.broadcastAdd(nakedCollection, nakedObject);
    }

    public void addMapper(SqlObjectMapper sqlObjectMapper) throws ObjectStoreException {
        this.objectMappers.put(sqlObjectMapper.getNakedClass(), sqlObjectMapper);
    }

    public boolean areObjectsDistributed() {
        return false;
    }

    public boolean areObjectsProxied() {
        return false;
    }

    public Enumeration cache() {
        return this.cache.elements();
    }

    public void cache(NakedObject nakedObject) {
        if (nakedObject.getOid() == null) {
            throw new IllegalArgumentException("Objects OID must be set before it can be cached");
        }
        this.cache.put(nakedObject.getOid(), nakedObject);
    }

    public Enumeration classes() throws ObjectStoreException {
        return null;
    }

    public void clearCache(NakedObject nakedObject) {
        this.cache.remove(nakedObject.getOid());
    }

    public void clearCache() {
        this.cache.clear();
    }

    private SqlCollectionMapper collectionMapper(NakedCollection nakedCollection) throws ObjectStoreException {
        return this.collectionMapper(nakedCollection.getOid());
    }

    private SqlCollectionMapper collectionMapper(Object object) throws ObjectStoreException {
        String string;
        String string2;
        Object object2;
        if (object instanceof AggregateOid) {
            object2 = (AggregateOid)object;
            string2 = ((SqlOid)((AggregateOid)object2).getParentOid()).getNakedClass().getSingularName();
            string = ((AggregateOid)object2).getName();
        } else {
            string2 = "arbitrary collection";
            string = "elements";
        }
        object2 = string2 + "#" + string;
        SqlCollectionMapper sqlCollectionMapper = (SqlCollectionMapper)this.collectionMappers.get(object2);
        if (sqlCollectionMapper == null) {
            sqlCollectionMapper = new AutoSqlCollectionMapper(this, string2, string);
            this.collectionMappers.put(object2, sqlCollectionMapper);
        }
        return sqlCollectionMapper;
    }

    public boolean containsElement(NakedCollection nakedCollection, NakedObject nakedObject) throws ObjectStoreException {
        return this.collectionMapper(nakedCollection).containsElement(nakedCollection.getOid(), nakedObject);
    }

    public NakedObject createInstance(NakedClass nakedClass) throws ObjectStoreException {
        NakedObject nakedObject = nakedClass.acquireInstance();
        this.makePersistent(nakedObject);
        nakedObject.created();
        nakedObject.objectChanged();
        this.save(nakedObject);
        return nakedObject;
    }

    public void destroyObject(NakedObject nakedObject) throws ObjectStoreException {
        this.objectMapper(nakedObject).delete(nakedObject);
        this.clearCache(nakedObject);
    }

    public void endTransaction() throws ObjectStoreException {
        throw new RuntimeException("Not implmented");
    }

    public Vector getNextElements(NakedCollection nakedCollection, NakedObject nakedObject, int n) throws ObjectStoreException {
        return this.collectionMapper(nakedCollection).nextElements(nakedCollection.getOid(), nakedObject, n);
    }

    public Vector getNextInstances(NakedObject nakedObject, NakedObject nakedObject2, int n) throws ObjectStoreException {
        return this.objectMapper(nakedObject).nextInstances(nakedObject, nakedObject2, n);
    }

    public NakedObject getObject(Object object) throws ObjectNotFoundException, ObjectStoreException {
        if (this.isObjectCached(object)) {
            NakedObject nakedObject = (NakedObject)this.cache.get(object);
            if (!nakedObject.isResolved()) {
                nakedObject.resolve();
            }
            return nakedObject;
        }
        if (object instanceof SqlOid) {
            SqlOid sqlOid = (SqlOid)object;
            NakedClass nakedClass = sqlOid.getNakedClass();
            SqlObjectMapper sqlObjectMapper = this.objectMapper(nakedClass);
            NakedObject nakedObject = sqlOid.getNakedClass().acquireInstance();
            nakedObject.setOid(object);
            this.cache(nakedObject);
            sqlObjectMapper.readObject(nakedObject);
            nakedObject.setResolved();
            return nakedObject;
        }
        if (object instanceof AggregateOid) {
            AggregateOid aggregateOid = (AggregateOid)object;
            InternalCollection internalCollection = new InternalCollection(aggregateOid.getClass(), this.getObject(aggregateOid.getParentOid()));
            internalCollection.setOid(object);
            this.cache(internalCollection);
            internalCollection.setResolved();
            return internalCollection;
        }
        throw new ObjectNotFoundException("Invalid oid: must be an SqlOid or AggregateOid");
    }

    public Vector getPreviousElements(NakedCollection nakedCollection, NakedObject nakedObject, int n) throws ObjectStoreException {
        return this.collectionMapper(nakedCollection).previousElements(nakedCollection.getOid(), nakedObject, n);
    }

    public Vector getPreviousInstances(NakedObject nakedObject, NakedObject nakedObject2, int n) throws ObjectStoreException {
        return this.objectMapper(nakedObject).previousInstances(nakedObject, nakedObject2, n);
    }

    protected NakedObject getUnresolvedObject(SqlOid sqlOid) throws ObjectNotFoundException, ObjectStoreException {
        if (this.isObjectCached(sqlOid)) {
            return (NakedObject)this.cache.get(sqlOid);
        }
        NakedObject nakedObject = sqlOid.getNakedClass().acquireInstance();
        nakedObject.setOid(sqlOid);
        this.cache(nakedObject);
        return nakedObject;
    }

    public boolean hasInstances(NakedClass nakedClass) throws ObjectStoreException {
        return this.objectMapper(nakedClass).hasInstances();
    }

    public void setUpdateNotifier(UpdateNotifier updateNotifier) {
        this.notifier = updateNotifier;
    }

    public void init() throws ObjectStoreException {
        new DatabaseInitialisation(this).init();
    }

    public boolean isFirstElement(NakedCollection nakedCollection, NakedObject nakedObject) throws ObjectStoreException {
        return this.collectionMapper(nakedCollection).isFirstElement(nakedCollection.getOid(), nakedObject);
    }

    public boolean isFirstInstance(NakedObject nakedObject, NakedObject nakedObject2) throws ObjectStoreException {
        return this.objectMapper(nakedObject).isFirstInstance(nakedObject, nakedObject2);
    }

    public boolean isLastElement(NakedCollection nakedCollection, NakedObject nakedObject) throws ObjectStoreException {
        return this.collectionMapper(nakedCollection).isLastElement(nakedCollection.getOid(), nakedObject);
    }

    public boolean isLastInstance(NakedObject nakedObject, NakedObject nakedObject2) throws ObjectStoreException {
        return this.objectMapper(nakedObject).isLastInstance(nakedObject, nakedObject2);
    }

    public boolean isObjectCached(Object object) {
        return this.cache.containsKey(object);
    }

    public void makePersistent(NakedObject nakedObject) throws ObjectStoreException {
        if (nakedObject instanceof InternalCollection) {
            throw new IllegalArgumentException("Cannot persist an InternalCollection");
        }
        this.makePersistent(nakedObject, new Vector());
    }

    private void makePersistent(NakedObject nakedObject, Vector vector) throws ObjectStoreException {
        if (nakedObject == null || nakedObject.isPersistent() || vector.contains(nakedObject)) {
            return;
        }
        SqlObjectMapper sqlObjectMapper = this.objectMapper(nakedObject);
        SqlOid sqlOid = new SqlOid(nakedObject.getNakedClass(), sqlObjectMapper.createKey());
        vector.addElement(nakedObject);
        if (nakedObject instanceof NakedCollection) {
            NakedCollection nakedCollection = (NakedCollection)nakedObject;
            Enumeration enumeration = nakedCollection.elements();
            while (enumeration.hasMoreElements()) {
                NakedObject nakedObject2 = (NakedObject)enumeration.nextElement();
                this.makePersistent(nakedObject2, vector);
                this.addElement(nakedCollection, nakedObject2);
            }
            sqlObjectMapper.insert(nakedCollection, sqlOid.getDBKey());
        } else {
            Field[] fieldArray = nakedObject.getNakedClass().getFields();
            int n = 0;
            while (n < fieldArray.length) {
                Naked naked = fieldArray[n].get(nakedObject);
                if (naked instanceof InternalCollection) {
                    NakedCollection nakedCollection = (NakedCollection)naked;
                    AggregateOid aggregateOid = new AggregateOid(sqlOid, fieldArray[n].getName());
                    Enumeration enumeration = nakedCollection.elements();
                    while (enumeration.hasMoreElements()) {
                        NakedObject nakedObject3 = (NakedObject)enumeration.nextElement();
                        this.makePersistent(nakedObject3, vector);
                        this.collectionMapper(aggregateOid).add(aggregateOid, nakedObject3);
                    }
                } else if (naked instanceof NakedObject) {
                    this.makePersistent((NakedObject)naked, vector);
                }
                ++n;
            }
            sqlObjectMapper.insert(nakedObject, sqlOid.getDBKey());
        }
        nakedObject.setOid(sqlOid);
        nakedObject.setResolved();
        this.cache(nakedObject);
    }

    public String name() {
        return "SQL/JDBC Persistor, version 0.1";
    }

    public int numberOfElements(NakedCollection nakedCollection) throws ObjectStoreException {
        return this.collectionMapper(nakedCollection).numberOfElements(nakedCollection.getOid());
    }

    public int numberOfInstances(NakedObject nakedObject) throws ObjectStoreException {
        return this.objectMapper(nakedObject).numberOfInstances(nakedObject);
    }

    private SqlObjectMapper objectMapper(NakedObject nakedObject) throws ObjectStoreException {
        return this.objectMapper(nakedObject.getNakedClass());
    }

    private SqlObjectMapper objectMapper(NakedClass nakedClass) throws ObjectStoreException {
        SqlObjectMapper sqlObjectMapper = (SqlObjectMapper)this.objectMappers.get(nakedClass);
        if (sqlObjectMapper == null) {
            sqlObjectMapper = new AutoSqlObjectMapper(this, nakedClass);
            this.objectMappers.put(nakedClass, sqlObjectMapper);
        }
        return sqlObjectMapper;
    }

    public PersistenceType persistenceType() {
        return PersistenceType.AUTHORITATIVE;
    }

    public void removeElement(NakedCollection nakedCollection, NakedObject nakedObject) throws ObjectStoreException {
        this.collectionMapper(nakedCollection).remove(nakedCollection.getOid(), nakedObject);
        this.notifier.broadcastRemove(nakedCollection, nakedObject);
    }

    public void resolve(NakedObject nakedObject) throws ObjectStoreException {
        if (nakedObject instanceof NakedCollection) {
            nakedObject.setResolved();
        } else {
            this.objectMapper(nakedObject).readObject(nakedObject);
            nakedObject.setResolved();
        }
    }

    public void save(NakedObject nakedObject) throws ObjectStoreException {
        this.objectMapper(nakedObject).update(nakedObject);
        this.notifier.broadcastObject(nakedObject);
    }

    public long serialNumber(String string) throws ObjectStoreException {
        return new SqlSerialNumbers(this).serialNumber(string);
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void shutdown() {
        try {
            this.serialNumbers.getConnection().close();
        }
        catch (SQLException sQLException) {
            this.log.log("Failed to shutdown connection: " + sQLException.getMessage());
        }
        catch (ObjectStoreException objectStoreException) {
            this.log.log("Failed to shutdown server properly: " + objectStoreException.getMessage());
        }
    }

    public void startTransaction() throws ObjectStoreException {
        throw new RuntimeException("Not implmented");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

