/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.nakedobjects.object.Naked;
import org.nakedobjects.object.NakedCollection;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.object.control.About;
import org.nakedobjects.object.distribution.AssociateRequest;
import org.nakedobjects.object.distribution.DissociateRequest;
import org.nakedobjects.object.distribution.GetAssociationRequest;
import org.nakedobjects.object.reflect.Field;
import org.nakedobjects.object.reflect.Member;
import org.nakedobjects.utility.NotImplementedException;

public class Association
extends Field {
    protected Method setMethod;
    protected Method addMethod;
    protected Method removeMethod;

    public Association(String string, Class clazz, Method method, Method method2, Method method3, Method method4, Method method5) {
        super(string, clazz, method, method5, false);
        this.setMethod = method2;
        this.addMethod = method3;
        this.removeMethod = method4;
    }

    public Naked get(NakedObject nakedObject) {
        if (this.isProxied(nakedObject)) {
            try {
                return new GetAssociationRequest(nakedObject, this).getAttribute();
            }
            catch (ObjectStoreException objectStoreException) {
                Field.LOG.error((Object)"Problem with distribution", objectStoreException.getException());
                return null;
            }
        }
        try {
            return (Naked)this.getMemberMethod().invoke((Object)nakedObject, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            Field.LOG.error((Object)("Exception executing " + this.getMemberMethod()), invocationTargetException.getTargetException());
        }
        catch (IllegalAccessException illegalAccessException) {
            Field.LOG.error((Object)("Illegal access of " + this.getMemberMethod()), (Throwable)illegalAccessException);
        }
        return null;
    }

    public About getAbout(NakedObject nakedObject, NakedObject nakedObject2) {
        Method method = this.getAboutMethod();
        if (method == null) {
            return new Member.DefaultAbout();
        }
        if (this.isProxied(nakedObject)) {
            throw new NotImplementedException();
        }
        try {
            return (About)method.invoke((Object)nakedObject, nakedObject2);
        }
        catch (InvocationTargetException invocationTargetException) {
            Field.LOG.error((Object)("Exception executing " + method), invocationTargetException.getTargetException());
        }
        catch (IllegalAccessException illegalAccessException) {
            Field.LOG.error((Object)("Illegal access of " + method), (Throwable)illegalAccessException);
        }
        return null;
    }

    public String getLabel(NakedObject nakedObject) {
        About about = this.getAbout(nakedObject, (NakedObject)this.get(nakedObject));
        return this.getLabel(about);
    }

    protected String getLabel(About about) {
        if (about == null) {
            return this.getName();
        }
        if (about.getName() == null) {
            return this.getName();
        }
        return about.getName();
    }

    public boolean hasAddMethod() {
        return this.addMethod != null;
    }

    public void init(NakedObject nakedObject, Object object) {
        Field.LOG.debug((Object)("Role.init() " + nakedObject + "/" + object));
        try {
            if (nakedObject instanceof NakedCollection) {
                throw new RuntimeException();
            }
            if (this.setMethod == null) {
                throw new IllegalStateException("can't intialise " + this.getName() + "  in " + nakedObject.getClass() + " as there is no set method");
            }
            this.setMethod.invoke((Object)nakedObject, object);
        }
        catch (InvocationTargetException invocationTargetException) {
            Field.LOG.error((Object)("Exception executing " + this.setMethod), invocationTargetException.getTargetException());
        }
        catch (IllegalAccessException illegalAccessException) {
            Field.LOG.error((Object)("Illegal access of " + this.setMethod), (Throwable)illegalAccessException);
        }
    }

    public void remove(NakedObject nakedObject, NakedObject nakedObject2) {
        if (nakedObject2 == null) {
            throw new NullPointerException("Must specify the item to remove/dissociate");
        }
        Field.LOG.debug((Object)("remove() " + nakedObject + "/" + nakedObject2));
        if (this.isDistributed(nakedObject)) {
            try {
                new DissociateRequest(nakedObject, this, (NakedObject)this.get(nakedObject)).execute();
            }
            catch (ObjectStoreException objectStoreException) {
                Field.LOG.error((Object)"Distribution problem ", objectStoreException.getException());
                throw (RuntimeException)objectStoreException.getException();
            }
        }
        try {
            if (this.removeMethod != null) {
                this.removeMethod.invoke((Object)nakedObject, nakedObject2);
            } else {
                this.setMethod.invoke((Object)nakedObject, new Object[]{null});
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("set method expects a " + this.getType().getName() + " object; not a " + nakedObject2.getClass().getName());
        }
        catch (InvocationTargetException invocationTargetException) {
            Field.LOG.error((Object)("Exception executing " + this.setMethod), invocationTargetException.getTargetException());
            throw (RuntimeException)invocationTargetException.getTargetException();
        }
        catch (IllegalAccessException illegalAccessException) {
            Field.LOG.error((Object)("Illegal access of " + this.setMethod), (Throwable)illegalAccessException);
            throw new RuntimeException(illegalAccessException.getMessage());
        }
    }

    public void set(NakedObject nakedObject, Object object) {
        if (object == null) {
            throw new NullPointerException("Must specify an object to add");
        }
        Field.LOG.debug((Object)("set role " + this.getName() + " in " + nakedObject + " with " + object));
        if (this.isDistributed(nakedObject)) {
            try {
                if (object == null) {
                    new DissociateRequest(nakedObject, this, (NakedObject)this.get(nakedObject)).execute();
                }
                new AssociateRequest(nakedObject, this, (NakedObject)object).execute();
            }
            catch (ObjectStoreException objectStoreException) {
                Field.LOG.error((Object)"Distribution problem ", objectStoreException.getException());
                throw (RuntimeException)objectStoreException.getException();
            }
        } else {
            try {
                if (object == null) {
                    if (this.removeMethod != null) {
                        this.removeMethod.invoke((Object)nakedObject, this.get(nakedObject));
                    } else {
                        this.setMethod.invoke((Object)nakedObject, object);
                    }
                } else if (this.hasAddMethod()) {
                    this.addMethod.invoke((Object)nakedObject, object);
                } else {
                    this.setMethod.invoke((Object)nakedObject, object);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException(this.setMethod + " method doesn't expect a " + object.getClass().getName());
            }
            catch (InvocationTargetException invocationTargetException) {
                Field.LOG.error((Object)("Exception executing " + this.setMethod), invocationTargetException.getTargetException());
                if (invocationTargetException.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)invocationTargetException.getTargetException();
                }
                throw new RuntimeException(invocationTargetException.getTargetException().getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                Field.LOG.error((Object)("Illegal access of " + this.setMethod), (Throwable)illegalAccessException);
                throw new RuntimeException(illegalAccessException.getMessage());
            }
        }
    }

    public String toString() {
        String string = (this.getMemberMethod() == null ? "" : "GET") + (this.setMethod == null ? "" : " SET") + (this.addMethod == null ? "" : " ADD") + (this.removeMethod == null ? "" : " REMOVE");
        return "Association [name=\"" + this.getName() + "\", method=" + this.getMemberMethod() + ",about=" + this.getAboutMethod() + ", methods=" + string + ", type=" + this.getType() + " ]";
    }
}

