/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.basicgui.view.border;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import org.nakedobjects.basicgui.view.ObjectViewer;
import org.nakedobjects.basicgui.view.StatusColor;
import org.nakedobjects.basicgui.view.TextStyle;
import org.nakedobjects.basicgui.view.ViewBorder;
import org.nakedobjects.basicgui.view.ViewColor;
import org.nakedobjects.basicgui.view.border.IconBorder;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.utility.Debug;

public class WindowIconBorder
extends IconBorder {
    public WindowIconBorder() {
        super(TextStyle.getStyle(2), null);
    }

    public WindowIconBorder(int n, int n2, TextStyle textStyle, ViewBorder viewBorder) {
        super(n, n2, textStyle, viewBorder);
    }

    public WindowIconBorder(TextStyle textStyle, ViewBorder viewBorder) {
        super(textStyle, viewBorder);
    }

    public WindowIconBorder(ViewBorder viewBorder) {
        super(TextStyle.getStyle(2), viewBorder);
    }

    protected Dimension getIconDimension(NakedObject nakedObject) {
        Image image = nakedObject.iconImage(32);
        Dimension dimension = image == null ? new Dimension(32, 32) : new Dimension(image.getWidth(null), image.getHeight(null));
        return dimension;
    }

    public Dimension getMinimumSize(ObjectViewer objectViewer) {
        NakedObject nakedObject = objectViewer.getObject();
        Dimension dimension = this.getIconDimension(nakedObject);
        FontMetrics fontMetrics = this.style.getMetrics();
        int n = dimension.width + 6 + fontMetrics.stringWidth(this.getTitle(nakedObject));
        return new Dimension(n, 0);
    }

    public Insets insets(NakedObject nakedObject) {
        Dimension dimension = this.getIconDimension(nakedObject);
        return new Insets(dimension.height + 8, 2, 2, 2);
    }

    public void paint(Graphics graphics, Rectangle rectangle, ObjectViewer objectViewer) {
        NakedObject nakedObject = objectViewer.getObject();
        Color color = StatusColor.colorFor(objectViewer.getDisplayState(), ViewColor.textNormal);
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        Image image = nakedObject.iconImage(32);
        Dimension dimension = this.getIconDimension(nakedObject);
        String string = this.getTitle(nakedObject);
        graphics.setColor(ViewColor.windowBackground);
        graphics.fillRect(n, n2, n3 - 1, dimension.height + 3);
        if (color == ViewColor.textNormal) {
            graphics.setColor(ViewColor.outlineNormal);
        } else {
            graphics.setColor(color);
        }
        graphics.drawLine(n, n2 + dimension.height + 3, n + n3 - 1, n2 + dimension.height + 3);
        graphics.drawLine(n, n2 + dimension.height + 4, n + n3 - 1, n2 + dimension.height + 4);
        if (image == null) {
            graphics.setColor(Color.gray);
            graphics.fillOval(n + 1, n2, dimension.width - 1, dimension.height - 1);
        } else {
            graphics.drawImage(image, n + 1, n2 + 1, null);
        }
        graphics.setColor(color);
        graphics.setFont(this.style.getFont());
        FontMetrics fontMetrics = this.style.getMetrics();
        int n4 = n2 + dimension.height / 2;
        graphics.drawString(string, n + dimension.width + 6, n4 + fontMetrics.getAscent() / 2);
        this.paintBorder(graphics, rectangle, objectViewer);
        if (Debug.DISPLAY_OID) {
            graphics.setColor(ViewColor.debugLabel);
            graphics.setFont(TextStyle.getStyle(6).getFont());
            graphics.drawString(String.valueOf(objectViewer.getObject().getOid()), 5 + rectangle.x + dimension.width + 6 + this.style.getMetrics().stringWidth(string), n4 + fontMetrics.getAscent() / 2);
        }
        if (objectViewer.getDisplayState().isActive()) {
            graphics.setColor(Color.red);
            graphics.fillRect(rectangle.x, rectangle.y, 10, 10);
        }
    }

    public String toString() {
        return "WindowIconBorder" + super.toString();
    }
}

