/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.basicgui.view.border;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Enumeration;
import org.nakedobjects.basicgui.view.CollectionViewer;
import org.nakedobjects.basicgui.view.DisplayState;
import org.nakedobjects.basicgui.view.ObjectViewer;
import org.nakedobjects.basicgui.view.StatusColor;
import org.nakedobjects.basicgui.view.TableLayout;
import org.nakedobjects.basicgui.view.TextStyle;
import org.nakedobjects.basicgui.view.ViewBorder;
import org.nakedobjects.basicgui.view.ViewColor;
import org.nakedobjects.object.NakedCollection;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.reflect.Field;

public class TableBorder
extends ViewBorder {
    private TextStyle style;

    public TableBorder() {
        this(TextStyle.getStyle(3));
    }

    public TableBorder(TextStyle textStyle) {
        this.style = textStyle;
    }

    public Insets getBorderInsets(ObjectViewer objectViewer) {
        return new Insets(this.style.getMetrics().getHeight(), 0, 16, 0);
    }

    public void paint(Graphics graphics, Rectangle rectangle, ObjectViewer objectViewer) {
        int n;
        Enumeration enumeration = ((NakedCollection)objectViewer.getObject()).elements();
        if (!enumeration.hasMoreElements()) {
            return;
        }
        NakedObject nakedObject = (NakedObject)enumeration.nextElement();
        Field[] fieldArray = nakedObject.getNakedClass().getFields();
        TableLayout tableLayout = (TableLayout)objectViewer.getDisplay().getLayout();
        graphics.setColor(StatusColor.colorFor(objectViewer.getDisplayState(), ViewColor.fieldLabel));
        graphics.setFont(this.style.getFont());
        int n2 = rectangle.y + this.style.getMetrics().getAscent();
        int n3 = rectangle.x + tableLayout.getHeaderWidth();
        int n4 = 0;
        while (n4 < fieldArray.length) {
            n = tableLayout.getColumnWidth(n4);
            String string = fieldArray[n4].getName();
            if (this.style.getMetrics().stringWidth(string) < n) {
                graphics.drawString(string, n3, n2);
            } else {
                int n5 = string.length() - 1;
                while (n5 > 0) {
                    if (this.style.getMetrics().stringWidth(string.substring(0, n5)) < n) break;
                    --n5;
                }
                graphics.drawString(string.substring(0, n5) + "...", n3, n2);
            }
            n3 += n;
            ++n4;
        }
        n = rectangle.x;
        int n6 = rectangle.height;
        DisplayState displayState = objectViewer.getDisplayState();
        if (displayState.isPossibleDrop()) {
            graphics.setColor(ViewColor.objectCanDrop);
        } else if (displayState.isInvalidDrop()) {
            graphics.setColor(ViewColor.objectCantDrop);
        } else {
            graphics.setColor(ViewColor.outlineNormal);
        }
        graphics.fillOval(n + 2, n6 - 14, 12, 12);
        FontMetrics fontMetrics = TextStyle.getStyle(1).getMetrics();
        String string = objectViewer instanceof CollectionViewer ? objectViewer.typeName() : "Object";
        graphics.drawString(string, n + 19, n6 - fontMetrics.getDescent());
    }
}

