/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.basicgui.view;

import java.awt.Container;
import java.awt.Dimension;
import java.util.Observable;
import org.nakedobjects.basicgui.event.dnd.DragDropEvent;
import org.nakedobjects.basicgui.event.popup.MenuOptionSet;
import org.nakedobjects.basicgui.view.Display;
import org.nakedobjects.basicgui.view.ExplorationOption;
import org.nakedobjects.basicgui.view.FeedbackFrame;
import org.nakedobjects.basicgui.view.FindOption;
import org.nakedobjects.basicgui.view.FirstPageOption;
import org.nakedobjects.basicgui.view.LastPageOption;
import org.nakedobjects.basicgui.view.MakePersistentOption;
import org.nakedobjects.basicgui.view.NextElementOption;
import org.nakedobjects.basicgui.view.ObjectOption;
import org.nakedobjects.basicgui.view.ObjectViewer;
import org.nakedobjects.basicgui.view.PreviousElementOption;
import org.nakedobjects.basicgui.view.UsesViewer;
import org.nakedobjects.basicgui.view.View;
import org.nakedobjects.object.NakedClass;
import org.nakedobjects.object.NakedCollection;
import org.nakedobjects.object.NakedInterfaceEvent;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.control.About;
import org.nakedobjects.object.control.Permission;
import org.nakedobjects.object.reflect.Action;
import org.nakedobjects.utility.Debug;

public class RealObjectViewer
extends ObjectViewer {
    private NakedObject object;

    public RealObjectViewer(NakedObject nakedObject, View view) {
        this(nakedObject, view, null);
    }

    public RealObjectViewer(NakedObject nakedObject, View view, View view2) {
        super(view, view2);
        if (nakedObject != null) {
            nakedObject.resolve();
        }
        this.setObject(nakedObject);
    }

    public RealObjectViewer(NakedObject nakedObject, View view, View view2, boolean bl) {
        super(view, view2, bl);
        if (nakedObject != null) {
            nakedObject.resolve();
        }
        this.setObject(nakedObject);
    }

    public boolean canDrag() {
        return true;
    }

    public boolean canDrop(DragDropEvent dragDropEvent) {
        NakedObject nakedObject = ((UsesViewer)dragDropEvent.getSource()).getViewer().getObject();
        NakedObject nakedObject2 = this.getObject();
        Action action = nakedObject2.getNakedClass().get1ParamAction(nakedObject.getClass());
        if (action != null) {
            About about = nakedObject2.about();
            if (about != null && about.canUse().isVetoed()) {
                return false;
            }
            About about2 = action.getAbout(nakedObject2, nakedObject);
            if (about2 == null) {
                FeedbackFrame.clear();
                return true;
            }
            Permission permission = about2.canUse();
            FeedbackFrame.setActionName(about2.getName() == null ? action.getName() : about2.getName());
            FeedbackFrame.setDropStatus(permission.getReason());
            return !permission.isVetoed();
        }
        if (nakedObject2 instanceof NakedCollection) {
            return ((NakedCollection)nakedObject2).canAdd(nakedObject).isAllowed();
        }
        FeedbackFrame.clear();
        return false;
    }

    public void copy(DragDropEvent dragDropEvent) {
    }

    protected void debugData(StringBuffer stringBuffer) {
        stringBuffer.append("  Object:     " + this.getObject() + "\n");
    }

    public final void dispose() {
        if (this.getObject() != null) {
            this.getObject().deleteObserver(this);
        }
    }

    public void drop(DragDropEvent dragDropEvent) {
        NakedObject nakedObject = ((UsesViewer)dragDropEvent.getSource()).getViewer().getObject();
        NakedObject nakedObject2 = this.getObject();
        Action action = nakedObject2.getNakedClass().get1ParamAction(nakedObject.getClass());
        if (action != null) {
            NakedObject nakedObject3 = action.execute(nakedObject2, nakedObject);
            if (nakedObject3 != null) {
                this.results(nakedObject3, dragDropEvent.getLocationOnScreen());
            }
        } else if (nakedObject2 instanceof NakedCollection) {
            ((NakedCollection)nakedObject2).add(nakedObject);
        }
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.getView().getContentSize(this);
        Dimension dimension2 = this.getView().getMiminumBorderSize(this);
        return new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
    }

    public NakedObject getObject() {
        return this.object;
    }

    public void init() {
        this.getView().init(this.getObject(), this, this.getDisplay());
        super.init();
    }

    public void menuOptions(MenuOptionSet menuOptionSet) {
        if (this.getObject() == null) {
            return;
        }
        NakedObject nakedObject = this.getObject();
        if (nakedObject instanceof NakedCollection) {
            menuOptionSet.add(new FirstPageOption());
            menuOptionSet.add(new NextElementOption());
            menuOptionSet.add(new PreviousElementOption());
            menuOptionSet.add(new LastPageOption());
        }
        super.menuOptions(menuOptionSet);
        if (nakedObject.isFinder()) {
            menuOptionSet.add(new FindOption());
            if (Debug.DISPLAY_DEBUG_MENU) {
                menuOptionSet.add(ObjectViewer.debug);
            }
        } else {
            if (!(nakedObject instanceof NakedClass) && !nakedObject.isPersistent()) {
                menuOptionSet.add(new MakePersistentOption());
            }
            if (Debug.DISPLAY_DEBUG_MENU) {
                menuOptionSet.add(ObjectViewer.debug);
            }
            if (this.getObject() instanceof NakedObject) {
                ObjectOption.menuOptions(this.getObject(), menuOptionSet);
                ExplorationOption.menuOptions(this.getObject(), menuOptionSet);
            }
        }
    }

    public void move(DragDropEvent dragDropEvent) {
    }

    public void setObject(NakedObject nakedObject) {
        this.dispose();
        if (nakedObject != null) {
            nakedObject.addObserver(this);
        }
        this.object = nakedObject;
    }

    public String toString() {
        return "RealObject" + super.toString();
    }

    public void update(Observable observable, Object object) {
        NakedInterfaceEvent nakedInterfaceEvent = null;
        if (object != null && object instanceof NakedInterfaceEvent) {
            nakedInterfaceEvent = (NakedInterfaceEvent)object;
        }
        this.getView().update(nakedInterfaceEvent, this, this.getDisplay());
        Container container = this.getDisplay().getParent();
        if (container != null) {
            ((Display)((Object)container)).getViewer().update(observable, object);
        }
    }
}

