/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.basicgui.view;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import org.apache.log4j.Category;
import org.nakedobjects.basicgui.view.Display;
import org.nakedobjects.basicgui.view.FieldValue;
import org.nakedobjects.basicgui.view.Lookup;
import org.nakedobjects.basicgui.view.TextStyle;
import org.nakedobjects.basicgui.view.ViewColor;

public class EditField
extends Container
implements Lookup {
    static final Category LOG = Category.getInstance((Class)(class$org$nakedobjects$basicgui$view$EditField == null ? (class$org$nakedobjects$basicgui$view$EditField = EditField.class$("org.nakedobjects.basicgui.view.EditField")) : class$org$nakedobjects$basicgui$view$EditField));
    private static int nextNo = 1;
    private static final TextStyle style = TextStyle.getStyle(1);
    private final int no = nextNo++;
    public char[] buffer;
    public int entryLength;
    public boolean hasFocus;
    public boolean inError;
    public boolean isValid;
    public boolean isSaved = true;
    public int cursorAt;
    public int selectedFrom;
    public int selectedTo;
    public int displayFrom;
    public int displayTo;
    public int minimumWidth;
    public FieldValue attributeValue;
    private int noLines = 1;
    static /* synthetic */ Class class$org$nakedobjects$basicgui$view$EditField;

    public EditField(FieldValue fieldValue) {
        this.attributeValue = fieldValue;
        MouseEventHandler mouseEventHandler = new MouseEventHandler();
        this.addMouseListener(mouseEventHandler);
        this.addMouseMotionListener(mouseEventHandler);
        this.addFocusListener(new FocusEventHandler());
        this.addKeyListener(new KeyEventHandler());
        this.minimumWidth = 150;
        this.lookupValue();
    }

    public EditField(FieldValue fieldValue, int n) {
        this(fieldValue);
        this.minimumWidth = n;
    }

    public int characterAt(int n, int n2, int n3) {
        int n4 = this.getSize().width;
        int n5 = n2;
        int n6 = 0;
        while (n5 <= n3) {
            if ((n6 += style.getMetrics().charWidth(this.buffer[n5])) > n + 3 || n6 > n4) {
                return n5;
            }
            ++n5;
        }
        return n3;
    }

    public int characterAt(Point point) {
        int n;
        int n2 = point.x;
        int n3 = point.y;
        int n4 = 0;
        int n5 = style.getMetrics().getAscent();
        do {
            n = this.lineToEndAt(n4);
            if (n3 < n5) {
                return this.characterAt(n2, n4, n);
            }
            n5 += style.getMetrics().getAscent();
        } while ((n4 = n) < this.entryLength);
        return this.entryLength;
    }

    private void copy() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        String string = new String(this.buffer, this.startOfSelection(), this.endOfSelection() - this.startOfSelection());
        StringSelection stringSelection = new StringSelection(string);
        clipboard.setContents(stringSelection, null);
    }

    public void delete() {
        if (this.selectedTo != this.selectedFrom) {
            int n = this.endOfSelection() - this.startOfSelection();
            int n2 = this.endOfSelection();
            while (n2 < this.entryLength) {
                this.buffer[n2 - n] = this.buffer[n2];
                ++n2;
            }
            this.cursorAt = this.startOfSelection();
            this.entryLength -= n;
            this.selectedTo = this.selectedFrom;
        } else if (this.cursorAt > 0) {
            --this.cursorAt;
            int n = this.cursorAt + 1;
            while (n < this.entryLength) {
                this.buffer[n - 1] = this.buffer[n];
                ++n;
            }
            --this.entryLength;
        }
        this.isSaved = false;
        this.repaint();
    }

    public void editComplete() {
        LOG.debug((Object)("Field edited: new data = '" + new String(this.buffer, 0, this.entryLength) + "'"));
        this.attributeValue.setAs(new String(this.buffer, 0, this.entryLength));
        if (!this.attributeValue.isValid()) {
            this.isValid = true;
            this.repaint();
            return;
        }
        this.isSaved = true;
        if (this.inError || this.isValid) {
            this.inError = false;
            this.isValid = false;
            this.repaint();
        }
    }

    public void end() {
        this.cursorAt = this.entryLength;
        this.repaint();
    }

    public int endOfSelection() {
        return Math.max(this.selectedTo, this.selectedFrom);
    }

    private void focusChanged() {
        if (this.attributeValue.canEdit()) {
            if (this.hasFocus) {
                this.setCursor(Cursor.getPredefinedCursor(2));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    private int getNoLines() {
        return this.noLines;
    }

    public Dimension getPreferredSize() {
        int n = this.noLines * (style.getMetrics().getHeight() + 4);
        return new Dimension(this.minimumWidth, n);
    }

    public void home() {
        this.cursorAt = 0;
        this.repaint();
    }

    public String idString() {
        return "EditField" + this.no;
    }

    private void insert(char[] cArray, int n) {
        int n2 = cArray.length;
        if (this.entryLength + n2 >= this.buffer.length) {
            char[] cArray2 = new char[this.buffer.length + n2 + 10];
            int n3 = 0;
            while (n3 < n) {
                cArray2[n3] = this.buffer[n3];
                ++n3;
            }
            int n4 = 0;
            while (n4 < n2) {
                cArray2[n4 + n] = cArray[n4];
                ++n4;
            }
            int n5 = this.cursorAt;
            while (n5 < this.entryLength) {
                cArray2[n5 + n] = this.buffer[n5];
                ++n5;
            }
            this.buffer = cArray2;
        } else {
            int n6 = this.entryLength;
            while (n6 >= n) {
                this.buffer[n6 + n2] = this.buffer[n6];
                --n6;
            }
            int n7 = 0;
            while (n7 < n2) {
                this.buffer[n + n7] = cArray[n7];
                ++n7;
            }
        }
        this.cursorAt += n2;
        this.entryLength += n2;
        this.isSaved = false;
        this.repaint();
    }

    public boolean isFocusTraversable() {
        return this.attributeValue.canEdit();
    }

    private void keyPress(int n, int n2) {
        if (!this.attributeValue.canEdit()) {
            return;
        }
        if ((n2 & 2) == 2) {
            switch (n) {
                case 33: {
                    ++this.noLines;
                    ((Display)((Object)this.getParent())).refresh();
                    break;
                }
                case 34: {
                    if (this.noLines <= 1) break;
                    --this.noLines;
                    ((Display)((Object)this.getParent())).refresh();
                    break;
                }
                case 86: {
                    this.paste();
                    break;
                }
                case 67: {
                    this.copy();
                }
            }
            return;
        }
        boolean bl = (n2 & 4) > 0;
        boolean bl2 = (n2 & 1) > 0;
        switch (n) {
            case 40: {
                this.lineDown();
                break;
            }
            case 36: {
                this.home();
                break;
            }
            case 35: {
                this.end();
                break;
            }
            case 37: {
                if (bl) {
                    this.wordLeft();
                    break;
                }
                this.left();
                break;
            }
            case 39: {
                if (bl) {
                    this.wordRight();
                    break;
                }
                this.right();
                break;
            }
            case 8: 
            case 127: {
                this.delete();
                break;
            }
            case 9: 
            case 10: {
                if (this.isSaved) break;
                this.editComplete();
                break;
            }
            case 27: {
                this.undo();
                break;
            }
        }
        if (n != 16) {
            if (bl2) {
                this.selectedTo = this.cursorAt;
            } else {
                this.selectedFrom = this.selectedTo = this.cursorAt;
            }
        }
    }

    private void keyType(char c) {
        this.insert(new char[]{c}, this.cursorAt);
    }

    public void left() {
        if (this.cursorAt > 0) {
            --this.cursorAt;
            this.repaint();
        }
    }

    public void lineDown() {
        int n;
        int n2 = 0;
        do {
            n = n2;
        } while (this.cursorAt > (n2 = this.lineToEndAt(n2)));
        int n3 = style.getMetrics().stringWidth(new String(this.buffer, n, this.cursorAt - n));
        if (n2 == this.entryLength) {
            return;
        }
        int n4 = n2;
        n2 = this.lineToEndAt(n2);
        this.cursorAt = this.characterAt(n3, n4, n2);
        this.repaint();
    }

    public int lineHeight() {
        return style.getMetrics().getHeight();
    }

    protected int lineToEndAt(int n) {
        int n2 = this.getSize().width;
        int n3 = 0;
        int n4 = n;
        int n5 = n;
        while (n5 < this.entryLength) {
            n3 += style.getMetrics().charWidth(this.buffer[n5]);
            if (this.buffer[n5] == ' ') {
                n4 = n5 + 1;
            }
            if (n3 > n2) {
                return n4 == n ? n5 : n4;
            }
            ++n5;
        }
        return this.entryLength;
    }

    public void lineUp() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        do {
            n2 = n3;
            n3 = n;
        } while (this.cursorAt > (n = this.lineToEndAt(n)));
        if (n3 == 0) {
            return;
        }
        int n4 = style.getMetrics().stringWidth(new String(this.buffer, n3, this.cursorAt - n3));
        this.cursorAt = this.characterAt(n4, n2, n3 - 1);
        this.repaint();
    }

    public void lookupValue() {
        this.attributeValue.update();
        String string = this.attributeValue.getText();
        this.entryLength = string.length();
        this.buffer = new char[this.entryLength + 10];
        string.getChars(0, this.entryLength, this.buffer, 0);
        this.displayFrom = 0;
        this.cursorAt = string.length();
        this.inError = false;
        this.isSaved = true;
    }

    public void paint(Graphics graphics) {
        int n = this.getSize().width;
        if (this.hasFocus && this.selectedFrom != this.selectedTo) {
            this.paintHighlight(graphics, n);
        }
        this.paintLines(graphics, n);
        this.paintText(graphics, n);
    }

    private void paintHighlight(Graphics graphics, int n) {
        int n2;
        graphics.setColor(ViewColor.textHighlight);
        int n3 = 0;
        int n4 = 0;
        int n5 = this.startOfSelection();
        int n6 = this.endOfSelection();
        do {
            n2 = this.lineToEndAt(n3);
            int n7 = 0;
            int n8 = 0;
            if (n5 <= n2) {
                if (n5 >= n3) {
                    n7 = this.widthForBuffer(n3, n5 - n3);
                }
                if (n6 >= n3) {
                    int n9 = n3;
                    int n10 = n6 <= n2 ? n6 - n3 : n2 - n3;
                    n8 = this.widthForBuffer(n9, n10) - n7;
                }
            }
            graphics.fillRect(n7, n4, n8, this.lineHeight());
            n4 += this.lineHeight();
        } while ((n3 = n2) < this.entryLength);
    }

    private void paintLines(Graphics graphics, int n) {
        if (this.attributeValue.canEdit()) {
            graphics.setColor(this.hasFocus ? ViewColor.outlineHighlight : ViewColor.outlineNormal);
            int n2 = this.lineHeight() - style.getMetrics().getDescent();
            int n3 = 0;
            while (n3 < this.noLines) {
                graphics.drawLine(0, n2, n - 1, n2);
                n2 += this.lineHeight();
                ++n3;
            }
        }
    }

    private void paintText(Graphics graphics, int n) {
        int n2;
        Color color;
        if (this.inError) {
            color = Color.red;
        } else if (this.isValid) {
            color = Color.orange;
            color.darker();
        } else {
            color = !this.isSaved ? ViewColor.textEdited : ViewColor.textNormal;
        }
        graphics.setFont(style.getFont());
        int n3 = 0;
        int n4 = style.getMetrics().getAscent();
        do {
            n2 = this.lineToEndAt(n3);
            graphics.setColor(color);
            graphics.drawChars(this.buffer, n3, n2 - n3, 1, n4);
            if (this.hasFocus && this.cursorAt >= n3 && (this.cursorAt < n2 || this.cursorAt == this.entryLength) && this.attributeValue.canEdit()) {
                graphics.setColor(ViewColor.textCursor);
                int n5 = style.getMetrics().stringWidth(new String(this.buffer, n3, this.cursorAt - n3));
                graphics.drawLine(n5, n4, n5, n4 - style.getMetrics().getHeight());
            }
            n4 += this.lineHeight();
        } while ((n3 = n2) < this.entryLength);
    }

    public void paste() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        try {
            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            this.insert(string.toCharArray(), this.cursorAt);
        }
        catch (Throwable throwable) {
            LOG.error((Object)("Invalid paste operation " + throwable));
        }
    }

    public void right() {
        if (this.cursorAt < this.entryLength) {
            ++this.cursorAt;
            this.repaint();
        }
    }

    public void setNoLines(int n) {
        this.noLines = n;
    }

    public void setWidth(int n) {
        this.minimumWidth = n;
    }

    public int startOfSelection() {
        return Math.min(this.selectedTo, this.selectedFrom);
    }

    public String toString() {
        Rectangle rectangle = this.getBounds();
        return this.idString() + " view [bounds=" + rectangle + ",object=" + this.attributeValue.getAttribute().getName() + "]";
    }

    public void undo() {
        this.lookupValue();
        this.repaint();
    }

    protected int widthForBuffer(int n, int n2) {
        return style.getMetrics().stringWidth(new String(this.buffer, n, n2));
    }

    public void wordLeft() {
        do {
            --this.cursorAt;
        } while (this.cursorAt > 0 && this.buffer[this.cursorAt] != ' ');
        this.repaint();
    }

    public void wordRight() {
        do {
            ++this.cursorAt;
        } while (this.cursorAt < this.entryLength && this.buffer[this.cursorAt] != ' ');
        this.repaint();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class KeyEventHandler
    extends KeyAdapter {
        KeyEventHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            EditField.this.keyPress(keyEvent.getKeyCode(), keyEvent.getModifiers());
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (!keyEvent.isActionKey() && !Character.isISOControl(keyEvent.getKeyChar())) {
                EditField.this.keyType(keyEvent.getKeyChar());
            }
        }
    }

    class FocusEventHandler
    extends FocusAdapter {
        FocusEventHandler() {
        }

        public void focusGained(FocusEvent focusEvent) {
            EditField.this.hasFocus = true;
            EditField.this.focusChanged();
            EditField.this.repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!EditField.this.isSaved) {
                EditField.this.editComplete();
            }
            EditField.this.hasFocus = false;
            EditField.this.focusChanged();
            EditField.this.repaint();
        }
    }

    private class MouseEventHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private MouseEventHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!EditField.this.attributeValue.canEdit()) {
                return;
            }
            EditField.this.requestFocus();
            EditField.this.selectedTo = EditField.this.cursorAt = EditField.this.characterAt(mouseEvent.getPoint());
            EditField.this.selectedFrom = EditField.this.cursorAt;
            EditField.this.repaint();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                EditField.this.cursorAt = EditField.this.characterAt(mouseEvent.getPoint());
                EditField.this.selectedFrom = EditField.this.cursorAt - 1;
                EditField.this.selectedTo = EditField.this.cursorAt + 1;
                EditField.this.repaint();
            } else if (mouseEvent.getClickCount() == 3) {
                EditField.this.selectedFrom = 0;
                EditField.this.selectedTo = EditField.this.entryLength;
                EditField.this.repaint();
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!EditField.this.attributeValue.canEdit()) {
                return;
            }
            EditField.this.selectedTo = EditField.this.characterAt(mouseEvent.getPoint());
            EditField.this.repaint();
        }
    }
}

