/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.basicgui.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.nakedobjects.basicgui.event.action.ObjectActionEvent;
import org.nakedobjects.basicgui.event.action.ObjectActionProcessor;
import org.nakedobjects.basicgui.event.dnd.DragDropEvent;
import org.nakedobjects.basicgui.event.dnd.DragDropProcessor;
import org.nakedobjects.basicgui.event.popup.MenuOptionSet;
import org.nakedobjects.basicgui.event.popup.MenuOptionTarget;
import org.nakedobjects.basicgui.event.popup.ObjectPopup;
import org.nakedobjects.basicgui.view.Display;
import org.nakedobjects.basicgui.view.FeedbackFrame;
import org.nakedobjects.basicgui.view.ObjectActionHandler;
import org.nakedobjects.basicgui.view.ObjectViewer;
import org.nakedobjects.basicgui.view.ViewColor;

public class DisplayMechanism {
    private static DragDropProcessor dndProcessor = new DragDropProcessor();
    private static ObjectPopup popup;
    private ObjectActionProcessor actionProcessor;
    private Display display;
    private ObjectViewer viewer;

    public DisplayMechanism(Display display) {
        this.display = display;
    }

    public DisplayMechanism(Display display, ObjectViewer objectViewer) {
        this(display);
        this.viewer = objectViewer;
        this.setupHandler();
    }

    public void cancel(DragDropEvent dragDropEvent) {
        this.viewer.updateDisplayState(15);
    }

    public void copy(DragDropEvent dragDropEvent) {
        this.viewer.copy(dragDropEvent);
        this.viewer.updateDisplayState(13);
    }

    public String debugDetails() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Display:      " + this.display.idString() + "\n");
        if (this.display.getParent() != null) {
            stringBuffer.append("  Parent:     " + this.display.getParent() + "\n");
        }
        stringBuffer.append("  Bounds:     " + this.display.getBounds() + "\n");
        stringBuffer.append("  Insets:     " + this.display.getInsets() + "\n");
        stringBuffer.append("  Minimum:    " + this.display.getMinimumSize() + "\n");
        stringBuffer.append("  Preferred:  " + this.display.getPreferredSize() + "\n");
        stringBuffer.append("  Layout:     " + this.display.getLayout() + "\n");
        stringBuffer.append("  Viewer:     " + this.viewer + "\n");
        stringBuffer.append("  Cursor:      " + ((Component)((Object)this.display)).getCursor().getType() + "\n");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public void dispose() {
        if (this.viewer != null) {
            this.viewer.dispose();
        }
    }

    public void doubleClicked(ObjectActionEvent objectActionEvent) {
        this.viewer.open(objectActionEvent);
    }

    public void drag(DragDropEvent dragDropEvent) {
        if (this.viewer.canDrag()) {
            this.viewer.updateDisplayState(14);
        }
        FeedbackFrame.setDragObject(this.viewer.getObject());
    }

    public void dragEnter(DragDropEvent dragDropEvent) {
        if (this.viewer.canDrop(dragDropEvent)) {
            this.viewer.updateDisplayState(10);
        } else {
            this.viewer.updateDisplayState(11);
        }
    }

    public void dragExit(DragDropEvent dragDropEvent) {
        this.viewer.updateDisplayState(15);
    }

    public void dragging(DragDropEvent dragDropEvent) {
    }

    public void drop(final DragDropEvent dragDropEvent) {
        if (this.viewer.canDrop(dragDropEvent)) {
            new Thread(new Runnable(){

                public void run() {
                    DisplayMechanism.this.viewer.setActive(true);
                    DisplayMechanism.this.viewer.drop(dragDropEvent);
                    DisplayMechanism.this.viewer.setActive(false);
                }
            }, "Drop").start();
        }
        this.viewer.updateDisplayState(15);
        FeedbackFrame.setDragObject(null);
        FeedbackFrame.setDropStatus("");
    }

    public Color getBackground() {
        return ViewColor.windowBackground;
    }

    public Dimension getBorderSize() {
        if (this.viewer == null) {
            return new Dimension(0, 0);
        }
        return this.viewer.getBorderSize();
    }

    public Insets getInsets(Insets insets) {
        Insets insets2 = (Insets)insets.clone();
        if (this.viewer != null) {
            Insets insets3 = this.viewer.getBorderInsets();
            insets2.top += insets3.top;
            insets2.bottom += insets3.bottom;
            insets2.left += insets3.left;
            insets2.right += insets3.right;
        }
        return insets2;
    }

    public Dimension getMinimumSize() {
        if (this.viewer == null) {
            return new Dimension(0, 0);
        }
        Dimension dimension = this.viewer.getMinimumSize();
        Insets insets = this.display.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public ObjectViewer getViewer() {
        return this.viewer;
    }

    public void menuOptions(MenuOptionSet menuOptionSet) {
        this.viewer.menuOptions(menuOptionSet);
    }

    public void move(DragDropEvent dragDropEvent) {
        this.viewer.move(dragDropEvent);
        this.viewer.updateDisplayState(13);
        FeedbackFrame.setDragObject(this.viewer.getObject());
    }

    public void paint(Graphics graphics, Insets insets) {
        this.paintContent(graphics, insets);
    }

    public void paintContent(Graphics graphics, Insets insets) {
        if (this.viewer != null) {
            Dimension dimension = this.display.getSize();
            int n = dimension.width - insets.left - insets.right;
            int n2 = dimension.height - insets.top - insets.bottom;
            Rectangle rectangle = new Rectangle(insets.left, insets.top, n, n2);
            Insets insets2 = this.display.getInsets();
            int n3 = dimension.width - insets2.left - insets2.right;
            int n4 = dimension.height - insets2.top - insets2.bottom;
            Rectangle rectangle2 = new Rectangle(insets2.left, insets2.top, n3, n4);
            this.viewer.getView().drawBackground(graphics, rectangle2, this.viewer);
            this.viewer.getView().drawBorder(graphics, rectangle, this.viewer);
            this.viewer.getView().drawContent(graphics, rectangle2, this.viewer);
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        this.actionProcessor.processMouseEvent(mouseEvent);
        dndProcessor.processMouseEvent(mouseEvent);
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        dndProcessor.processMouseEvent(mouseEvent);
    }

    public void setupHandler() {
        this.actionProcessor = new ObjectActionProcessor(new ObjectActionHandler(this.viewer));
        dndProcessor = new DragDropProcessor();
    }

    public void showPopup(MenuOptionTarget menuOptionTarget, Point point, boolean bl) {
        MenuOptionSet menuOptionSet = new MenuOptionSet();
        menuOptionTarget.menuOptions(menuOptionSet);
        if (popup == null) {
            popup = new ObjectPopup();
        }
        menuOptionTarget.remove(popup);
        menuOptionTarget.add(popup);
        popup.popup(menuOptionTarget, menuOptionSet.getMenuOptions(bl), point);
    }

    public String toString() {
        return this.display.idString() + " view [viewer=" + this.viewer.idString() + ",object=" + this.viewer.getObject() + "]";
    }

    public void useViewer(ObjectViewer objectViewer) {
        this.display.removeAll();
        if (this.viewer != null) {
            this.viewer.dispose();
        }
        this.viewer = objectViewer;
        this.setupHandler();
        objectViewer.setDisplay(this.display);
        objectViewer.init();
        this.display.refresh();
    }

    public void vacantDrop(DragDropEvent dragDropEvent) {
        this.viewer.vacantDrop(dragDropEvent);
        this.viewer.updateDisplayState(13);
    }
}

