/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.basicgui.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import org.nakedobjects.basicgui.view.ObjectViewer;
import org.nakedobjects.basicgui.view.SmallIconContent;
import org.nakedobjects.basicgui.view.StatusColor;
import org.nakedobjects.basicgui.view.TextStyle;
import org.nakedobjects.basicgui.view.ViewColor;
import org.nakedobjects.object.NakedObject;

public class CellIconContent
extends SmallIconContent {
    public CellIconContent() {
    }

    public CellIconContent(TextStyle textStyle) {
        super(textStyle);
    }

    public Dimension getMinimumSize(NakedObject nakedObject) {
        Dimension dimension = super.getMinimumSize(nakedObject);
        int n = Math.min(80, dimension.width);
        return new Dimension(n, dimension.height);
    }

    public void paint(Graphics graphics, Rectangle rectangle, ObjectViewer objectViewer) {
        NakedObject nakedObject = objectViewer.getObject();
        if (nakedObject == null) {
            return;
        }
        Color color = StatusColor.colorFor(objectViewer.getDisplayState(), ViewColor.textNormal);
        Image image = nakedObject.iconImage(16);
        graphics.drawImage(image, rectangle.x, rectangle.y + (rectangle.height - image.getHeight(null)) / 2, null);
        String string = nakedObject.title() == null ? "" : nakedObject.title().toString();
        FontMetrics fontMetrics = this.style.getMetrics();
        Dimension dimension = objectViewer.getDisplay().getSize();
        int n = string.length();
        while (n > 0) {
            if (image.getWidth(null) + 6 + fontMetrics.stringWidth(string.substring(0, n)) < dimension.width) {
                string = string.substring(0, n) + "...";
                break;
            }
            n -= 5;
        }
        graphics.setFont(this.style.getFont());
        graphics.setColor(color);
        int n2 = rectangle.y + rectangle.height / 2;
        graphics.drawString(string, rectangle.x + image.getWidth(null) + 6, n2 + fontMetrics.getAscent() / 2);
    }
}

