/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.basicgui.view;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import org.nakedobjects.basicgui.view.Display;
import org.nakedobjects.basicgui.view.FieldValue;
import org.nakedobjects.basicgui.view.TextStyle;

public abstract class AbstractField
extends Container {
    private static int nextNo = 1;
    protected static final TextStyle style = TextStyle.getStyle(1);
    protected final int no = nextNo++;
    protected boolean hasFocus;
    protected boolean editable;
    private FieldValue attributeValue;

    public AbstractField(FieldValue fieldValue) {
        this.attributeValue = fieldValue;
        this.editable = true;
        if (this.editable) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.addFocusListener(new FocusEventHandler());
        this.addMouseListener(new MouseEventHandler());
        this.addKeyListener(new KeyEventHandler());
    }

    public void add(Display display) {
    }

    public void click(int n, int n2) {
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public abstract Dimension getPreferredSize();

    public void highlight(int n) {
    }

    public String idString() {
        return "Field" + this.no;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void press(int n) {
    }

    public void setValue(String string) {
        this.attributeValue.setAs(string);
    }

    public String toString() {
        Rectangle rectangle = this.getBounds();
        return this.idString() + " [x=" + rectangle.x + ",y=" + rectangle.y + ",w=" + rectangle.width + ",h=" + rectangle.height + "]";
    }

    class FocusEventHandler
    extends FocusAdapter {
        FocusEventHandler() {
        }

        public void focusGained(FocusEvent focusEvent) {
            AbstractField.this.hasFocus = true;
            AbstractField.this.repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            AbstractField.this.hasFocus = false;
            AbstractField.this.repaint();
        }
    }

    class KeyEventHandler
    extends KeyAdapter {
        KeyEventHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            AbstractField.this.press(keyEvent.getKeyCode());
        }
    }

    class MouseEventHandler
    extends MouseAdapter {
        MouseEventHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (AbstractField.this.editable) {
                AbstractField.this.click(mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

