/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.basicgui.event.dnd;

import java.awt.Point;
import java.util.EventObject;
import org.nakedobjects.basicgui.event.dnd.DragSource;
import org.nakedobjects.basicgui.event.dnd.DropDestination;

public class DragDropEvent
extends EventObject {
    public static final int DRAG = 1;
    public static final int DRAGGING = 2;
    public static final int MOVE = 3;
    public static final int COPY = 4;
    public static final int DROP = 5;
    public static final int VACANT_DROP = 6;
    public static final int DRAG_ENTER = 7;
    public static final int DRAG_EXIT = 8;
    public static final int DRAG_CANCEL = 9;
    private int action;
    private int modifiers;
    private DropDestination dropDestination;
    private Point location;

    public DragDropEvent(int n, int n2, DragSource dragSource, DropDestination dropDestination, Point point) {
        super(dragSource);
        this.action = n;
        this.modifiers = n2;
        this.dropDestination = dropDestination;
        this.location = point;
    }

    public int getAction() {
        return this.action;
    }

    public DragSource getDragSource() {
        return (DragSource)this.getSource();
    }

    public DropDestination getDropDestination() {
        return this.dropDestination;
    }

    public Point getLocationInDestination() {
        Point point = new Point(this.location);
        Point point2 = this.getDropDestination().getComponent().getLocationOnScreen();
        point.translate(-point2.x, -point2.y);
        return point;
    }

    public Point getLocationInSource() {
        Point point = new Point(this.location);
        Point point2 = this.getDragSource().getComponent().getLocationOnScreen();
        point.translate(-point2.x, -point2.y);
        return point;
    }

    public Point getLocationOnScreen() {
        return this.location;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String toString() {
        String string = "";
        switch (this.action) {
            case 1: {
                string = "DRAG";
                break;
            }
            case 2: {
                string = "DRAGGING";
                break;
            }
            case 3: {
                string = "MOVE";
                break;
            }
            case 4: {
                string = "COPY";
                break;
            }
            case 6: {
                string = "VACANT_DROP";
                break;
            }
            case 5: {
                string = "DROP";
                break;
            }
            case 7: {
                string = "DRAG_ENTER";
                break;
            }
            case 8: {
                string = "DRAG_EXIT";
                break;
            }
            case 9: {
                string = "DRAG_CANCEL";
            }
        }
        String string2 = this.getDragSource().idString();
        String string3 = this.getDropDestination() instanceof DropDestination ? this.getDropDestination().idString() : "FREE";
        return "DragDropEvent[action=" + string + ",drag=" + string2 + ",drop=" + string3 + ",location=" + this.location.x + "," + this.location.y + "]";
    }
}

