# Connection: zci
# Host: localhost
# Saved: 2004-12-17 20:48:15
# 
# Connection: zci2
# Host: 10.3.182.110
# Saved: 2004-08-31 12:50:00
# 
create database zci;
use zci;


#######creating table for item categories
create table ownership_category	(
modelid	integer unsigned primary key,
name	varchar(31) default null
) type=InnoDB;
insert into ownership_category (modelid,name) values (0,'Unknown'),(1000,'Own'),(2000,'Lease'),(3000,'End of Ownership'),(4000,'End of Lease');

create table domain_category (
modelid integer unsigned primary key auto_increment,
name varchar(31) default null
) type=InnoDB;

create table model_category (
modelid	integer unsigned primary key auto_increment,
vendor	varchar(31),
model	varchar(63),
cversion varchar(31)
) type=InnoDB;

create table os_category (
modelid	integer unsigned primary key auto_increment,
name	varchar(63)
) type=InnoDB;

create table vga_category(
modelid integer unsigned primary key auto_increment,
name	varchar(63)
) type=InnoDB;

create table monitor_category(
modelid integer unsigned primary key auto_increment,
name	varchar(63)
) type=InnoDB;

create table sound_category(
modelid integer unsigned primary key auto_increment,
name	varchar(63)
) type=InnoDB;

create table processor_category(
modelid integer unsigned primary key auto_increment,
name	varchar(63),
speed	smallint unsigned default 0
) type=InnoDB;

create table harddisk_category(
modelid integer unsigned primary key auto_increment,
name	varchar(63),
size	smallint unsigned default 0
) type=InnoDB;

create table cdrom_category(
modelid integer unsigned primary key auto_increment,
name	varchar(31)
) type=InnoDB;

create table scsi_category(
modelid integer unsigned primary key auto_increment,
name	varchar(63)
) type=InnoDB;

create table nic_category(
modelid integer unsigned primary key auto_increment,
name	varchar(100)
) type=InnoDB;

create table peripheral_category(
modelid integer unsigned primary key auto_increment,
name	varchar(100)
) type=InnoDB;

create table software_category(
modelid	integer unsigned primary key auto_increment,
name	varchar(100),
sw_version varchar(31)
)	type=InnoDB;

#####creating table for component item
create table computer_system(
computerid	integer unsigned primary key auto_increment,
hostname	varchar(31),
model		integer unsigned references model_category(modelid),
serialnumber varchar(31),
domain		integer unsigned references domain_category(modelid),
user		varchar(31),
reserved	char(1) default null,
zciid		integer unsigned,
registerdate date
) type=InnoDB;

##single item 
create table ownership	(
itemid		integer unsigned primary key auto_increment,
computerid	integer unsigned references computer_system(computerid) on delete cascade,
modelid		integer unsigned default 1000 references ownership_category(modelid),
registerdate date,
removed		date default null
) type=InnoDB;

create table os(
itemid		integer unsigned primary key auto_increment,
computerid	integer unsigned references computer_system(computerid) on delete cascade,
modelid		integer unsigned references os_category(modelid),
installdate date,
removed		date default null
) type=InnoDB;

create table ram(
itemid		integer unsigned primary key auto_increment,
computerid	integer unsigned references computer_system(computerid) on delete cascade,
modelid		integer unsigned,
registerdate date,
removed		date default null
) type=InnoDB;

create table vga_controller(
itemid		integer unsigned primary key auto_increment,
computerid	integer unsigned references computer_system(computerid) on delete cascade,
modelid		integer unsigned references vga_category(modelid),
registerdate date,
removed		date default null
) type=InnoDB;

create table floppy(
itemid		integer unsigned primary key auto_increment,
computerid	integer unsigned references computer_system(computerid) on delete cascade,
modelid		tinyint unsigned references floppy_category(modelid),
registerdate date,
removed		date default null
) type=InnoDB;

###multiple item

create table sound_controller(
itemid		integer unsigned primary key auto_increment,
computerid	integer unsigned references computer_system(computerid) on delete cascade,
modelid		integer unsigned references sound_category(modelid),
registerdate	date,
removed	date default null
) type=InnoDB;

create table processor(
itemid		integer unsigned primary key auto_increment,
computerid	integer unsigned references computer_system(computerid) on delete cascade,
modelid		integer unsigned references processor_category(modelid),
registerdate date,
removed		date default null
) type=InnoDB;

create table monitor(
itemid		integer unsigned primary key auto_increment,
modelid		integer unsigned references monitor_category(modelid),
serialnumber	varchar(31) default null,
registerdate date,
reserved	char(1) default null
) type=InnoDB;

create table harddisk(
itemid		integer unsigned primary key auto_increment,
computerid	integer unsigned references computer_system(computerid) on delete cascade,
modelid		integer unsigned references harddisk_category(modelid),
registerdate date,
removed		date default null
) type=InnoDB;

create table cdrom(
itemid		integer unsigned primary key auto_increment,
computerid	integer unsigned references computer_system(computerid) on delete cascade,
modelid		integer unsigned references cdrom_category(modelid),
registerdate date,
removed		date default null
) type=InnoDB;

create table scsi(
itemid		integer unsigned primary key auto_increment,
computerid	integer unsigned references computer_system(computerid) on delete cascade,
modelid		integer unsigned references scsi_category(modelid),
registerdate date,
removed		date default null
) type=InnoDB;

create table nic(
computerid	integer unsigned references computer_system(computerid) on delete cascade,
modelid		integer unsigned references nic_category(modelid),
mac			char(17) primary key,
ipaddress	varchar(15),
registerdate date,
removed		date default null
) type=InnoDB;

create table peripheral(
itemid		integer unsigned primary key auto_increment,
modelid		integer unsigned references peripheral_category(modelid),
serialnumber	varchar(31) default null,
registerdate date,
reserved	char(1) default null
) type=InnoDB;

create table ownership_monitor	(
itemid		integer unsigned primary key auto_increment,
componentid	integer unsigned references monitor(itemid) on delete cascade,
modelid		integer unsigned default 1000 references ownership_category(modelid),
computerid	integer unsigned default null,	# references computer_system(computerid) on delete cascade,
registerdate date,
removed		date default null
) type=InnoDB;

create table ownership_peripheral	(
itemid		integer unsigned primary key auto_increment,
componentid	integer unsigned references peripheral(itemid) on delete cascade,
modelid		integer unsigned default 1000 references ownership_category(modelid),
computerid	integer unsigned default null,	# references computer_system(computerid) on delete cascade,
registerdate date,
removed		date default null
) type=InnoDB;

create table software(
itemid		integer unsigned primary key auto_increment,
computerid	integer unsigned references computer_system(computerid) on delete cascade,
modelid		integer unsigned references software_category(modelid),
registerdate date,
removed		date default null
) type=InnoDB;
