/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidLookAndFeel;
import com.birosoft.liquid.skin.Skin;
import com.birosoft.liquid.skin.SkinSimpleButtonIndexModel;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;

public class LiquidTabbedPaneUI
extends BasicTabbedPaneUI {
    static Skin skinTop;
    static Skin skinLeft;
    static Skin skinRight;
    static Skin skinBottom;
    static Skin skinBorder;
    static Skin skinBorderRight;
    SkinSimpleButtonIndexModel indexModel = new SkinSimpleButtonIndexModel();
    Color componentBackground = LiquidLookAndFeel.getControl();
    Color tabBackground = LiquidLookAndFeel.getLightControl();
    int rollover = -1;

    public static ComponentUI createUI(JComponent c) {
        return new LiquidTabbedPaneUI();
    }

    protected void installListeners() {
        super.installListeners();
        this.tabPane.addMouseMotionListener((MouseMotionListener)((Object)this.mouseListener));
    }

    protected MouseListener createMouseListener() {
        return new MyMouseHandler();
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            BasicTabbedPaneUI.TabbedPaneLayout layout = (BasicTabbedPaneUI.TabbedPaneLayout)this.tabPane.getLayout();
            layout.calculateLayoutInfo();
        }
    }

    private int getTabAtLocation(int x, int y) {
        this.ensureCurrentLayout();
        int tabCount = this.tabPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            if (!this.rects[i].contains(x, y)) continue;
            return i;
        }
        return -1;
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
    }

    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
    }

    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        Insets contentBorderInsets = this.getContentBorderInsets(tabPlacement);
        if (this.tabPane.getTabPlacement() == 3 && contentBorderInsets.top == 5) {
            contentBorderInsets.top = 0;
            contentBorderInsets.bottom = 5;
            this.tabPane.revalidate();
        } else if (this.tabPane.getTabPlacement() == 1 && contentBorderInsets.top == 0) {
            contentBorderInsets.top = 5;
            contentBorderInsets.bottom = 0;
            this.tabPane.revalidate();
        }
        int index = this.indexModel.getIndexForState(this.tabPane.isEnabledAt(tabIndex), this.rollover == tabIndex, isSelected);
        switch (tabPlacement) {
            case 2: {
                this.getSkinLeft().draw(g, index, x, y, w, h - 1);
                break;
            }
            case 4: {
                this.getSkinRight().draw(g, index, x - 2, y, w, h - 1);
                break;
            }
            case 3: {
                this.getSkinBottom().draw(g, index, x, y, w, h);
                break;
            }
            default: {
                this.getSkinTop().draw(g, index, x, y, w, h);
            }
        }
    }

    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        int yOffset = 0;
        if (tabPlacement == 1 && isSelected) {
            yOffset = 1;
        }
        if (tabPlacement == 3) {
            yOffset = isSelected ? -2 : -1;
        }
        g.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            textRect.y += yOffset;
            v.paint(g, textRect);
        } else {
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
                g.setColor(this.tabPane.getForegroundAt(tabIndex));
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent() + yOffset);
            } else {
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).brighter());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).darker());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x - 1, textRect.y + metrics.getAscent() - 1);
            }
        }
    }

    public void update(Graphics g, JComponent c) {
        Insets contentBorderInsets = this.getContentBorderInsets(this.tabPane.getTabPlacement());
        if (this.tabPane.getTabPlacement() == 3 && contentBorderInsets.top == 5) {
            contentBorderInsets.top = 0;
            contentBorderInsets.bottom = 5;
            this.tabPane.revalidate();
        } else if (this.tabPane.getTabPlacement() == 1 && contentBorderInsets.top == 0) {
            contentBorderInsets.top = 5;
            contentBorderInsets.bottom = 0;
            this.tabPane.revalidate();
        }
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.right - insets.left;
        int h = height - insets.top - insets.bottom;
        if (c.isOpaque()) {
            g.setColor(this.componentBackground);
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        int tabPlacement = this.tabPane.getTabPlacement();
        switch (tabPlacement) {
            case 2: {
                w -= (x += this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                w -= this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                break;
            }
            default: {
                h -= (y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        g.setColor(this.tabBackground);
        g.fillRect(x, y, w, h);
        g.drawLine(x, y, x, y + h - 3);
        g.drawLine(x, y, x + w - 3, y);
        if (tabPlacement == 3) {
            this.getSkinBorder().draw(g, 0, x, h - 5, w, 5);
        }
        if (tabPlacement == 1) {
            this.getSkinBorder().draw(g, 0, x, y, w, 5);
        }
        this.paint(g, c);
    }

    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        Rectangle tabRect = this.rects[tabIndex];
        int nudge = 0;
        switch (tabPlacement) {
            case 2: {
                nudge = isSelected ? -1 : 1;
                break;
            }
            case 4: {
                nudge = isSelected ? 1 : -1;
                break;
            }
            default: {
                nudge = 0;
            }
        }
        return nudge;
    }

    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        Rectangle tabRect = this.rects[tabIndex];
        int nudge = 0;
        switch (tabPlacement) {
            case 3: {
                nudge = isSelected ? 1 : -1;
                break;
            }
            case 2: 
            case 4: {
                nudge = tabRect.height % 2;
                break;
            }
            default: {
                nudge = isSelected ? -1 : 1;
            }
        }
        return nudge;
    }

    public Skin getSkinTop() {
        if (skinTop == null) {
            skinTop = new Skin("tabtop.png", 4, 7, 6, 7, 2);
        }
        return skinTop;
    }

    public Skin getSkinLeft() {
        if (skinLeft == null) {
            skinLeft = new Skin("tableft.png", 4, 6, 7, 2, 7);
        }
        return skinLeft;
    }

    public Skin getSkinRight() {
        if (skinRight == null) {
            skinRight = new Skin("tabright.png", 4, 2, 7, 6, 7);
        }
        return skinRight;
    }

    public Skin getSkinBottom() {
        if (skinBottom == null) {
            skinBottom = new Skin("tabbottom.png", 4, 6, 7, 6, 7);
        }
        return skinBottom;
    }

    public Skin getSkinBorder() {
        if (skinBorder == null) {
            skinBorder = new Skin("tabborderh.png", 1, 5, 2, 5, 2);
        }
        return skinBorder;
    }

    public Skin getSkinBorderRight() {
        if (skinBorderRight == null) {
            skinBorderRight = new Skin("tabborderright.png", 1, 0, 5, 0, 5);
        }
        return skinBorderRight;
    }

    public class MyMouseHandler
    implements MouseListener,
    MouseMotionListener {
        public void mousePressed(MouseEvent e) {
            if (!LiquidTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            int tabIndex = LiquidTabbedPaneUI.this.getTabAtLocation(e.getX(), e.getY());
            if (tabIndex >= 0 && LiquidTabbedPaneUI.this.tabPane.isEnabledAt(tabIndex)) {
                if (tabIndex == LiquidTabbedPaneUI.this.tabPane.getSelectedIndex()) {
                    if (LiquidTabbedPaneUI.this.tabPane.isRequestFocusEnabled()) {
                        LiquidTabbedPaneUI.this.tabPane.requestFocus();
                        LiquidTabbedPaneUI.this.tabPane.repaint(LiquidTabbedPaneUI.this.getTabBounds(LiquidTabbedPaneUI.this.tabPane, tabIndex));
                    }
                } else {
                    LiquidTabbedPaneUI.this.tabPane.setSelectedIndex(tabIndex);
                }
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
            if (LiquidTabbedPaneUI.this.rollover != -1 && LiquidTabbedPaneUI.this.rollover < LiquidTabbedPaneUI.this.tabPane.getTabCount()) {
                LiquidTabbedPaneUI.this.tabPane.repaint(LiquidTabbedPaneUI.this.getTabBounds(LiquidTabbedPaneUI.this.tabPane, LiquidTabbedPaneUI.this.rollover));
                LiquidTabbedPaneUI.this.rollover = -1;
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            if (LiquidTabbedPaneUI.this.tabPane == null) {
                return;
            }
            if (!LiquidTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            int tabIndex = LiquidTabbedPaneUI.this.getTabAtLocation(e.getX(), e.getY());
            if (tabIndex >= 0 && tabIndex != LiquidTabbedPaneUI.this.rollover && LiquidTabbedPaneUI.this.rollover != -1) {
                if (LiquidTabbedPaneUI.this.rollover >= 0 && LiquidTabbedPaneUI.this.rollover < LiquidTabbedPaneUI.this.tabPane.getTabCount()) {
                    LiquidTabbedPaneUI.this.tabPane.repaint(LiquidTabbedPaneUI.this.getTabBounds(LiquidTabbedPaneUI.this.tabPane, LiquidTabbedPaneUI.this.rollover));
                }
                if (tabIndex == -1) {
                    LiquidTabbedPaneUI.this.rollover = -1;
                }
            }
            if (tabIndex >= 0 && LiquidTabbedPaneUI.this.tabPane.isEnabledAt(tabIndex) && tabIndex < LiquidTabbedPaneUI.this.tabPane.getTabCount() && tabIndex != LiquidTabbedPaneUI.this.rollover) {
                LiquidTabbedPaneUI.this.rollover = tabIndex;
                LiquidTabbedPaneUI.this.tabPane.repaint(LiquidTabbedPaneUI.this.getTabBounds(LiquidTabbedPaneUI.this.tabPane, tabIndex));
            }
        }
    }
}

