/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.util.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.codehaus.janino.util.resource.ResourceFinder;

public class ZipFileResourceFinder
extends ResourceFinder {
    private final ZipFile zipFile;

    public ZipFileResourceFinder(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    public ResourceFinder.Resource findResource(final String string) {
        final ZipEntry zipEntry = this.zipFile.getEntry(string);
        if (zipEntry == null) {
            return null;
        }
        return new ResourceFinder.Resource(){

            public String getFileName() {
                return String.valueOf(zipFile.getName()) + ':' + string;
            }

            public InputStream open() throws IOException {
                return zipFile.getInputStream(zipEntry);
            }
        };
    }

    public String toString() {
        return "zip:" + this.zipFile.getName();
    }
}

