/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.util;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class AutoIndentWriter
extends FilterWriter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private int previousChar = -1;
    private int indentation = 0;

    public AutoIndentWriter(Writer writer) {
        super(writer);
    }

    public void indent() {
        ++this.indentation;
    }

    private static boolean isLineSeparatorChar(int n) {
        return LINE_SEPARATOR.indexOf(n) != -1;
    }

    public void unindent() {
        --this.indentation;
    }

    public void write(int n) throws IOException {
        if (AutoIndentWriter.isLineSeparatorChar(n)) {
            if (this.previousChar == 123) {
                this.indent();
            }
        } else if (AutoIndentWriter.isLineSeparatorChar(this.previousChar)) {
            if (n == 125) {
                this.unindent();
            }
            int n2 = 0;
            while (n2 < this.indentation) {
                this.out.write("    ");
                ++n2;
            }
        }
        super.write(n);
        this.previousChar = n;
    }

    public void write(String string, int n, int n2) throws IOException {
        while (n2 > 0) {
            this.write(string.charAt(n++));
            --n2;
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            this.write(cArray[n++]);
            --n2;
        }
    }
}

