/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.Java;
import org.codehaus.janino.MethodDescriptor;

public abstract class IClass {
    private static final boolean DEBUG = false;
    public static final IClass VOID = new PrimitiveIClass("V");
    public static final IClass BYTE = new PrimitiveIClass("B");
    public static final IClass CHAR = new PrimitiveIClass("C");
    public static final IClass DOUBLE = new PrimitiveIClass("D");
    public static final IClass FLOAT = new PrimitiveIClass("F");
    public static final IClass INT = new PrimitiveIClass("I");
    public static final IClass LONG = new PrimitiveIClass("J");
    public static final IClass SHORT = new PrimitiveIClass("S");
    public static final IClass BOOLEAN = new PrimitiveIClass("Z");
    private IConstructor[] declaredIConstructors = null;
    protected IMethod[] declaredIMethods = null;
    private IField[] declaredIFields = null;
    private IClass[] declaredIClasses = null;
    private boolean declaringIClassIsCached = false;
    private IClass declaringIClass = null;
    private boolean outerIClassIsCached = false;
    private IClass outerIClass = null;
    private boolean superclassIsCached = false;
    private IClass superclass = null;
    private IClass[] interfaces = null;
    private String descriptor = null;
    private boolean componentTypeIsCached = false;
    private IClass componentType = null;
    private final Map memberTypeCache = new HashMap();
    private static final IClass[] ZERO_ICLASSES = new IClass[0];
    public static final int PRIVATE = 0;
    public static final int PROTECTED = 1;
    public static final int PACKAGE = 2;
    public static final int PUBLIC = 3;

    public static IClass createArrayIClass(IClass iClass, final IClass iClass2) {
        return new IClass(){

            public IClass getComponentType2() {
                return IClass.this;
            }

            public IClass[] getDeclaredIClasses2() {
                return new IClass[0];
            }

            public IConstructor[] getDeclaredIConstructors2() {
                return new IConstructor[0];
            }

            public IField[] getDeclaredIFields2() {
                return new IField[0];
            }

            public IMethod[] getDeclaredIMethods2() {
                return new IMethod[0];
            }

            public IClass getDeclaringIClass2() {
                return null;
            }

            public String getDescriptor2() {
                return String.valueOf('[') + IClass.this.getDescriptor();
            }

            public IClass[] getInterfaces2() {
                return new IClass[0];
            }

            public IClass getOuterIClass2() {
                return null;
            }

            public IClass getSuperclass2() {
                return iClass2;
            }

            public boolean isAbstract() {
                return false;
            }

            public boolean isArray() {
                return true;
            }

            public boolean isFinal() {
                return true;
            }

            public boolean isInterface() {
                return false;
            }

            public boolean isPrimitive() {
                return false;
            }

            public boolean isPrimitiveNumeric() {
                return false;
            }

            public boolean isPublic() {
                return IClass.this.isPublic();
            }

            public String toString() {
                return String.valueOf(IClass.this.toString()) + "[]";
            }
        };
    }

    IClass[] findMemberType(String string) throws Java.CompileException {
        IClass[] iClassArray = (IClass[])this.memberTypeCache.get(string);
        if (iClassArray == null) {
            HashSet hashSet = new HashSet();
            this.findMemberType(string, hashSet);
            iClassArray = hashSet.isEmpty() ? ZERO_ICLASSES : hashSet.toArray(new IClass[hashSet.size()]);
            this.memberTypeCache.put(string, iClassArray);
        }
        return iClassArray;
    }

    private void findMemberType(String string, Collection collection) throws Java.CompileException {
        Object object;
        IClass[] iClassArray = this.getDeclaredIClasses();
        if (string == null) {
            collection.addAll(Arrays.asList(iClassArray));
        } else {
            object = Descriptor.fromClassName(String.valueOf(Descriptor.toClassName(this.getDescriptor())) + '$' + string);
            int n = 0;
            while (n < iClassArray.length) {
                IClass iClass = iClassArray[n];
                if (iClass.getDescriptor().equals(object)) {
                    collection.add(iClass);
                    return;
                }
                ++n;
            }
        }
        object = this.getSuperclass();
        if (object != null) {
            ((IClass)object).findMemberType(string, collection);
        }
        IClass[] iClassArray2 = this.getInterfaces();
        int n = 0;
        while (n < iClassArray2.length) {
            iClassArray2[n].findMemberType(string, collection);
            ++n;
        }
        IClass iClass = this.getDeclaringIClass();
        IClass iClass2 = this.getOuterIClass();
        if (iClass != null) {
            iClass.findMemberType(string, collection);
        }
        if (iClass2 != null && iClass2 != iClass) {
            iClass2.findMemberType(string, collection);
        }
    }

    public final IClass getComponentType() {
        if (!this.componentTypeIsCached) {
            this.componentType = this.getComponentType2();
            this.componentTypeIsCached = true;
        }
        return this.componentType;
    }

    protected abstract IClass getComponentType2();

    public final IClass[] getDeclaredIClasses() throws Java.CompileException {
        if (this.declaredIClasses == null) {
            this.declaredIClasses = this.getDeclaredIClasses2();
        }
        return this.declaredIClasses;
    }

    protected abstract IClass[] getDeclaredIClasses2() throws Java.CompileException;

    public final IConstructor[] getDeclaredIConstructors() {
        if (this.declaredIConstructors == null) {
            this.declaredIConstructors = this.getDeclaredIConstructors2();
        }
        return this.declaredIConstructors;
    }

    protected abstract IConstructor[] getDeclaredIConstructors2();

    public final IField[] getDeclaredIFields() {
        if (this.declaredIFields == null) {
            this.declaredIFields = this.getDeclaredIFields2();
        }
        return this.declaredIFields;
    }

    protected abstract IField[] getDeclaredIFields2();

    public final IMethod[] getDeclaredIMethods() {
        if (this.declaredIMethods == null) {
            this.declaredIMethods = this.getDeclaredIMethods2();
        }
        return this.declaredIMethods;
    }

    protected abstract IMethod[] getDeclaredIMethods2();

    public final IClass getDeclaringIClass() throws Java.CompileException {
        if (!this.declaringIClassIsCached) {
            this.declaringIClass = this.getDeclaringIClass2();
            this.declaringIClassIsCached = true;
        }
        return this.declaringIClass;
    }

    protected abstract IClass getDeclaringIClass2() throws Java.CompileException;

    public final String getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = this.getDescriptor2();
        }
        return this.descriptor;
    }

    protected abstract String getDescriptor2();

    public static String[] getDescriptors(IClass[] iClassArray) {
        String[] stringArray = new String[iClassArray.length];
        int n = 0;
        while (n < iClassArray.length) {
            stringArray[n] = iClassArray[n].getDescriptor();
            ++n;
        }
        return stringArray;
    }

    public final IClass[] getInterfaces() throws Java.CompileException {
        if (this.interfaces == null) {
            this.interfaces = this.getInterfaces2();
            int n = 0;
            while (n < this.interfaces.length) {
                if (this.interfaces[n].implementsInterface(this)) {
                    throw new Java.CompileException("Interface circularity detected for \"" + Descriptor.toClassName(this.getDescriptor()) + "\"", null);
                }
                ++n;
            }
        }
        return this.interfaces;
    }

    protected abstract IClass[] getInterfaces2() throws Java.CompileException;

    public final IClass getOuterIClass() throws Java.CompileException {
        if (!this.outerIClassIsCached) {
            this.outerIClass = this.getOuterIClass2();
            this.outerIClassIsCached = true;
        }
        return this.outerIClass;
    }

    protected abstract IClass getOuterIClass2() throws Java.CompileException;

    public final IClass getSuperclass() throws Java.CompileException {
        if (!this.superclassIsCached) {
            this.superclass = this.getSuperclass2();
            this.superclassIsCached = true;
            if (this.superclass != null && this.superclass.isSubclassOf(this)) {
                throw new Java.CompileException("Class circularity detected for \"" + Descriptor.toClassName(this.getDescriptor()) + "\"", null);
            }
        }
        return this.superclass;
    }

    protected abstract IClass getSuperclass2() throws Java.CompileException;

    public boolean implementsInterface(IClass iClass) throws Java.CompileException {
        IClass iClass2 = this;
        while (iClass2 != null) {
            IClass[] iClassArray = iClass2.getInterfaces();
            int n = 0;
            while (n < iClassArray.length) {
                IClass iClass3 = iClassArray[n];
                if (iClass3 == iClass || iClass3.implementsInterface(iClass)) {
                    return true;
                }
                ++n;
            }
            iClass2 = iClass2.getSuperclass();
        }
        return false;
    }

    public abstract boolean isAbstract();

    public abstract boolean isArray();

    public boolean isAssignableFrom(IClass iClass) throws Java.CompileException {
        if (this == iClass) {
            return true;
        }
        if (Java.isWideningPrimitiveConvertible(iClass, this)) {
            return true;
        }
        return Java.isWideningReferenceConvertible(iClass, this);
    }

    public abstract boolean isFinal();

    public abstract boolean isInterface();

    public abstract boolean isPrimitive();

    public abstract boolean isPrimitiveNumeric();

    public abstract boolean isPublic();

    public boolean isSubclassOf(IClass iClass) throws Java.CompileException {
        IClass iClass2 = this.getSuperclass();
        while (iClass2 != null) {
            if (iClass2 == iClass) {
                return true;
            }
            iClass2 = iClass2.getSuperclass();
        }
        return false;
    }

    public String toString() {
        return Descriptor.toClassName(this.getDescriptor());
    }

    private static class PrimitiveIClass
    extends IClass {
        private final String fieldDescriptor;

        public PrimitiveIClass(String string) {
            this.fieldDescriptor = string;
        }

        protected IClass getComponentType2() {
            return null;
        }

        protected IClass[] getDeclaredIClasses2() {
            return new IClass[0];
        }

        protected IConstructor[] getDeclaredIConstructors2() {
            return new IConstructor[0];
        }

        protected IField[] getDeclaredIFields2() {
            return new IField[0];
        }

        protected IMethod[] getDeclaredIMethods2() {
            return new IMethod[0];
        }

        protected IClass getDeclaringIClass2() {
            return null;
        }

        protected String getDescriptor2() {
            return this.fieldDescriptor;
        }

        protected IClass[] getInterfaces2() {
            return new IClass[0];
        }

        protected IClass getOuterIClass2() {
            return null;
        }

        protected IClass getSuperclass2() {
            return null;
        }

        public boolean isAbstract() {
            return false;
        }

        public boolean isArray() {
            return false;
        }

        public boolean isFinal() {
            return true;
        }

        public boolean isInterface() {
            return false;
        }

        public boolean isPrimitive() {
            return true;
        }

        public boolean isPrimitiveNumeric() {
            return Descriptor.isPrimitiveNumeric(this.fieldDescriptor);
        }

        public boolean isPublic() {
            return true;
        }
    }

    public static interface IMember {
        public int getAccess();

        public IClass getDeclaringIClass();
    }

    public abstract class IInvocable
    implements IMember {
        public abstract int getAccess();

        public IClass getDeclaringIClass() {
            return IClass.this;
        }

        public abstract String getDescriptor() throws Java.CompileException;

        public abstract IClass[] getParameterTypes() throws Java.CompileException;

        public abstract IClass[] getThrownExceptions() throws Java.CompileException;

        public boolean isLessSpecificThan(IInvocable iInvocable) throws Java.CompileException {
            return iInvocable.isMoreSpecificThan(this);
        }

        public boolean isMoreSpecificThan(IInvocable iInvocable) throws Java.CompileException {
            if (!iInvocable.getDeclaringIClass().isAssignableFrom(this.getDeclaringIClass())) {
                return false;
            }
            IClass[] iClassArray = this.getParameterTypes();
            IClass[] iClassArray2 = iInvocable.getParameterTypes();
            int n = 0;
            while (n < iClassArray.length) {
                if (!iClassArray2[n].isAssignableFrom(iClassArray[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public abstract String toString();
    }

    public abstract class IConstructor
    extends IInvocable {
        public String getDescriptor() throws Java.CompileException {
            return new MethodDescriptor(IClass.getDescriptors(this.getParameterTypes()), "V").toString();
        }

        public abstract IClass[] getParameterTypes() throws Java.CompileException;

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getDeclaringIClass().toString());
            stringBuffer.append('(');
            try {
                IClass[] iClassArray = this.getParameterTypes();
                int n = 0;
                while (n < iClassArray.length) {
                    if (n > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(iClassArray[n].toString());
                    ++n;
                }
            }
            catch (Java.CompileException compileException) {
                stringBuffer.append("<invalid type>");
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
    }

    public abstract class IMethod
    extends IInvocable {
        public String getDescriptor() throws Java.CompileException {
            return new MethodDescriptor(IClass.getDescriptors(this.getParameterTypes()), this.getReturnType().getDescriptor()).toString();
        }

        public abstract String getName();

        public abstract IClass getReturnType() throws Java.CompileException;

        public abstract boolean isAbstract();

        public abstract boolean isStatic();

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                stringBuffer.append(this.getReturnType().toString());
            }
            catch (Java.CompileException compileException) {
                stringBuffer.append("<invalid type>");
            }
            stringBuffer.append(' ');
            stringBuffer.append(this.getDeclaringIClass().toString());
            stringBuffer.append('.');
            stringBuffer.append(this.getName());
            stringBuffer.append('(');
            try {
                IClass[] iClassArray = this.getParameterTypes();
                int n = 0;
                while (n < iClassArray.length) {
                    if (n > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(iClassArray[n].toString());
                    ++n;
                }
            }
            catch (Java.CompileException compileException) {
                stringBuffer.append("<invalid type>");
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
    }

    public abstract class IField
    implements IMember {
        public abstract int getAccess();

        public abstract Object getConstantValue() throws Java.CompileException;

        public IClass getDeclaringIClass() {
            return IClass.this;
        }

        public String getDescriptor() throws Java.CompileException {
            return this.getType().getDescriptor();
        }

        public abstract String getName();

        public abstract IClass getType() throws Java.CompileException;

        public abstract boolean isStatic();

        public String toString() {
            return this.getName();
        }
    }
}

