/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.IOException;
import java.util.HashMap;
import org.codehaus.janino.ByteArrayClassLoader;
import org.codehaus.janino.ClassLoaderIClassLoader;
import org.codehaus.janino.DebuggingInformation;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.Java;
import org.codehaus.janino.Location;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.util.ClassFile;

public class EvaluatorBase {
    private static final boolean DEBUG = false;
    private final ClassLoaderIClassLoader classLoaderIClassLoader;

    protected EvaluatorBase(ClassLoader classLoader) {
        this.classLoaderIClassLoader = new ClassLoaderIClassLoader(classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader());
    }

    protected Java.Block addClassMethodBlockDeclaration(Location location, Java.CompilationUnit compilationUnit, String string, Class clazz, Class[] classArray, boolean bl, Class clazz2, String string2, String[] stringArray, Class[] classArray2, Class[] classArray3) throws Parser.ParseException {
        if (stringArray.length != classArray2.length) {
            throw new RuntimeException("Lengths of \"parameterNames\" and \"parameterTypes\" do not match");
        }
        Java.PackageMemberClassDeclaration packageMemberClassDeclaration = this.addPackageMemberClassDeclaration(location, compilationUnit, string, clazz, classArray);
        Java.MethodDeclarator methodDeclarator = new Java.MethodDeclarator(location, packageMemberClassDeclaration, bl ? (short)9 : 1, this.classToType(location, clazz2), string2, this.makeFormalParameters(location, stringArray, classArray2), this.classesToTypes(location, classArray3));
        packageMemberClassDeclaration.addDeclaredMethod(methodDeclarator);
        Java.Block block = new Java.Block(location, methodDeclarator);
        methodDeclarator.setBody(block);
        return block;
    }

    protected Java.PackageMemberClassDeclaration addPackageMemberClassDeclaration(Location location, Java.CompilationUnit compilationUnit, String string, Class clazz, Class[] classArray) throws Parser.ParseException {
        Java.PackageMemberClassDeclaration packageMemberClassDeclaration = new Java.PackageMemberClassDeclaration(location, compilationUnit, 1, string, this.classToType(location, clazz), this.classesToTypes(location, classArray));
        compilationUnit.addPackageMemberTypeDeclaration(packageMemberClassDeclaration);
        return packageMemberClassDeclaration;
    }

    protected Java.Type classToType(Location location, Class clazz) {
        if (clazz == null) {
            return null;
        }
        return new Java.SimpleType(location, this.classLoaderIClassLoader.loadIClass(Descriptor.fromClassName(clazz.getName())));
    }

    protected Java.Type[] classesToTypes(Location location, Class[] classArray) {
        Java.Type[] typeArray = new Java.Type[classArray.length];
        int n = 0;
        while (n < classArray.length) {
            typeArray[n] = this.classToType(location, classArray[n]);
            ++n;
        }
        return typeArray;
    }

    protected ClassLoader compileAndLoad(Java.CompilationUnit compilationUnit, DebuggingInformation debuggingInformation) throws Java.CompileException {
        ClassFile[] classFileArray = compilationUnit.compile(this.classLoaderIClassLoader, debuggingInformation);
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        int n = 0;
        while (n < classFileArray.length) {
            ClassFile classFile = classFileArray[n];
            hashMap.put(classFile.getThisClassName(), classFile.toByteArray());
            ++n;
        }
        return new ByteArrayClassLoader(hashMap, this.classLoaderIClassLoader.getClassLoader());
    }

    protected Class compileAndLoad(Java.CompilationUnit compilationUnit, DebuggingInformation debuggingInformation, String string) throws Java.CompileException, ClassNotFoundException {
        return this.compileAndLoad(compilationUnit, debuggingInformation).loadClass(string);
    }

    protected Java.FormalParameter[] makeFormalParameters(Location location, String[] stringArray, Class[] classArray) {
        Java.FormalParameter[] formalParameterArray = new Java.FormalParameter[stringArray.length];
        int n = 0;
        while (n < formalParameterArray.length) {
            formalParameterArray[n] = new Java.FormalParameter(true, this.classToType(location, classArray[n]), stringArray[n]);
            ++n;
        }
        return formalParameterArray;
    }

    protected void parseImportDeclarations(Java.CompilationUnit compilationUnit, Scanner scanner) throws Scanner.ScanException, Parser.ParseException, IOException {
        Parser parser = new Parser(scanner);
        while (scanner.peek().isKeyword("import")) {
            compilationUnit.addImportDeclaration(parser.parseImportDeclaration());
        }
    }
}

