/*
 * Decompiled with CFR 0.152.
 */
package com.liveperf.rms.agents.db2;

import com.liveperf.rms.EntityId;
import com.liveperf.rms.agents.F;
import com.liveperf.rms.agents.db2.Configuration;
import com.liveperf.rms.agents.db2.DB2AgentException;
import com.liveperf.rms.agents.db2.DB2AgentNotSupportedException;
import com.liveperf.rms.agents.db2.DB2NativeException;
import com.liveperf.rms.agents.impl.A;
import com.liveperf.rms.agents.impl.B;
import com.liveperf.rms.agents.impl.C;
import com.liveperf.rms.data.CounterValue;
import com.liveperf.rms.data.CounterValueDouble;
import com.liveperf.rms.e;
import com.liveperf.rms.i;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DB2RootEntity
extends A {
    private boolean \u01ad = false;
    private static final String \u01ac = "`";
    protected int connHandle = 0;
    protected String dbName = "";

    protected static native int Attach(String var0, String var1, String var2) throws DB2NativeException;

    protected static native void Detach(int var0) throws DB2NativeException;

    protected static native void EnableMonitors(int var0, boolean var1, boolean var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8) throws DB2NativeException;

    protected static native NativeEntity EnumSystemEntities(int var0) throws DB2NativeException;

    protected static native NativeEntity EnumDatabaseEntities(int var0, String var1) throws DB2NativeException;

    public DB2RootEntity(F f) throws DB2AgentNotSupportedException {
        super(f);
        try {
            System.loadLibrary("db2perf");
        }
        catch (Throwable throwable) {
            throw new DB2AgentNotSupportedException(throwable);
        }
    }

    public void updateChildrenEntities(boolean bl) throws Throwable {
        if (this.connHandle == 0) {
            return;
        }
        NativeEntity nativeEntity = this.dbName == null || this.dbName.length() == 0 ? DB2RootEntity.EnumSystemEntities(this.connHandle) : DB2RootEntity.EnumDatabaseEntities(this.connHandle, this.dbName);
        Iterator iterator = nativeEntity.C.iterator();
        while (iterator.hasNext()) {
            NativeEntity nativeEntity2 = (NativeEntity)iterator.next();
            if (nativeEntity2 == null || nativeEntity2.B == null) continue;
            String[] stringArray = nativeEntity2.B.split(\u01ac);
            EntityId entityId = new EntityId(this.getId(), stringArray[0]);
            DB2Entity dB2Entity = (DB2Entity)this.getChildEntity(entityId);
            if (dB2Entity != null) {
                this.\u01ad = dB2Entity.updateData(nativeEntity2, stringArray, 0) || this.\u01ad;
                continue;
            }
            this.addChildEntity(new DB2Entity(this.getId(), nativeEntity2, stringArray, 0, this.fContext));
            this.\u01ad = true;
        }
    }

    public void beginSession() throws Throwable {
        this.endSession();
        Configuration configuration = (Configuration)this.fContext.B().getAgentCustomConfiguration();
        String string = configuration.getString("config.username");
        String string2 = configuration.getString("config.password");
        String string3 = configuration.getString("config.instance");
        this.dbName = configuration.getString("config.database");
        this.connHandle = DB2RootEntity.Attach(string, string2, string3);
        boolean bl = configuration.getBoolean("config.uow.switch");
        boolean bl2 = configuration.getBoolean("config.statement.switch");
        boolean bl3 = configuration.getBoolean("config.table.switch");
        boolean bl4 = configuration.getBoolean("config.buffer_pool.switch");
        boolean bl5 = configuration.getBoolean("config.lock.switch");
        boolean bl6 = configuration.getBoolean("config.sort.switch");
        boolean bl7 = configuration.getBoolean("config.timestamp.switch");
        boolean bl8 = configuration.getBoolean("config.agg_all_nodes");
        DB2RootEntity.EnableMonitors(this.connHandle, bl8, bl, bl2, bl3, bl4, bl5, bl6, bl7);
    }

    public void endSession() throws Throwable {
        if (this.connHandle != 0) {
            DB2RootEntity.Detach(this.connHandle);
            this.connHandle = 0;
        }
    }

    public void beginCycle() throws Throwable {
        try {
            if (this.connHandle == 0) {
                this.beginSession();
            }
            this.\u01ad = false;
            this.updateChildrenEntities(true);
            if (this.\u01ad) {
                try {
                    this.fContext.A(this.extractDescriptorTree(true));
                }
                catch (Throwable throwable) {
                    this.fContext.A(throwable);
                }
            }
        }
        catch (DB2AgentException dB2AgentException) {
            // empty catch block
        }
    }

    public static final class NativeCounter {
        String A;
        e B;
        CounterValue C;

        public NativeCounter(String string, CounterValue counterValue) {
            this.A = string;
            this.C = counterValue;
            this.B = counterValue instanceof CounterValueDouble ? e.e : e.c;
        }
    }

    public static final class NativeEntity {
        String B;
        List C = new LinkedList();
        List A = new LinkedList();

        public NativeEntity(String string) {
            this.B = string;
        }

        public void addCounter(NativeCounter nativeCounter) {
            this.A.add(nativeCounter);
        }

        public void addEntity(NativeEntity nativeEntity) {
            this.C.add(nativeEntity);
        }
    }

    public static class DB2Counter
    extends C {
        public DB2Counter(NativeCounter nativeCounter) {
            super(nativeCounter.A, String.valueOf(nativeCounter.A) + ".desc", nativeCounter.B);
            this.updateData(nativeCounter);
        }

        public void updateData(NativeCounter nativeCounter) {
            this.reset();
            this.dataReceived(nativeCounter.C);
        }
    }

    public static class DB2Entity
    extends B {
        public DB2Entity(EntityId entityId, NativeEntity nativeEntity, String[] stringArray, int n, F f) throws Throwable {
            super(new EntityId(entityId, stringArray[n]), f);
            if (n >= stringArray.length - 1) {
                Object object;
                Iterator iterator = nativeEntity.A.iterator();
                while (iterator.hasNext()) {
                    object = (NativeCounter)iterator.next();
                    this.addCounter(new DB2Counter((NativeCounter)object));
                }
                iterator = nativeEntity.C.iterator();
                while (iterator.hasNext()) {
                    object = (NativeEntity)iterator.next();
                    String[] stringArray2 = ((NativeEntity)object).B.split(DB2RootEntity.\u01ac);
                    this.addChildEntity(new DB2Entity(this.getId(), (NativeEntity)object, stringArray2, 0, f));
                }
            } else {
                String string = stringArray[n];
                EntityId entityId2 = new EntityId(this.getId(), string);
                DB2Entity dB2Entity = (DB2Entity)this.getChildEntity(entityId2);
                if (dB2Entity == null) {
                    dB2Entity = new DB2Entity(this.getId(), nativeEntity, stringArray, n + 1, this.fContext);
                    this.addChildEntity(dB2Entity);
                }
            }
        }

        protected void retrieveCounterValues() throws Throwable {
        }

        protected boolean testForChildren() throws Throwable {
            return this.fChildrenEntities.size() > 0;
        }

        public void addChildEntity(B b) throws Throwable {
            super.addChildEntity(b);
        }

        public boolean updateData(NativeEntity nativeEntity, String[] stringArray, int n) throws Throwable {
            boolean bl = false;
            if (n >= stringArray.length - 1) {
                String[] stringArray2;
                Object object;
                Iterator iterator = nativeEntity.A.iterator();
                while (iterator.hasNext()) {
                    object = (NativeCounter)iterator.next();
                    stringArray2 = (String[])this.getCounter(new i(((NativeCounter)object).A));
                    if (stringArray2 != null) {
                        stringArray2.updateData((NativeCounter)object);
                        continue;
                    }
                    this.addCounter(new DB2Counter((NativeCounter)object));
                    bl = true;
                }
                iterator = nativeEntity.C.iterator();
                while (iterator.hasNext()) {
                    object = (NativeEntity)iterator.next();
                    stringArray2 = ((NativeEntity)object).B.split(DB2RootEntity.\u01ac);
                    DB2Entity dB2Entity = (DB2Entity)this.getChildEntity(new EntityId(this.getId(), stringArray2[0]));
                    if (dB2Entity != null) {
                        bl = dB2Entity.updateData((NativeEntity)object, stringArray2, 0) || bl;
                        continue;
                    }
                    this.addChildEntity(new DB2Entity(this.getId(), (NativeEntity)object, stringArray2, 0, this.fContext));
                    bl = true;
                }
            } else {
                String string = stringArray[n + 1];
                EntityId entityId = new EntityId(this.getId(), string);
                DB2Entity dB2Entity = (DB2Entity)this.getChildEntity(entityId);
                if (dB2Entity == null) {
                    dB2Entity = new DB2Entity(this.getId(), nativeEntity, stringArray, n + 1, this.fContext);
                    this.addChildEntity(dB2Entity);
                    bl = true;
                } else {
                    bl = dB2Entity.updateData(nativeEntity, stringArray, n + 1) || bl;
                }
            }
            return bl;
        }
    }
}

