/*
 * Decompiled with CFR 0.152.
 */
package com.liveperf.rms.agents.impl.jmx;

import com.liveperf.common.F.C;
import com.liveperf.rms.agents.Agent;
import com.liveperf.rms.agents.AgentId;
import com.liveperf.rms.agents.impl.AbstractAgent;
import com.liveperf.rms.agents.impl.jmx.B;
import com.liveperf.rms.agents.impl.jmx.D;
import com.liveperf.rms.agents.impl.jmx.exception.JMXCommunicationError;
import com.liveperf.rms.agents.impl.jmx.exception.JMXSecurityError;
import com.liveperf.rms.exception.InvalidConfiguration;
import java.io.IOException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public abstract class JMXAbstractAgent
extends AbstractAgent {
    protected JMXConnector fConnector;
    protected MBeanServerConnection fMBeanServer;

    public JMXAbstractAgent(AgentId agentId, Agent._A _A2) {
        super(agentId, _A2);
        _A _A3 = new _A();
        this.fContext = _A3;
        this.fRootEntity = new D(_A3);
    }

    protected void configCustomChanged() throws InvalidConfiguration, Throwable {
        super.configCustomChanged();
        String string = this.getJMXConnectionURL();
        if (C.C((String)string)) {
            throw new InvalidConfiguration("JMX connection URL is missing");
        }
        JMXServiceURL jMXServiceURL = new JMXServiceURL(string);
        try {
            this.fConnector = JMXConnectorFactory.connect(jMXServiceURL, null);
            this.fMBeanServer = this.fConnector.getMBeanServerConnection();
        }
        catch (IOException iOException) {
            throw new JMXCommunicationError((Throwable)iOException);
        }
        catch (SecurityException securityException) {
            throw new JMXSecurityError((Throwable)securityException);
        }
    }

    public synchronized void deactivate() throws Throwable {
        super.deactivate();
        if (this.fConnector != null) {
            this.fConnector.close();
        }
    }

    protected abstract String getJMXConnectionURL();

    protected abstract String getDomainFilter();

    protected abstract String getKeyFilter(String var1, String var2);

    protected boolean acceptCounter(ObjectName objectName, MBeanAttributeInfo mBeanAttributeInfo) {
        return true;
    }

    protected boolean acceptCounter(ObjectName objectName, String string, String string2, OpenType openType) {
        return true;
    }

    protected String[] getCounterNameAndDescription(ObjectName objectName, MBeanAttributeInfo mBeanAttributeInfo) {
        return new String[]{mBeanAttributeInfo.getName(), mBeanAttributeInfo.getDescription()};
    }

    protected String[] getCounterNameAndDescription(ObjectName objectName, String string, CompositeType compositeType, String string2) {
        return new String[]{string2, compositeType.getDescription(string2)};
    }

    protected String getEntityDescription(MBeanInfo mBeanInfo) {
        return mBeanInfo.getDescription();
    }

    private final class _A
    extends AbstractAgent._A
    implements B {
        _A() {
        }

        public MBeanServerConnection E() {
            return JMXAbstractAgent.this.fMBeanServer;
        }

        public String D() {
            return JMXAbstractAgent.this.getDomainFilter();
        }

        public String A(String string, String string2) {
            return JMXAbstractAgent.this.getKeyFilter(string, string2);
        }

        public boolean A(ObjectName objectName, MBeanAttributeInfo mBeanAttributeInfo) {
            return JMXAbstractAgent.this.acceptCounter(objectName, mBeanAttributeInfo);
        }

        public String[] B(ObjectName objectName, MBeanAttributeInfo mBeanAttributeInfo) {
            return JMXAbstractAgent.this.getCounterNameAndDescription(objectName, mBeanAttributeInfo);
        }

        public String A(MBeanInfo mBeanInfo) {
            return JMXAbstractAgent.this.getEntityDescription(mBeanInfo);
        }

        public String[] A(ObjectName objectName, String string, CompositeType compositeType, String string2) {
            return JMXAbstractAgent.this.getCounterNameAndDescription(objectName, string, compositeType, string2);
        }

        public boolean A(ObjectName objectName, String string, String string2, OpenType openType) {
            return JMXAbstractAgent.this.acceptCounter(objectName, string, string2, openType);
        }
    }
}

