/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarVerifier;
import java.util.jar.JavaUtilJarAccessImpl;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sun.misc.SharedSecrets;
import sun.security.action.GetPropertyAction;
import sun.security.util.ManifestEntryVerifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarFile
extends ZipFile {
    private Manifest man;
    private JarEntry manEntry;
    private boolean manLoaded;
    private JarVerifier jv;
    private boolean jvInitialized;
    private boolean verify;
    private boolean computedHasClassPathAttribute;
    private boolean hasClassPathAttribute;
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private static int[] lastOcc;
    private static int[] optoSft;
    private static char[] src;
    private static String javaHome;

    public JarFile(String string) throws IOException {
        this(new File(string), true, 1);
    }

    public JarFile(String string, boolean bl2) throws IOException {
        this(new File(string), bl2, 1);
    }

    public JarFile(File file) throws IOException {
        this(file, true, 1);
    }

    public JarFile(File file, boolean bl2) throws IOException {
        this(file, bl2, 1);
    }

    public JarFile(File file, boolean bl2, int n2) throws IOException {
        super(file, n2);
        this.verify = bl2;
    }

    public Manifest getManifest() throws IOException {
        if (!this.manLoaded) {
            JarEntry jarEntry = this.getManEntry();
            if (jarEntry != null) {
                if (this.verify) {
                    byte[] byArray = this.getBytes(jarEntry);
                    this.man = new Manifest(new ByteArrayInputStream(byArray));
                    this.jv = new JarVerifier(this.man, byArray);
                } else {
                    this.man = new Manifest(super.getInputStream(jarEntry));
                }
            }
            this.manLoaded = true;
        }
        return this.man;
    }

    private native String[] getMetaInfEntryNames();

    public JarEntry getJarEntry(String string) {
        return (JarEntry)this.getEntry(string);
    }

    @Override
    public ZipEntry getEntry(String string) {
        ZipEntry zipEntry = super.getEntry(string);
        if (zipEntry != null) {
            return new JarFileEntry(zipEntry);
        }
        return null;
    }

    public Enumeration<JarEntry> entries() {
        final Enumeration<? extends ZipEntry> enumeration = super.entries();
        return new Enumeration<JarEntry>(){

            @Override
            public boolean hasMoreElements() {
                return enumeration.hasMoreElements();
            }

            @Override
            public JarFileEntry nextElement() {
                ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                return new JarFileEntry(zipEntry);
            }
        };
    }

    private void maybeInstantiateVerifier() throws IOException {
        if (this.jv != null) {
            return;
        }
        if (this.verify) {
            String[] stringArray = this.getMetaInfEntryNames();
            if (stringArray != null) {
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    String string = stringArray[i2].toUpperCase(Locale.ENGLISH);
                    if (!string.endsWith(".DSA") && !string.endsWith(".RSA") && !string.endsWith(".SF")) continue;
                    this.getManifest();
                    return;
                }
            }
            this.verify = false;
        }
    }

    private void initializeVerifier() {
        ManifestEntryVerifier manifestEntryVerifier = null;
        try {
            String[] stringArray = this.getMetaInfEntryNames();
            if (stringArray != null) {
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    byte[] byArray;
                    JarEntry jarEntry = this.getJarEntry(stringArray[i2]);
                    if (jarEntry.isDirectory()) continue;
                    if (manifestEntryVerifier == null) {
                        manifestEntryVerifier = new ManifestEntryVerifier(this.man);
                    }
                    if ((byArray = this.getBytes(jarEntry)) == null || byArray.length <= 0) continue;
                    this.jv.beginEntry(jarEntry, manifestEntryVerifier);
                    this.jv.update(byArray.length, byArray, 0, byArray.length, manifestEntryVerifier);
                    this.jv.update(-1, null, 0, 0, manifestEntryVerifier);
                }
            }
        }
        catch (IOException iOException) {
            this.jv = null;
            this.verify = false;
        }
        if (this.jv != null) {
            this.jv.doneWithMeta();
            if (JarVerifier.debug != null) {
                JarVerifier.debug.println("done with meta!");
            }
            if (this.jv.nothingToVerify()) {
                if (JarVerifier.debug != null) {
                    JarVerifier.debug.println("nothing to verify!");
                }
                this.jv = null;
                this.verify = false;
            }
        }
    }

    private byte[] getBytes(ZipEntry zipEntry) throws IOException {
        byte[] byArray = new byte[(int)zipEntry.getSize()];
        DataInputStream dataInputStream = new DataInputStream(super.getInputStream(zipEntry));
        dataInputStream.readFully(byArray, 0, byArray.length);
        dataInputStream.close();
        return byArray;
    }

    @Override
    public synchronized InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        this.maybeInstantiateVerifier();
        if (this.jv == null) {
            return super.getInputStream(zipEntry);
        }
        if (!this.jvInitialized) {
            this.initializeVerifier();
            this.jvInitialized = true;
            if (this.jv == null) {
                return super.getInputStream(zipEntry);
            }
        }
        return new JarVerifier.VerifierStream(this.man, zipEntry instanceof JarFileEntry ? (JarEntry)zipEntry : this.getJarEntry(zipEntry.getName()), super.getInputStream(zipEntry), this.jv);
    }

    private JarEntry getManEntry() {
        if (this.manEntry == null) {
            String[] stringArray;
            this.manEntry = this.getJarEntry(MANIFEST_NAME);
            if (this.manEntry == null && (stringArray = this.getMetaInfEntryNames()) != null) {
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    if (!MANIFEST_NAME.equals(stringArray[i2].toUpperCase(Locale.ENGLISH))) continue;
                    this.manEntry = this.getJarEntry(stringArray[i2]);
                    break;
                }
            }
        }
        return this.manEntry;
    }

    boolean hasClassPathAttribute() throws IOException {
        JarEntry jarEntry;
        if (this.computedHasClassPathAttribute) {
            return this.hasClassPathAttribute;
        }
        this.hasClassPathAttribute = false;
        if (!this.isKnownToNotHaveClassPathAttribute() && (jarEntry = this.getManEntry()) != null) {
            char c2;
            int n2;
            byte[] byArray = new byte[(int)jarEntry.getSize()];
            DataInputStream dataInputStream = new DataInputStream(super.getInputStream(jarEntry));
            dataInputStream.readFully(byArray, 0, byArray.length);
            dataInputStream.close();
            int n3 = byArray.length - src.length;
            block0: for (int i2 = 0; i2 <= n3; i2 += Math.max(n2 + 1 - lastOcc[c2 & 0x7F], optoSft[n2])) {
                for (n2 = 9; n2 >= 0; --n2) {
                    c2 = (char)byArray[i2 + n2];
                    char c3 = c2 = (c2 - 65 | 90 - c2) >= 0 ? (char)(c2 + 32) : c2;
                    if (c2 == src[n2]) continue;
                    continue block0;
                }
                this.hasClassPathAttribute = true;
                break;
            }
        }
        this.computedHasClassPathAttribute = true;
        return this.hasClassPathAttribute;
    }

    private boolean isKnownToNotHaveClassPathAttribute() {
        String string;
        String string2;
        if (javaHome == null) {
            javaHome = (String)AccessController.doPrivileged(new GetPropertyAction("java.home"));
        }
        return (string2 = this.getName()).startsWith(string = javaHome) && (string2.endsWith("rt.jar") || string2.endsWith("sunrsasign.jar") || string2.endsWith("jsse.jar") || string2.endsWith("jce.jar") || string2.endsWith("charsets.jar") || string2.endsWith("dnsns.jar") || string2.endsWith("ldapsec.jar") || string2.endsWith("localedata.jar") || string2.endsWith("sunjce_provider.jar"));
    }

    static {
        SharedSecrets.setJavaUtilJarAccess(new JavaUtilJarAccessImpl());
        src = new char[]{'c', 'l', 'a', 's', 's', '-', 'p', 'a', 't', 'h'};
        lastOcc = new int[128];
        optoSft = new int[10];
        JarFile.lastOcc[99] = 1;
        JarFile.lastOcc[108] = 2;
        JarFile.lastOcc[115] = 5;
        JarFile.lastOcc[45] = 6;
        JarFile.lastOcc[112] = 7;
        JarFile.lastOcc[97] = 8;
        JarFile.lastOcc[116] = 9;
        JarFile.lastOcc[104] = 10;
        for (int i2 = 0; i2 < 9; ++i2) {
            JarFile.optoSft[i2] = 10;
        }
        JarFile.optoSft[9] = 1;
    }

    private class JarFileEntry
    extends JarEntry {
        JarFileEntry(ZipEntry zipEntry) {
            super(zipEntry);
        }

        public Attributes getAttributes() throws IOException {
            Manifest manifest = JarFile.this.getManifest();
            if (manifest != null) {
                return manifest.getAttributes(this.getName());
            }
            return null;
        }

        public Certificate[] getCertificates() {
            Certificate[] certificateArray;
            try {
                JarFile.this.maybeInstantiateVerifier();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            if (this.certs == null && JarFile.this.jv != null && (certificateArray = JarFile.this.jv.getCerts(this.getName())) != null) {
                this.certs = (Certificate[])certificateArray.clone();
            }
            return this.certs;
        }

        public CodeSigner[] getCodeSigners() {
            CodeSigner[] codeSignerArray;
            try {
                JarFile.this.maybeInstantiateVerifier();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            if (this.signers == null && JarFile.this.jv != null && (codeSignerArray = JarFile.this.jv.getCodeSigners(this.getName())) != null) {
                this.signers = (CodeSigner[])codeSignerArray.clone();
            }
            return this.signers;
        }
    }
}

