/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.MetaData;
import com.sun.jmx.trace.Trace;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;

abstract class BaseMetaDataImpl
implements MetaData {
    private static final String dbgTag = "BaseMetaDataImpl";

    BaseMetaDataImpl() {
    }

    public abstract MBeanInfo getMBeanInfo(Object var1) throws IntrospectionException;

    public abstract Object getAttribute(Object var1, String var2) throws MBeanException, AttributeNotFoundException, ReflectionException;

    public abstract AttributeList getAttributes(Object var1, String[] var2) throws ReflectionException;

    public abstract AttributeList setAttributes(Object var1, AttributeList var2) throws ReflectionException;

    public abstract Object setAttribute(Object var1, Attribute var2) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException;

    public abstract Object invoke(Object var1, String var2, Object[] var3, String[] var4) throws MBeanException, ReflectionException;

    public ObjectName preRegisterInvoker(Object object, ObjectName objectName, MBeanServer mBeanServer) throws InstanceAlreadyExistsException, MBeanRegistrationException {
        ObjectName objectName2;
        if (!(object instanceof MBeanRegistration)) {
            return objectName;
        }
        try {
            objectName2 = ((MBeanRegistration)object).preRegister(mBeanServer, objectName);
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeMBeanException(runtimeException, "RuntimeException thrown in preRegister method");
        }
        catch (Error error) {
            throw new RuntimeErrorException(error, "Error thrown in preRegister method");
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw mBeanRegistrationException;
        }
        catch (Exception exception) {
            throw new MBeanRegistrationException(exception, "Exception thrown in preRegister method");
        }
        if (objectName2 != null) {
            return objectName2;
        }
        return objectName;
    }

    public void postRegisterInvoker(Object object, boolean bl2) {
        if (!(object instanceof MBeanRegistration)) {
            return;
        }
        try {
            ((MBeanRegistration)object).postRegister(new Boolean(bl2));
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeMBeanException(runtimeException, "RuntimeException thrown in postRegister method");
        }
        catch (Error error) {
            throw new RuntimeErrorException(error, "Error thrown in postRegister method");
        }
    }

    public void preDeregisterInvoker(Object object) throws MBeanRegistrationException {
        if (!(object instanceof MBeanRegistration)) {
            return;
        }
        try {
            ((MBeanRegistration)object).preDeregister();
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeMBeanException(runtimeException, "RuntimeException thrown in preDeregister method");
        }
        catch (Error error) {
            throw new RuntimeErrorException(error, "Error thrown in preDeregister method");
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw mBeanRegistrationException;
        }
        catch (Exception exception) {
            throw new MBeanRegistrationException(exception, "Exception thrown in preDeregister method");
        }
    }

    public void postDeregisterInvoker(Object object) {
        if (!(object instanceof MBeanRegistration)) {
            return;
        }
        try {
            ((MBeanRegistration)object).postDeregister();
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeMBeanException(runtimeException, "RuntimeException thrown in postDeregister method");
        }
        catch (Error error) {
            throw new RuntimeErrorException(error, "Error thrown in postDeregister method");
        }
    }

    public String getMBeanClassName(Object object) throws IntrospectionException, NotCompliantMBeanException {
        MBeanInfo mBeanInfo;
        try {
            mBeanInfo = this.getMBeanInfo(object);
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (IntrospectionException introspectionException) {
            throw introspectionException;
        }
        catch (Exception exception) {
            throw new NotCompliantMBeanException("Can't obtain MBeanInfo from DynamicMBean: " + exception);
        }
        if (mBeanInfo == null) {
            throw new NotCompliantMBeanException("The MBeanInfo returned is null");
        }
        String string = mBeanInfo.getClassName();
        if (string == null) {
            throw new IntrospectionException("The class Name returned is null");
        }
        return string;
    }

    public boolean isInstanceOf(Object object, String string) throws ReflectionException {
        try {
            String string2 = this.getMBeanClassName(object);
            if (string2.equals(string)) {
                return true;
            }
            try {
                ClassLoader classLoader = object.getClass().getClassLoader();
                Class clazz = this.findClass(string, classLoader);
                if (clazz == null) {
                    return false;
                }
                if (clazz.isInstance(object)) {
                    return true;
                }
                Class clazz2 = this.findClass(string2, classLoader);
                if (clazz2 == null) {
                    return false;
                }
                return clazz.isAssignableFrom(clazz2);
            }
            catch (Exception exception) {
                BaseMetaDataImpl.debugX("isInstanceOf", exception);
                return false;
            }
        }
        catch (IntrospectionException introspectionException) {
            BaseMetaDataImpl.debugX("isInstanceOf", introspectionException);
            throw new ReflectionException(introspectionException, introspectionException.getMessage());
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            BaseMetaDataImpl.debugX("isInstanceOf", notCompliantMBeanException);
            throw new ReflectionException(notCompliantMBeanException, notCompliantMBeanException.getMessage());
        }
    }

    protected Class findClass(String string, ClassLoader classLoader) throws ReflectionException {
        try {
            if (classLoader == null) {
                return Class.forName(string);
            }
            return classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionException(classNotFoundException, classNotFoundException.getMessage());
        }
    }

    private static boolean isTraceOn() {
        return Trace.isSelected(1, 1);
    }

    private static void trace(String string, String string2, String string3) {
        Trace.send(1, 1, string, string2, string3);
    }

    private static void trace(String string, String string2) {
        BaseMetaDataImpl.trace(dbgTag, string, string2);
    }

    private static boolean isDebugOn() {
        return Trace.isSelected(2, 1);
    }

    private static void debug(String string, String string2, String string3) {
        Trace.send(2, 1, string, string2, string3);
    }

    private static void debug(String string, String string2) {
        BaseMetaDataImpl.debug(dbgTag, string, string2);
    }

    private static void debugX(String string, Throwable throwable) {
        if (BaseMetaDataImpl.isDebugOn()) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            String string2 = stringWriter.toString();
            BaseMetaDataImpl.debug(dbgTag, string, "Exception caught in " + string + "(): " + throwable);
            BaseMetaDataImpl.debug(dbgTag, string, string2);
        }
    }
}

