/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class WindowsTableHeaderUI
extends BasicTableHeaderUI {
    private TableCellRenderer originalHeaderRenderer;
    private int rolloverColumn = -1;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsTableHeaderUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (XPStyle.getXP() != null) {
            this.originalHeaderRenderer = this.header.getDefaultRenderer();
            if (this.originalHeaderRenderer instanceof UIResource) {
                this.header.setDefaultRenderer(new XPDefaultRenderer());
            }
        }
    }

    private void updateRolloverColumn(MouseEvent mouseEvent) {
        int n2;
        if (this.header.getDraggedColumn() == null && this.header.contains(mouseEvent.getPoint()) && (n2 = this.header.columnAtPoint(mouseEvent.getPoint())) != this.rolloverColumn) {
            this.rolloverColumn = n2;
            this.header.repaint();
        }
    }

    protected MouseInputListener createMouseInputListener() {
        if (XPStyle.getXP() != null) {
            return new BasicTableHeaderUI.MouseInputHandler(){

                public void mouseMoved(MouseEvent mouseEvent) {
                    super.mouseMoved(mouseEvent);
                    WindowsTableHeaderUI.this.updateRolloverColumn(mouseEvent);
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    super.mouseEntered(mouseEvent);
                    WindowsTableHeaderUI.this.updateRolloverColumn(mouseEvent);
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    super.mouseExited(mouseEvent);
                    WindowsTableHeaderUI.this.rolloverColumn = -1;
                    WindowsTableHeaderUI.this.header.repaint();
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    super.mousePressed(mouseEvent);
                    if (WindowsTableHeaderUI.this.header.getReorderingAllowed()) {
                        WindowsTableHeaderUI.this.rolloverColumn = -1;
                        WindowsTableHeaderUI.this.header.repaint();
                    }
                }

                public void mouseDragged(MouseEvent mouseEvent) {
                    super.mouseDragged(mouseEvent);
                    WindowsTableHeaderUI.this.updateRolloverColumn(mouseEvent);
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    super.mouseReleased(mouseEvent);
                    WindowsTableHeaderUI.this.updateRolloverColumn(mouseEvent);
                }
            };
        }
        return super.createMouseInputListener();
    }

    public void uninstallUI(JComponent jComponent) {
        if (this.header.getDefaultRenderer() instanceof XPDefaultRenderer) {
            this.header.setDefaultRenderer(this.originalHeaderRenderer);
        }
        super.uninstallUI(jComponent);
    }

    private class XPDefaultRenderer
    extends DefaultTableCellRenderer
    implements UIResource {
        XPStyle.Skin skin = XPStyle.getXP().getSkin("header.headeritem");
        boolean isSelected;
        boolean hasFocus;
        boolean hasRollover;
        int column;

        private XPDefaultRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            JTableHeader jTableHeader;
            if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                this.setFont(jTableHeader.getFont());
            }
            this.isSelected = bl2;
            this.hasFocus = bl3;
            this.column = n3;
            this.hasRollover = n3 == WindowsTableHeaderUI.this.rolloverColumn;
            this.setText(object == null ? "" : object.toString());
            this.setBorder(new EmptyBorder(this.skin.getContentMargin()));
            return this;
        }

        private int viewIndexForColumn(TableColumn tableColumn) {
            TableColumnModel tableColumnModel = WindowsTableHeaderUI.this.header.getColumnModel();
            for (int i2 = 0; i2 < tableColumnModel.getColumnCount(); ++i2) {
                if (tableColumnModel.getColumn(i2) != tableColumn) continue;
                return i2;
            }
            return -1;
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            int n2 = 0;
            if (this.column == this.viewIndexForColumn(WindowsTableHeaderUI.this.header.getDraggedColumn())) {
                n2 = 2;
            } else if (this.isSelected || this.hasFocus || this.hasRollover) {
                n2 = 1;
            }
            this.skin.paintSkin(graphics, 0, 0, dimension.width - 1, dimension.height - 1, n2);
            super.paint(graphics);
        }
    }
}

