/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class WindowsScrollBarUI
extends BasicScrollBarUI {
    private Grid thumbGrid;
    private Grid highlightGrid;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsScrollBarUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        if (XPStyle.getXP() != null) {
            this.scrollbar.setBorder(null);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.highlightGrid = null;
        this.thumbGrid = null;
    }

    protected void configureScrollBarColors() {
        super.configureScrollBarColors();
        Color color = UIManager.getColor("ScrollBar.trackForeground");
        if (color != null && this.trackColor != null) {
            this.thumbGrid = Grid.getGrid(color, this.trackColor);
        }
        if ((color = UIManager.getColor("ScrollBar.trackHighlightForeground")) != null && this.trackHighlightColor != null) {
            this.highlightGrid = Grid.getGrid(color, this.trackHighlightColor);
        }
    }

    protected JButton createDecreaseButton(int n2) {
        return new WindowsArrowButton(n2, UIManager.getColor("ScrollBar.thumb"), UIManager.getColor("ScrollBar.thumbShadow"), UIManager.getColor("ScrollBar.thumbDarkShadow"), UIManager.getColor("ScrollBar.thumbHighlight"));
    }

    protected JButton createIncreaseButton(int n2) {
        return new WindowsArrowButton(n2, UIManager.getColor("ScrollBar.thumb"), UIManager.getColor("ScrollBar.thumbShadow"), UIManager.getColor("ScrollBar.thumbDarkShadow"), UIManager.getColor("ScrollBar.thumbHighlight"));
    }

    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        boolean bl2 = this.scrollbar.getOrientation() == 1;
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            JScrollBar jScrollBar = (JScrollBar)jComponent;
            int n2 = 0;
            if (!jScrollBar.isEnabled()) {
                n2 = 3;
            }
            String string = bl2 ? "scrollbar.lowertrackvert" : "scrollbar.lowertrackhorz";
            xPStyle.getSkin(string).paintSkin(graphics, rectangle, n2);
        } else if (this.thumbGrid == null) {
            super.paintTrack(graphics, jComponent, rectangle);
        } else {
            this.thumbGrid.paint(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (this.trackHighlight == 1) {
                this.paintDecreaseHighlight(graphics);
            } else if (this.trackHighlight == 2) {
                this.paintIncreaseHighlight(graphics);
            }
        }
    }

    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        boolean bl2 = this.scrollbar.getOrientation() == 1;
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            JScrollBar jScrollBar = (JScrollBar)jComponent;
            int n2 = 0;
            if (!jScrollBar.isEnabled()) {
                n2 = 3;
            } else if (this.isDragging) {
                n2 = 2;
            } else if (this.isThumbRollover()) {
                n2 = 1;
            }
            XPStyle.Skin skin = xPStyle.getSkin(bl2 ? "scrollbar.thumbbtnvert" : "scrollbar.thumbbtnhorz");
            skin.paintSkin(graphics, rectangle, n2);
            skin = xPStyle.getSkin(bl2 ? "scrollbar.grippervert" : "scrollbar.gripperhorz");
            skin.paintSkin(graphics, rectangle.x + (rectangle.width - skin.getWidth()) / 2, rectangle.y + (rectangle.height - skin.getHeight()) / 2, skin.getWidth(), skin.getHeight(), n2);
        } else {
            super.paintThumb(graphics, jComponent, rectangle);
        }
    }

    protected void paintDecreaseHighlight(Graphics graphics) {
        if (this.highlightGrid == null) {
            super.paintDecreaseHighlight(graphics);
        } else {
            int n2;
            int n3;
            int n4;
            int n5;
            Insets insets = this.scrollbar.getInsets();
            Rectangle rectangle = this.getThumbBounds();
            if (this.scrollbar.getOrientation() == 1) {
                n5 = insets.left;
                n4 = this.decrButton.getY() + this.decrButton.getHeight();
                n3 = this.scrollbar.getWidth() - (insets.left + insets.right);
                n2 = rectangle.y - n4;
            } else {
                n5 = this.decrButton.getX() + this.decrButton.getHeight();
                n4 = insets.top;
                n3 = rectangle.x - n5;
                n2 = this.scrollbar.getHeight() - (insets.top + insets.bottom);
            }
            this.highlightGrid.paint(graphics, n5, n4, n3, n2);
        }
    }

    protected void paintIncreaseHighlight(Graphics graphics) {
        if (this.highlightGrid == null) {
            super.paintDecreaseHighlight(graphics);
        } else {
            int n2;
            int n3;
            int n4;
            int n5;
            Insets insets = this.scrollbar.getInsets();
            Rectangle rectangle = this.getThumbBounds();
            if (this.scrollbar.getOrientation() == 1) {
                n5 = insets.left;
                n4 = rectangle.y + rectangle.height;
                n3 = this.scrollbar.getWidth() - (insets.left + insets.right);
                n2 = this.incrButton.getY() - n4;
            } else {
                n5 = rectangle.x + rectangle.width;
                n4 = insets.top;
                n3 = this.incrButton.getX() - n5;
                n2 = this.scrollbar.getHeight() - (insets.top + insets.bottom);
            }
            this.highlightGrid.paint(graphics, n5, n4, n3, n2);
        }
    }

    private static class Grid {
        private static final int BUFFER_SIZE = 64;
        private static HashMap map = new HashMap();
        private BufferedImage image;

        public static Grid getGrid(Color color, Color color2) {
            Grid grid;
            String string = color.getRGB() + " " + color2.getRGB();
            WeakReference weakReference = (WeakReference)map.get(string);
            Grid grid2 = grid = weakReference == null ? null : (Grid)weakReference.get();
            if (grid == null) {
                grid = new Grid(color, color2);
                map.put(string, new WeakReference<Grid>(grid));
            }
            return grid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Grid(Color color, Color color2) {
            int[] nArray = new int[]{color.getRGB(), color2.getRGB()};
            IndexColorModel indexColorModel = new IndexColorModel(8, 2, nArray, 0, false, -1, 0);
            this.image = new BufferedImage(64, 64, 13, indexColorModel);
            Graphics graphics = this.image.getGraphics();
            try {
                graphics.setClip(0, 0, 64, 64);
                this.paintGrid(graphics, color, color2);
            }
            finally {
                graphics.dispose();
            }
        }

        public void paint(Graphics graphics, int n2, int n3, int n4, int n5) {
            Rectangle rectangle = graphics.getClipBounds();
            int n6 = Math.max(n2, rectangle.x);
            int n7 = Math.max(n3, rectangle.y);
            int n8 = Math.min(rectangle.x + rectangle.width, n2 + n4);
            int n9 = Math.min(rectangle.y + rectangle.height, n3 + n5);
            if (n8 <= n6 || n9 <= n7) {
                return;
            }
            int n10 = (n6 - n2) % 2;
            for (int i2 = n6; i2 < n8; i2 += 64) {
                int n11 = (n7 - n3) % 2;
                int n12 = Math.min(64 - n10, n8 - i2);
                for (int i3 = n7; i3 < n9; i3 += 64) {
                    int n13 = Math.min(64 - n11, n9 - i3);
                    graphics.drawImage(this.image, i2, i3, i2 + n12, i3 + n13, n10, n11, n10 + n12, n11 + n13, null);
                    if (n11 == 0) continue;
                    i3 -= n11;
                    n11 = 0;
                }
                if (n10 == 0) continue;
                i2 -= n10;
                n10 = 0;
            }
        }

        private void paintGrid(Graphics graphics, Color color, Color color2) {
            int n2;
            Rectangle rectangle = graphics.getClipBounds();
            graphics.setColor(color2);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(color);
            graphics.translate(rectangle.x, rectangle.y);
            int n3 = rectangle.width;
            int n4 = rectangle.height;
            int n5 = n3 - n4;
            for (n2 = rectangle.x % 2; n2 < n5; n2 += 2) {
                graphics.drawLine(n2, 0, n2 + n4, n4);
            }
            n5 = n3;
            while (n2 < n5) {
                graphics.drawLine(n2, 0, n3, n3 - n2);
                n2 += 2;
            }
            int n6 = n4 - n3;
            for (n5 = rectangle.x % 2 == 0 ? 2 : 1; n5 < n6; n5 += 2) {
                graphics.drawLine(0, n5, n3, n5 + n3);
            }
            n6 = n4;
            while (n5 < n6) {
                graphics.drawLine(0, n5, n4 - n5, n4);
                n5 += 2;
            }
            graphics.translate(-rectangle.x, -rectangle.y);
        }
    }

    private class WindowsArrowButton
    extends BasicArrowButton {
        public WindowsArrowButton(int n2, Color color, Color color2, Color color3, Color color4) {
            super(n2, color, color2, color3, color4);
        }

        public WindowsArrowButton(int n2) {
            super(n2);
        }

        public void paint(Graphics graphics) {
            XPStyle xPStyle = XPStyle.getXP();
            if (xPStyle != null) {
                ButtonModel buttonModel = this.getModel();
                XPStyle.Skin skin = xPStyle.getSkin("scrollbar.arrowbtn");
                int n2 = 0;
                switch (this.direction) {
                    case 1: {
                        n2 = 0;
                        break;
                    }
                    case 5: {
                        n2 = 4;
                        break;
                    }
                    case 7: {
                        n2 = 8;
                        break;
                    }
                    case 3: {
                        n2 = 12;
                    }
                }
                if (buttonModel.isArmed() && buttonModel.isPressed()) {
                    n2 += 2;
                } else if (!buttonModel.isEnabled()) {
                    n2 += 3;
                } else if (buttonModel.isRollover() || buttonModel.isPressed()) {
                    ++n2;
                }
                skin.paintSkin(graphics, 0, 0, this.getSize().width, this.getSize().height, n2);
            } else {
                super.paint(graphics);
            }
        }

        public Dimension getPreferredSize() {
            int n2 = 16;
            if (WindowsScrollBarUI.this.scrollbar != null) {
                switch (WindowsScrollBarUI.this.scrollbar.getOrientation()) {
                    case 1: {
                        n2 = WindowsScrollBarUI.this.scrollbar.getWidth();
                        break;
                    }
                    case 0: {
                        n2 = WindowsScrollBarUI.this.scrollbar.getHeight();
                    }
                }
                n2 = Math.max(n2, 5);
            }
            return new Dimension(n2, n2);
        }
    }
}

